//File - THREADS.C
//***************************************************************************
//
//Description:
//
//	This file contains function definitions to work with threads
//in an OS independent manner.
//
//Copyright Distributed Processing Technology, Corp.
//	  140 Candace Dr.
//	  Maitland, Fl.	32751   USA
//	  Phone: (407) 830-5522  Fax: (407) 260-5366
//	  All Rights Reserved
//
//Author:
//Date:
//
//Editors:
//
//Remarks:
//
//
//***************************************************************************


//Include Files -------------------------------------------------------------

#include <osd_util.h>
#include <unistd.h>
#include <stdlib.h>
//#include <process.h>    /* exit, Thread...., delay          */


typedef void	(*threadFn_T) (void *);


//Function - osdSwitchThreads() - start
//===========================================================================
//
//Description:
//
//	This function switches control to the task switcher in a non-
//preemptive multi-tasking operating system.   A call to this function
//will give other threads a chance to execute.
//
//Parameters:
//
//Return Value:
//
//Remarks: (Side effects, Assumptions, Warnings...)
//
//---------------------------------------------------------------------------

void osdSwitchThreads()
{
 // ThreadSwitch();
}



//Function - osdStartThread() - start
//===========================================================================
//
//Description:
//
//	This function starts the specified thread function.
//
//Parameters:
//
//   fn_P	= Pointer to the thread function
//   param_P	= Pointer to the thread function input parameter structure
//
//Return Value:
//
//   0 		= Successfull
//   non-zero	= Failure, unable to start the thread
//
//Remarks: (Side effects, Assumptions, Warnings...)
//
//---------------------------------------------------------------------------

uLONG   osdStartThread(void *fn_P,void *param_P)
{
  uLONG retVal=0;
  int P_ID;

  // Call the thread function

   if((P_ID = fork()) == -1)
        retVal=1;

  // If The PID Is 0, This Is The Child, So Go Process The Connection

    else if(!P_ID)
           {
             alarm(60);
             ((threadFn_T)fn_P)(param_P);
             exit(0);
            }
  return (retVal);
}
//osdStartThread() - end
