#ifndef         __DPT_OSD_H
#define         __DPT_OSD_H
/*
 * Copyright (c) 1997-1998 Distributed Processing Technology Corporation
 * All rights reserved.
 *
 * Redistribution and use in source form, with or without modification, are
 * permitted provided that redistributions of source code must retain the
 * above copyright notice, this list of conditions and the following disclaimer.
 *
 * This software is provided `as is' by Distributed Processing Technology and
 * any express or implied warranties, including, but not limited to, the
 * implied warranties of merchantability and fitness for a particular purpose,
 * are disclaimed. In no event shall Distributed Processing Technology be
 * liable for any direct, indirect, incidental, special, exemplary or
 * consequential damages (including, but not limited to, procurement of
 * substitute goods or services; loss of use, data, or profits; or business
 * interruptions) however caused and on any theory of liability, whether in
 * contract, strict liability, or tort (including negligence or otherwise)
 * arising in any way out of the use of this driver software, even if advised
 * of the possibility of such damage.
 *
 * DPT EATA packet to I2O packet conversion utility.
 */

#if (!defined(IN))
# define IN
#endif
#if (!defined(OUT))
# define OUT
#endif
#if (!defined(INOUT))
# define INOUT
#endif
#if (!defined(EXTERNAL))
# define EXTERNAL extern
#endif
#if (!defined(STATIC))
# define STATIC static
#endif
#if (!defined(PUBLIC))
# define PUBLIC
#endif
#if (!defined(INLINE))
# define INLINE
#endif
#if (!defined(__P))
# define __P(protos)     protos          /* full-blown ANSI C */
#endif
#if (!defined(__FAR__))
# define __FAR__ 
#endif

#ifdef __SPARC__
# include <string.h>
#endif /* __SPARC__ */
#include <stdlib.h>
#include <dpt_scsi.h>

/* Required to get dpt_eata.h to define eataCP_getSgAddr(x) */
#define osdPhys(x)      (unsigned long)(x)
#define osdVirt(x)      (unsigned char far *)(x)

#if defined(__UNIX__)
#define UNREFERENCED_PARAMETER(x)
#else
#define UNREFERENCED_PARAMETER(x) (x)
#endif

/*
 *      If there is a local swapping utility that is more efficient than
 * the one in dptalign.h then please override it here!
 */

/*
 *      Removes any clock based timeouts.
*/
//#define osdClockTick

#undef osdBcopy
#define osdBcopy(x,y,z) memcpy(y,x,z)
#undef osdBzero
#define osdBzero(x,y)   memset(x,0,y)
#define osdAlloc(x)     malloc(x)
#define osdFree(x,y)    free(x)
#define osdEata4(x)  (*(unsigned long __FAR__ *)(x))

#define pushInterrupts()
#define popInterrupts()
#define enableInterrupts()
#define osdStartI2OCp _osdStartI2OCp

#define NUM_CALLBACK    1
#define NUM_DEVICES     -1
#define NUM_CONTROLLERS 16

typedef unsigned char Controller_t; /* Controller virtualization        */
typedef void __FAR__ * Status_t;    /* Returned Status Packet           */
typedef sdRequestSense_S __FAR__ * Sense_t; /* Return sense packet      */
typedef void * InComing_t;      /* Incoming packets to system           */
typedef void * OutGoing_t;      /* Outgoing packets to Drive system     */
                                /* Completion routine                   */
#ifdef _DPT_LINUX // hnt - for some reason, GCC hates the other prototype
typedef void (__FAR__ * __FAR__ Callback_t) (Controller_t controller,
                                                 Status_t     status,
                                                 Sense_t      sense);
#else
typedef void (__FAR__ * __FAR__ Callback_t) __P((Controller_t controller,
                                                 Status_t     status,
                                                 Sense_t      sense));
#endif

#if (defined(__cplusplus))
extern "C" {
#endif
int _osdStartI2OCp(Controller_t controller,
                OutGoing_t packet,
                Callback_t callback);
#if (defined(__cplusplus))
}
#endif

#endif /* __DPT_OSD_H */
