#ifndef HEADER_NICK
#define HEADER_NICK

#ifdef DMALLOC
#include <dmalloc.h>
#endif

#include "support.h"
#include "defines.h"

class tglobalnick {
 private:
    char *name;
  public:
    char *ip;
    char *mask;
    char *ident;
    char *host;
    int o;
    int h;
    int operator==(tglobalnick &nick) {
      return(strcasecmp(name,nick.name)==0);
    }
    int operator>=(tglobalnick &nick) {
      return(strcasecmp(name,nick.name)>=0);
    }

    tglobalnick(tglobalnick &tgn) {
      name = mystrdup(tgn.name);
      ip = tgn.ip;
      mask = tgn.mask;
      ident = tgn.ident;
      host = tgn.host;
      o = tgn.o;
      h = tgn.h;
    }

    tglobalnick(char *nick) {
      name = mystrdup(nick);
    }

    ~tglobalnick() {
      free(name);
    }
};

class tnick {
 private:
    char *name;
    char *entry;

    void updateentry(void) {
      free(entry);
      if(oped || voiced) {
	entry = (char *)mymalloc(strlen(name) + 2);
	strcpy(entry+1, name);
	if(voiced) entry[0] = '+';
	if(oped) entry[0] = '@';
      } else {
	entry = strdup(name);
      }
    }

  public:
    int time;
    int index;
    int voiced;
    int oped;
    tglobalnick *global;

    int operator==(tnick &nick) {
      return(strcasecmp(name,nick.name)==0);
    }

    int operator>=(tnick &nick) {
      int retval;
      if(entry[0]=='@') entry[0]=1;
      if(nick.entry[0]=='@') nick.entry[0]=1;
      if(entry[0]=='+') entry[0]=2;
      if(nick.entry[0]=='+') nick.entry[0]=2;
      retval=(strcasecmp(entry,nick.entry)>=0);
      if(entry[0]==1) entry[0]='@';
      if(nick.entry[0]==1) nick.entry[0]='@';
      if(entry[0]==2) entry[0]='+';
      if(nick.entry[0]==2) nick.entry[0]='+';
      return retval;
    }

    const char *getname(void) {
      return name;
    }

    const char *getentry(void) {
      return entry;
    }

    void changenick(char *newnick) {
      free(name);
      name = strdup(newnick);

      updateentry();
    }

    void setvoiced(int v) {
      if(voiced == v) return;
      voiced = v;
      
      updateentry();
    }

    void setoped(int o) {
      if(oped == o) return;
      oped = o;

      updateentry();
    }

    // Copy constructor
    tnick(const tnick& tn) {
      name = mystrdup(tn.name);
      entry = mystrdup(tn.entry);

      time = tn.time;
      index = tn.index;
      voiced = tn.voiced;
      oped = tn.oped;

      global = tn.global;
    }

    tnick(const char *nick) {
      entry = strdup(nick);
      if(entry[0]=='@') {
        oped=1;
        voiced=0;
        name = mystrdup(entry+1);
      } else if(entry[0]=='+') {
        oped=0;
        voiced=1;
        name = mystrdup(entry+1);
      } else {
        oped=0;
        voiced=0;
        name = mystrdup(entry);
      }
    }

    ~tnick() {
      free(name);
      free(entry);
    }
};

#endif

