#ifdef DMALLOC
#include <dmalloc.h>
#endif

#include "llist.h"
#include "network.h"
#include "tcltk.h"

//#include "arlibcc.h"

// Since the TCL networking was implemented, the network lock was implemented
// to keep things working as they were before, only faster.
int networklock=0;
list<handleable*> reinstate;
int arfd;
int reinstate_arfd=0;

list<int> lookups;

void handle_ar(int mask) {
  printf("Here we are, handling ar\n");
}

void handle_networking(ClientData clientData, int mask) {
  handleable *handler=(handleable *)clientData;
  handleable **handlerp;
  if(networklock) {
    if(clientData) {
      Tcl_DeleteFileHandler(handler->getsockfd());
      reinstate.insert_start(handler);
    } else {
      reinstate_arfd=1;
    }
    return;
  }
  networklock=1;
  if(clientData) {
    handler->handle(mask);
  } else {
    handle_ar(mask);
  }
  networklock=0;
  reinstate.init_trav();
  while((handlerp=reinstate.trav())) {
    Tcl_CreateFileHandler((*handlerp)->getsockfd(),(*handlerp)->getflags(),handle_networking,(*handlerp));
  }
  reinstate.clear();
  if(reinstate_arfd) {
    Tcl_CreateFileHandler(arfd,TCL_READABLE,handle_networking,0);
    reinstate_arfd=0;
  }
}

void init_ar() {
  /* Section removed due to removal of arlib:
  if((arfd=ar_init(ARES_INITLIST|ARES_CALLINIT|ARES_INITSOCK))==-1) {
    fprintf(stderr,"Could not initialize arlib for doing name lookups.\n");
    exit(1);
  }
  Tcl_CreateFileHandler(arfd,TCL_READABLE,handle_networking,0);
  */
}

void do_gethostbyname(char *hostname, void (*handler)(void *), void *data) {
  // Add it to a list, then send it to ar.
}

/*
void do_gethostbyaddr(struct in_addr *adr ... gethostbyaddr arg) {
  struct in_addr adr;
      ar_gethostbyaddr((char *)&adr, (char *)&seq, sizeof(seq));
}
*/
