
//  qnetwalk/mainwindow.h
//  Copyright (C) 2004, Andi Peredri <andi@ukr.net>

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <qmainwindow.h>

class Cell;
class QAction;
class QSound;
class QLCDNumber;


class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    MainWindow();
protected:
    virtual void closeEvent(QCloseEvent*);
private:
    enum Skill { Novice, Normal, Expert, Master };
    enum BoardSize
    {
        NoviceBoardSize = 5,
        NormalBoardSize = 7,
        ExpertBoardSize = 9,
        MasterBoardSize = 9
    };
    enum
    {
	NumHighscores   = 10,
	MinimumNumCells = 20
    };
    typedef QValueList<Cell*> CellList;
private slots:
    void  help();
    void  about();
    void  newGame();
    void  lClicked(int index);
    void  rClicked(int index);
    void  openHomepage();
    void  showHighscores();
    void  setSkillNovice() { setSkill(Novice); }
    void  setSkillNormal() { setSkill(Normal); }
    void  setSkillExpert() { setSkill(Expert); }
    void  setSkillMaster() { setSkill(Master); }
private:
    Cell* uCell(Cell* cell) const;
    Cell* dCell(Cell* cell) const;
    Cell* lCell(Cell* cell) const;
    Cell* rCell(Cell* cell) const;
    bool  isGameOver();
    bool  startBrowser(const QString& url);
    bool  updateConnections();
    void  blink(int index);
    void  rotate(int index, bool toleft);
    void  setSkill(int s);
    void  addRandomDir(CellList& list);
    void  addHighscore(int score);
    void  dialog(const QString& caption, const QString& text);
private:
    int         skill;
    bool        wrapped;
    Cell*       root;
    Cell*       board[MasterBoardSize * MasterBoardSize];
    QSound*     clicksound;
    QSound*     connectsound;
    QSound*     startsound;
    QSound*     turnsound;
    QSound*     winsound;
    QString     username;
    QString     soundpath;
    QAction*    soundaction;
    QStringList highscores;
    QLCDNumber* lcd;
    QPopupMenu* gamemenu;
    QPopupMenu* skillmenu;
};

#endif

