
//  qnetwalk/main.cpp
//  Copyright (C) 2004, Andi Peredri <andi@ukr.net>

#include <qapplication.h>
#include <qtextcodec.h>
#include <qtranslator.h>

#include "mainwindow.h"

int main(int argc, char ** argv)
{
    if((argc > 1) && QString(argv[1]) == "-help")
    {
	qWarning("Usage: qnetwalk [OPTIONS]\n"
		 "QNetWalk is a game for system administrators.\n"
		 "  -novice     set the skill Novice\n"
		 "  -amateur    set the skill Amateur\n"
		 "  -expert     set the skill Expert\n"
		 "  -master     set the skill Master\n"
		 "  -nosound    disable all sound effects\n"
		 "  -help       display this help and exit\n");
        return 1;
    }

    QApplication app(argc, argv);

    QTranslator qtranslator(&app);
    qtranslator.load(QString("qt_") + QTextCodec::locale(),
		     qInstallPathTranslations());
    app.installTranslator(&qtranslator);

    QString appdir   = app.applicationDirPath();
    QString filename = QString("qnetwalk_") + QTextCodec::locale();
    QTranslator translator(&app);
    if(!translator.load(filename, appdir + "/translations/"))
	translator.load(filename, appdir + "/../share/qnetwalk/translations/");
    app.installTranslator(&translator);

    MainWindow window;
    app.setMainWidget(&window);
    window.show();

    return app.exec();
}

