/*	$Id: qident.c,v 1.4 2001/09/15 12:07:36 ad Exp $	*/

/*
 * Copyright (c) 2001 Andrew Doran.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Andrew Doran.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/socket.h>

#include <netinet/in.h>
#include <arpa/inet.h>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <netdb.h>
#include <err.h>

#include <ident.h>

enum which {
	WHICH_USER,
	WHICH_OS
};

void	usage(void);

#if !defined(__NetBSD__) || __NetBSD_Version__ < 105010000
const char	*getprogname(void);
#endif

int
main(int argc, char **argv)
{
	struct in_addr la, fa;
	int lport, fport;
	char *ident, *os, *cs;
	ident_t *id;
	enum which which;
	struct hostent *he;
	int ch;

	which = WHICH_USER;

	while ((ch = getopt(argc, argv, "ou")) != -1)
		switch (ch) {
		case 'o':
			which = WHICH_OS;
			break;
		case 'u':
			which = WHICH_USER;
			break;
		default:
			usage();
			/* NOTREACHED */
		} 

	if (argc - optind != 4)
		usage();
	argv += optind;

	if ((he = gethostbyname(argv[0])) == NULL)
		errx(EXIT_FAILURE, "%s: %s", argv[0], hstrerror(h_errno));
	la = *(struct in_addr *)he->h_addr_list[0];

	if ((he = gethostbyname(argv[2])) == NULL)
		errx(EXIT_FAILURE, "%s: %s", argv[2], hstrerror(h_errno));
	fa = *(struct in_addr *)he->h_addr_list[0];

	if ((id = id_open(&la, &fa, NULL)) == NULL)
		errx(EXIT_FAILURE, "id_open() failed");

	if (id_query(id, atoi(argv[1]), atoi(argv[3]), NULL) < 0)
		err(EXIT_FAILURE, "id_query() failed");

	if (id_parse(id, NULL, &lport, &fport, &ident, &os, &cs) <= 0)
		err(EXIT_FAILURE, "id_parse() failed");	

	switch (which) {
	case WHICH_USER:
		printf("%s\n", ident);
		break;
	case WHICH_OS:
		if (os == NULL)
			os = "UNKNOWN-ERROR";
		printf("%s\n", os);
		break;
	}

	id_close(id);
	return (0);
}

void
usage(void)
{

	fprintf(stderr, "usage: %s <local-host> <local port>"
	    " <remote-host> <remote port>\n", getprogname());
	exit(EXIT_FAILURE);
	/* NOTREACHED */
}

#if !defined(__NetBSD__) || __NetBSD_Version__ < 105010000
const char *
getprogname(void)
{
	extern const char *__progname;

	return (__progname);
}
#endif
