#include "qadsl.h"

void create_pid()
{
	FILE *pidfd;
	
	if((pidfd=fopen(TMP_PID,"w"))==NULL) {
		fprintf(stderr,"Could not create PID file!\n");
		exit(1);
	}

	fprintf(pidfd,"%d",getpid());

	fclose(pidfd);
}

void quit_deamon()
{
	fprintf(stderr,"qADSL[%d]: Got SIGTERM signal, quiting!\n",getpid());
	exit(0);
}

void kill_pid()
{
	FILE *pidfd;
	char input[MAXLEN];

	if((pidfd=fopen(TMP_PID,"r"))!=NULL) {
		while((fgets(input, sizeof(input), pidfd))!=NULL) {
			kill(atoi(input),SIGTERM);
		}
	}
}
	
void url_encode(const char *in, char *out)
{
	for(;*in;++in) {
		if(isalnum(*in)) {
			*out = *in;
			++out;
		} else {
			sprintf(out, "%%%02x", *in);
			out += 3;
		}
	}
	*out = '\0';
}

void usage(char *argv) {
	printf("Usage: %s [ -h ] [ -c file ] [ -l ] [ -o ]\n", argv);
	printf("\t-h\t\tPrint this message\n\t-c file\t\tUse settings from file instead of /etc/qadsl.conf\n\t"
		"-l\t\tWill try to login\n\t-o\t\tWill try to logout\n");
}
