typedef struct
{
    double  x, y, z ;
} Point ;

typedef struct
{
    double  rl, fr, lr ;
} Angle ;

typedef struct
{
    double  r, g, b ;
} Color ;

typedef struct
{
    Point   point ;
    Angle   angle ;
    Point   scale ;
} Locate ;

typedef struct
{
    Color   rnd, mrr ;
    double  mrr_exponent ;
} Color_Data ;

typedef struct
{
    int         polygon_switch,
                nm_tops, top_no[MAX_TOPS_OF_POLYGON] ;
    Color_Data  color_data ;
} Polygon ;

typedef struct
{
    int     display_switch, nm_tops, nm_polygons ;
    Color   color2 ;
    Point   tops[MAX_TOPS_OF_OBJECT] ;
    Polygon polygons[MAX_POLYGONS] ;
} TP_Data ;

typedef struct
{
    int     my_chr, parent_obj, child_no_from_parent,
            nm_children, child_obj[MAX_CHILDREN] ;
    double  matrix_o_to_p[4][4], matrix_o_to_w[4][4],
            matrix_p_to_o[4][4], matrix_w_to_o[4][4],
            yon_clipping_distance, order_of_tops, color_rate ;
    Locate  locate ;
    Point   world_point ;
    TP_Data tp_data ;
} Object ;

typedef struct
{
    Point   vector ;
    Color   level, amb, back ;
    double  air_shading ;
} Light ;

typedef struct
{
    int     chr_no ;
    Locate  locate ;
} Child ;

typedef struct
{
    int     class, super_class_id, nm_children ;
    Child   children[MAX_CHILDREN] ;
    TP_Data tp_data ;
} Chr_Tbl ;

typedef struct
{
    int     x, y ;
} Position ;

typedef struct
{
    int     width, height ;
} W_Size ;

typedef struct
{
    double  width, height ;
} S_Size ;

typedef struct
{
    double  x, y ;
} Scr_XY ;

typedef struct
{
    int             nm_tops ;
    Scr_XY          scr_xy[MAX_TOPS_OF_POLYGON] ;
    unsigned long   pixel ;
    double          eye_distance ;
} Scr_Pol ;

typedef struct
{
    Scr_Pol scr_pol[MAX_OBJECTS * MAX_POLYGONS] ;
    Color   back ;
    int     nm_polygons ;
    int     priority[MAX_OBJECTS * MAX_POLYGONS] ;
} Screen_Work ;

typedef struct
{
    int         min_obj, max_obj ;
} D_Status ;

typedef struct
{
    double      rnd, mrr ;
} P_L_Work ;

typedef struct
{
    int         sw ;
    double      eye_distance ;
    P_L_Work    light ;
} D_P_Work ;

typedef struct
{
    int         sw ;
    Point       tops[MAX_TOPS_OF_OBJECT] ;
    Scr_XY      scr_xy[MAX_TOPS_OF_OBJECT] ;
    D_P_Work    polygons[MAX_POLYGONS] ;
} Display_Work ;

typedef struct
{
    Window          window ;
    Pixmap          pixmap ;
    int             color_type, red_shift, green_shift, blue_shift,
                    nm_red, nm_green, nm_blue, create_colormap,
                    p_nm_red, p_nm_green, p_nm_blue, p_nm_colors,
                    resize_mode, lgt_no, nm_objects ;
    double          mul_red, mul_green, mul_blue, scr_rate ;
    unsigned long   pixels[NM_COLORCELLS] ;
    Color           rgb_scale ;
    Colormap        colormap ;
    GC              gc ;
    Position        position ;
    XSizeHints      size_hint ;
    W_Size          size ;
    S_Size          scr_size, set_size ;
    double          scr_distance ;
    long            event_mask ;
    Screen_Work     screen_work ;
    Display_Work    display_work[MAX_OBJECTS] ;
    char            *title_name ;
} W_Status ;

typedef struct
{
    Display     *display ;
    Window      parent ;
    W_Status    win[MAX_WINDOWS] ;
    int         screen, depth ;
    Visual      *visual ;
    XSetWindowAttributes    attributes ;
    Colormap    colormap ;
    XEvent      event, event2 ;
    char        key_vector[32] ;
    XPoint      points[MAX_TOPS_OF_POLYGON] ;
    int         colormap_mode ;
} X_Objs ;

typedef struct
{
    int         nm_objects ;
    D_Status    d_status ;
    Object      obj[MAX_OBJECTS] ;
    Locate      eye_locate[MAX_EYES] ;
    Light       lgt[MAX_LIGHTS] ;
    Chr_Tbl     chr[MAX_CHARS] ;
    X_Objs      x_objs ;
} Data ;

typedef struct
{
    Point   vector, down_vector ;
} Dir_Vec ;

typedef struct
{
    double      sn, cs ;
} SinCos ;
