
/* ݥꥴ󥷥ƥॽץ
 * ΥեϤ˥󥯥롼ɤƻ */

#ifndef ___POLYGON_SYSTEM___
#define ___POLYGON_SYSTEM___

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <limits.h>

#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>

#include "setdef.h"
#include "strobj.h"
#include "proto.h"
#include "const.h"
#include "macro.h"

Data    *data ; /* ݥ륷ǰǡݥ */

/* data ¤κؿ
 * Ϥˤδؿ򥳡뤷ʤФʤʤ
 *  display    ³ X ФΥǥץ쥤̾ؤΥݥ
 *  SUCCESS_CODEԤ ERROR_CODE ֤ */
int CreateData(char *display)
{
    int     obj_no, chr_no, eye_no, lgt_no, child_no, win_no ;

    if ((data = (Data *)malloc(sizeof(Data))) == NULL) return ERROR_CODE ;

    /* ֥ȡʥ󥹥󥹡˥̥륯ꥢ */
    data->nm_objects = 0 ;
    for (obj_no = 0 ; obj_no < MAX_OBJECTS ; obj_no ++)
    {
	data->obj[obj_no].my_chr     = NULL_CHR ;
	data->obj[obj_no].parent_obj = NULL_CHR ;

	for (child_no = 0 ; child_no < MAX_CHILDREN ; child_no ++)
	    data->obj[obj_no].child_obj[child_no] = NULL_CHR ;
    }

    /* 饯ʥ饹˥̥륯ꥢ */
    for (chr_no = 0 ; chr_no < MAX_CHARS ; chr_no ++)
    {
	data->chr[chr_no].class = NULL_CHR ;
	data->chr[chr_no].super_class_id = NULL_CHR ;
    }

    /* ǥեȡC_White, P_DefaultLightVectorˤ˥å */
    for (lgt_no = 0 ; lgt_no < MAX_EYES ; lgt_no ++)
        SetLightStatus(lgt_no, C_White, C_Black,
		       P_DefaultLightVector, DEFAULT_AIR_SHADING) ;

    /* ǥեȥɥƥ */
    for (win_no = 0 ; win_no < MAX_WINDOWS ; win_no ++)
        SetDefaultWindowStatus(win_no) ;

    /* X Ф³ */
    X.display = XOpenDisplay(display) ;
    if (!(X.display))
    {
	fprintf(stderr, "Can't open display  %s\n", XDisplayName(display)) ;
        exit(1) ;
    }

    X.screen   = DefaultScreen(X.display) ;
    X.parent   = RootWindow(X.display, X.screen) ;
    X.visual   = DefaultVisual(X.display, X.screen) ;
    X.depth    = DefaultDepth(X.display, X.screen) ;
    X.colormap = DefaultColormap(X.display, X.screen) ;


/**********************/
    {
      XVisualInfo template;
      XVisualInfo *vinfo, *vi;
      int nitems, i, j, vflag = 0 ;

      int depthtable[10] = { 32, 24, 20, 16, 12, 10, 8, 4, 2, 1 };

      for ( i = 0; i < 10; ++i ) {
	template.screen = X.screen;
	template.depth = depthtable[i];
	if ( template.depth <= X.depth ) { break; }
	if ( !(vinfo = XGetVisualInfo( X.display, VisualScreenMask | VisualDepthMask,
				       &template, &nitems )) || nitems <= 0 ) continue;
	for ( j = 0, vi = vinfo; j < nitems; ++j, ++vi ) if ( vi->class == TrueColor ) break;
	if ( j == nitems ) for ( j = 0, vi = vinfo; j < nitems; ++j, ++vi )
	  if ( vi->class == DirectColor ) break;
	if ( j == nitems ) j = 0;
	X.visual = vi->visual;
	X.depth = vi->depth;
	vflag = 1;
	XFree( vinfo );
	break;
      }
    
      if ( vflag ) X.colormap = XCreateColormap( X.display, X.parent, X.visual, AllocNone );
      else X.colormap = XDefaultColormap( X.display, X.screen );
    }
/**********************/


    fprintf(stderr, "VisualClass: ") ;
    switch (X.visual->class)
    {
      case TrueColor:   fprintf(stderr, "TrueColor  \n") ; break ;
      case PseudoColor: fprintf(stderr, "PseudoColor\n") ; break ;
      case DirectColor: fprintf(stderr, "DirectColor\n") ; break ;
      default:          fprintf(stderr, "OtherClass \n") ; break ;
    }
    fprintf(stderr, "Depth: %d\n", X.depth) ;

    return SUCCESS_CODE ;
}

/* ФȤ³򥫥åȡǡ˴
 * ѸϤδؿ򥳡뤹٤Ǥ */
void DestroyData(void)
{
    XCloseDisplay(X.display) ;
    free(data) ;
    return ;
}

/* ƥɥ˥ǥեȤΥǡǼ */
void SetDefaultWindowStatus(int win_no)
{
    XW.size.width      = DEFAULT_WINDOW_WIDTH ;
    XW.size.height     = DEFAULT_WINDOW_HEIGHT ;

    SetWindowSizeHintsByGeometry(win_no, "", "") ;
    SetScreenSize(win_no, DEFAULT_SCREEN_WIDTH, DEFAULT_SCREEN_HEIGHT) ;

    XW.scr_distance    = DEFAULT_SCREEN_DISTANCE ;

    XW.color_type      = DEFAULT_COLOR_TYPE ;
    XW.rgb_scale.r     = DEFAULT_RGB_SCALE_R ;
    XW.rgb_scale.g     = DEFAULT_RGB_SCALE_G ;
    XW.rgb_scale.b     = DEFAULT_RGB_SCALE_B ;

    XW.event_mask      = StructureNotifyMask | ExposureMask ;

    SetNumberOfRGB(win_no, DEFAULT_NM_RED, DEFAULT_NM_GREEN, DEFAULT_NM_BLUE) ;

    return ;
}


/* ɥơؿ
 * δؿ뤵ʤϡǥեͤ
 *  win_no               ɥֹ0 - MAX_WINDOWS
 *  w_width, w_height    ɥΥ
 *  color_type           顼 RGBʥ顼 SCALEʥΡ
 *  r, g, b              r,g,b 
 *  scr_distance         ƥ꡼ޤǤεΥ
 *  s_width, s_height    ꡼Υ
 *  event_mask           ٥ȥޥ StructureNotifyMask
 *                       ڤ ExposureMask ϼưŪ򤵤
 *  resize_mode          ꥵβѲˡ
 *                       RESIZE_DEFAULT, RESIZE_WIDTH, RESIZE_HEIGHT,
 *                       RESIZE_SHORT, RESIZE_LONG Τ줫
 * ɥơطδؿơ
 * ̵ʰͿˤѲʤ */
void SetWindowStatus(int win_no,
		     int w_width, int w_height, int color_type,
		     double r, double g, double b, double scr_distance,
		     double s_width, double s_height, long event_mask,
		     int resize_mode)
{
    if (win_no < 0 || win_no >= MAX_WINDOWS) return ;

    SetWindowSize(win_no, w_width, w_height) ;
    SetColorType(win_no, color_type, r, g, b) ;
    SetScreenDistance(win_no, scr_distance) ;
    SetScreenSize(win_no, s_width, s_height) ;
    SetEventMask(win_no, event_mask) ;
    SetResizeMode(win_no, resize_mode) ;

    return ;
}

/* ɥơåȤΥӥ˥󥹴ؿ */

/* ɥޥ͡ؤΥҥȺؿ
 * ɸॸȥʸؤΥݥ󥿤顢ΥҥȤ */
void SetWindowSizeHintsByGeometry(int win_no, char *geometry, char *defgeom)
{
    int     geom_flag, x, y, w, h ;
    XW.size_hint.flags  = False ;
    XW.size_hint.width  = XW.size.width ;
    XW.size_hint.height = XW.size.height ;

/*
    geom_flag = XParseGeometry(geometry, &x, &y, &w, &h) ;
*/
    geom_flag = XGeometry(X.display, X.screen, geometry, defgeom,
			  0, 1,1, 0,0, &x, &y, &w, &h) ;
    if (geom_flag & WidthValue)
    {
        XW.size_hint.width = w ;
	XW.size_hint.flags |= USSize ;
    }
    if (geom_flag & HeightValue)
    {
        XW.size_hint.height = h ;
	XW.size_hint.flags |= USSize ;
    }
    if (geom_flag & XValue)
    {
        XW.size_hint.x = x ;
	XW.size_hint.flags |= USPosition ;
    }
    if (geom_flag & YValue)
    {
        XW.size_hint.y = y ;
	XW.size_hint.flags |= USPosition ;
    }
/*
    if (geom_flag & XValue)
    {
        if (geom_flag & XNegative)
	    x += DisplayWidth(X.display, X.screen) - XW.size_hint.width ;
        XW.size_hint.x = x ;
	XW.size_hint.flags |= USPosition ;
    }
    if (geom_flag & YValue)
    {
        if (geom_flag & YNegative)
	    y += DisplayHeight(X.display, X.screen) - XW.size_hint.height ;
        XW.size_hint.y = y ;
	XW.size_hint.flags |= USPosition ;
    }
*/

/*
    printf("%d, %d\n", x, y) ;
*/

/*
    if (XW.size_hint.flags & USPosition)
    {
        XW.size_hint.flags |= PWinGravity ;
        if (geom_flag & XNegative)
	{
	    if (geom_flag & YNegative)
	        XW.size_hint.win_gravity = SouthEastGravity ;
	    else 
	        XW.size_hint.win_gravity = NorthEastGravity ;
	}
	else
	{
	    if (geom_flag & YNegative)
	        XW.size_hint.win_gravity = NorthWestGravity ;
	    else 
	        XW.size_hint.win_gravity = SouthWestGravity ;
	}
    }
*/
    SetWindowPosition(win_no, XW.size_hint.x, XW.size_hint.y) ;
    SetWindowSize(win_no, XW.size_hint.width, XW.size_hint.height) ;
    XYRateByChangedSize(win_no) ;
    return ;
}

void SetWindowOrigin(int win_no, int win_gravity)
{
    XSizeHints  xs ;
    xs.flags = PWinGravity ;
    xs.win_gravity = win_gravity ;
    XSetNormalHints(X.display, XW.window, &xs) ;
    return ;
}

void SetWindowPosition(int win_no, int position_x, int position_y)
{
    if (win_no < 0 || win_no >= MAX_WINDOWS) return ;
    if (position_x != NULL_I) XW.position.x = position_x ;
    if (position_y != NULL_I) XW.position.y = position_y ;
    return ;
}

void SetWindowSize(int win_no, int w_width, int w_height)
{
    if (win_no < 0 || win_no >= MAX_WINDOWS) return ;
    if (w_width  > 0) XW.size.width  = w_width ;
    if (w_height > 0) XW.size.height = w_height ;
    return ;
}

/* resize_mode ˤ ꡼󥵥ѹ */
void XYRateByChangedSize(int win_no)
{
    double  scr_rate, r_rate ;
    scr_rate = (double)XW.size.width / (double)XW.size.height ;
    r_rate = scr_rate / XW.scr_rate ;
    switch (XW.resize_mode)
    {
      case RESIZE_DEFAULT:
	break ;
      case RESIZE_WIDTH:
	XW.scr_size.width  = XW.set_size.width ;
	XW.scr_size.height = XW.set_size.height / r_rate ;
	break ;
      case RESIZE_HEIGHT:
	XW.scr_size.height = XW.set_size.height ;
	XW.scr_size.width  = XW.set_size.width * r_rate ;
	break ;
      case RESIZE_SHORT:
	if (XW.scr_rate > scr_rate)
	{
	    XW.scr_size.width  = XW.set_size.width ;
	    XW.scr_size.height = XW.set_size.height / r_rate ;
	}
	else
	{
	    XW.scr_size.height = XW.set_size.height ;
	    XW.scr_size.width  = XW.set_size.width * r_rate ;
	}
	break ;
      case RESIZE_LONG:
	if (XW.scr_rate < scr_rate)
	{
	    XW.scr_size.width  = XW.set_size.width ;
	    XW.scr_size.height = XW.set_size.height / r_rate ;
	}
	else
	{
	    XW.scr_size.height = XW.set_size.height ;
	    XW.scr_size.width  = XW.set_size.width * r_rate ;
	}
	break ;
    }
    return ;
}

void SetScreenSize(int win_no, double s_width, double s_height)
{
    if (win_no < 0 || win_no >= MAX_WINDOWS) return ;
    if (s_width  != NULL_D) XW.scr_size.width = XW.set_size.width  = s_width ;
    if (s_height != NULL_D) XW.scr_size.height= XW.set_size.height = s_height ;
    /* ꡼Ĳ */
    XW.scr_rate = XW.scr_size.width / XW.scr_size.height ;
    return ;
}

void SetScreenDistance(int win_no, double scr_distance)
{
    if (win_no < 0 || win_no >= MAX_WINDOWS) return ;
    if (scr_distance > 0.0) XW.scr_distance = scr_distance ;
    return ;
}

/* 顼פ r,g,b ٤򥻥å */
void SetColorType(int win_no, int color_type,
		  double r, double g, double b)
{
    if (win_no < 0 || win_no >= MAX_WINDOWS) return ;
    if (color_type == RGB || color_type == SCALE) XW.color_type = color_type ;

    if (r != NULL_D) XW.rgb_scale.r = r ;
    if (g != NULL_D) XW.rgb_scale.g = g ;
    if (b != NULL_D) XW.rgb_scale.b = b ;

    return ;
}

void SetEventMask(int win_no, long event_mask)
{
    if (win_no < 0 || win_no >= MAX_WINDOWS) return ;
    XW.event_mask = event_mask | StructureNotifyMask | ExposureMask ;
    return ;
}

void SetResizeMode(int win_no, int resize_mode)
{
    if (win_no < 0 || win_no >= MAX_WINDOWS) return ;
    XW.resize_mode = resize_mode ;
    return ;
}

/* PseudoColor  XлѻΤͭ
 * r,g,b  åɡ꡼󡢥֥롼γƵʳ
 * r * g * b˸ĤΥ顼ͭ
 * ͭ˼ԤϿ˥顼ޥåפ
 * ͤ˴طʤ 8,8,4 Ȥ */
void SetNumberOfRGB(int win_no, int r, int g, int b)
{
    if (win_no < 0 || win_no >= MAX_WINDOWS) return ;
    if (r >= 1) XW.p_nm_red    = r ;
    if (g >= 1) XW.p_nm_green  = g ;
    if (b >= 1) XW.p_nm_blue   = b ;
    XW.p_nm_colors = XW.p_nm_red * XW.p_nm_green * XW.p_nm_blue ;
    return ;
}

/* ɥơѹؿ
 *  SetWindowStatus() Ʊ
 * SetupWindow() 򥳡뤷ΥɥΥơϤѹ
 *  ӥ˥󥹴ؿǡ
 * Change...() ̵Τϡ Set...() ѤǤ */
void ChangeWindowStatus(int win_no,
			int w_width, int w_height, int color_type,
			double r, double g, double b, double scr_distance,
			double s_width, double s_height, long event_mask,
			int resize_mode)
{
    if (win_no < 0 || win_no >= MAX_WINDOWS) return ;

    ChangeWindowSize(win_no, w_width, w_height) ;
    ChangeColorType(win_no, color_type, r, g, b) ;
    ChangeEventMask(win_no, event_mask) ;

    SetScreenDistance(win_no, scr_distance) ;
    SetScreenSize(win_no, s_width, s_height) ;
    SetResizeMode(win_no, resize_mode) ;

    return ;
}

void ChangeWindowPosition(int win_no, int position_x, int position_y)
{
    if (win_no < 0 || win_no >= MAX_WINDOWS) return ;

    if (position_x == NULL_I) position_x = XW.position.x ;
    if (position_y == NULL_I) position_y = XW.position.y ;

    XMoveWindow(X.display, XW.window, position_x, position_y) ; 
    do
    {
        XWindowEvent(X.display, XW.window, SubstructureNotifyMask, &X.event) ;
    } while (X.event.type != ConfigureNotify) ;

    XPutBackEvent(X.display, &X.event) ;
    EventOfWindowConfig(OFF, ON) ;
    return ;
}

void ChangeWindowSize(int win_no, int w_width, int w_height)
{
    if (win_no < 0 || win_no >= MAX_WINDOWS) return ;

    if (w_width  <= 0) w_width  = XW.size.width ;
    if (w_height <= 0) w_height = XW.size.height ;
    
    XResizeWindow(X.display, XW.window, w_width, w_height) ;
    XFreePixmap(X.display, XW.pixmap) ;
    XW.pixmap = XCreatePixmap(X.display, XW.window,
			      w_width, w_height, X.depth) ;
    do
    {
        XWindowEvent(X.display, XW.window, SubstructureNotifyMask, &X.event) ;
    } while (X.event.type != ConfigureNotify) ;

    XPutBackEvent(X.display, &X.event) ;
    EventOfWindowConfig(OFF, ON) ;
    return ;
}

void ChangeColorType(int win_no, int color_type,
		     double r, double g, double b)
{
    if (win_no < 0 || win_no >= MAX_WINDOWS) return ;
    if (color_type == RGB || color_type == SCALE) XW.color_type = color_type ;

    if (r != NULL_D) XW.rgb_scale.r = r ;
    if (g != NULL_D) XW.rgb_scale.g = g ;
    if (b != NULL_D) XW.rgb_scale.b = b ;

    /* PseudoColor λϡ顼٥å */
    if (X.visual->class == PseudoColor) SetColorCells(win_no) ;
    return ;
}

void ChangeEventMask(int win_no, long event_mask)
{
    if (win_no < 0 || win_no >= MAX_WINDOWS) return ;

    SetEventMask(win_no, event_mask) ;
    XSelectInput(X.display, XW.window, XW.event_mask) ;
}

void ChangeTitleName(int win_no, char *name)
{
    if (win_no < 0 || win_no >= MAX_WINDOWS) return ;
    AllocTitleName(win_no, name) ;
    XStoreName(X.display, XW.window, name) ;
    return ;
}


/* ɥեʥ٥Ƚ
 * 롼פδؿ򥳡뤹СɥѲɤ³뤳Ȥ
 *  clear_queue_switch     ON  ʤǸ˥٥ȥ塼˴
 *                         OFF λˤ˴ʤ
 *                       ץꥱ¦٥Ȥ򰷤ʤʤ顢ON 
 *  flush_switch           ON  ʤ顢X ΥꥯȥХåեɬեå夷
 *                         X ФƱ
 *   Ż߲˻ȤȤ ON ˡɽԤʤ̾ˤ OFF ˤ */
void EventOfWindowConfig(int clear_queue_switch, int flush_switch)
{
    int     config_flag = False ;
    if (flush_switch) XSync(X.display, False) ;

    while (XCheckTypedEvent(X.display, ConfigureNotify, &X.event))
    {
	PressureEvents() ;
	config_flag = WindowConfig(&X.event.xconfigure) ;
    }
    while (XCheckTypedEvent(X.display, Expose, &X.event))
    {
	int     nm_events = 0 ;
	nm_events = PressureEvents() ;
	if (!config_flag) WindowExpose(&X.event.xexpose, nm_events) ;
    }
    while (XCheckTypedEvent(X.display, ReparentNotify, &X.event))
    {
	WindowReparent(&X.event.xreparent) ;
    }
    if (clear_queue_switch) ClearEventsQueue() ;
    return ;
}

int PressureEvents(void)
{
    int     nm_events = 0 ;
    while (XCheckTypedWindowEvent(X.display, X.event.xany.window,
				  X.event.type, &X.event)) nm_events ++ ;
    return nm_events ; /* ̤٥ȤθĿ */
}

int ClearEventsQueue(void)
{
    int     nm_events = 0 ;
    while (XCheckMaskEvent(X.display, -1, &X.event)) nm_events ++ ;
    return nm_events ; /* ˴٥ȤθĿ */
}

/* ɥѲν
 * event   ConfigureNotify ٥ȹ¤ΤؤΥݥ */
int WindowConfig(XConfigureEvent *event)
{
    int     win_no = 0 ;
    while (XW.window != event->window)
        if ((++ win_no) > MAX_WINDOWS) return False ;

    XW.position.x = event->x ;
    XW.position.y = event->y ;

    if (XW.size.width  != event->width ||
	XW.size.height != event->height)
    {
	XW.size.width  = event->width ;
	XW.size.height = event->height ;

	/* ѲƤϡԥޥåפľ */
	XFreePixmap(X.display, XW.pixmap) ;
	XW.pixmap = XCreatePixmap(X.display, XW.window,
				  XW.size.width, XW.size.height, X.depth) ;

	/* ꥵ⡼ɤˤꥹ꡼󥵥ѹ */
	XYRateByChangedSize(win_no) ;

	/* RESIZE_DEFAULT ʳλϡåԥ󥰤ľ */
	switch (XW.resize_mode)
	{
	  case RESIZE_DEFAULT:
	    DrawWindowByScreenWork(win_no) ;
	    break ;
	  default:
	    CreateScreenWork(win_no) ;
	    break ;
	}
	return True ;
    }
    return False ;
}

/* ɥؿ
 *  event      ExposeEvent ¤ΤؤΥݥ
 * ٥Ȥ̤ƤСevent2_flag > 0Τ */
void WindowExpose(XExposeEvent *event, int event2_flag)
{
    int     win_no = 0 ;
    while (XW.window != event->window) if ((++ win_no) > MAX_WINDOWS) return ;

    if (event2_flag)
        XCopyArea(X.display, XW.pixmap, XW.window, XW.gc,
		  0,0, XW.size.width, XW.size.height, 0,0) ;
    else
        XCopyArea(X.display, XW.pixmap, XW.window, XW.gc, event->x, event->y,
		  event->width, event->height, event->x, event->y) ;

    XFlush(X.display) ;
    return ;
}

void WindowReparent(XReparentEvent *event)
{
    int     win_no = 0 ;

    while (XW.window != event->window)
        if ((++ win_no) > MAX_WINDOWS) return ;

    /* ɥޥ͡ҥȥå */
    if (X.parent != event->parent) 
    {
        XSetNormalHints(X.display, XW.window, &XW.size_hint) ;
	XStoreName(X.display, XW.window, XW.title_name) ;
    }

    return ;
}


/* ꤵ줿ɥơǡɥƥޥåפ
 * δؿǺΥɥΥơϡʤ Change...()
 * Ѥ
 *  win_no     ɥֹ0 - MAX_WINDOWS
 *  name       ȥСʸؤΥݥ */
void SetupWindow(int win_no, char *name)
{
    int     obj_no ;

    /* ꡼ѥХåեꥢ */
    XW.screen_work.nm_polygons = 0 ;
    XW.screen_work.back        = C_White ;
    for (obj_no = 0 ; obj_no < MAX_OBJECTS ; obj_no ++)
        XW.display_work[obj_no].sw = OFF ;

    XW.title_name = NULL ;

    /* ɥ */

    X.attributes.background_pixel = X.attributes.border_pixel = 0;
    X.attributes.colormap = X.colormap;

    XW.window = XCreateWindow(X.display, X.parent, XW.position.x,XW.position.y,
			      XW.size.width, XW.size.height, 0, X.depth,
			      InputOutput, X.visual, CWBackPixel | CWBorderPixel | CWColormap,
			      &X.attributes) ;

    /* ֥Хåեѥԥޥå & GC  */
    XW.pixmap = XCreatePixmap(X.display, XW.window,
			      XW.size.width, XW.size.height, X.depth) ;
    XW.gc = XCreateGC(X.display, XW.window, 0, 0) ;
    CreateNewColormap(win_no) ; /* ץ饤١ȥ顼ޥå׳*/ 

    /* ɥޥ͡ҥȥå */
    XSetNormalHints(X.display, XW.window, &XW.size_hint) ;
    AllocTitleName(win_no, name) ;

    /* ٥Ⱥ & ɥޥå */
    XSelectInput(X.display, XW.window, XW.event_mask) ;
    XMapWindow(X.display, XW.window) ;

/*
    SetWindowOrigin(0, NorthWestGravity) ;
*/

    SetColorCells(win_no) ; /* 顼륻å */
    ClearPixmap(win_no) ;   /* ԥޥåץꥢ */

    /* ɥޥåפˤ륤٥ȤԤ */
    XWindowEvent(X.display, XW.window, ExposureMask, &X.event) ;
    XPutBackEvent(X.display, &X.event) ;
    EventOfWindowConfig(OFF, OFF) ;

/*    XStoreName(X.display, XW.window, name) ; */
    XFlush(X.display) ;
    return ;
}

void AllocTitleName(int win_no, char *name)
{
    if (XW.title_name != NULL) free(XW.title_name) ;

    if (name == NULL) XW.title_name = NULL ;
    else
    {
	XW.title_name = (char *)malloc(strlen(name) + 1) ;
	strcpy(XW.title_name, name) ;
    }
    return ;
}

void  ClearPixmap(int win_no)
{
    XSetForeground(X.display, XW.gc, GetPixelByRGB(C_White, win_no)) ;
    XFillRectangle(X.display, XW.pixmap, XW.gc, 0,0,
		   XW.size.width, XW.size.height) ;
    return ;
}    

void InputKeybordMatrix(void)
{
    XQueryKeymap(X.display, X.key_vector) ;
    return ;
}

/* 顼ޥåסʥ˼ */
void CreateNewColormap(int win_no)
{
    unsigned long p_masks[8], pixels[1] ;
    XW.colormap = X.colormap ;
    XW.create_colormap = False ;

    switch(X.visual->class)
    {
      case PseudoColor:

	/* PseudoColor ʤ ץ饤١ȥ顼
	 * SetNumberOfRGB() ǥåȤ r * g * b˸Ĥͭ
	 * 뤬ǤʤȤϿ˥顼ޥåפ
	 * ơ256ġˤͭľʾ rgbͤ ̣ʤ */

        if (!XAllocColorCells(X.display, XW.colormap, False,
			      p_masks, 0, XW.pixels, XW.p_nm_colors))
	{
	    fprintf(stderr, "Can't alloc color cells.\n") ;
	    fprintf(stderr, "So creating new colormap.\n") ;

	    XW.create_colormap = True ;
	    XW.colormap = XCreateColormap
	      (X.display, XW.window, X.visual, AllocNone) ;

	    if (!XAllocColorCells(X.display, XW.colormap,
				  True, p_masks, 8, pixels, 1))
	    {
	        fprintf(stderr, "XallocColorCells Error\n") ;
		exit(1) ;
	    }
	}
	break ;
      case DirectColor:
	XW.colormap = XCreateColormap
	  (X.display, XW.window, X.visual, AllocAll) ;
	break ;
    }
    XSetWindowColormap(X.display, XW.window, XW.colormap) ;
    return ;
}

/* 顼륻å */
void SetColorCells(int win_no)
{
    if (X.visual->class == TrueColor || X.visual->class == DirectColor)
        SetColorCellsTD(win_no) ;
    else if (X.visual->class == PseudoColor)
    {
        if (XW.create_colormap)
	{
	    if (XW.color_type == RGB)
	        SetColorCells8RGB(win_no) ;
	    else if (XW.color_type == SCALE)
	        SetColorCells8SCALE(win_no) ;
	}
	else
	{
	    if (XW.color_type == RGB)
	        SetColorCellsLRGB(win_no) ;
	    else if (XW.color_type == SCALE)
	        SetColorCellsLSCALE(win_no) ;
	}
    }
    return ;
}

/* TrueColor ڤ DirectColor  rgb եɤĴ٤ */
void SetColorCellsTD(int win_no)
{
    XColor  rgb[256] ;
    int     cell, shift, bits ;

    for (shift = 0 ; !(X.visual->red_mask & (1 << shift)) ; ) shift ++ ;
    XW.red_shift = shift ;
    for (bits = 0 ; (X.visual->red_mask & (1 << shift)) ; shift ++) bits ++ ;
    XW.nm_red = 1 << bits ;

    for (shift = 0 ; !(X.visual->green_mask & (1 << shift)) ; ) shift ++ ;
    XW.green_shift = shift ;
    for (bits = 0 ; (X.visual->green_mask & (1 << shift)) ; shift ++) bits ++ ;
    XW.nm_green = 1 << bits ;

    for (shift = 0 ; !(X.visual->blue_mask & (1 << shift)) ; ) shift ++ ;
    XW.blue_shift = shift ;
    for (bits = 0 ; (X.visual->blue_mask & (1 << shift)) ; shift ++) bits ++ ;
    XW.nm_blue = 1 << bits ;

    XW.mul_red   = (double)XW.nm_red   - 0.001 ;
    XW.mul_green = (double)XW.nm_green - 0.001 ;
    XW.mul_blue  = (double)XW.nm_blue  - 0.001 ;

    if (X.visual->class == TrueColor) return ;

    /* DirectColor ʤ顢顼 rgb 򥻥åȤ
     * ߤΤȤ ե륫顼Τб */

    for (cell = 0 ; cell < 256 ; cell ++)
    {
	rgb[cell].red = rgb[cell].green = rgb[cell].blue = cell * 256 ;
	rgb[cell].pixel = (cell << XW.red_shift) +
	                  (cell << XW.green_shift) + (cell << XW.blue_shift) ;
	rgb[cell].flags = DoRed | DoGreen | DoBlue ;
    }
    XStoreColors(X.display, XW.colormap, rgb, 256) ;
    return ;
}

/* PseudoColor 256 */
void SetColorCells8RGB(int win_no)
{
    XColor  rgb[256] ;
    int     cell, r, g, b ;
    XW.green_shift = 3 + (XW.red_shift = 2 + (XW.blue_shift = 0)) ;

    for (g = 0 ; g < 8 ; g ++)
    {
	for (r = 0 ; r < 8 ; r ++)
	{
	    for (b = 0 ; b < 4 ; b ++)
	    {
		cell = (g << 5) + (r << 2) + b ;

		rgb[cell].red   = (double)r * XW.rgb_scale.r *  9362 ;
		rgb[cell].green = (double)g * XW.rgb_scale.g *  9362 ;
		rgb[cell].blue  = (double)b * XW.rgb_scale.b * 21845 ;

		rgb[cell].pixel = (g << XW.green_shift) +
		                  (r << XW.red_shift) + (b << XW.blue_shift) ;
		rgb[cell].flags = DoRed | DoGreen | DoBlue ;
	    }
	}
    }
    XStoreColors(X.display, XW.colormap, rgb, 256) ;
    return ;
}

void SetColorCells8SCALE(int win_no)
{
    XColor  scale[256] ;
    int     cell ;
    XW.red_shift = 0 ;

    for (cell = 0 ; cell < 256 ; cell ++)
    {
	scale[cell].red   = (unsigned long)((XW.rgb_scale.r * 255.0) * cell) ;
	scale[cell].green = (unsigned long)((XW.rgb_scale.g * 255.0) * cell) ;
	scale[cell].blue  = (unsigned long)((XW.rgb_scale.b * 255.0) * cell) ;
	scale[cell].pixel = cell << XW.red_shift ;
	scale[cell].flags = DoRed | DoGreen | DoBlue ;
    }
    XStoreColors(X.display, XW.colormap, scale, 256) ;
    return ;
}

/* PseudoColor  顼򿷵ʤä */
void SetColorCellsLRGB(int win_no)
{
#define XC  rgb[cell]
    XColor  rgb[256] ;   /* rgb[XW.p_nm_colors] ; */
    int     cell, r, g, b ;

    for (g = 0 ; g < XW.p_nm_green ; g ++)
    {
	for (r = 0 ; r < XW.p_nm_red ; r ++)
	{
	    for (b = 0 ; b < XW.p_nm_blue ; b ++)
	    {
		cell = g * G_GREEN + r * G_RED + b ;

		XC.red   = XW.rgb_scale.r * r * 65535 / (XW.p_nm_red   - 1) ;
		XC.green = XW.rgb_scale.g * g * 65535 / (XW.p_nm_green - 1) ;
		XC.blue  = XW.rgb_scale.b * b * 65535 / (XW.p_nm_blue  - 1) ;

		XC.pixel = XW.pixels[cell] ;
		XC.flags = DoRed | DoGreen | DoBlue ;
	    }
	}
    }
    XStoreColors(X.display, XW.colormap, rgb, XW.p_nm_colors) ;
    return ;
#undef  XC
}

void SetColorCellsLSCALE(int win_no)
{
#define XC  scale[cell]
    XColor  scale[256] ; /* scale[XW.p_nm_colors] ; */
    int     cell ;
    XW.red_shift = 0 ;

    for (cell = 0 ; cell < XW.p_nm_colors ; cell ++)
    {
	XC.red   = XW.rgb_scale.r * cell * 65535 / (XW.p_nm_colors - 1) ;
	XC.green = XW.rgb_scale.g * cell * 65535 / (XW.p_nm_colors - 1) ;
	XC.blue  = XW.rgb_scale.b * cell * 65535 / (XW.p_nm_colors - 1) ;

	XC.pixel = XW.pixels[cell] ;
	XC.flags = DoRed | DoGreen | DoBlue ;
    }
    XStoreColors(X.display, XW.colormap, scale, XW.p_nm_colors) ;
    return ;
#undef  XC
}


/*
void SetColorCells24(int win_no)
{
    XColor  rgb[256] ;
    int     cell, shift ;

    for (shift = 0 ; X.visual->red_mask % (1 << shift + 1) == 0 ; shift ++) ;
    XW.red_shift = shift ;
    for (shift = 0 ; X.visual->green_mask % (1 << shift + 1) == 0 ; shift ++) ;
    XW.green_shift = shift ;
    for (shift = 0 ; X.visual->blue_mask % (1 << shift + 1) == 0 ; shift ++) ;
    XW.blue_shift = shift ;

    if (X.visual->class == TrueColor) return ;
    
    for (cell = 0 ; cell < 256 ; cell ++)
    {
	rgb[cell].red = rgb[cell].green = rgb[cell].blue = cell * 256 ;
	rgb[cell].pixel = (cell << XW.red_shift) +
	                  (cell << XW.green_shift) + (cell << XW.blue_shift) ;
	rgb[cell].flags = DoRed | DoGreen | DoBlue ;
    }
    XStoreColors(X.display, XW.colormap, rgb, 256) ;
    return ;
}

void SetColorCells16(int win_no)
{
    XColor  rgb[32] ;
    int     cell, shift ;

    for (shift = 0 ; X.visual->red_mask % (1 << shift + 1) == 0 ; shift ++) ;
    XW.red_shift = shift ;
    for (shift = 0 ; X.visual->green_mask % (1 << shift + 1) == 0 ; shift ++) ;
    XW.green_shift = shift ;
    for (shift = 0 ; X.visual->blue_mask % (1 << shift + 1) == 0 ; shift ++) ;
    XW.blue_shift = shift ;

    if (X.visual->class == TrueColor) return ;
    
    for (cell = 0 ; cell < 32 ; cell ++)
    {
	rgb[cell].red = rgb[cell].green = rgb[cell].blue = cell * 2048 ;
	rgb[cell].pixel = (cell << XW.red_shift) +
	                  (cell << XW.green_shift) + (cell << XW.blue_shift) ;
	rgb[cell].flags = DoRed | DoGreen | DoBlue ;
    }
    XStoreColors(X.display, XW.colormap, rgb, 32) ;
    return ;
}
*/


/* GC ǻѤԥ֤ͤ
 * Color ι¤Τ ꡢ¸ߤ뿧Ƕ */
unsigned long GetPixelByRGB(Color cl, int win_no)
{
    if (cl.r > 1.0) cl.r = 1.0 ;
    if (cl.g > 1.0) cl.g = 1.0 ;
    if (cl.b > 1.0) cl.b = 1.0 ;

    if (cl.r < 0.0) cl.r = 0.0 ;
    if (cl.g < 0.0) cl.g = 0.0 ;
    if (cl.b < 0.0) cl.b = 0.0 ;

    if (X.visual->class == PseudoColor)
    {
        if (XW.create_colormap)
	{
	    switch (XW.color_type)
	    {
	      case RGB:
	        return
		  ((unsigned long)(cl.r * 7.999) << XW.red_shift  ) +
		  ((unsigned long)(cl.g * 7.999) << XW.green_shift) +
		  ((unsigned long)(cl.b * 3.999) << XW.blue_shift ) ;
	      case SCALE:
		return (unsigned long)
		  ((cl.r * 0.299 + cl.g * 0.587 + cl.b * 0.114) * 255.99) ;
	    }
	}
	else
	{
	    switch (XW.color_type)
	    {
	      case RGB:
	        return XW.pixels[(int)(cl.r * MUL_RED  ) * G_RED   +
				 (int)(cl.g * MUL_GREEN) * G_GREEN +
				 (int)(cl.b * MUL_BLUE )] ;
	      case SCALE:
		return XW.pixels[(int)
				 ((cl.r * 0.299 + cl.g * 0.587 + cl.b * 0.114)
				  * MUL_COLORS)] ;
	    }
	}
    }
    else if (X.visual->class == TrueColor)
    {
	switch (XW.color_type)
	{
	  case RGB:
	    return 
	      ((unsigned long)
	       (cl.r * XW.rgb_scale.r * XW.mul_red  ) << XW.red_shift) +
	      ((unsigned long)
	       (cl.g * XW.rgb_scale.g * XW.mul_green) << XW.green_shift) +
	      ((unsigned long)
	       (cl.b * XW.rgb_scale.b * XW.mul_blue ) << XW.blue_shift) ;
	  case SCALE:
	    cl.r = cl.r * 0.299 + cl.g * 0.587 + cl.b * 0.114 ;
	    return
	      ((unsigned long)
	       (cl.r * XW.rgb_scale.r * XW.mul_red  ) << XW.red_shift) +
	      ((unsigned long)
	       (cl.r * XW.rgb_scale.g * XW.mul_green) << XW.green_shift) +
	      ((unsigned long)
	       (cl.r * XW.rgb_scale.b * XW.mul_blue ) << XW.blue_shift) ;
	}
    }
    /* ǥХå */
    else if (X.depth == 15 ||
	     (X.depth == 16 && X.visual->class == DirectColor))
    {
	switch (XW.color_type)
	{
	  case RGB:
	    return 
	      ((unsigned long)
	       (cl.r * XW.rgb_scale.r * 31.99) << XW.red_shift) +
	      ((unsigned long)
	       (cl.g * XW.rgb_scale.g * 31.99) << XW.green_shift) +
	      ((unsigned long)
	       (cl.b * XW.rgb_scale.b * 31.99) << XW.blue_shift) ;
	  case SCALE:
	    cl.r = cl.r * 0.299 + cl.g * 0.587 + cl.b * 0.114 ;
	    return
	      ((unsigned long)
	       (cl.r * XW.rgb_scale.r * 31.99) << XW.red_shift) +
	      ((unsigned long)
	       (cl.r * XW.rgb_scale.g * 31.99) << XW.green_shift) +
	      ((unsigned long)
	       (cl.r * XW.rgb_scale.b * 31.99) << XW.blue_shift) ;
	}
    }
    else if (X.depth == 16)
    {
	switch (XW.color_type)
	{
	  case RGB:
	    return 
	      ((unsigned long)
	       (cl.r * XW.rgb_scale.r * 31.99) << XW.red_shift) +
	      ((unsigned long)
	       (cl.g * XW.rgb_scale.g * 63.99) << XW.green_shift) +
	      ((unsigned long)
	       (cl.b * XW.rgb_scale.b * 31.99) << XW.blue_shift) ;
	  case SCALE:
	    cl.r = cl.r * 0.299 + cl.g * 0.587 + cl.b * 0.114 ;
	    return
	      ((unsigned long)
	       (cl.r * XW.rgb_scale.r * 31.99) << XW.red_shift) +
	      ((unsigned long)
	       (cl.r * XW.rgb_scale.g * 63.99) << XW.green_shift) +
	      ((unsigned long)
	       (cl.r * XW.rgb_scale.b * 31.99) << XW.blue_shift) ;
	}
    }

    return ;
}

/* SetupWindow() ɥ˴
 * Ʊˡԥޥåפȥ顼ޥåסʥˤ */
void CloseWindow(int win_no)
{
    XDestroyWindow(X.display, XW.window) ;
    XFreePixmap(X.display, XW.pixmap) ;

    if (X.visual->class == PseudoColor && !XW.create_colormap)
        XFreeColors(X.display, XW.colormap, XW.pixels, XW.p_nm_colors, 0) ;
    else if (X.visual->class != TrueColor)
        XFreeColormap(X.display, XW.colormap) ;

    return ;
}

/* ١degreeˤ򸵤 sin,cos ׻SinCos ˥å */
void CalculateSinCos(SinCos *sincos, double degree)
{
    sincos->sn = Sin(degree) ;
    sincos->cs = Cos(degree) ;

    return ;
}

/* ɸx, yˤ degree ٲž */
void Revolve2D(double *x, double *y, double degree)
{
    SinCos  sincos ;

    CalculateSinCos(&sincos, degree) ;
    Revolve2DBySinCos(x, y, sincos) ;

    return ;
}

/* sincos ˤꡢx, yˤž */
void Revolve2DBySinCos(double *x, double *y, SinCos sincos)
{
#define SIN     sincos.sn
#define COS     sincos.cs

    double  work ;

    work = *x * COS - *y * SIN ;
    *y   = *x * SIN + *y * COS ;
    *x   = work ;

    return ;

#undef  SIN
#undef  COS
}

/* point  angle ˤžʣơ */
void RevolvePointByAngle(Point *point, Angle angle)
{
    Revolve2D(&(point->x), &(point->y), angle.rl) ;
    Revolve2D(&(point->y), &(point->z), angle.fr) ;
    Revolve2D(&(point->z), &(point->x), angle.lr) ;
    return ;
}

/* point  angle ˤղžʣơ */
void RevolvePointByReverseAngle(Point *point, Angle angle)
{
    Revolve2D(&(point->x), &(point->y), -angle.rl) ;
    Revolve2D(&(point->y), &(point->z), -angle.fr) ;
    Revolve2D(&(point->z), &(point->x), -angle.lr) ;
    return ;
}


/* ֥ȺɸɺɸؤѴ
 * ڤӤεѴȡƺɸؤѴ
 * ݥꥴĺν֡ʺƵˡɺɸ */
void MoveToParent(int obj_no)
{
    int     p_obj ;
    double  mat[4][4] ;
    p_obj = OBJ.parent_obj ;

    /* ֥ȺɸɺɸؤΰѴ
     * ȥåץ٥ ֥ Ǥʤ
     * ʬοƤؤѴ ƤΥɤؤѴ  */

    GetMatrixForObjectToParentByLocate(OBJ.matrix_o_to_w, &(OBJ.locate)) ;
    GetMatrixForParentToObjectByLocate(OBJ.matrix_w_to_o, &(OBJ.locate)) ;
    CopyMatrix4X4(OBJ.matrix_o_to_p, OBJ.matrix_o_to_w) ;
    CopyMatrix4X4(OBJ.matrix_p_to_o, OBJ.matrix_w_to_o) ;

    OBJ.order_of_tops = OBJ.locate.scale.x *
                        OBJ.locate.scale.y * OBJ.locate.scale.z ;
    if (p_obj != NULL_CHR)
    {
        AmpersandMatrix4X4(OBJ.matrix_o_to_w, P_OBJ.matrix_o_to_w) ;
        MultiMatrix4X4(OBJ.matrix_w_to_o, P_OBJ.matrix_w_to_o) ;
	OBJ.order_of_tops *= P_OBJ.order_of_tops ;
    }
    /* ɺɸ׻ */
    OBJ.world_point.x = OBJ.world_point.y = OBJ.world_point.z = 0.0 ;
    ChangePointByMatrix(&OBJ.world_point, OBJ.matrix_o_to_w) ;

    /* ʲƵ */
    {
	int     child_no = 0, child_obj ;

	while (child_no < MAX_CHILDREN)
	    if ((child_obj = OBJ.child_obj[child_no ++]) != NULL_CHR)
	        MoveToParent(child_obj) ;
    }
    return ;
}

/* ¹Ƽʬκɸ˰ư MoveToParent() 򥳡) */
void MoveChildrenToI(int obj_no)
{
    int     child_no = 0, child_obj ;

    while (child_no < MAX_CHILDREN)
        if ((child_obj = OBJ.child_obj[child_no ++]) != NULL_CHR)
	    MoveToParent(child_obj) ;
    return ;
}


/*
void AddPoint(Point *point, Point o_point)
{
    point->x += o_point.x ;
    point->y += o_point.y ;
    point->z += o_point.z ;

    return ;
}

void SubPoint(Point *point, Point o_point)
{
    point->x -= o_point.x ;
    point->y -= o_point.y ;
    point->z -= o_point.z ;

    return ;
}

void ScalingPoint(Point *p, Point scale)
{
    p->x *= scale.x ;
    p->y *= scale.y ;
    p->z *= scale.z ;

    return ;
}
*/


/*  o_anglerl, fr, lr νˡ˲žʥ֥Ⱥɸ */
/* scale ˤäơžդˤʤ */
void AmpersandAngleOnObjectByAngle(Locate *l, Angle *o_angle)
{
    AmpersandAngleByRL(&l->angle, Sgn(l->scale.x * l->scale.y) * o_angle->rl) ;
    AmpersandAngleByFR(&l->angle, Sgn(l->scale.y * l->scale.z) * o_angle->fr) ;
    AmpersandAngleByLR(&l->angle, Sgn(l->scale.z * l->scale.x) * o_angle->lr) ;
    return ;
}

/* angle   o_anglerl, fr, lr νˡ˲ž */
void AmpersandAngleByAngle(Angle *angle, Angle *o_angle)
{
    AmpersandAngleByRL(angle, o_angle->rl) ;
    AmpersandAngleByFR(angle, o_angle->fr) ;
    AmpersandAngleByLR(angle, o_angle->lr) ;
    return ;
}

/* angle   o_angle žʿƺɸȤơ */
void AmpersandAngleOnParentByAngle(Angle *angle, Angle *o_angle)
{
    /* dir = ܸ٥ȥʥ٥ȥ & ٥ȥ */
    Dir_Vec dir = {{0.0, 0.0, 1.0}, {0.0, 1.0, 0.0}} ;

    /* ܸ٥ȥ򸵤θ˲ž */
    RevolvePointByAngle(&(dir.vector), *angle) ;
    RevolvePointByAngle(&(dir.down_vector), *angle) ;

    /* ˲ž˲ž dir = ٥ȥ */
    RevolvePointByAngle(&(dir.vector), *o_angle) ;
    RevolvePointByAngle(&(dir.down_vector), *o_angle) ;

    VectorToAngle(angle, dir) ;
    return ;
}

/* angle   rl  ž */
void AmpersandAngleByRL(Angle *angle, double rl)
{
    /* dir = ܸ٥ȥʥ٥ȥ & ٥ȥ */
    Dir_Vec dir = {{0.0, 0.0, 1.0}, {0.0, 1.0, 0.0}} ;

    /* ܸ٥ȥž˲ž */
    Revolve2D(&(dir.vector.x), &(dir.vector.y), rl) ;
    Revolve2D(&(dir.down_vector.x), &(dir.down_vector.y), rl) ;

    /* ˸θ˲ž dir = ٥ȥ */
    RevolvePointByAngle(&(dir.vector), *angle) ;
    RevolvePointByAngle(&(dir.down_vector), *angle) ;

    VectorToAngle(angle, dir) ;
    return ;
}

/* angle   fr  ž */
void AmpersandAngleByFR(Angle *angle, double fr)
{
    /* dir = ܸ٥ȥʥ٥ȥ & ٥ȥ */
    Dir_Vec dir = {{0.0, 0.0, 1.0}, {0.0, 1.0, 0.0}} ;

    /* ܸ٥ȥž˲ž */
    Revolve2D(&(dir.vector.y), &(dir.vector.z), fr) ;
    Revolve2D(&(dir.down_vector.y), &(dir.down_vector.z), fr) ;

    /* ˸θ˲ž dir = ٥ȥ */
    RevolvePointByAngle(&(dir.vector), *angle) ;
    RevolvePointByAngle(&(dir.down_vector), *angle) ;

    VectorToAngle(angle, dir) ;
    return ;
}

/* angle   lr  ž */
void AmpersandAngleByLR(Angle *angle, double lr)
{
    /* dir = ܸ٥ȥʥ٥ȥ & ٥ȥ */
    Dir_Vec dir = {{0.0, 0.0, 1.0}, {0.0, 1.0, 0.0}} ;

    /* ܸ٥ȥž˲ž */
    Revolve2D(&(dir.vector.z), &(dir.vector.x), lr) ;
    Revolve2D(&(dir.down_vector.z), &(dir.down_vector.x), lr) ;

    /* ˸θ˲ž dir = ٥ȥ */
    RevolvePointByAngle(&(dir.vector), *angle) ;
    RevolvePointByAngle(&(dir.down_vector), *angle) ;

    VectorToAngle(angle, dir) ;
    return ;
}

/* ٥ȥȡŤ٥ȥ뤫
 * ٥ȥ׻Dir_Vec  */
void CalculateNewDownVectorOfDir_Vec(Dir_Vec *dir)
{
    Point   w ;

    /* Ť٥ȥȡ٥ȥγѡʿ٥ȥ */
    CalculateNormalVectorBy2Vectors(&w, &(dir->down_vector), &(dir->vector)) ;

    /* ٥ȥȡα٥ȥγѡʿ٥ȥ */
    CalculateNormalVectorBy2Vectors(&(dir->down_vector), &(dir->vector), &w) ;

    return ;
}

/* ٥ȥ & ٥ȥDir_Vecˤ angle() ׻ */
void VectorToAngle(Angle *angle, Dir_Vec dir)
{
#define SIN     sincos.sn
#define COS     sincos.cs
#define VX      dir.vector.x
#define VY      dir.vector.y
#define VZ      dir.vector.z
#define DVX     dir.down_vector.x
#define DVY     dir.down_vector.y
#define DVZ     dir.down_vector.z

    SinCos  sincos ;
    double  rt ;

    if (VZ == 0.0 && VX == 0.0) angle->lr = 0.0 ;
    else
    {
	rt  = sqrt(VZ * VZ + VX * VX) ;
	SIN = -VX / rt ;
	COS =  VZ / rt ;
	Revolve2DBySinCos(&(VZ), &(VX), sincos) ;
	Revolve2DBySinCos(&(DVZ), &(DVX), sincos) ;
	angle->lr = -Atan2(SIN, COS) ;
    }

    if (VY == 0.0 && VZ == 0.0) angle->fr = 0.0 ;
    else
    {
	rt  = sqrt(VY * VY + VZ * VZ) ;
	SIN = VY / rt ;
	COS = VZ / rt ;
/*	Revolve2DBySinCos(&(VY), &(VZ), sincos) ; */
	Revolve2DBySinCos(&(DVY), &(DVZ), sincos) ;
	angle->fr = -Atan2(SIN, COS) ;
    }

    if (DVX == 0.0 && DVY == 0.0) angle->rl = 0.0 ;
    else
    {
	rt = sqrt(DVX * DVX + DVY * DVY) ;
	angle->rl = -Atan2(DVX / rt, DVY / rt) ;
    }

    return ;

#undef  SIN
#undef  COS
#undef  VX
#undef  VY
#undef  VZ
#undef  DVX
#undef  DVY
#undef  DVZ
}

/* Angle -180.0 <= angle <= 180.0 */
void NormalizeAngle(Angle *angle)
{
    int     w ;

    w = (int)angle->rl / 360 ;
    angle->rl -= (double)w * 360.0 ;
    if (Abs(angle->rl) > 180.0) angle->rl -= Sgn(angle->rl) * 360.0 ;

    w = (int)angle->fr / 360 ;
    angle->fr -= (double)w * 360.0 ;
    if (Abs(angle->fr) > 180.0) angle->fr -= Sgn(angle->fr) * 360.0 ;

    w = (int)angle->lr / 360 ;
    angle->lr -= (double)w * 360.0 ;
    if (Abs(angle->lr) > 180.0) angle->lr -= Sgn(angle->lr) * 360.0 ;

    return ;
}

/* ѲѲ angle 顢ư¤ angle  */
void DivideMovedAngle(Angle *a, Angle o, Angle r)
{
    double  v ;

    if (r.rl > 0.0 && r.rl < 1.0)
    {
	if (a->rl < 0.0) a->rl += 360.0 ;
	if (o.rl  < 0.0) o.rl  += 360.0 ;
	v = a->rl - o.rl ;
	if (Abs(v) > 180.0) v -= Sgn(v) * 360.0 ;
	a->rl = o.rl + v * r.rl ;
    }
    if (r.fr > 0.0 && r.fr < 1.0)
    {
	if (a->fr < 0.0) a->fr += 360.0 ;
	if (o.fr  < 0.0) o.fr  += 360.0 ;
	v = a->fr - o.fr ;
	if (Abs(v) > 180.0) v -= Sgn(v) * 360.0 ;
	a->fr = o.fr + v * r.fr ;
    }
    if (r.lr > 0.0 && r.lr < 1.0)
    {
	if (a->lr < 0.0) a->lr += 360.0 ;
	if (o.lr  < 0.0) o.lr  += 360.0 ;
	v = a->lr - o.lr ;
	if (Abs(v) > 180.0) v -= Sgn(v) * 360.0 ;
	a->lr = o.lr + v * r.lr ;
    }
    NormalizeAngle(a) ;
    return ;
}

/* ѲѲ angle 顢٤ư¤ angle  */
void LimitMovedAngle(Angle *a, Angle o, Angle l)
{
    double  v ;

    if (l.rl > 0.0 && l.rl < 180.0)
    {
	if (a->rl < 0.0) a->rl += 360.0 ;
	if (o.rl  < 0.0) o.rl  += 360.0 ;
	v = a->rl - o.rl ;
	if (Abs(v) > 180.0) v -= Sgn(v) * 360.0 ;
	if (Abs(v) > l.rl) a->rl = o.rl + Sgn(v) * l.rl ;
    }
    if (l.fr > 0.0 && l.fr < 180.0)
    {
	if (a->fr < 0.0) a->fr += 360.0 ;
	if (o.fr  < 0.0) o.fr  += 360.0 ;
	v = a->fr - o.fr ;
	if (Abs(v) > 180.0) v -= Sgn(v) * 360.0 ;
	if (Abs(v) > l.fr) a->fr = o.fr + Sgn(v) * l.fr ;
    }
    if (l.lr > 0.0 && l.lr < 180.0)
    {
	if (a->lr < 0.0) a->lr += 360.0 ;
	if (o.lr  < 0.0) o.lr  += 360.0 ;
	v = a->lr - o.lr ;
	if (Abs(v) > 180.0) v -= Sgn(v) * 360.0 ;
	if (Abs(v) > l.lr) a->lr = o.lr + Sgn(v) * l.lr ;
    }
    NormalizeAngle(a) ;
    return ;
}

int CreateNewObject(int chr_no, Locate locate)
{
    int     obj_no ;
    if ((obj_no = SearchNullObject()) == NULL_CHR) return ERROR_CODE ;

    OBJ.yon_clipping_distance = DEFAULT_YON_CLIPPING_DISTANCE ; 
    OBJ.my_chr                = chr_no ;
    OBJ.locate                = locate ;
    OBJ.color_rate            = 0.0 ;
    OBJ.tp_data               = data->chr[chr_no].tp_data ;

    data->nm_objects ++ ;
    return obj_no ;
}

/* ꥯ饹(chr_no)ǡ locate  ˥塼֥Ȥ */
int CreateObject(int chr_no, int p_obj, Locate locate,
		 int n, int min_obj, int nm_obj)
{
    int     obj_no ;

    if (min_obj <= 0)                DST.min_obj = 0 ;
    else if (min_obj >= MAX_OBJECTS) DST.min_obj = MAX_OBJECTS -1 ;
    else                             DST.min_obj = min_obj ;

    if (nm_obj <= 0 || DST.min_obj + nm_obj > MAX_OBJECTS)
        DST.max_obj = MAX_OBJECTS ;
    else
        DST.max_obj = DST.min_obj + nm_obj ;

    if (p_obj >= 0 && P_OBJ.nm_children >= MAX_CHILDREN) return ERROR_CODE ;
    if ((obj_no = CreateNewObject(chr_no, locate)) == NULL_CHR)
        return ERROR_CODE ;

    if (p_obj < 0)
        OBJ.parent_obj = OBJ.child_no_from_parent = NULL_CHR ;
    else
    {
	int     child_no = 0 ;
	OBJ.parent_obj = p_obj ;

	while (P_OBJ.child_obj[child_no] >= 0) child_no ++ ;
	OBJ.child_no_from_parent = child_no ;
	P_OBJ.nm_children ++ ;
	P_OBJ.child_obj[child_no] = obj_no ;
    }

    /* Һǽ */
    if (CreateChildren(obj_no, n) == ERROR_CODE)
    {
        DestroyObject(obj_no) ;
	return ERROR_CODE ;
    }

    MoveToParent(obj_no) ;
    return obj_no ;
}

/* ꥪ֥ȤƤλ¹֥Ȥ Chr_Tbl ˤ */
int CreateChildren(int obj_no, int n)
{
    int     return_code ;

    if (n == 0) n = MAX_OBJECTS ;
    return_code = CreateChildByChr_Tbl(obj_no, n, 1) ;
    if (return_code == ERROR_CODE) return ERROR_CODE ;

    return SUCCESS_CODE ;
}

/* ꥪ֥ȤƤλҥ֥ȤʺƵ */
int CreateChildByChr_Tbl(int obj_no, int n, int r_count)
{
#define C_CHILD chr_children[child_no]

    Chr_Tbl *chr ;
    Child   *chr_children ;
    int     child_no, child_obj, return_code ;

    chr = &(data->chr[OBJ.my_chr]) ;
    chr_children = chr->children ;

    OBJ.nm_children = 0 ;

    for (child_no = 0 ; child_no < MAX_CHILDREN ; child_no ++)
        OBJ.child_obj[child_no] = NULL_CHR ;

    if (r_count >= n) return R_OVER ;

    for (child_no = 0 ; child_no < chr->nm_children ; child_no ++)
    {
	if ((child_obj = CreateNewObject(C_CHILD.chr_no, C_CHILD.locate))
	    == NULL_CHR) return ERROR_CODE ;

	OBJ.nm_children ++ ;
	OBJ.child_obj[child_no] = child_obj ;

	C_OBJ.child_no_from_parent  = child_no ;
	C_OBJ.parent_obj = obj_no ;

	/* ʲƵ */
	return_code = CreateChildByChr_Tbl(child_obj, n, r_count + 1) ;
	if (return_code == ERROR_CODE) return ERROR_CODE ;
    }
    return SUCCESS_CODE ;

#undef C_CHILD
}

/* ̥륪֥ȡʥ󥹥󥹡ˤ򸡺 */
int SearchNullObject(void)
{
    int     obj_no = 0 ;
    obj_no = DST.min_obj ;

    while (obj_no < DST.max_obj && (data->obj[obj_no].my_chr != NULL_CHR))
        obj_no ++ ;

    if (obj_no < DST.max_obj) return obj_no ;
    else                      return NULL_CHR ;
}

/* ̥륭饯ʥ饹ˤ򸡺 */
int SearchNullChar(void)
{
    int     chr_no = 0 ;
    while (chr_no < MAX_CHARS && (data->chr[chr_no].class != NULL_CHR))
        chr_no ++ ;

    if (chr_no < MAX_CHARS) return chr_no ;
    else                    return NULL_CHR ;
}

/* ֥ȺɸpointˤɺɸѴ */
void ObjectPointToWorldPointByObjectLocate(Point *point, Locate *locate)
{
    RevolvePointByAngle(point, locate->angle) ;
    ScalingPoint(point, locate->scale) ;
    AddPoint(point, locate->point) ;
    return ;
}

/* Display_work[] ڤ Polyon[]ſɸc_of_gravity˷׻ */
void CalculateCenterOfGravityOfPolygon(Point *c_of_gravity,
				       Display_Work *dw, Polygon *pn)
{
    int     top_no ;

    c_of_gravity->x = 0.0 ;
    c_of_gravity->y = 0.0 ;
    c_of_gravity->z = 0.0 ;

    for (top_no = 0 ; top_no < pn->nm_tops ; top_no ++)
    {
	c_of_gravity->x += dw->tops[pn->top_no[top_no]].x ;
	c_of_gravity->y += dw->tops[pn->top_no[top_no]].y ;
	c_of_gravity->z += dw->tops[pn->top_no[top_no]].z ;
    }
    c_of_gravity->x /= top_no ;
    c_of_gravity->y /= top_no ;
    c_of_gravity->z /= top_no ;

    return ;
}

/* vector = p1  p2 ظ٥ȥ */
void CalculateVectorOfPointToPoint(Point *vector, Point *p1, Point *p2)
{
    *vector = *p2 ;
    SubPoint(vector, *p1) ;
    return ;
}

/* Display_Work[] ڤ Polygon[] ñˡ٥ȥn_vector˷׻
 * Σκɸ׻order_of_tops ˤäƽѤ */
void CalculateUnitNormalVectorOfPolygon(Point *n_vector, Display_Work *dw,
					Polygon *pn, double order_of_tops)
{
    Point p1, p2 ;

    if (order_of_tops >= 0.0)
    {
	p1 = dw->tops[pn->top_no[0]] ;
	p2 = dw->tops[pn->top_no[1]] ;

	/* Σ飲٥ȥp1,p2ˤ׻ */
	SubPoint(&p1, p2) ;
	SubPoint(&p2, dw->tops[pn->top_no[2]]) ;
    }
    else
    {
	p1 = dw->tops[pn->top_no[2]] ;
	p2 = dw->tops[pn->top_no[1]] ;

	/* Σ飲٥ȥp1,p2ˤ׻ */
	SubPoint(&p1, p2) ;
	SubPoint(&p2, dw->tops[pn->top_no[0]]) ;
    }

    /* Ѥ ñ̥٥ȥ벽 */
    CalculateNormalVectorBy2Vectors(n_vector, &p1, &p2) ;
    UnitVector(n_vector) ;

    return ;
}

/* ٥ȥp1,p2ˤ鳰ѡn_vector˷׻  */
void CalculateNormalVectorBy2Vectors(Point *n_vector, Point *p1, Point *p2)
{
    n_vector->x = p1->y * p2->z - p2->y * p1->z ;
    n_vector->y = p1->z * p2->x - p2->z * p1->x ;
    n_vector->z = p1->x * p2->y - p2->x * p1->y ;

    return ;
}

/* ñ̥٥ȥ벽 */
void UnitVector(Point *v)
{
    double  abs_vector ;

    abs_vector = sqrt(v->x * v->x + v->y * v->y + v->z * v->z) ;
    if (abs_vector != 0.0)
    {
	v->x /= abs_vector ;
	v->y /= abs_vector ;
	v->z /= abs_vector ;
    }
    return ;
}

/* Lambert ;§ˤȻȿͥǥ
 * l:٥ȥ, n:ˡ٥ȥ */
double Shading(Point *l, Point *n)
{
    double  ln ;

    ln = -(l->x * n->x + l->y * n->y + l->z * n->z) ;
    if (ln < 0.0) return 0.0 ;

    return ln ;
}

/* Phong Υǥˤϥ饤
 * e:٥ȥ, l:٥ȥ, n:ˡ٥ȥ */
double HighLight(Point *e, Point *l, Point *n, double m_exp)
{
    double  ln ;
    Point   r ;

    ReflectVector(&r, l, n) ;
    ln = -(r.x * e->x + r.y * e->y + r.z * e->z) ;

    if (ln < 0.0) return 0.0 ;
    return pow(ln, pow(2, m_exp * 10.0)) ;
}

/* ϥ饤ȤΣ
 * e:٥ȥ, l:٥ȥ, n:ˡ٥ȥ */
double HighLight2(Point *e, Point *l, Point *n, double m_exp)
{
    double  ln ;
    Point   h ;
    h = *e ;

    AddVector(&h, l) ;
    UnitVector(&h) ;
    ln = -(h.x * n->x + h.y * n->y + h.z * n->z) ;

    if (ln < 0.0) return 0.0 ;
    return pow(ln, pow(2, m_exp * 10.0)) ;
}

/* ȿͥ٥ȥ׻
 * r:, v:ȿ٥ȥ, n:ˡ٥ȥ */
void ReflectVector(Point *r, Point *v, Point *n)
{
    double  ln2 ;

    ln2 = 2.0 * (v->x * n->x + v->y * n->y + v->z * n->z) ;
    r->x = v->x - ln2 * n->x ;
    r->y = v->x - ln2 * n->y ;
    r->z = v->z - ln2 * n->z ;

    return ;
}

void AddVector(Point *v1, Point *v2)
{
    v1->x += v2->x ;
    v1->y += v2->y ;
    v1->z += v2->z ;

    return ;
}

/* ̽ʥХåեˡ */
int HiddenSurface(Point *e, Point *n)
{
    if ((e->x * n->x + e->y * n->y + e->z * n->z) < 0.0) return ON ;
    return OFF ;
}


#define SX      scr_xy->x
#define SY      scr_xy->y
#define S_DST   x_win->scr_distance

/* ƩѴ(, 3D_Point, ɥơ) */
void CalculateScreenXYBy3DPoint(Scr_XY *scr_xy, Point *p, W_Status *x_win)
{
    if (p->z >= S_DST)
    {
	SX = p->x * S_DST / p->z ; 
	SY = p->y * S_DST / p->z ;
    }
    else
        SX = SY = OUT_OF_SCREEN ;

    return ;
}

void ResizeScreenXY(Scr_XY *scr_xy, int win_no)
{
    if (SX == OUT_OF_SCREEN) return ;
    SX = SX / XW.scr_size.width  + 0.5 ;
    SY = SY / XW.scr_size.height + 0.5 ;
    return ;
}

#undef  SX
#undef  SY
#undef  S_DST

#define EYE     data->obj[eye_no]
#define TP      OBJ.tp_data
#define SW      XW.screen_work
#define DW      XW.display_work[obj_no]
#define PN      polygons[pol_no]
#define TN      tops[top_no]
#define LGT     data->lgt[lgt_no]

/* ֥Ȥ򥦥ɥɽ */
void DisplayObjects(int eye_no, int lgt_no, int win_no)
{
    int     nm_objects = 0, i = 0, obj_no = 0, pol_no, top_no ;
    Point   p_gravity, n_vector, e_vector, e_point = {0.0, 0.0, 0.0} ;
    Color   cl ;
    double  air_lv ;

    /* e_point = Υɺɸ */
    ChangePointByMatrix(&e_point, EYE.matrix_o_to_w) ;

    do
    {
        /* ̥륪֥,å ֥Ȥ򥪥 */
        if (OBJ.my_chr == NULL_CHR)
	{
	    DW.sw = OFF ;
	    continue ;
	}
	i ++ ;
	if (OBJ.tp_data.display_switch == OFF)
	{
	    DW.sw = OFF ;
	    continue ;
	}
	DW.sw = ON ;
	for (pol_no = 0 ; pol_no < TP.nm_polygons ; pol_no ++)
	{
	    if (TP.PN.polygon_switch == ON) DW.PN.sw = ON ;
	    else                            DW.PN.sw = OFF ;
	}
	for (top_no = 0 ; top_no < TP.nm_tops ; top_no ++)
	{
	    /* ֥ȺɸɺɸѴ */
	    DW.TN = TP.TN ;
	    ChangePointByMatrix(&(DW.TN), OBJ.matrix_o_to_w) ;
	}
	for (pol_no = 0 ; pol_no < TP.nm_polygons ; pol_no ++)
	{
	    if (DW.PN.sw == OFF) continue ;
	    if (TP.PN.nm_tops >= 3)
	    {
	        /* DW.PN.c_of_gravity = ݥꥴſɸ */
	        CalculateCenterOfGravityOfPolygon(&p_gravity, &DW, &TP.PN) ;

		/* e_vector = ݥꥴſ٥ȥ */
		CalculateVectorOfPointToPoint(&e_vector,&e_point, &p_gravity) ;

		/* DW.PN.eye_distance = ݥꥴſޤǤεΥ */
		DW.PN.eye_distance = VAbs(e_vector) ;

		/* åԥ */
		if ((OBJ.yon_clipping_distance > 0.0 &&
		     OBJ.yon_clipping_distance < DW.PN.eye_distance) ||
		    (LGT.air_shading > 0.0 &&
		     LGT.air_shading < DW.PN.eye_distance))
		{
		    DW.PN.sw = OFF ;
		    continue ;
		}
		/* e_vector = ñ̻٥ȥ */
		UnitVector(&e_vector) ;

		/* n_vector = ݥꥴñˡ٥ȥ */
		CalculateUnitNormalVectorOfPolygon(&n_vector, &DW, &TP.PN,
						   OBJ.order_of_tops) ;

		/* Хåեˡˤ뱣̽ */
		if ((DW.PN.sw = HiddenSurface(&e_vector, &n_vector)) == OFF)
		    continue ; /* ̤ʤ鼡Υ롼פ */

		/* Lambert ;§ˤ륷ǥ */
		DW.PN.light.rnd = Shading(&LGT.vector, &n_vector) ;

		/* Phong Υǥˤϥ饤 */
		DW.PN.light.mrr =HighLight2(&e_vector, &LGT.vector, &n_vector,
					    TP.PN.color_data.mrr_exponent) ;
	    }
	    else if (TP.PN.nm_tops == 2)
	    {
	        e_vector = p_gravity = DW.tops[TP.PN.top_no[0]] ;
		SubPoint(&e_vector, e_point) ;
		DW.PN.eye_distance = VAbs(e_vector) - (double)pol_no * 0.0001 ;
		/* åԥ */
		if ((OBJ.yon_clipping_distance > 0.0 &&
		     OBJ.yon_clipping_distance < DW.PN.eye_distance) ||
		    (LGT.air_shading > 0.0 &&
		     LGT.air_shading < DW.PN.eye_distance))
		{
		    DW.PN.sw = OFF ;
		    continue ;
		}
		DW.PN.light.rnd = 1.0 ;
		DW.PN.light.mrr = 0.0 ;

		/* Ѵ tops[top1].x,y Ⱦ¤ɽ褦Ѵ */
		{
		    Point   t0, t1 ;

		    t0 = DW.tops[TP.PN.top_no[0]] ;
		    t1 = DW.tops[TP.PN.top_no[1]] ;

		    ChangePointByMatrix(&t0, EYE.matrix_w_to_o) ;
		    ChangePointByMatrix(&t1, EYE.matrix_w_to_o) ;
		    SubPoint(&t1, t0) ;
		    t1.x = t1.y = VAbs(t1) ;
		    t1.z += t0.z ;

		    ChangePointByMatrix(&t1, EYE.matrix_o_to_w) ;
		    DW.tops[TP.PN.top_no[1]] = t1 ;
		}
	    }
	}

	for (top_no = 0 ; top_no < TP.nm_tops ; top_no ++)
	{
	    /* ɺɸѴ */
	    ChangePointByMatrix(&(DW.TN), EYE.matrix_w_to_o) ;

	    /* ƩѴ */
	    CalculateScreenXYBy3DPoint(&(DW.scr_xy[top_no]), &(DW.TN), &XW) ;
	}
	nm_objects ++ ;

    } while ((++ obj_no < MAX_OBJECTS) && i < data->nm_objects) ;

    XW.lgt_no     = lgt_no ;
    XW.nm_objects = nm_objects ;

    CreateScreenWork(win_no) ;
    return ;
}

/* ǥץ쥤饹꡼ʺǽ˺ */
void CreateScreenWork(int win_no)
{
    int   lgt_no, nm_objects, i = 0, obj_no, pol_no, top_no, no, out_x, out_y ;
    Color   cl ;
    double  air_lv ;
    lgt_no     = XW.lgt_no ;
    nm_objects = XW.nm_objects ;

    SW.back        = LGT.back ;
    SW.nm_polygons = 0 ;

    for (obj_no = 0 ; obj_no < MAX_OBJECTS &&
	              i < nm_objects ; obj_no ++)
    {
        if (DW.sw == OFF) continue ;
	i ++ ;
	for (pol_no = 0 ; pol_no < TP.nm_polygons ; pol_no ++)
	{
	    int     out_x = 0, out_y = 0 ;
	    if (DW.PN.sw == OFF) continue ;
	    for (top_no = 0 ; top_no < TP.PN.nm_tops ; top_no ++)
	    {
		SW.scr_pol[SW.nm_polygons].scr_xy[top_no] =
		  DW.scr_xy[TP.PN.top_no[top_no]] ;
		ResizeScreenXY
		  (&SW.scr_pol[SW.nm_polygons].scr_xy[top_no], win_no) ;

		if (SW.scr_pol[SW.nm_polygons].scr_xy[top_no].x ==
		    OUT_OF_SCREEN)
		{
/*		    DW.PN.sw = OFF ; */
		    break ;
		}
		if (TP.PN.nm_tops >= 3)
		{
		    if (SW.scr_pol[SW.nm_polygons].scr_xy[top_no].x < 0.0)
		        out_x -- ;
		    else if (SW.scr_pol[SW.nm_polygons].scr_xy[top_no].x > 1.0)
		        out_x ++ ;

		    if (SW.scr_pol[SW.nm_polygons].scr_xy[top_no].y < 0.0)
		        out_y -- ;
		    else if (SW.scr_pol[SW.nm_polygons].scr_xy[top_no].y > 1.0)
		        out_y ++ ;
		}
		else if (TP.PN.nm_tops == 2 && top_no == 1)
		{
		    double  xr, yr ;

		    /* Ⱦ¤ */
		    xr = (SW.scr_pol[SW.nm_polygons].scr_xy[1].x -= 0.5) ;
		    yr = (SW.scr_pol[SW.nm_polygons].scr_xy[1].y -= 0.5) ;

		    /* åԥ */
		    if (SW.scr_pol[SW.nm_polygons].scr_xy[0].x < -xr ||
			SW.scr_pol[SW.nm_polygons].scr_xy[0].x > 1.0 + xr ||
			SW.scr_pol[SW.nm_polygons].scr_xy[0].y < -yr ||
			SW.scr_pol[SW.nm_polygons].scr_xy[0].y > 1.0 + yr)
		        out_x = 2 ;
		}
	    }
	    if (DW.PN.sw == OFF	||
		Abs(out_x) == top_no || Abs(out_y) == top_no)
	    {
/*		DW.PN.sw = OFF ; */
		continue ;
	    }

	    /* ѤˡݥꥴεΥ screen_work ˥å */
	    SW.scr_pol[SW.nm_polygons].eye_distance = DW.PN.eye_distance ;

	    /* ƥݥꥴĺ򥻥å */
	    SW.scr_pol[SW.nm_polygons].nm_tops = TP.PN.nm_tops ;

	    /* ƥݥꥴο׻ */
	    cl.r = LGT.level.r * (TP.PN.color_data.rnd.r * DW.PN.light.rnd +
				  TP.PN.color_data.mrr.r * DW.PN.light.mrr) +
		   LGT.amb.r   *  TP.PN.color_data.rnd.r ;

	    cl.g = LGT.level.g * (TP.PN.color_data.rnd.g * DW.PN.light.rnd +
				  TP.PN.color_data.mrr.g * DW.PN.light.mrr) +
		   LGT.amb.g   *  TP.PN.color_data.rnd.g ;

	    cl.b = LGT.level.b * (TP.PN.color_data.rnd.b * DW.PN.light.rnd +
				  TP.PN.color_data.mrr.b * DW.PN.light.mrr) +
		   LGT.amb.b   *  TP.PN.color_data.rnd.b ;

	    /* 졼Ȥˤꥫ顼 */
	    cl.r += (TP.color2.r - cl.r) * OBJ.color_rate ;
	    cl.g += (TP.color2.g - cl.g) * OBJ.color_rate ;
	    cl.b += (TP.color2.b - cl.b) * OBJ.color_rate ;

	    /* ǥ */
	    if (LGT.air_shading > 0.0)
	        air_lv = DW.PN.eye_distance / LGT.air_shading ;
	    else
	        air_lv = 0.0 ;

	    cl.r += (LGT.back.r - cl.r) * air_lv ;
	    cl.g += (LGT.back.g - cl.g) * air_lv ;
	    cl.b += (LGT.back.b - cl.b) * air_lv ;

	    SW.scr_pol[SW.nm_polygons ++].pixel =
	      GetPixelByRGB(cl, win_no) ;
	}
    }

    /* ץ饤ƥ */
    for (no = 0 ; no < SW.nm_polygons ; SW.priority[no] = no ++) ;

/*
    for (no = 0 ; no < SW.nm_polygons ;
	 SW.priority[SW.nm_polygons - no - 1] = no ++) ;
*/

    QuickSort(SW.nm_polygons, SW.priority, SW.scr_pol) ;
    DrawWindowByScreenWork(win_no) ;

    return ;
}

/* ꡼Ƥ饦ɥɽ */
void DrawWindowByScreenWork(int win_no)
{
#define WID     XW.size.width
#define HGT     XW.size.height

    int     no, pol_no, top_no ;

    XSync(X.display, False) ;

    /* طʿǥꥢ */
    XSetForeground(X.display, XW.gc, GetPixelByRGB(SW.back, win_no)) ;
    XFillRectangle(X.display, XW.pixmap, XW.gc, 0,0, WID, HGT) ;
    for (no = SW.nm_polygons - 1 ; no >= 0 ; no --)
    {
	pol_no = SW.priority[no] ;

	if (SW.scr_pol[pol_no].nm_tops >= 3)
	{
	    for (top_no = 0 ; top_no < SW.scr_pol[pol_no].nm_tops ; top_no ++)
	    {
		X.points[top_no].x =
		  (short)(SW.scr_pol[pol_no].scr_xy[top_no].x * (double)WID) ;
		X.points[top_no].y =
		  (short)(SW.scr_pol[pol_no].scr_xy[top_no].y * (double)HGT) ;
	    }
	    XSetForeground(X.display, XW.gc, SW.scr_pol[pol_no].pixel) ;
	    XFillPolygon(X.display, XW.pixmap, XW.gc, X.points,
			 SW.scr_pol[pol_no].nm_tops, Convex, CoordModeOrigin) ;
	}
	else if (SW.scr_pol[pol_no].nm_tops == 2)
	{
	    X.points[1].x =
	      (short)(SW.scr_pol[pol_no].scr_xy[1].x * (double)WID) ;
	    X.points[1].y =
	      (short)(SW.scr_pol[pol_no].scr_xy[1].y * (double)HGT) ;

	    X.points[0].x =
	      (short)(SW.scr_pol[pol_no].scr_xy[0].x * (double)WID) -
	      X.points[1].x ;
	    X.points[0].y =
	      (short)(SW.scr_pol[pol_no].scr_xy[0].y * (double)HGT) -
	      X.points[1].y ;

	    XSetForeground(X.display, XW.gc, SW.scr_pol[pol_no].pixel) ;
	    XFillArc(X.display, XW.pixmap, XW.gc, X.points[0].x, X.points[0].y,
		     X.points[1].x * 2, X.points[1].y * 2, 0, 360 * 64) ;
	}
    }
    XCopyArea(X.display, XW.pixmap, XW.window, XW.gc, 0,0, WID,HGT, 0,0) ;

    XFlush(X.display) ;
    return ;

#undef  WID
#undef  HGT
}

#undef  EYE
#undef  TP
#undef  DW
#undef  SW
#undef  PN
#undef  TN
#undef  LGT

/* åȡ Ȥѡ */
void QuickSort(int n, int no[], Scr_Pol a[])
{
    int     i, j, left, right, p, t ;
    int     leftstack[STACKSIZE_FOR_QUICKSORT],
            rightstack[STACKSIZE_FOR_QUICKSORT] ;
    double  x ;

    left  = 0 ;
    right = n - 1 ;
    p = 0 ;

    for ( ; ; )
    {
	if (right - left <= THRESHOLD_FOR_QUICKSORT)
	{
	    if (p == 0) break ;
	    p -- ;
	    left  = leftstack[p] ;
	    right = rightstack[p] ;
	}
	x = a[no[(left + right) / 2]].eye_distance ;
	i = left ;
	j = right ;
	for ( ; ; )
	{
	    while (a[no[i]].eye_distance < x) i ++ ;
	    while (x < a[no[j]].eye_distance) j -- ;
	    if (i >= j) break ;
	    t = no[i] ;
	    no[i] = no[j] ;
	    no[j] = t ;
	    i ++ ;
	    j -- ;
	}
	if (i - left > right - j)
	{
	    if (i - left > THRESHOLD_FOR_QUICKSORT)
	    {
		leftstack[p]  = left ;
		rightstack[p] = i - 1 ;
		p ++ ;
	    }
	    left = j + 1 ;
	}
	else
	{
	    if (right - j > THRESHOLD_FOR_QUICKSORT)
	    {
		leftstack[p]  = j + 1 ;
		rightstack[p] = right ;
		p ++ ;
	    }
	    right = i - 1 ;
	}
    }
    InsertionSort(n, no, a) ;
    return ;
}

/*  */
void InsertionSort(int n, int no[], Scr_Pol a[])
{
    int     i, j, x ;

    for (i = 1 ; i < n ; i ++)
    {
	x = no[i] ;
	for (j = i - 1 ; j >= 0 && a[no[j]].eye_distance >
	                           a[x].eye_distance ; j --) no[j + 1] = no[j] ;
	no[j + 1] = x ;
    }
    return ;
}

/* ɸˤѴp = mat[4][4] * p */
void ChangePointByMatrix(Point *p, double mat[4][4])
{
    Point   w ;
    w = *p ;

    p->x = mat[0][0] * w.x + mat[0][1] * w.y + mat[0][2] * w.z + mat[0][3] ;
    p->y = mat[1][0] * w.x + mat[1][1] * w.y + mat[1][2] * w.z + mat[1][3] ;
    p->z = mat[2][0] * w.x + mat[2][1] * w.y + mat[2][2] * w.z + mat[2][3] ;

    return ;
}

/* Τa = a * b */
void MultiMatrix4X4(double a[4][4], double b[4][4])
{
    double  c[4][4] ;
    int     i, j ;

    for (i = 0 ; i < 4 ; i ++)
        for (j = 0 ; j < 4 ; j ++)
	    c[i][j] = a[i][0] * b[0][j] + a[i][1] * b[1][j] +
	              a[i][2] * b[2][j] + a[i][3] * b[3][j] ;

    for (i = 0 ; i < 4 ; i ++)
        for (j = 0 ; j < 4 ; a[i][j] = c[i][j ++]) ;

    return ;
}

/* ιa = b * a */
void AmpersandMatrix4X4(double a[4][4], double b[4][4])
{
    double  c[4][4] ;
    int     i, j ;

    for (i = 0 ; i < 4 ; i ++)
        for (j = 0 ; j < 4 ; j ++)
	    c[i][j] = b[i][0] * a[0][j] + b[i][1] * a[1][j] +
	              b[i][2] * a[2][j] + b[i][3] * a[3][j] ;

    for (i = 0 ; i < 4 ; i ++)
        for (j = 0 ; j < 4 ; a[i][j] = c[i][j ++]) ;

    return ;
}

/* rl žѤѴ׻ */
void GetMatrixForRevolveRLByAngle(double mat[4][4], Angle *angle)
{
    SinCos  sincos ;
    CalculateSinCos(&sincos, angle->rl) ;

    mat[0][0] =   mat[1][1] = sincos.cs ;
    mat[0][1] = -(mat[1][0] = sincos.sn) ;
    mat[2][2] =   mat[3][3] = 1.0 ;
    mat[0][2] =   mat[0][3] = mat[1][2] = mat[1][3] = mat[2][0] =
    mat[2][1] =   mat[2][3] = mat[3][0] = mat[3][1] = mat[3][2] = 0.0 ;

    return ;
}

/* fr žѤѴ׻ */
void GetMatrixForRevolveFRByAngle(double mat[4][4], Angle *angle)
{
    SinCos  sincos ;
    CalculateSinCos(&sincos, angle->fr) ;

    mat[1][1] =   mat[2][2] = sincos.cs ;
    mat[1][2] = -(mat[2][1] = sincos.sn) ;
    mat[0][0] =   mat[3][3] = 1.0 ;
    mat[0][1] =   mat[0][2] = mat[0][3] = mat[1][0] = mat[1][3] =
    mat[2][0] =   mat[2][3] = mat[3][0] = mat[3][1] = mat[3][2] = 0.0 ;

    return ;
}

/* lr žѤѴ׻ */
void GetMatrixForRevolveLRByAngle(double mat[4][4], Angle *angle)
{
    SinCos  sincos ;
    CalculateSinCos(&sincos, angle->lr) ;

    mat[0][0] =   mat[2][2] = sincos.cs ;
    mat[2][0] = -(mat[0][2] = sincos.sn) ;
    mat[1][1] =   mat[3][3] = 1.0 ;
    mat[0][1] =   mat[0][3] = mat[1][0] = mat[1][2] = mat[1][3] =
    mat[2][1] =   mat[2][3] = mat[3][0] = mat[3][1] = mat[3][2] = 0.0 ;

    return ;
}

/* ʿ԰ưѤѴ׻ */
void GetMatrixForMoveByPoint(double mat[4][4], Point *p)
{
    mat[0][3] = p->x ; mat[1][3] = p->y ; mat[2][3] = p->z ;
    mat[0][0] = mat[1][1] = mat[2][2] = mat[3][3] = 1.0 ;
    mat[0][1] = mat[0][2] = mat[1][0] = mat[1][2] =
    mat[2][0] = mat[2][1] = mat[3][0] = mat[3][1] = mat[3][2] = 0.0 ;

    return ;
}

/* ѤѴ׻ */
void GetMatrixForScaling(double mat[4][4], Point *s)
{
    mat[0][0] = s->x ; mat[1][1] = s->y ; mat[2][2] = s->z ; mat[3][3] = 1.0 ;
    mat[0][1] = mat[0][2] = mat[0][3] = mat[1][0] =
    mat[1][2] = mat[1][3] = mat[2][0] = mat[2][1] =
    mat[2][3] = mat[3][0] = mat[3][1] = mat[3][2] = 0.0 ;

    return ;
}

/* ֥ȺɸϤ飱ĿƤκɸϤؤѴ */
void GetMatrixForObjectToParentByLocate(double mat[4][4], Locate *locate)
{
    double  w_m[4][4] ;
/*
    GetMatrixForRevolveRLByAngle(mat, &(locate->angle)) ;
    GetMatrixForRevolveFRByAngle(w_m, &(locate->angle)) ;
    AmpersandMatrix4X4(mat, w_m) ;

    GetMatrixForRevolveLRByAngle(w_m, &(locate->angle)) ;
    AmpersandMatrix4X4(mat, w_m) ;

    GetMatrixForScaling(w_m, &(locate->scale)) ;
    AmpersandMatrix4X4(mat, w_m) ;

    GetMatrixForMoveByPoint(w_m, &(locate->point)) ;
    AmpersandMatrix4X4(mat, w_m) ;
*/
    GetMatrixForScaling(mat, &(locate->scale)) ;
    GetMatrixForRevolveRLByAngle(w_m, &(locate->angle)) ;
    AmpersandMatrix4X4(mat, w_m) ;

    GetMatrixForRevolveFRByAngle(w_m, &(locate->angle)) ;
    AmpersandMatrix4X4(mat, w_m) ;

    GetMatrixForRevolveLRByAngle(w_m, &(locate->angle)) ;
    AmpersandMatrix4X4(mat, w_m) ;

    GetMatrixForMoveByPoint(w_m, &(locate->point)) ;
    AmpersandMatrix4X4(mat, w_m) ;

    return ;
}

/* ĿƤκɸϤ饪֥ȺɸϤؤѴʾεѴ */
void GetMatrixForParentToObjectByLocate(double mat[4][4], Locate *locate)
{
    double  w_m[4][4] ;
    Locate  l ;
    l = *locate ;

    /* Locate ȿž */
    ReverseLocate(&l) ;

    /* սѴ */
/*
    GetMatrixForMoveByPoint(mat, &(l.point)) ;
    GetMatrixForScaling(w_m, &(l.scale)) ;
    AmpersandMatrix4X4(mat, w_m) ;

    GetMatrixForRevolveLRByAngle(w_m, &(l.angle)) ;
    AmpersandMatrix4X4(mat, w_m) ;

    GetMatrixForRevolveFRByAngle(w_m, &(l.angle)) ;
    AmpersandMatrix4X4(mat, w_m) ;

    GetMatrixForRevolveRLByAngle(w_m, &(l.angle)) ;
    AmpersandMatrix4X4(mat, w_m) ;
*/
    GetMatrixForMoveByPoint(mat, &(l.point)) ;
    GetMatrixForRevolveLRByAngle(w_m, &(l.angle)) ;
    AmpersandMatrix4X4(mat, w_m) ;

    GetMatrixForRevolveFRByAngle(w_m, &(l.angle)) ;
    AmpersandMatrix4X4(mat, w_m) ;

    GetMatrixForRevolveRLByAngle(w_m, &(l.angle)) ;
    AmpersandMatrix4X4(mat, w_m) ;

    GetMatrixForScaling(w_m, &(l.scale)) ;
    AmpersandMatrix4X4(mat, w_m) ;

    return ;
}

/* ǥ󥰴ؿѤѴ */
void GetMatrixForCreateChr_Tbl(double mat[4][4], Locate *locate)
{
    double  w_m[4][4] ;
    Point   point = {0.0, 0.0, 0.0} ;

    /* point = -locate->point */
    SubPoint(&point, locate->point) ;

    GetMatrixForRevolveRLByAngle(mat, &(locate->angle)) ;
    GetMatrixForRevolveFRByAngle(w_m, &(locate->angle)) ;
    AmpersandMatrix4X4(mat, w_m) ;

    GetMatrixForRevolveLRByAngle(w_m, &(locate->angle)) ;
    AmpersandMatrix4X4(mat, w_m) ;

    GetMatrixForMoveByPoint(w_m, &point) ;
    AmpersandMatrix4X4(mat, w_m) ;

    GetMatrixForScaling(w_m, &(locate->scale)) ;
    AmpersandMatrix4X4(mat, w_m) ;

    return ;
}


/* ڤӥ֥Ȱưޥ */

#define O_OBJ   data->obj[o_obj]
#define CHR     data->chr[chr_no]

#define InstanceCommand(COMMAND) \
{ \
    int     obj_no ; \
    if (class_id >= 0) \
    { \
	if (instance_id >= 0) \
	{ \
	    obj_no = instance_id ; \
	    do \
	    { \
		if (IfInstanceBelongToClass(obj_no, class_id)) \
		{ \
		    COMMAND ; \
	        } \
	    } while ((obj_no = SearchNextDescendant \
		      (obj_no, instance_id)) != NULL_CHR) ; \
        } \
	else if (instance_id == ALL) \
	{ \
	    for (obj_no = 0 ; obj_no < MAX_OBJECTS ; obj_no ++) \
	    { \
	        if (OBJ.my_chr != NULL_CHR && \
		    IfInstanceBelongToClass(obj_no, class_id)) \
	        { \
		    COMMAND ; \
	        } \
	    } \
        } \
    } \
    else if (class_id == ALL) \
    { \
	if (instance_id >= 0) \
	{ \
	    obj_no = instance_id ; \
	    do \
	    { \
		COMMAND ; \
	    } while ((obj_no = SearchNextDescendant \
		      (obj_no, instance_id)) != NULL_CHR) ;\
        } \
	else if (instance_id == ALL) \
	{ \
	    for (obj_no = 0 ; obj_no < MAX_OBJECTS ; obj_no ++) \
	    { \
		if (OBJ.my_chr != NULL_CHR) { COMMAND ; } \
	    } \
        } \
    } \
    else if (class_id == NONE) \
    { \
	if (instance_id >= 0) \
	{ \
	    obj_no = instance_id ; \
	    { COMMAND ; } \
        } \
	else if (instance_id == ALL) \
	{ \
	    for (obj_no = 0 ; obj_no < MAX_OBJECTS ; obj_no ++) \
	    { \
		if (OBJ.parent_obj == NULL_CHR) { COMMAND ; } \
	    } \
        } \
    } \
}


/* instance λ¹obj_noˤˤɤNULL_CHR ޤǡ */
int SearchNextDescendant(int obj_no, int instance_id)
{
    int     child_no ;
    if (OBJ.nm_children > 0)
    {
	child_no = 0 ;
	while (OBJ.child_obj[child_no] == NULL_CHR) child_no ++ ;
	return OBJ.child_obj[child_no] ;
    }
    else
    {
	do
	{
	    for (child_no = OBJ.child_no_from_parent + 1,
		 obj_no = OBJ.parent_obj ;
		 OBJ.child_obj[child_no] == NULL_CHR &&
		 child_no < MAX_CHILDREN ;
		 child_no ++) ;
	    if (child_no < MAX_CHILDREN) return OBJ.child_obj[child_no] ;
	} while (obj_no != instance_id) ;

	/* 롼Ȥä */
	return NULL_CHR ;
    }
}

/* obj_no  class_id ڤӤ饹°Ƥ뤫 */
int IfInstanceBelongToClass(int obj_no, int class_id)
{
    int     chr_no ;
    chr_no = OBJ.my_chr ;

    while (True)
    {
	if (chr_no == class_id) return True ;
	if ((chr_no = CHR.super_class_id) == NULL_CHR) return False ;
    }
}

/* obj_no  instance_id Ϥλ¹ɤ */
int IfInstanceDescendant(int obj_no, int instance_id)
{
    while (True)
    {
	if (obj_no == instance_id) return True ;
	if ((obj_no = OBJ.parent_obj) == NULL_CHR) return False ;
    }
}


/* 󥹥󥹥ޥ */
void MoveC(int instance_id, int class_id, Point v)
{
    InstanceCommand(Move(obj_no, v)) ;
    return ;
}

void RevolveC(int instance_id, int class_id, Angle v)
{
    InstanceCommand(Revolve(obj_no, v)) ;
    return ;
}

void RevolveAndMoveC(int instance_id, int class_id, Locate v)
{
    InstanceCommand(RevolveAndMove(obj_no, v)) ;
    return ;
}

void MoveOnParentC(int instance_id, int class_id, Point v)
{
    InstanceCommand(MoveOnParent(obj_no, v)) ;
    return ;
}

void RevolveOnParentC(int instance_id, int class_id, Angle v)
{
    InstanceCommand(RevolveOnParent(obj_no, v)) ;
    return ;
}

void LockOnObjectC(int instance_id, int class_id,
		   int o_obj, Angle rate, Angle limit)
{
    InstanceCommand(LockOnObject(obj_no, o_obj, rate, limit)) ;
    return ;
}

void ScalingC(int instance_id, int class_id,
	      Point s, int relative_switch)
{
    InstanceCommand(Scaling(obj_no, s, relative_switch)) ;
    return ;
}

void SetDisplaySwitchC(int instance_id, int class_id,
		       int display_switch)
{
    InstanceCommand(SetDisplaySwitch(obj_no, display_switch)) ;
    return ;
}

void SetYonClippingC(int instance_id, int class_id,
		     double yon_clipping)
{
    InstanceCommand(SetYonClipping(obj_no, yon_clipping)) ;
    return ;
}

void SetColorRateC(int instance_id, int class_id, int color_rate)
{
    InstanceCommand(SetDisplaySwitch(obj_no, color_rate)) ;
    return ;
}






void Move(int obj_no, Point v)
{
    /* Ƥκɸʬžȥ ԤʤäƤư */
    ScalingPoint(&v, OBJ.locate.scale) ;
    RevolvePointByAngle(&v, OBJ.locate.angle) ;
/*
    RevolvePointByAngle(&v, OBJ.locate.angle) ;
    ScalingPoint(&v, OBJ.locate.scale) ;
*/
    AddPoint(&(OBJ.locate.point), v) ;
    MoveToParent(obj_no) ;

    return ;
}

void Revolve(int obj_no, Angle v)
{
    AmpersandAngleOnObjectByAngle(&OBJ.locate, &v) ;
    MoveToParent(obj_no) ;
    return ;
}

void RevolveAndMove(int obj_no, Locate v)
{
    /* ޤž */
    AmpersandAngleOnObjectByAngle(&OBJ.locate, &v.angle) ;

    /* Ƥκɸʬžȥ ԤʤäƤư */
    ScalingPoint(&v.point, OBJ.locate.scale) ;
    RevolvePointByAngle(&v.point, OBJ.locate.angle) ;
/*
    RevolvePointByAngle(&v.point, OBJ.locate.angle) ;
    ScalingPoint(&v.point, OBJ.locate.scale) ;
*/
    AddPoint(&(OBJ.locate.point), v.point) ;
    MoveToParent(obj_no) ;

    return ;
}

void MoveOnParent(int obj_no, Point v)
{
    AddPoint(&(OBJ.locate.point), v) ;
    MoveToParent(obj_no) ;
    return ;
}

void RevolveOnParent(int obj_no, Angle v)
{
    AmpersandAngleOnParentByAngle(&OBJ.locate.angle, &v) ;
    MoveToParent(obj_no) ;
    return ;
}

void LockOnObject(int obj_no, int o_obj, Angle rate, Angle limit)
{
    int     p_obj ;
    Dir_Vec d = {{0.0, 0.0, 0.0}, {0.0, 1.0, 0.0}} ;
    Angle   old ;
    p_obj = OBJ.parent_obj ;
    old = OBJ.locate.angle ;

    /* d.vector = ֥ȣΡ֥ȣLocateǤκɸ */
    d.vector = O_OBJ.world_point ;
    if (p_obj != NULL_CHR)
          ChangePointByMatrix(&d.vector, P_OBJ.matrix_w_to_o) ;

    /* d.vector = 飲ظ֥ȣLocateǤΥ٥ȥ */
    SubPoint(&d.vector, OBJ.locate.point) ;
    if (OBJ.locate.scale.z < 0.0)
    {
	d.vector.x = -d.vector.x ;
	d.vector.y = -d.vector.y ;
	d.vector.z = -d.vector.z ;
    }

    /* d.down_vector = ֥ȣѹ٥ȥ */
    RevolvePointByAngle(&d.down_vector, old) ;

    /* d = ٥ȥ  angle ׻ */
/*
    CalculateNewDownVectorOfDir_Vec(&d) ;
*/
    VectorToAngle(&OBJ.locate.angle, d) ;

    /* ٤ư̤ */
    DivideMovedAngle(&(OBJ.locate.angle), old, rate) ;
    LimitMovedAngle(&(OBJ.locate.angle), old, limit) ;

    MoveToParent(obj_no) ;
    return ;
}

/* ֥ȤƤΩ */
void IndependentFromParent(int obj_no)
{
    int     p_obj ;
    Dir_Vec d = {{0.0, 0.0, 1.0}, {0.0, 1.0, 0.0}} ;
    Point   right_vector = {1.0, 0.0, 0.0} ;

    if ((p_obj = OBJ.parent_obj) == NULL_CHR) return ;
    OBJ.parent_obj = NULL_CHR ;
    P_OBJ.nm_children -- ;
    P_OBJ.child_obj[OBJ.child_no_from_parent] = NULL_CHR ;

    OBJ.locate.point = GetPointOnWorld(obj_no) ;

    ChangePointByMatrix(&d.vector, OBJ.matrix_o_to_w) ;
    ChangePointByMatrix(&d.down_vector, OBJ.matrix_o_to_w) ;
    ChangePointByMatrix(&right_vector, OBJ.matrix_o_to_w) ;

    SubPoint(&d.vector, OBJ.locate.point) ;
    SubPoint(&d.down_vector, OBJ.locate.point) ;
    SubPoint(&right_vector, OBJ.locate.point) ;

    OBJ.locate.scale.x = VAbs(right_vector) * Sgn(OBJ.order_of_tops) ;
    OBJ.locate.scale.y = VAbs(d.down_vector) ;
    OBJ.locate.scale.z = VAbs(d.vector) ;

    VectorToAngle(&OBJ.locate.angle, d) ;

    MoveToParent(obj_no) ;
    return ;
}

void Scaling(int obj_no, Point s, int relative_switch)
{
    if (relative_switch == ON)
    {
        ScalingPoint(&OBJ.locate.scale, s) ;
    }
    else
	OBJ.locate.scale = s ;

    MoveToParent(obj_no) ;
    return ;
}

void SetPointOnParent(int obj_no, Point p)
{
    OBJ.locate.point = p ;
    MoveToParent(obj_no) ;
    return ;
}

void SetPointOnWorld(int obj_no, Point p)
{
    ChangePointByMatrix(&p, OBJ.matrix_w_to_o) ;
    OBJ.locate.point = p ;
    MoveToParent(obj_no) ;
    return ;
}

void SetAngleOnParent(int obj_no, Angle a)
{
    OBJ.locate.angle = a ;
    MoveToParent(obj_no) ;
    return ;
}

void SetDisplaySwitch(int obj_no, int display_switch)
{
    if (display_switch == TURN)
    {
	if (OBJ.tp_data.display_switch == ON) display_switch = OFF ;
	else                                  display_switch = ON ;
    }
    OBJ.tp_data.display_switch = display_switch ;
    return ;
}

void SetYonClipping(int obj_no, double yon_clipping)
{
    OBJ.yon_clipping_distance = yon_clipping ;
    return ;
}

void SetColorRate(int obj_no, double color_rate)
{
    OBJ.color_rate = color_rate ;
    return ;
}

void SetColor2(int obj_no, Color color2)
{
    OBJ.tp_data.color2 = color2 ;
    return ;
}

void DestroyObject(int obj_no)
{
    int     p_obj, child_obj, child_no, nm_children, i ;
    if (OBJ.my_chr == NULL_CHR) return ;
    nm_children = OBJ.nm_children ;

    /* Ҥк */
    for (child_no = 0, i = 0 ; child_no < MAX_CHILDREN &&
	                       i < nm_children ; child_no ++)
    {
	if ((child_obj = OBJ.child_obj[child_no]) < 0) continue ;
	DestroyObject(child_obj) ;
	i ++ ; /* Ҥο */
    }
    /* Ƥ Ƥ鼫ʬؤ³򥫥å */
    if ((p_obj = OBJ.parent_obj) >= 0)
    {
	P_OBJ.nm_children -- ;
	P_OBJ.child_obj[OBJ.child_no_from_parent] = NULL_CHR ;
    }
    /* ʬ */
    OBJ.my_chr = NULL_CHR ;
    data->nm_objects -- ;

    return ;
}




/* 饹° ǽΥ󥹥󥹤 ID ֤
 * 륪֥Ȥʤ NULL_CHR */
int GetInstanceID(int instance_id, int class_id)
{
    InstanceCommand(return obj_no) ;
    return NULL_CHR ;
}

/* ʣnm_ids <= 0 ʤ顢¹ǳΤơ
 * ǽŪ  ID ο֤ʳʤʤ  */
int GetInstanceIDs(int instance_id, int class_id,
		   int nm_ids, int *ids)
{
    int     i = 0 ;
    InstanceCommand(ids[i ++] = obj_no ;
		    if (nm_ids > 0 && i >= nm_ids) return i) ;
    return i ;
}

int GetInstanceIDsOfChildren(int obj_no, int nm_ids, int *ids)
{
    int     i, child_no = 0 ;
    if (OBJ.nm_children < nm_ids || nm_ids <= 0) nm_ids = OBJ.nm_children ;
    for (i = 0 ; i < nm_ids || i < MAX_CHILDREN ; i++)
    {
	while ((ids[i] = OBJ.child_obj[child_no]) == NULL_CHR) child_no ++ ;
	child_no ++ ;
    }
    return nm_ids ;
}

Point GetPointOnParent(int obj_no)
{
    return OBJ.locate.point ;
}

Point GetPointOnWorld(int obj_no)
{
    return OBJ.world_point ;
}

Angle GetAngleOnParent(int obj_no)
{
    return OBJ.locate.angle ;
}

Angle GetAngleOnWorld(int obj_no)
{
    Angle   a ;
    Dir_Vec d = {{0.0, 0.0, 1.0}, {0.0, 1.0, 0.0}} ;

    ChangePointByMatrix(&d.vector, OBJ.matrix_o_to_w) ;
    ChangePointByMatrix(&d.down_vector, OBJ.matrix_o_to_w) ;

    SubPoint(&d.vector, OBJ.world_point) ;
    SubPoint(&d.down_vector, OBJ.world_point) ;

    VectorToAngle(&a, d) ;
    return a ;
}

Point GetPointToObjectOnWorld(int obj_no, int o_obj)
{
    Point p ;
    p = O_OBJ.world_point ;
    SubPoint(&p, OBJ.world_point) ;
    return p ;
}

Point GetPointToObjectOnParent(int obj_no, int o_obj)
{
    Point   p ;
    p = O_OBJ.world_point ;
    ChangePointByMatrix(&p, OBJ.matrix_w_to_o) ;
    return p ;
}

int GetDisplaySwitch(int obj_no)
{
    return OBJ.tp_data.display_switch ;
}

double GetYonClipping(int obj_no)
{
    return OBJ.yon_clipping_distance ;
}

double GetColorRate(int obj_no)
{
    return OBJ.color_rate ;
}

int GetNumberOfChildren(int obj_no)
{
    return OBJ.nm_children ;
}


#undef  CHR


/* ǡѹ롼 */


#define LGT     data->lgt[lgt_no]

void SetLightStatus(int lgt_no, Color cl, Color back,
		    Point vector, double air_shading)
{
    SetLightAndAmbientLevel(lgt_no, cl) ;
    UnitVector(&vector) ;
    LGT.vector      = vector ;
    LGT.back        = back ;
    LGT.air_shading = air_shading ;
    return ;
}

void SetLightVector(int lgt_no, Point vector)
{
    UnitVector(&vector) ;
    LGT.vector = vector ;
    return ;
}

void SetLightAngle(int lgt_no, Angle angle)
{
    Point   vector = {0.0, 0.0, 1.0} ;
    RevolvePointByAngle(&vector, angle) ;
    LGT.vector = vector ;
    return ;
}

void SetLightLevel(int lgt_no, Color cl)
{
    LGT.level = cl ;
    return ;
}

void SetAmbientLevel(int lgt_no, Color cl)
{
    LGT.amb = cl ;
    return ;
}

void SetBackColor(int lgt_no, Color cl)
{
    LGT.back = cl ;
    return ;
}

void SetAirShading(int lgt_no, double air_shading)
{
    LGT.air_shading = air_shading ;
    return ;
}

void SetLightAndAmbientLevel(int lgt_no, Color cl)
{
    Color   amb ;

    amb.r = cl.r * 0.4 ;
    amb.g = cl.g * 0.4 ;
    amb.b = cl.b * 0.4 ;

    LGT.level = cl ;
    LGT.amb   = amb ;
    return ;
}

void CopyLightStatus(int lgt_no, int o_lgt)
{
    LGT = data->lgt[o_lgt] ;
    return ;
}

/* ¤η㥹ȥ롼 */

Point GetPoint(double x, double y, double z)
{
    Point   p ;
    p.x = x ;
    p.y = y ;
    p.z = z ;
    return p ;
}

Angle GetAngle(double rl, double fr, double lr)
{
    Angle   a ;
    a.rl = rl ;
    a.fr = fr ;
    a.lr = lr ;
    return a ;
}

Point GetScale(double s_xyz)
{
    Point   s ;
    s.x = s_xyz ;
    s.y = s_xyz ;
    s.z = s_xyz ;
    return s ;
}

Locate GetLocate(double x, double y, double z,
		 double rl, double fr, double lr,
		 double sx, double sy, double sz)
{
    Locate  l ;

    l.point.x = x ;
    l.point.y = y ;
    l.point.z = z ;

    l.angle.rl = rl ;
    l.angle.fr = fr ;
    l.angle.lr = lr ;

    l.scale.x = sx ;
    l.scale.y = sy ;
    l.scale.z = sz ;

    return l ;
}

Color GetColor(double r, double g, double b)
{
    Color   cl ;
    cl.r = r ;
    cl.g = g ;
    cl.b = b ;
    return cl ;
}

Color GetColorByName(char *name)
{
    Color   cl = {-1,-1,-1} ;
    XColor  xcl ;
    if (XParseColor(X.display, X.colormap, name, &xcl))
        cl = GetColor((double)xcl.red   / 65535.0,
		      (double)xcl.green / 65535.0,
		      (double)xcl.blue  / 65535.0) ;
    return cl ;
}

Color_Data GetColor_Data(double r, double g, double b,
			 double mr, double mg, double mb, double mrr_exp)
{
    Color_Data  cd ;

    cd.rnd.r = r ;
    cd.rnd.g = g ;
    cd.rnd.b = b ;

    cd.mrr.r = mr ;
    cd.mrr.g = mg ;
    cd.mrr.b = mb ;

    cd.mrr_exponent = mrr_exp ;
    return cd ;
}

Color_Data GetColor_DataByColor(Color cl, int strct)
{
    Color_Data  cd ;
    switch (strct)
    {
      case PLASTIC:
        cd.rnd = cl ;
        cd.mrr = GetColor(2.0, 2.0, 2.) ;
	cd.mrr_exponent = 0.6 ;
	break ;
      case METAL:
        cd.rnd = GetColor(cl.r * 0.3, cl.g * 0.3, cl.b * 0.3) ;
        cd.mrr = GetColor(0.5 + cl.r*1.5, 0.5 + cl.g*1.5, 0.5 + cl.b*1.5) ;
	cd.mrr_exponent = 0.5 ;
	break ;
      case MAT:
      default:
        cd.rnd = cl ;
        cd.mrr = GetColor(0.3, 0.3, 0.3) ;
	cd.mrr_exponent = 0.2 ;
	break ;
    }
    return cd ;
}

Color_Data GetColor_DataByName(char *name, int strct)
{
    Color       cl ;
    Color_Data  cd ;

    cl = GetColorByName(name) ;
    cd = GetColor_DataByColor(cl, strct) ;
    return cd ;
}

/* Chr_Tblʥ饹˺Ѵؿʥǥ󥰥롼 */

#define CLS     data->chr[id]
#define B_CLS   data->chr[base_id]
#define CTP     CLS.tp_data
#define PN      polygons[pol_no]
#define TN      tops[top_no]

void ReversePolygon(TP_Data *tp, int pol_no, int reverse)
{
    int     nm_tops, top_no, t_no[MAX_TOPS_OF_POLYGON] ;
    tp->PN.nm_tops = nm_tops = tp->polygons[reverse].nm_tops ;

    for (top_no = 0 ; top_no < nm_tops ; top_no ++)
        t_no[top_no] = tp->polygons[reverse].top_no[top_no] ;

    for (top_no = 0 ; top_no < nm_tops ; top_no ++)
	tp->PN.top_no[top_no] = t_no[nm_tops - top_no - 1] ;
}

#define NotTransparent \
{ \
    CTP.PN.color_data = color_data2 ; \
    if (transparent_switch == OFF) break ; \
}

/* إ꥿󥹥⡼ɤˤꡢѥ饹 */
#define SetSuperClassByInheritanceMode \
{ \
    switch(inheritance_mode) \
    { \
      case INHERITANCE: \
	CLS.super_class_id = base_id ; \
	break ; \
      case BROTHER: \
	CLS.super_class_id = data->chr[base_id].super_class_id ; \
	break ; \
      case INDEPENDANCE: \
	CLS.super_class_id = NULL_CHR ; \
	break ; \
    } \
}

/* 饹class = ON, nm_children = 0, polygon_switch = ON */
int CreateNewClass(void)
{
    int     id, pol_no ;

    if ((id = SearchNullChar()) == NULL_CHR) return NULL_CHR ;
    CLS.class = ON ;
    CLS.nm_children = 0 ;

    CTP.display_switch = ON ;
    CTP.color2 = C_Red ;

    for (pol_no = 0 ; pol_no < MAX_POLYGONS ; pol_no ++)
        CTP.PN.polygon_switch = ON ;

    return id ;
}

/* Υ饹 */
int CreateClassOfSphere(Locate l, int nu, int nv,
			Color_Data color_data, Color_Data color_data2,
			int transparent_switch, int check)
{
    int     id, u, v, pol_no, top_no ;
    double  mat[4][4], d_u, d_v ;
    SinCos  sc ;

    if ((pol_no = nu *  nv         ) > MAX_POLYGONS ||
	(top_no = nu * (nv - 1) + 2) > MAX_TOPS_OF_OBJECT ||
	(id     = CreateNewClass()) == NULL_CHR) return ERROR_CODE ;

    CLS.super_class_id = NULL_CHR ;
    CTP.nm_polygons    = pol_no ;
    CTP.nm_tops        = top_no ;

    /* ĺǡ */
    GetMatrixForObjectToParentByLocate(mat, &l) ;
    d_u = 360.0 / nu ; d_v = 180.0 / nv ;

    for (v = 0 ; v < nv - 1 ; v ++)
    {
	CalculateSinCos(&sc, (v + 1) * d_v) ;
	for (u = 0 ; u < nu ; u ++)
	{
	    top_no = v * nu + u + 1 ;
	    CTP.TN.x = 0.0 ;
	    CTP.TN.y = 1.0 ;
	    Revolve2D(&(CTP.TN.y), &(CTP.TN.x), -u * d_u) ;
	    CTP.TN.x *= sc.sn ;
	    CTP.TN.y *= sc.sn ;
	    CTP.TN.z  = sc.cs ;
	    ChangePointByMatrix(&CTP.TN, mat) ;
	}
    }
    CTP.tops[0].x               = CTP.tops[0].y               =
    CTP.tops[CTP.nm_tops - 1].x = CTP.tops[CTP.nm_tops - 1].y = 0.0 ;
    CTP.tops[0].z               =  1.0 ;
    CTP.tops[CTP.nm_tops - 1].z = -1.0 ;
    ChangePointByMatrix(&CTP.tops[0], mat) ;
    ChangePointByMatrix(&CTP.tops[CTP.nm_tops - 1], mat) ;
    
    /* ݥꥴǡ */
    for (v = 0, pol_no = 0 ; v < nv ; v ++)
    {
	for (u = 0 ; u < nu ; u ++, pol_no ++)
	{
	    CTP.PN.color_data = color_data ;

	    if (v == 0)
	    {
		CTP.PN.nm_tops = 3 ;
		CTP.PN.top_no[0] = 0 ;
		CTP.PN.top_no[1] = u + 1 ;
		if (u == nu - 1) CTP.PN.top_no[2] = 1 ;
		else		 CTP.PN.top_no[2] = u + 2 ;
	    }
	    else if (v == nv - 1)
	    {
		CTP.PN.nm_tops = 3 ;
		top_no = (v - 1) * nu + u + 1 ;
		CTP.PN.top_no[0] = CTP.nm_tops - 1 ;
		CTP.PN.top_no[2] = top_no ;
		if (u == nu - 1) CTP.PN.top_no[1] = top_no + 1 - nu ;
		else		 CTP.PN.top_no[1] = top_no + 1 ;
	    }
	    else
	    {
		CTP.PN.nm_tops = 4 ;
		top_no = (v - 1) * nu + u + 1 ;
		CTP.PN.top_no[0] = top_no ;
		CTP.PN.top_no[1] = top_no + nu ;
		if (u == nu - 1)
		{
		    CTP.PN.top_no[2] = top_no + 1 ;
		    CTP.PN.top_no[3] = top_no + 1 - nu ;
		}
		else
		{
		    CTP.PN.top_no[2] = top_no + nu + 1 ;
		    CTP.PN.top_no[3] = top_no + 1 ; 
		}
	    }
	}
    }

    /* åͽ */
    for (pol_no = 0 ; pol_no < CTP.nm_polygons ; pol_no ++)
    {
	int     reverse ;
	switch (check)
	{
	  case 1:
	    if (((pol_no / nu) & 1) == 0) break ;
	    NotTransparent
	    reverse = pol_no - nu ;
	    ReversePolygon(&CTP, pol_no, reverse) ;
	    break ;
	  case 2:
	    if ((pol_no & 1) == 0) break ;
	    NotTransparent
	    reverse = pol_no - 1 ;
	    ReversePolygon(&CTP, pol_no, reverse) ;
	    break ;
	  case 3:
	    if (((pol_no / nu + pol_no) & 1) == 0) break ;
	    NotTransparent
	    if ((pol_no + nu) % (nu * 2) == 0)
	        reverse = pol_no - 1 + nu ;
	    else
	        reverse = pol_no - 1 ;
	    ReversePolygon(&CTP, pol_no, reverse) ;
	    break ;
	  case 4:
	    if (pol_no < CTP.nm_polygons / 2) break ;
	    NotTransparent
	    reverse = CTP.nm_polygons - pol_no - 1 ;
	    ReversePolygon(&CTP, pol_no, reverse) ;
	    break ;
	  case 5:
	    if (((pol_no / (nu / 2)) & 1) == 0) break ;
	    NotTransparent
	    reverse = pol_no - nu / 2 ;
	    ReversePolygon(&CTP, pol_no, reverse) ;
	    break ;
	}
    }
    return id ;
}

/* 饹 */
int CreateClassOfPillar(Locate l, int nu, int nv,
			Color_Data color_data, Color_Data color_data2,
			int transparent_switch, int check)
{
    int     id, u, v, pol_no, top_no ;
    double  mat[4][4], d_u, d_v ;
    SinCos  sc ;

    if (nu > MAX_TOPS_OF_POLYGON ||
	(pol_no = nu *  nv + 2 ) > MAX_POLYGONS ||
	(top_no = nu * (nv + 1)) > MAX_TOPS_OF_OBJECT ||
	(id     = CreateNewClass()) == NULL_CHR) return ERROR_CODE ;

    CLS.super_class_id = NULL_CHR ;
    CTP.nm_polygons    = pol_no ;
    CTP.nm_tops        = top_no ;

    /* ĺǡ */
    GetMatrixForObjectToParentByLocate(mat, &l) ;
    d_u = 360.0 / nu ; d_v = 180.0 / nv ;

    for (v = 0 ; v <= nv ; v ++)
    {
	for (u = 0 ; u < nu ; u ++)
	{
	    top_no = v * nu + u ;
	    CTP.TN.x = 0.0 ;
	    CTP.TN.y = 1.0 ;
	    Revolve2D(&(CTP.TN.y), &(CTP.TN.x), -u * d_u) ;
	    CTP.TN.z = 0.5 - (double)v / (double)nv ;
	    ChangePointByMatrix(&CTP.TN, mat) ;
	}
    }

    /* ݥꥴǡ */
    for (v = 0 ; v < nv ; v ++)
    {
	for (u = 0 ; u < nu ; u ++)
	{
	    pol_no = v * nu + u + 1;
	    top_no = v * nu + u ;
	    CTP.PN.color_data = color_data ;
	    CTP.PN.nm_tops = 4 ;

	    CTP.PN.top_no[0] = top_no ;
	    CTP.PN.top_no[1] = top_no + nu ;
	    CTP.PN.top_no[2] = top_no + nu + 1 ;
	    CTP.PN.top_no[3] = top_no + 1 ;

	    if (u == nu - 1)
	    {
		CTP.PN.top_no[2] = top_no + 1 ;
		CTP.PN.top_no[3] = top_no + 1 - nu ;
	    }
	}
    }
    for (v = 0 ; v < 2 ; v ++)
    {
	pol_no = v * (CTP.nm_polygons - 1) ;
	CTP.PN.color_data = color_data ;
	CTP.PN.nm_tops = nu ;

	for (top_no = 0 ; top_no < nu ; top_no ++)
	{
	    if (v == 0) CTP.PN.top_no[top_no] = top_no ;
	    else        CTP.PN.top_no[top_no] = CTP.nm_tops - top_no - 1 ;
	}
    }

    /* åͽ */
    for (pol_no = 0 ; pol_no < CTP.nm_polygons ; pol_no ++)
    {
	int     reverse ;
	switch (check)
	{
	  case 1:
	    if ((((pol_no + nu - 1)/ nu) & 1) == 0) break ;
	    NotTransparent
	    reverse = pol_no - nu ;
	    ReversePolygon(&CTP, pol_no, reverse) ;
	    break ;
	  case 2:
	    if ((pol_no & 1) == 0) break ;
	    NotTransparent
	    reverse = pol_no - 1 ;
	    ReversePolygon(&CTP, pol_no, reverse) ;
	    break ;
	  case 3:
	    if (((pol_no / nu + pol_no) & 1) == 0) break ;
	    NotTransparent
	    if ((pol_no + nu) % (nu * 2) == 0)
	        reverse = pol_no - 1 + nu ;
	    else
	        reverse = pol_no - 1 ;
	    ReversePolygon(&CTP, pol_no, reverse) ;
	    break ;
	  case 4:
	    if (pol_no < CTP.nm_polygons / 2) break ;
	    NotTransparent
	    reverse = CTP.nm_polygons - pol_no - 1 ;
	    ReversePolygon(&CTP, pol_no, reverse) ;
	    break ;
	  case 5:
	    if (((pol_no / (nu / 2)) & 1) == 0) break ;
	    NotTransparent
	    reverse = pol_no - nu / 2 ;
	    ReversePolygon(&CTP, pol_no, reverse) ;
	    break ;
	}
    }
    return id ;
}

/* 饹 */
int CreateClassOfCone(Locate l, int nu, int nv,
		      Color_Data color_data, Color_Data color_data2,
		      int transparent_switch, int check)
{
    int     id, u, v, pol_no, top_no ;
    double  mat[4][4], d_u, d_v ;
    SinCos  sc ;

    if ((pol_no = nu *  nv         ) > MAX_POLYGONS ||
	(top_no = nu * (nv - 1) + 2) > MAX_TOPS_OF_OBJECT ||
	(id     = CreateNewClass()) == NULL_CHR) return ERROR_CODE ;

    CLS.super_class_id = NULL_CHR ;
    CTP.nm_polygons    = pol_no ;
    CTP.nm_tops        = top_no ;

    /* ĺǡ */
    GetMatrixForObjectToParentByLocate(mat, &l) ;
    d_u = 360.0 / nu ; d_v = 180.0 / nv ;

    for (v = 0 ; v < nv - 1 ; v ++)
    {
	CalculateSinCos(&sc, (v + 1) * d_v) ;
	for (u = 0 ; u < nu ; u ++)
	{
	    top_no = v * nu + u + 1 ;
	    CTP.TN.x = 0.0 ;
	    CTP.TN.y = 1.0 ;
	    Revolve2D(&(CTP.TN.y), &(CTP.TN.x), -u * d_u) ;
	    CTP.TN.x *= sc.sn ;
	    CTP.TN.y *= sc.sn ;
	    CTP.TN.z  = sc.cs ;
	    ChangePointByMatrix(&CTP.TN, mat) ;
	}
    }
    CTP.tops[0].x               = CTP.tops[0].y               =
    CTP.tops[CTP.nm_tops - 1].x = CTP.tops[CTP.nm_tops - 1].y = 0.0 ;
    CTP.tops[0].z               =  1.0 ;
    CTP.tops[CTP.nm_tops - 1].z = -1.0 ;
    ChangePointByMatrix(&CTP.tops[0], mat) ;
    ChangePointByMatrix(&CTP.tops[CTP.nm_tops - 1], mat) ;
    
    /* ݥꥴǡ */
    for (v = 0, pol_no = 0 ; v < nv ; v ++)
    {
	for (u = 0 ; u < nu ; u ++, pol_no ++)
	{
	    CTP.PN.color_data = color_data ;

	    if (v == 0)
	    {
		CTP.PN.nm_tops = 3 ;
		CTP.PN.top_no[0] = 0 ;
		CTP.PN.top_no[1] = u + 1 ;
		if (u == nu - 1) CTP.PN.top_no[2] = 1 ;
		else		 CTP.PN.top_no[2] = u + 2 ;
	    }
	    else if (v == nv - 1)
	    {
		CTP.PN.nm_tops = 3 ;
		top_no = (v - 1) * nu + u + 1 ;
		CTP.PN.top_no[0] = CTP.nm_tops - 1 ;
		CTP.PN.top_no[2] = top_no ;
		if (u == nu - 1) CTP.PN.top_no[1] = top_no + 1 - nu ;
		else		 CTP.PN.top_no[1] = top_no + 1 ;
	    }
	    else
	    {
		CTP.PN.nm_tops = 4 ;
		top_no = (v - 1) * nu + u + 1 ;
		CTP.PN.top_no[0] = top_no ;
		CTP.PN.top_no[1] = top_no + nu ;
		if (u == nu - 1)
		{
		    CTP.PN.top_no[2] = top_no + 1 ;
		    CTP.PN.top_no[3] = top_no + 1 - nu ;
		}
		else
		{
		    CTP.PN.top_no[2] = top_no + nu + 1 ;
		    CTP.PN.top_no[3] = top_no + 1 ; 
		}
	    }
	}
    }

    /* åͽ */
    for (pol_no = 0 ; pol_no < CTP.nm_polygons ; pol_no ++)
    {
	int     reverse ;
	switch (check)
	{
	  case 1:
	    if (((pol_no / nu) & 1) == 0) break ;
	    NotTransparent
	    reverse = pol_no - nu ;
	    ReversePolygon(&CTP, pol_no, reverse) ;
	    break ;
	  case 2:
	    if ((pol_no & 1) == 0) break ;
	    NotTransparent
	    reverse = pol_no - 1 ;
	    ReversePolygon(&CTP, pol_no, reverse) ;
	    break ;
	  case 3:
	    if (((pol_no / nu + pol_no) & 1) == 0) break ;
	    NotTransparent
	    if ((pol_no + nu) % (nu * 2) == 0)
	        reverse = pol_no - 1 + nu ;
	    else
	        reverse = pol_no - 1 ;
	    ReversePolygon(&CTP, pol_no, reverse) ;
	    break ;
	  case 4:
	    if (pol_no < CTP.nm_polygons / 2) break ;
	    NotTransparent
	    reverse = CTP.nm_polygons - pol_no - 1 ;
	    ReversePolygon(&CTP, pol_no, reverse) ;
	    break ;
	  case 5:
	    if (((pol_no / (nu / 2)) & 1) == 0) break ;
	    NotTransparent
	    reverse = pol_no - nu / 2 ;
	    ReversePolygon(&CTP, pol_no, reverse) ;
	    break ;
	}
    }
    return id ;
}

int CreateClassByTP_Data(TP_Data *tp_data)
{
    int     id ;
    if ((id = CreateNewClass()) == NULL_CHR) return ERROR_CODE ;
    CLS.tp_data = *tp_data ;
    return id ;
}

int CreateClassOfNone(void)
{
    int     id ;
    if ((id = CreateNewClass()) == NULL_CHR) return ERROR_CODE ;
    CLS.super_class_id = NULL_CHR ;
    CTP.display_switch = OFF ;
    CTP.nm_tops        = 0 ;
    CTP.nm_polygons    = 0 ;
    return id ;
}

int CreateClassOfCircles(int nm_circles,
			 Color *colors, double *r)
{
    int     id, pol_no ;

    if (nm_circles >= MAX_POLYGONS ||
	(id = CreateNewClass()) == NULL_CHR) return ERROR_CODE ;

    CLS.super_class_id = NULL_CHR ;
    CTP.nm_tops        = nm_circles * 2 ;
    CTP.nm_polygons    = nm_circles ;

    for (pol_no = 0 ; pol_no < nm_circles ; pol_no ++)
    {
	CTP.tops[pol_no * 2] = CTP.tops[pol_no * 2 + 1] = P_Origin ;
	CTP.tops[pol_no * 2 + 1].x = r[pol_no] ;

	CTP.PN.nm_tops = 2 ;
	CTP.PN.top_no[0] = pol_no * 2 ;
	CTP.PN.top_no[1] = pol_no * 2 + 1 ;
	CTP.PN.color_data = CD_None ;
	CTP.PN.color_data.rnd = colors[pol_no] ;
    }
    return id ;
}

int CreateClassOfGatheringCircles(int nm_circles,
				  Color *colors, double *r,
				  int nm_gathering, Locate *l)
{
    int     id, pol_no, gather ;
    Point   *tops ;
    tops = (Point *)malloc(sizeof(Point) * nm_circles * 2 * nm_gathering) ;

    if (nm_circles * nm_gathering > MAX_POLYGONS ||
	(id = CreateNewClass()) == NULL_CHR) return ERROR_CODE ;

    CLS.super_class_id = NULL_CHR ;
    CTP.nm_tops        = nm_circles * 2 * nm_gathering ;
    CTP.nm_polygons    = nm_circles * nm_gathering ;

    for (pol_no = 0 ; pol_no < nm_circles ; pol_no ++)
    {
	tops[pol_no * 2] = tops[pol_no * 2 + 1] = P_Origin ;
	tops[pol_no * 2 + 1].x = r[pol_no] ;
    }
    for (gather = 0 ; gather < nm_gathering ; gather ++)
    {
	int     top_no, i ;
	double  mat[4][4] ;
	GetMatrixForObjectToParentByLocate(mat, &l[gather]) ;

	/* nm_circles * 2 * nm_gathering ʬĺ */
	for (top_no = 0 ; top_no < nm_circles * 2 ; top_no ++)
	{
	    CTP.tops[gather * nm_circles * 2 + top_no] = tops[top_no] ;
	    ChangePointByMatrix(&CTP.tops[gather*nm_circles*2 + top_no], mat) ;
	}
	for (i = 0 ; i < nm_circles ; i ++)
	{
	    pol_no = gather * nm_circles + i ;
	    CTP.PN.nm_tops = 2 ;

	    CTP.PN.top_no[0] = gather * nm_circles * 2 + i * 2 ;
	    CTP.PN.top_no[1] = gather * nm_circles * 2 + i * 2 + 1 ;
	    CTP.PN.color_data = CD_None ;
	    CTP.PN.color_data.rnd = colors[i] ;
	}
    }

    free(tops) ;
    return id ;
}









int CreateClassHaveChild(int base_id, int child_id,
			 Locate l, int inheritance_mode)
{
    int     id, child_no ;

    if ((id = CreateNewClass()) == NULL_CHR) return ERROR_CODE ;

    /* ˤʤ륯饹 NONE ʤ顢ǡ̵Υ饹 */
    if (base_id == NONE)
    {
	/* 饹̵Ω */
	CLS.super_class_id      = NULL_CHR ;
	CLS.nm_children         = 0 ;
	/* ɽݥꥴĺǡ̵ */
	CTP.display_switch = OFF ;
	CTP.nm_polygons    = 0 ;
	CTP.nm_tops        = 0 ;
    }
    else
    {
	CLS = data->chr[base_id] ;
	/* إ꥿󥹥⡼ɤˤꡢѥ饹 */
	SetSuperClassByInheritanceMode ;
    }

    /* ҤǽʤʿСʤС˻Ҥ */
    if ((child_no = CLS.nm_children) < MAX_CHILDREN)
    {
	CLS.nm_children ++ ;
	CLS.children[child_no].chr_no = child_id ;
	CLS.children[child_no].locate = l ;
    }
    return id ;
}

/* ҡʡˤդ饹 */
int CreateClassHaveChildren(int base_id, int nm_children,
			    int *child_ids, Locate *l, int inheritance_mode)
{
    int     id, child_no, i ;

    if ((id = CreateNewClass()) == NULL_CHR) return ERROR_CODE ;

    /* ˤʤ륯饹 NONE ʤ顢ǡ̵Υ饹 */
    if (base_id == NONE)
    {
	/* 饹̵Ω */
	CLS.super_class_id      = NULL_CHR ;
	CLS.nm_children         = 0 ;
	/* ɽݥꥴĺǡ̵ */
	CTP.display_switch = OFF ;
	CTP.nm_polygons    = 0 ;
	CTP.nm_tops        = 0 ;
    }
    else
    {
	CLS = data->chr[base_id] ;

	/* إ꥿󥹥⡼ɤˤꡢѥ饹 */
	SetSuperClassByInheritanceMode ;
    }

    /* ҤǽʤʿСʤС˻Ҥ */
    for (child_no = CLS.nm_children, i = 0 ;
	 i < nm_children && child_no < MAX_CHILDREN;
	 child_no ++, i ++)
    {
	CLS.nm_children ++ ;
	CLS.children[child_no].chr_no = child_ids[i] ;
	CLS.children[child_no].locate = l[i] ;
    }
    return id ;
}

int CreateClassOfAdding(int nm_classes, int *ids, Locate *l)
{
    int     i, nm_tops = 0, nm_polygons = 0, id, base_id,
            top_no = 0, pol_no = 0 ;
    double  mat[4][4] ;

    for (i = 0 ; i < nm_classes ; i ++)
    {
        id = ids[i] ;
	nm_tops     += CTP.nm_tops ;
	nm_polygons += CTP.nm_polygons ;
	if (nm_tops > MAX_TOPS_OF_OBJECT || nm_polygons > MAX_POLYGONS)
	    return ERROR_CODE ;
    }
    if ((id = CreateNewClass()) == NULL_CHR) return ERROR_CODE ;

    CLS.super_class_id = NULL_CHR ;
    CLS.nm_children    = 0 ;
    CTP.nm_tops        = nm_tops ;
    CTP.nm_polygons    = nm_polygons ;

    for (i = 0 ; i < nm_classes ; top_no += B_CLS.tp_data.nm_tops, i ++)
    {
        int     j ;
	double  r ;
	base_id = ids[i] ;
	GetMatrixForObjectToParentByLocate(mat, &l[i]) ;
	r = l[i].scale.x * l[i].scale.y *l[i].scale.z ;

	for (j = 0 ; j < B_CLS.tp_data.nm_tops ; j ++)
	{
	    CTP.tops[top_no + j] = B_CLS.tp_data.tops[j] ;
	    ChangePointByMatrix(&CTP.tops[top_no + j], mat) ;
	}
	for (j = 0 ; j < B_CLS.tp_data.nm_polygons ; j ++, pol_no ++)
	{
	    int     k ;
	    CTP.PN = B_CLS.tp_data.polygons[j] ;
	    if (r < 0.0) ReversePolygon(&CTP, pol_no, pol_no) ;
	    for (k = 0 ; k < CTP.PN.nm_tops ; k ++)
	        CTP.PN.top_no[k] += top_no ;
	}
    }
    return id ;
}


/* ¸Υ饹 Locate ѹ饹 */
int CreateClassLocate(int base_id, Locate l, int inheritance_mode)
{
    int     id ;

    if (data->chr[base_id].nm_children == 0)
    {
	int     top_no, child_no, pol_no ;
	double  mat[4][4] ;

	if ((id = CreateNewClass()) == NULL_CHR) return ERROR_CODE ;
	CLS = data->chr[base_id] ;
	GetMatrixForObjectToParentByLocate(mat, &l) ;

	for (top_no = 0 ; top_no < CTP.nm_tops ; top_no ++)
	    ChangePointByMatrix(&CTP.tops[top_no], mat) ;

	if (l.scale.x * l.scale.y * l.scale.z < 0.0)
	    for (pol_no = 0 ; pol_no < CTP.nm_polygons ; pol_no ++)
	        ReversePolygon(&CTP, pol_no, pol_no) ;
    }
    else
    {
	int     child_id ;
	if ((id       = CreateNewClass()) == NULL_CHR ||
	    (child_id = CreateNewClass()) == NULL_CHR) return ERROR_CODE ;

	data->chr[child_id] = data->chr[base_id] ;
	data->chr[child_id].super_class_id = NULL_CHR ;

	CTP.nm_polygons = 0 ;
	CTP.nm_tops     = 0 ;

	CLS.nm_children = 1 ;
	CLS.children[0].chr_no = child_id ;
	CLS.children[0].locate = l ;
    }
    /* إ꥿󥹥⡼ɤˤꡢѥ饹 */
    SetSuperClassByInheritanceMode ;

    return id ;
}

/* ¸Υ饹򥹥󥰤饹 */
int CreateClassScale(int base_id, Point s, int inheritance_mode)
{
    int     id ;

    if (data->chr[base_id].nm_children == 0)
    {
	int     top_no, child_no, pol_no ;
	if ((id = CreateNewClass()) == NULL_CHR) return ERROR_CODE ;
	CLS = data->chr[base_id] ;

	for (top_no = 0 ; top_no < CTP.nm_tops ; top_no ++)
	    ScalingPoint(&CTP.tops[top_no], s) ;

	if (s.x * s.y * s.z < 0.0)
	    for (pol_no = 0 ; pol_no < CTP.nm_polygons ; pol_no ++)
	        ReversePolygon(&CTP, pol_no, pol_no) ;
    }
    else
    {
	int     child_id ;
	if ((id       = CreateNewClass()) == NULL_CHR ||
	    (child_id = CreateNewClass()) == NULL_CHR) return ERROR_CODE ;

	data->chr[child_id] = data->chr[base_id] ;
	data->chr[child_id].super_class_id = NULL_CHR ;

	CTP.nm_polygons = 0 ;
	CTP.nm_tops     = 0 ;

	CLS.nm_children = 1 ;
	CLS.children[0].chr_no = child_id ;
	CLS.children[0].locate = L_Normal ;
	CLS.children[0].locate.scale = s ;
    }
    /* إ꥿󥹥⡼ɤˤꡢѥ饹 */
    SetSuperClassByInheritanceMode ;

    return id ;
}

/* ¸Υ饹ư饹 */
int CreateClassMove(int base_id, Point p, int inheritance_mode)
{
    int     id, top_no, child_no ;

    if ((id = CreateNewClass()) == NULL_CHR) return ERROR_CODE ;
    CLS = data->chr[base_id] ;

    for (top_no = 0 ; top_no < CTP.nm_tops ; top_no ++)
        AddPoint(&CTP.tops[top_no], p) ;

    for (child_no = 0 ; child_no < CLS.nm_children ; child_no ++)
        AddPoint(&CLS.children[child_no].locate.point, p) ;

    /* إ꥿󥹥⡼ɤˤꡢѥ饹 */
    SetSuperClassByInheritanceMode ;

    return id ;
}

/* ¸Υ饹ž饹 */
int CreateClassRevolve(int base_id, Angle a, int inheritance_mode)
{
    int     id, top_no, child_no ;

    if ((id = CreateNewClass()) == NULL_CHR) return ERROR_CODE ;
    CLS = data->chr[base_id] ;

    for (top_no = 0 ; top_no < CTP.nm_tops ; top_no ++)
        RevolvePointByAngle(&CTP.tops[top_no], a) ;

    for (child_no = 0 ; child_no < CLS.nm_children ; child_no ++)
    {
        RevolvePointByAngle(&CLS.children[child_no].locate.point, a) ;
        AmpersandAngleOnParentByAngle
	  (&CLS.children[child_no].locate.angle, &a) ;
    }
    /* إ꥿󥹥⡼ɤˤꡢѥ饹 */
    SetSuperClassByInheritanceMode ;

    return id ;
}

/* ¸Υ饹Υ顼ѹ饹ʷ說饹ˤʤ */
int CreateClassColoring(int base_id, int nm_color_datas,
			Color_Data *s_cd, Color_Data *o_cd)
{
    int     id, pol_no ;
    if ((id = CreateNewClass()) == NULL_CHR) return ERROR_CODE ;
    CLS = data->chr[base_id] ;

    for (pol_no = 0 ; pol_no < CTP.nm_polygons ; pol_no ++)
    {
	int     c ;
	for (c = 0 ; c < nm_color_datas ; c ++)
	    if (Cmp_CD(CTP.PN.color_data, s_cd[c]))
	        CTP.PN.color_data = o_cd[c] ;
    }
    return id;
}

/* ¸Υ饹Ʊ饹ɬ說饹ˤʤ */
int CopyClass(int base_id)
{
    int     id ;
    if ((id = CreateNewClass()) == NULL_CHR) return ERROR_CODE ;
    CLS = data->chr[base_id] ;
    return id ;
}


/* ¸Υ饹 color2 ʥǥե:֡ */
void SetColor2OfClass(int id, Color color2)
{
    CTP.color2 = color2 ;
    return ;
}









#endif
