/*
 * Log:    page.c,v 
 * Revision 1.1	 85/10/28  17:38:29  broome
 * Initial revision
 * 
 */

#include "../common.h"
#include "defs.h"
#ifndef lint
#if 0
static char __unused RCSid[] = "Header: page.c,v 1.1 85/10/28 17:38:29 broome Exp ";
#else
static char __unused RCSid[] = "$Phone: page.c,v 1.2 2013/01/02 23:00:43 christos Exp $";
#endif
#endif


/*
 *   He wants us to page someone...
 *
 *   argv points to array like this: "callno : callee:tty:caller:conv_addr"
 *
 *   If we already have a call from the same address with the same call
 *   number then we assume it's a retransmission and just resend the
 *   same message-id(the one generated by us) and hope it will make 
 *   it to them.
 *
 *   We try to get the user's password entry so that we can
 *   look for a .busy forwarding file when we actually ring him.
 */

void
page(char *argv[], struct sockaddr_in *sin)
{
    time_t  now;
    INV	   *new;
    struct   passwd  *pw;
    struct   hostent *hp;

    /* first check to see if we already have the request */
    if ((new = seenit(argv[0], sin)) != NULL) {
	sendit(misc, sin, "%c%c%c%s", ESC, PAGE, ACK, new->id);
	return;
    }

    if (freelist) {
	new = freelist;		/* grab one from existing list */
	freelist = new->next;
	free(new->caller);     /* deallocate space from last time */
	free(new->callee);
	free(new->host);
	free(new->home);
	free(new->tty);
	free(new->convaddr);
	if (new->ptty)
	    free(new->ptty);
    } else {		/* need to malloc new space */
	if ((new = malloc(sizeof(*new))) == NULL)
	    err(1, "malloc failed...");
    }

    new->callno	  = strsave(argv[0]);	   /* caller's form of call id */
    new->callee	  = strsave(argv[1]);	   /* person being called */
    new->tty	  = strsave(argv[2]);	   /* his tty */
    new->caller	  = strsave(argv[3]);	   /* caller name */
    new->convaddr = strsave(argv[4]);	   /* conversation address */

    time(&now);

    /*	
     *	Acknowledge immediately. We make an id 
     *	from the lower 4 bits of the time.  
     */

    snprintf(new->id, sizeof(new->id), "%05ld",(now & 9999L));
    sendit(misc, sin, "%c%c%c%s", ESC, PAGE, ACK, new->id);

    /* figure out host name */
    if ((hp = gethostbyaddr((void *)&sin->sin_addr, sizeof(sin->sin_addr), AF_INET)) != NULL)
	new->host = strsave(hp->h_name);
    else
	new->host = strsave(inet_ntoa(sin->sin_addr));

    /* save control address */
    memcpy(&new->ctladdr, sin, sizeof(new->ctladdr));

    /* lookup callee in password file */
    if ((pw = getpwnam(argv[0])) != NULL) {
	new->home = strsave(pw->pw_dir);
	new->uid  = pw->pw_uid;
	new->gid  = pw->pw_gid;
    } else
	new->home = NULL;

    new->rings	= 0;	    /* so they get it next time around */
    new->ptty	= NULL;
    new->prev	= NULL;

    insert(new);	   /* and add to the pending list */
}


/*
 *  Search through the list of invitations, looking for one
 *  from the same address as this, with the same call number as well.
 */

INV *
seenit(char *callno, struct sockaddr_in *addr)
{
    INV *inv;

    for (inv = invitations; inv; inv = inv->next)
	if (strcmp(callno, inv->callno) == 0 && 
	    memcmp(addr, &inv->ctladdr, sizeof(*addr)) == 0)
		return inv;
    return NULL;
}

