#include "defs.h"
#ifndef lint
static char __unused RCSid[] = "$Phone: tilde.c,v 1.2 2013/01/02 23:00:43 christos Exp $";
#endif

/*
 *  Expand a name containing a tilde to the full pathname.
 */

char *
exptilde(const char *str)
{
    char   buf[MAXPATHLEN];
    char   name[20];
    char   *i;
    struct passwd *pw;

    if (*str != '~')		    /* doesn't contain a tilde */
	return strsave(str);

    if ((i = strchr(str, '/')) != NULL) /* find slash, if any */
	*i = '\0';
    
    strcpy(name, str+1);	   /* copy name after tilde */

    if (*name == '\0') {	   /* was "~/" */
	char *h;
	if ((h = getenv("HOME")) != NULL)
	    strlcpy(buf, h, sizeof(buf));  /* so use our home */
    } else {
	if ((pw = getpwnam(name)) == NULL) {
	    putmessage("Unknown user: %s", name);
	    return NULL;
	}
	strlcpy(buf, pw->pw_dir, sizeof(buf));	 /* fill in that user's home */
    }
    if (i) {
	*i = '/';		    /* and put back trailing pathname */
	strlcat(buf, i, sizeof(buf));
    }
    return strsave(buf);
}
