#include "defs.h"
#ifndef lint
static char __unused RCSid[] = "$Phone: sig.c,v 1.2 2013/01/02 23:00:43 christos Exp $";
#endif

/*
 *  Interrupt handler - if we have a child, kill it off, else exit.
 */

void
sigint(int n)
{
    unsigned char c;

    if (childpid > 0) {
	kill(childpid, SIGHUP);	   /* it's sure to die sooner or later!!! */
	kill(childpid, SIGINT);
	kill(childpid, SIGKILL);
	killedchild = 1;
	putmessage("Child has been killed!!!!");
    } else {
	if (connected && did_screen) {
	    putmessage("Really quit? ");
	    read(0, &c, 1);
	    c &= 0177;
	    if (c == 'y' || c == 'Y')
		quit(0, NULL);
	    putmessage(" ");
	} else {
	    quit(0, NULL);
	}
    }
}


/*
 *  Sigquit handler - save a copy of the screen into a ".dump" file.
 */

void
sigquit(int n)
{
    dodump(".dump");
}


/*
 *  Generic bad signal handler. Very non-portable,
 *  at least according to the documentation.
 */

void
badsig(int s)
{
    cleanup();
    printf("\r\n\r\nCaught %s signal!!!! Exiting...\r\n\r\n", strsignal(s));
    exit(1);
}
