#include "defs.h"
#ifndef lint
static char __unused RCSid[] = "$Phone: set.c,v 1.2 2013/01/02 23:00:43 christos Exp $";
#endif

/*
 *  Routines to manage the various user-modifiable variables 
 *  that influence the program's behaviour.
 */

int 
    Interval = 2,	    /* number of seconds between messages   */
    Inverse = 1,	    /* use inverse video in header lines    */
    Stop = 1,		    /* print out the "[Stopped]" mesg on ^Z */
    Debug = 0,		    /* print out gobs of debuuging info	    */
    Bells = 0,		    /* allow bells to actually beep	    */
    Echo = 1,		    /* echo kb input while running program  */
    Hold = 0;		    /* hold kb input from child program	    */


#define VALUE  (1<<1)	   /* variable must have a _value_ */
#define BOOLEAN (1<<2)	    /* is just a toggle */

static struct variable {
    const char *name;	    /* name of variable as user sees it */
    int	    *value;	    /* currently - stored value		*/
    int	    type;	    /* boolean or integer-type variable */
} vars[] = {
    { "interval",	&Interval,  VALUE   },
    { "inverse",	&Inverse,   BOOLEAN },
    { "stop",		&Stop,	    BOOLEAN },
    { "debug",		&Debug,	    BOOLEAN },
    { "bells",		&Bells,	    BOOLEAN },
    { "echo",		&Echo,	    BOOLEAN },
    { "hold",		&Hold,	    BOOLEAN },
    { 0,		0,	    0	    },
};

static void showvar(struct variable *);


/*
 *   Assign a value to a given variable ...
 */

void
set(int argc, char  *argv[])
{
    struct  variable *vp;
    const char *name;
    int	    vlen;
    int	    toggle = 0;

    /* see if it's a toggle */
    if (strncmp("no", *argv, 2) == 0) {
	toggle = 1;
	*argv += 2;
    }

    /* search for variable */
    vlen = strlen(*argv);
    for (vp = vars; vp && (name = vp->name) != NULL; vp++)
	if (strncmp(*argv, name, vlen) == 0)
	    break;
    
    if (!vp || !name) {	    /* not found */
	putmessage("%s: No such variable - %s", *argv,
	    "use 'show' to list all variable names");
	return;
    }

    if (argc == 2) {
	if (vp->type == BOOLEAN) {
	    putmessage("%s is a boolean toggle - use 'set %s' or 'set no%s'.", 
		name, name, name);
	} else {
	    if (!isdigit((unsigned char)argv[1][0]) || toggle) {
		putmessage("%s requires a numeric argument", name);
	    } else
		*vp->value = atoi(argv[1]);
	}
    } else {		/* argc == 1 */
	if (vp->type != BOOLEAN) {
	    putmessage("%s requires a numeric argument", name);
	} else {
	    if (toggle)	    /* name was preceeded by 'no' */
		*vp->value = 0;
	    else
		*vp->value = 1;
	}
    }
}



/*
 *  Show the value of a variable.
 */
void
show(int argc, char *argv[])
{
    struct variable *vp;
    const char	 *name;
    int	   vlen;

    if (argc == 0) {	    /* list all variables known */
	message("Listing all variable names:");
	for (vp = vars; vp && vp->name; vp++)
	    showvar(vp);
	return;
    }

    while (*argv) {
	/* search for variable */
	vlen = strlen(*argv);
	for (vp = vars; vp && (name = vp->name) != NULL; vp++)
	    if (strncmp(*argv, name, vlen) == 0)
		break;
	
	if (!vp || !name) {	/* not found */
	    putmessage("%s: No such variable - %s", *argv,
		"use 'show' to list all variable names");
	    return;
	}

	/* print out the variable */
	showvar(vp);
	argv++;
    }
}



/*
 *  Print out one variable nicely...
 */

static void
showvar(struct variable *vp)
{
    if (vp->type == BOOLEAN)
       message("%s is %s", vp->name, *vp->value ? "on" : "off");
    else
       message("%s = %d", vp->name, *vp->value);
}
