#include "../common.h"
#include "defs.h"
#ifndef lint
static char __unused RCSid[] = "$Phone: names.c,v 1.2 2013/01/02 23:00:42 christos Exp $";
#endif

/*
 *  Initialize all the various names and such that we all want to know.
 */

int
names(void)
{
    struct  passwd  *pw;
    struct  hostent *hp;
#ifdef SERVICES
    struct  servent *sp;
#endif
    char    *r, *p, *n;

    if ((pw = getpwuid(getuid())) == NULL) {
	fprintf(stderr, "Who are you?\n");
	return(1);
    }

    if ((n = getlogin()) == NULL)      /* in a window? */
	mylogin = strsave(pw->pw_name);	 /* use our acct name */
    else
	mylogin = strsave(n);

    if ((home = getenv("HOME")) == NULL)
	home = pw->pw_dir;

    if ((shell = getenv("SHELL")) == NULL)
	shell = "/bin/sh";

    if ((p = getenv("NAME")) != NULL)
	strcpy(realname, p);
    else {
	for (p=pw->pw_gecos, r=realname; p && *p && *p!=',' && *p!=';'; p++) {
	    if (*p == '&') {	    /* copy in from login name */
		n = pw->pw_name;    /* and grab the login name */
		if ('a' <= *n && *n <= 'z') /* capitalize the first character */
		    *n += 'A' - 'a';
		while (*n)
		    *r++ = *n++;
	    } else
		*r++ = *p;
	}
	*r = '\0';
    }

    if ((mytty = ttyname(0)) == NULL || !isatty(1)) {
	fprintf(stderr, "Input must be a terminal, not a file or pipe.\n");
	return(1);
    }
    mytty = strsave(mytty);
    if (strncmp(mytty, "/dev/", 5) == 0)
	mytty += 5;   /* skip over "/dev/" */
 
    /* find out about our host */
    gethostname(myhost, sizeof(myhost));
    if ((hp = gethostbyname("localhost")) == NULL)
	if ((hp = gethostbyname(myhost)) == NULL) {
	    fprintf(stderr, "Cannot find network entry for %s\n", myhost);
	    return(1);
	}
    memset(&locaddr, 0, sizeof(locaddr));
    memcpy(&locaddr.sin_addr, hp->h_addr, sizeof(locaddr.sin_addr));
    locaddr.sin_family = hp->h_addrtype;

#ifdef SERVICES
    if ((sp = getservbyname(SERVICE, "udp")) == NULL) {
	fprintf(stderr, "This machine doesn't support \"%s\"\r\n", SERVICE);
	return(1);
    }
    locaddr.sin_port = port = sp->s_port;
#else /*  SERVICES */
#ifdef PORT
    locaddr.sin_port = port = htons(PORT);
#else /* PORT */
    fprintf(stderr, 
	"Your site administrator screwed up installing this program!!!\r\n");
    return(1);
#endif /* PORT */
#endif /* SERVICES */

    return(0);
}
