#include "../common.h"
#include "defs.h"
#ifndef lint
static char __unused RCSid[] = "$Phone: main.c,v 1.2 2013/01/02 23:00:42 christos Exp $";
#endif

#define toggle(var) var = !var

int
main(int argc, char *argv[])
{
    int	    answer = 0;
    char    *user;		/* name of user we are trying to call */
    char    *hishost;		/* and his hostname */
    char    *addr = NULL;		/* address of conversation from getdaemon() */
    struct  sockaddr_in sin;
    struct pollfd pfd[4];

    char *program;

    program = *argv;

    argv++, argc--;

    while (*argv && **argv == '-') {
	while (*++*argv) {
	    switch(**argv) {
		case 'a':   if (argc > 1) {	/* given an address */
				addr = *++argv;
				argc--; 
				printf("Using address \"%s\"\n", addr);
			    }
			    break;
		case 'b':   toggle(Bells);     break;
		case 'd':   toggle(Debug);	break;
		case 'i':   toggle(Inverse);	break;
		case 'v':   printf("%s version %s\n",
			       program, version_string);
			exit(0);
	    }
	}
	argv++, argc--;
    }

    if (argc == 0)	/* just answer incoming calls */
	answer = 1;
    else if (argc > 2) {
	fprintf(stderr, "Usage: %s [-{bdi}] user@host [ tty ]\n", *argv);
	exit(1);
    }

    if (names())       /* get all the various info */
	exit(1);
    readrc();	       /* read in and act on the .phonerc */

    if (!answer) {	/* expand any user aliases and see who we're calling */
	if ((user = expalias(argv[0])) == NULL)
	    user = argv[0];
	if ((hishost = strchr(user, '@')) != NULL)
	    *hishost++ = '\0';
	else
	    hishost = myhost;
    } else {
	user = NULL;
	hishost = NULL;
    }

    connected = 0;
    pending = 0;

    /*	set up all the signals	*/
    signal(SIGPIPE,  SIG_IGN);
    if (!Debug) {
	signal(SIGHUP,	 badsig);
	signal(SIGBUS,	 badsig);
	signal(SIGSEGV,	 badsig);
    }
    signal(SIGALRM,  timer);
    signal(SIGQUIT,  sigquit);
    signal(SIGINT,   sigint);
#ifdef SIGWINCH
    signal(SIGWINCH, sigwinch);
#endif /*  */
    signal(SIGCHLD,  sigchld);

    /*	
     *	open datagram control socket.
     */

    if ((ctl = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
	error(1, "Can't get control socket");

    sin.sin_addr.s_addr = INADDR_ANY;
    sin.sin_port = 0;
    sin.sin_family = AF_INET;

    if (bind(ctl, (void *)&sin, sizeof(sin)) < 0)
	error(1, "Can't bind control socket");

    setup();	   /* initialize all the screen stuff */

    /*	Have we been invited ???  */
    if (addr ||(addr = check_invite(answer ? "*" : user, hishost))) {
	if (Debug)
	    printf("\r\nCheck_invite returned \"%s\"\r\n", addr);
	connect_daemon(addr);
	if (!connected) {
	    if (Debug)
		printf("Connection failed.\r\n");
	    goto again;	    /* caller has hung up !!! */
	}
    } else {
again:
	if (Debug)
	    printf("\r\nCheck_invite returned no address.\r\n");
	if (answer) {	/* don't want to place a call */
	    fprintf(stderr, "\r\nNo pending calls for %s\r\n", mylogin);
	    cleanup();
	    exit(1);
	}
	do {
	    putmessage("");
	    if ((addr = getdaemon()) ==NULL)
		error(1, "Cannot get conversation daemon address");
	    if (Debug)
		printf("\rGet_daemon returned address of \"%s\"\r\n", addr);
	    connect_daemon(addr);
	    if (!connected) {
		putmessage("Trying to connect to conversation daemon.");
		printf("Trying to connect to conversation daemon.");
		fflush(stdout);
	    }
	} while (!connected);
	placecall(user, hishost, argv[1] ? argv[1] : "");
    }

    alarm(1);	   /* get things rolling */

    /*
     *	Main loop - select on sockets and handle appropriately.
     */
    pfd[0].fd = 0;
    pfd[1].fd = ctl;
    pfd[2].fd = stream;
    pfd[0].events = pfd[1].events = pfd[2].events = pfd[3].events = POLLIN;
    for (;;) {
	int nfd;
#ifdef SIGWINCH
	if (changed_size) {	/* caught SIGWINCH - have to resize windows */
	    stretch(1);
	    changed_size = 0;
	}
#endif
	if (childpid) {
		pfd[3].fd = fromchild;
		nfd = 4;
	} else
		nfd = 3;

	if (poll(pfd, nfd, INFTIM) <= 0) {
	    if (errno == EINTR)
		continue;
	    error(1, "poll");
	}

	if (pfd[1].revents & POLLIN)
	    readctl();
	if (pfd[0].revents & POLLIN)
	    keyboard();
	if (pfd[2].revents & POLLIN)
	    readstream();
	if (childpid && (pfd[3].revents & POLLIN))
	    readchild();
    }
    /*NOTREACHED*/
}
