#include "../common.h"
#include "defs.h"
#ifndef lint
static char __unused RCSid[] = "$Phone: check_invite.c,v 1.2 2013/01/02 23:00:42 christos Exp $";
#endif

/*
 *  Check to see if we have any pending invitations from the named user.
 *  Returns the string containing our given address(or NULL)
 */

/*ARGSUSED*/
char *
check_invite(const char *user, char *host __unused)
{
    struct  sockaddr_in sin;	/* address of daemon socket */
    ssize_t r;
    size_t  tries;
    char buf[1024];

    /*	socket address "locaddr" is already initialised to the local host */
    memcpy(&sin, &locaddr, sizeof(sin));
    sin.sin_port = port;

    for (tries = 0; tries < 5; tries++) {
	if ((r = sendit(buf, sizeof(buf), &sin, "%c%c%s:%s", ESC, INQUIRE,
	    mylogin, user)) < 0) {
	    if (Debug)
		printf("\r\ncheck_invite: sendit returned %zd.\r\n", r);
	    continue;
	}
	buf[r] = '\0';
	if (Debug)
	    printf("check_invite: returned string is \"%s\"\r\n", buf+1);
	if (buf[2] == NAK)
	    return NULL;
	return strsave(buf + 3);   /* skip over ESC I y */
	printf("Trying to contact phone daemon.\r\n");
    }
    error(1, "Cannot contact local phone daemon.");
    return NULL;
}
