
/*
 * Log:    utmp.c,v 
 * Revision 1.1	 85/10/28  17:38:37  broome
 * Initial revision
 */

#include "../common.h"
#include "defs.h"
#ifndef lint
#if 0
static char __unused RCSid[] = "Header: utmp.c,v 1.1 85/10/28 17:38:37 broome Exp ";
#else
static char __unused RCSid[] = "$Phone: utmp.c,v 1.2 2013/01/02 23:00:43 christos Exp $";
#endif
#endif



/*
 *   Routines for dealing with /etc/utmp.
 *
 *   We use a statically-allocated array because readutmp() is
 *   called at interrupt-level and we don't want to mess up malloc()
 *   and free as a result.
 */

/*
 *  Go through the utmp buffer, trying to find the named user,
 *  possibly with the tty specified.
 */
char *
findtty(const char *user, const char *tty, int *mode)
{
    static char ttybuf[MAXPATHLEN];
    struct utmpx *utmp;
    struct stat statb;

    *mode = NOT_ON;			    /* start by assuming he's not on */
    setutxent();
    while ((utmp = getutxent()) != NULL) {
	if (*utmp->ut_name == '\0')		 /* noone on this port */
	    continue;
	if (strncmp(utmp->ut_name, user, 8))	/* names don't match */
	    continue;
	if (tty && *tty && strncmp(tty, utmp->ut_line, 8)) /* not spec'd tty */
	    continue;
	strlcpy (ttybuf, "/dev/", sizeof(ttybuf));
	strlcat(ttybuf, utmp->ut_line, sizeof(ttybuf));
	if (stat(ttybuf, &statb))  /* error on tty? */
	    continue;
	if ((statb.st_mode & S_IWGRP) == 0) {
	    *mode = MESG_OFF;	    /* refusing messages */
	    if (tty && *tty)	    /* they specified a particular tty */
		break;
	    else
		continue;	    /* see if we can find another one */
	} else {		    /* all is okay, use this one */
	    *mode = 0;
	    return ttybuf;
	}
    }
    return NULL;
}


/*
 *  Send a "who" message to the given address ...
 *  We go through the utmp buffer, building LINELEN-long buffers
 *  and send them on over to the user.
 */

void
who(struct sockaddr_in *sin)
{
#ifdef NO_WHO	    /* not allowed here ... */
    sendit(misc, sin, "%c%c%cwho@%s: this site doesn't allow remote who.", 
	ESC, NAK, WHO, host);
    return;
#else /* !NO_WHO   not so paranoid here */
    struct  utmpx *utmp;
    int	    users = 0;
    char   *msg = NULL;

    sendit(misc, sin, "%c%c%cwho info coming...", ESC, WHO, ACK);

    setutxent();
    while ((utmp = getutxent()) != NULL) {
	if (*utmp->ut_name == '\0' || utmp->ut_type != USER_PROCESS)
	    /* noone on that line */
	    continue;
	if (msg != NULL) {
	    char *nm;
	    asprintf(&nm, "%s %.8s(%.5s)", msg, utmp->ut_name, utmp->ut_line);
	    free(msg);
	    msg = nm;
	} else
	    asprintf(&msg, " %.8s(%.5s)", utmp->ut_name, utmp->ut_line);
	users++;
    }
    endutxent();
    if (users == 0) {
	sendit(misc, sin, "%c%c%c%s: Noone logged on.", 
		ESC, MESSAGE, ACK, host);
    } else if (msg)
       (void) sendto(misc, msg, strlen(msg), 0, (void *)sin, sizeof(*sin));
    free(msg);

#endif /* NO_WHO */
}
