#include "defs.h"
#ifndef lint
static char __unused RCSid[] = "$Phone: sendit.c,v 1.1 2013/01/02 23:00:43 christos Exp $";
#endif

/*
 *  Send the given buffer to the given address, with
 *  multiple retries.  Stores the received string
 *  in the global `buf', and returns the number of chars
 *  read, or -1 on error or no response.
 */

ssize_t
sendit(int fd, struct sockaddr_in *sin, const char *fmt, ...)
{
    int n;
    ssize_t rval;
    va_list ap;
    char buf[1024];

    va_start(ap, fmt);
    n = vsnprintf(buf, sizeof(buf), fmt, ap);
    va_end(ap);
    if ((size_t)n >= sizeof(buf)) {
	syslog(LOG_ERR, "sendit: overflow");
	return -1;
    }
    while ((rval = sendto(fd, buf, n, 0, (void *)sin, sizeof(*sin))) < 0)
	if (errno != EINTR)
		return rval;
    return rval;
}
