/*	$Phone: defs.h,v 1.2 2013/01/02 23:00:43 christos Exp $	*/
/*
 * Header: defs.h,v 1.1 85/10/28 17:38:15 broome Exp 
 */

/*
 * Log:    defs.h,v 
 * Revision 1.1	 85/10/28  17:38:15  broome
 * Initial revision
 */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/tty.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <fcntl.h>
#include <time.h>
#include <utmpx.h>
#include <signal.h>
#include <netdb.h>
#include <stdlib.h>
#include <unistd.h>
#include <poll.h>
#include <pwd.h>
#include <stdarg.h>
#include <string.h>
#include <syslog.h>
#include <err.h>
#include <errno.h>

#define SOCKADDR    struct sockaddr_in	  /* shorter to type */

/*
 *   One of these structures is used for each pending invitation.
 */

struct invite {
    /*	info about the person requesting a call	 */
    char      *caller;		 /* login name of person making invitation */
    char      *host;		 /* figured out from control port address  */
    SOCKADDR  ctladdr;		 /* inviter's control port address	   */
    char      *convaddr;	 /* inviter's conversation port address	   */
    char      *callno;		 /* unique per-user message id from caller */

    /*	info about the person being requested  */
    char      *callee;		 /* login name of person being requested   */
    char      *tty;		 /* user's tty, if any			   */
    char      *ptty;		 /* tty we are actually paging		   */
    char      *home;		 /* his home directory			   */
    uid_t     uid;
    gid_t     gid;		 /* used for forwarding programs	   */

    /*	and bookkeeping information about the invitation itself	 */
    int	      type;		 /* normal page or being forwarded?	   */
    int	      rings;		 /* send a new ring when rings == 0	   */
    pid_t     pid;		 /* child notification pid		   */
    int	      flags;		 /* various stuff about status		   */
    char      id[10];		 /* identification for this request	   */
    struct    invite *prev;	 /* previous in doubly-linked list	   */
    struct    invite *next;	 /* next most recent invitation		   */
};

typedef struct invite INV;
#define eq(a,b)	 (strcmp(a,b) == 0)

/*  often-used functions  */
/* child.c */
void sigchld(int s);

/* daemon.c */
void xdaemon(struct sockaddr_in *);
char *error(void);

/* dopage.c */
int doxpage(INV *);

/* forward_program.c */
void forward_program(char *, INV *);
int expand(char *, char **, size_t, INV *);

/* inquire.c */
void inquire(char *[], struct sockaddr_in *);
void answer(char *[]);

/* list.c */
void insert(INV *);
void ring(int);
void dopage(INV *);
INV *lookup(const char *, const char *);
void delete(INV *);

/* main.c */
void service(int);
int parse(char *, char **);

/* page.c */
void page(char *[], struct sockaddr_in *);
INV *seenit(char *, struct sockaddr_in *);

/* pagetty.c */
void pagetty(INV *, const char *);

/* reinvite.c */
void reinvite(char **, struct sockaddr_in *);

/* sendit.c */
ssize_t
sendit(int, struct sockaddr_in *, const char *fmt, ...)		
    __attribute__((__format__(__printf__, 3, 4)));

/* strsave.c */
char *strsave(const char *);

/* utmp.c */
char *findtty(const char *, const char *, int *);
void who(struct sockaddr_in *);

char	host[MAXHOSTNAMELEN];		    /* name of this host */
char	myaddr[MAXHOSTNAMELEN];
int	misc;			/* socket used to send out */

/*  Error return values from paging routines  */
#define NOT_HERE   1
#define ERR	   3
#define THRESHOLD (60*10)    /* ten minutes */

#define PROG	    (1<<0)	/* was forwarded to a program	     */
#define FORWARD	    (1<<1)	/* forwarded to another user/host    */
#define DONTFORWARD (1<<2)	/* forwarding failed - don't forward */
#define NOT_ON	    (1<<3)	/* user is not logged on */
#define MESG_OFF    (1<<4)	/* user is refusing messages */

#define BUSYFILE    "/.busy"	/* name of forwarding file */

INV	*invitations;		/* list of pending invitations */
INV	*freelist;		/* list of free invite structs */

