/*
 * Log:    daemon.c,v 
 * Revision 1.1	 85/10/28  17:38:13  broome
 * Initial revision
 * 
 */

#include "../common.h"
#include "defs.h"

#ifndef lint
#if 0
static char __unused RCSid[] = "Header: daemon.c,v 1.1 85/10/28 17:38:13 broome Exp ";
#else
static char __unused RCSid[] = "$Phone: daemon.c,v 1.2 2013/01/02 23:00:43 christos Exp $";
#endif
#endif



/*
 *  The guy wants a daemon, so give him one ...
 */

void
xdaemon(struct sockaddr_in *addr)
{
    struct sockaddr_in sin;	/* address of new daemon */
    int	   sock;
    int	   pid;
    int	   i;
    socklen_t slen;

    if ((sock = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	warn("socket");
	sendit(misc, addr, "%c%c%cCannot create socket: %s", 
	    ESC, DAEMON, NAK, strerror(errno));
	return;
    }

    i = 1;
    if (setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, &i, sizeof(i)))
	syslog(LOG_ERR, "daemon: setsockopt: %m");

    memset(&sin, 0, sizeof(sin));
    sin.sin_addr.s_addr = INADDR_ANY;
    sin.sin_port = 0;
    sin.sin_family = AF_INET;

    slen = sizeof(sin);
    if (bind(sock, (void *)&sin, slen) < 0) {
	warn("bind");
	sendit(misc, addr, "%c%c%cCannot bind socket: %s", ESC, DAEMON,
	    NAK, strerror(errno));
	return;
    }

    if ((pid = fork()) != 0) {	      /* parent */
	if (pid == -1) {	/* failed */
	    warn("fork");
	    sendit(misc, addr, "%c%c%cFork failed: %s", ESC, DAEMON,
		NAK, strerror(errno));
	} 
	(void) close(sock);
	return;
    }
    
    slen = sizeof(sin);
    if (getsockname(sock, (void *)&sin, &slen) < 0) {
	warn("getsockname");
	sendit(misc, addr, "%c%c%cCannot get socket name: %s", 
	    ESC, DAEMON, NAK, strerror(errno));
	_exit(1);
    }

    /* life is good */
    sendit(misc, addr, "%c%c%c%s/%d", ESC, DAEMON, ACK, myaddr,
	ntohs(sin.sin_port));

    listen(sock, 5);

    if (sock != 0)
	if (dup2(sock, 0)) {	   /* set socket to be stdin */
	    warn("dup2");
	    syslog(LOG_ERR, "daemon: dup2 failed: %m");
	}

    for (i = 1; i < getdtablesize(); i++)   /* close anything else */
       (void) close(i);
    
#ifdef DPATH	    /* sure hope this is it! */
    execl(DPATH, "convd", NULL);
#else /* !DPATH */
    execl("/usr/local/lib/convd", "convd", NULL);
    execl("/usr/lib/convd", "convd", NULL);
    execl("/etc/convd", "convd", NULL);
#endif /* DPATH */

#ifdef DPATH
    syslog(LOG_ERR, "cannot execl %s: %m", DPATH);
#else
    syslog(LOG_ERR, "cannot execl convd: %m");
#endif

    sendit(misc, addr, "%c%c%cExecl failed: %s", ESC, DAEMON, NAK, strerror(errno));
    _exit(-99);
}
