#include "defs.h"
#include "../common.h"
#ifndef lint
static char __unused RCSid[] = "$Phone: readctl.c,v 1.2 2013/01/02 23:00:43 christos Exp $";
#endif

/*
 *  Read a message on the control socket and act upon it.
 */

void
readctl(void)
{
    int	    ack;	    /* = 1 if this is a good message */
    int	    r;		    /* number of chars read */
    char    buf[512];	    /* input buffer */
    socklen_t len;	      /* length of return address */
    struct  sockaddr_in from;

    len = sizeof(from);
    if ((r = recvfrom(ctl, buf, 512, 0, (void *)&from, &len)) == 0) {
	error(0, "read: control socket");
	return;
    }

    if (*buf != ESC) {	    /* bad control packet */
	error(0, "malformed control packet");
	return;
    }

    buf[r] = '\0';

    ack = buf[2] == ACK;

    switch(buf[1]) {   /* command character */
    case CALLING:   if (!ack)		/* can't call a user */
			delete(buf+3);
		    putmessage("%s", buf+8);
		    break;

    case PAGE:	    if (!ack) {		/* couldn't place call */
			pending--;
			putmessage("%s", buf+3);
		    }
		    break;

    case INQUIRE:   break;		/* don't do anything */

    case DAEMON:    break;		/* and again */

    case MESSAGE:   message("%s", buf+3);    /* show message */
		    break;

    case ANSWER:    delete(buf+3);     /* someone answered a call */
		    if (Debug) { 
			putmessage("Answer on id >>%s<<", buf+3); 
		    }
		    break;
    }
}
