#include "defs.h"
#ifndef lint
static char __unused RCSid[] = "$Phone: parse.c,v 1.2 2013/01/02 23:00:42 christos Exp $";
#endif
/*
 *  Take a line buffer and turn into an array of words,
 *  doing the right thing with quotes.
 */

int
parse(const char *line, char **argv)
{
    const char *lp;
    char *wp;
    char **ap;
    char word[128];
    char quotec = '\0';

    ap = argv;
    lp = line;

    while (*lp) {
	while (any(*lp, " \t"))	    /* skip over leading space */
	    lp++;

	quotec = '\0';
	wp = word;

	while (*lp) {	 /* get one word */
	    if (*lp == '!') {	/* hack to allow !cmd */
		*wp++ = *lp++;
		break;
	    }
	    if (*lp == '\\') {	    /* literal next character */
		*wp++ = *++lp;
		lp++;
		continue;
	    }
	    if (any(*lp, " \t") && !quotec)    /* wsp not in a quoted string */
		break;
	    if (any(*lp, "\"'")) {	 /* quote characters */
		if (!quotec) {		  /* this must be open quote */
		    quotec = *lp++;
		    continue;
		} /* else */
		if (*lp == quotec) {	  /* matches opening -> close quote */
		    quotec = '\0';
		    lp++;
		    continue;
		}
	    }
	    *wp++ = *lp++;
	}
	*wp = '\0';
	if (wp > word)
	    *ap++ = exptilde(word);
    }
    *ap =NULL;
    if (quotec)
	putmessage("Unmatched quote.");
    return(ap - argv);
}
