/*
 *  All the(external) command functions.
 */
#include "defs.h"
#ifndef lint
static char __unused RCSid[] = "$Phone: cmd.c,v 1.2 2013/01/02 23:00:42 christos Exp $";
#endif

static const char aliashelp[]  = "Assign an alias to a user name";
static const char cancelhelp[] = "Cancel a pending call to user";
static const char cdhelp[]     = "Change the working directory";
static const char dumphelp[]   = "Save a copy of the screen image into a file";
static const char helphelp[]   = "See help messages for any command";
static const char pagehelp[]   = "Invite user to join the conversation";
static const char quithelp[]   = "Leave the current conversation";
static const char runhelp[]    = "Run a program within the window";
static const char sethelp[]    = "Set the value of a variable";
static const char showhelp[]   = "See the value of a variable";
static const char whohelp[]    = "See who is currently logged on";

static struct cmd {
    const char *name;		 /* name this command goes by */
    void (*func)(int, char *[]); /* function to handle it     */
    int minargs;		 /* minimum number of args    */
    int maxargs;		 /* maximum number of args    */
    const char *usage;		 /* usage message text	      */
    const char *help;		 /* help message text	      */
} cmds[] = {
    { "call",	page,	2,  3,	"user@host [tty]",	pagehelp    },
    { "page",	page,	2,  3,	"user@host [tty]",	pagehelp    },
    { "phone",	page,	2,  3,	"user@host [tty]",	pagehelp    },
    { "cancel", cancel, 2,  3,	"user@host [tty]",	cancelhelp  },
    { "quit",	quit,	1,  1,	"",			quithelp    },
    { "who",	who,	1,  2,	"[user]",		whohelp	    },
    { "?",	help,	1,  2,	"[command]",		helphelp    },
    { "help",	help,	1,  2,	"[command]",		helphelp    },
    { "set",	set,	2,  3,	"variable [value]",	sethelp	    },
    { "show",	show,	1,  98, "[var [var]]",		showhelp    },
    { "!",	run,	2,  98, "prog [args]",		runhelp	    },
    { "run",	run,	2,  98, "prog [args]",		runhelp	    },
    { "dump",	dump,	1,  2,	"[file]",		dumphelp    },
    { "cd",	cd,	1,  2,	"[directory]",		cdhelp	    },
    { "alias",	alias,	1,  3,	"[alias user]",		aliashelp   },
    { "accept", zip,	1,  99, "",			""	    },
    { "forward",zip,	1,  99, "",			""	    },
    { 0,	0,	0,  0,	0,			0	    }
};


/*
 *  Given a buffer, parse it and execute the command.
 */

void
execute(const char *buf)
{
    size_t     len;
    int	    argc;
    char    *argv[99];
    struct  cmd *cmd;

    if ((argc = parse(buf, argv)) == 0)	  /* null command */
	return;
    
    len = strlen(argv[0]);

    for (cmd = cmds; cmd->name; cmd++) {
	if (strncmp(argv[0], cmd->name, len))  /* is it a prefix? */
	    continue;
	if (argc < cmd->minargs || argc > cmd->maxargs) {
	    putmessage("%s: bad number of arguments - usage: %s %s",
		cmd->name, cmd->name, cmd->usage);
	} else 
	   (*cmd->func)(argc - 1, argv + 1);
	return;
    }
    putmessage("Unknown command: \"%s\" - try \"?\" for list of commands",
	argv[0]);
}


/*
 *  Print a help message for the given command, or all commands.
 */

void
help(int argc, char *argv[])
{
    struct cmd *cmd;
    int	   all =(argc == 0);
    size_t len;

    if (all) {
	message("Showing help for all commands. Commands may be abbreviated.");
	len = 0;
    } else
	len = strlen(argv[0]);
    
    for (cmd = cmds; cmd->name; cmd++)
	if (all || strncmp(argv[0], cmd->name, len) == 0) {
	    if (!all ||((cmd + 1)->name && /* budd */
		strcmp(cmd->help,(cmd + 1)->help) ) ) {
		message("help: %s: %s.", cmd->name, cmd->help);
	    }
	}
}


/*
 *  Do nothing. Used for commands in .phonerc that have 
 *  no meaning to the client process.
 */

void
zip(int argc __unused, char *argv[] __unused) {
}
