#include "settings.h"
#include <stdio.h>
#include <string.h>

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include "filebrowser.h"
#include "mimeaction.h"

AppSettings appSettings = {0};
const gboolean showHiddenFilesDefault = FALSE;
const gboolean showDirTreeDefault = FALSE;
const gboolean showThumbnailDefault = TRUE;
const int maxThumbSizeDefault = 1<<20;
const int openBookmarkMethodDefault = 1;
const int viewModeDefault = FBVM_LIST_VIEW;
const int sortOrderDefault = FB_SORT_BY_NAME;
const int sortTypeDefault = GTK_SORT_ASCENDING;

typedef void (*SettingsParseFunc)( char* line );

void parse_general_settings( char* line )
{
  char* sep = strstr( line, "=" );
  char* name;
  char* value;
  if( !sep )
    return;
  name = line;
  value = sep + 1;
  *sep = '\0';
  /*  g_print("name: %s = value: %s\n", name, value); */
  if( 0 == strcmp( name, "encoding" ) ) {
    strcpy( appSettings.encoding, value );
  }
  else if( 0 == strcmp( name, "showHiddenFiles" ) ) {
    appSettings.showHiddenFiles = atoi(value);
  }
  else if( 0 == strcmp( name, "showDirTree" ) ) {
    appSettings.showDirTree = atoi(value);
  }
  else if( 0 == strcmp( name, "showThumbnail" ) ) {
    appSettings.showThumbnail = atoi(value);
  }
  else if( 0 == strcmp( name, "maxThumbSize" ) ) {
    appSettings.maxThumbSize = atoi(value)<<10;
  }
  else if( 0 == strcmp( name, "viewMode" ) ){
    appSettings.viewMode = atoi(value);
  }
  else if( 0 == strcmp( name, "sortOrder" ) ){
    appSettings.sortOrder = atoi(value);
  }
  else if( 0 == strcmp( name, "sortType" ) ){
    appSettings.sortType = atoi(value);
  }
  else if( 0 == strcmp( name, "openBookmarkMethod" ) ){
    appSettings.openBookmarkMethod = atoi(value);
  }
}

void parse_window_state( char* line )
{
  char* sep = strstr( line, "=" );
  char* name;
  char* value;
  if( !sep )
    return;
  name = line;
  value = sep + 1;
  *sep = '\0';
  if( 0 == strcmp( name, "splitterPos" ) ) {
    appSettings.splitterPos = atoi(value);
  }
}

void load_bookmarks()
{
  FILE* file;
  gchar* path;
  char line[1024];

  path = g_build_filename( g_get_home_dir(), ".pcmanfm/bookmarks", NULL );
  file = fopen( path, "r" );
  g_free( path );
  if( file )
  {
    while( fgets( line, sizeof(line), file ) )
    {
      strtok( line, "\r\n" );
      if( ! line[0] )
        continue;
      appSettings.bookmarks = g_list_append( appSettings.bookmarks,
                                             strdup(line) );
    }
    fclose( file );
  }
}

void load_settings()
{
  FILE* file;
  gchar* path;
  char line[1024];
  char* section_name;
  SettingsParseFunc func = NULL;

  /* set default value */
  /* General */
  appSettings.encoding[0] = '\0';
  appSettings.showHiddenFiles = showHiddenFilesDefault;
  appSettings.showDirTree = showDirTreeDefault;
  appSettings.showThumbnail = showThumbnailDefault;
  appSettings.maxThumbSize = maxThumbSizeDefault;
  appSettings.viewMode = viewModeDefault;
  appSettings.openBookmarkMethod = openBookmarkMethodDefault;

  /* Window State */
  appSettings.splitterPos = 160;

  /* load settings */
  path = g_build_filename( g_get_home_dir(), ".pcmanfm/main", NULL );
  file = fopen( path, "r" );
  g_free( path );
  if( file )
  {
    while( fgets( line, sizeof(line), file ) )
    {
      strtok( line, "\r\n" );
      if( ! line[0] )
        continue;
      if( line[0] == '[' ){
        section_name = strtok( line, "]" );
        if( 0 == strcmp( line + 1, "General" ) )
          func = &parse_general_settings;
        else if( 0 == strcmp( line + 1, "Window" ) )
          func = &parse_window_state;
        else
          func = NULL;
        continue;
      }
      if( func )
        (*func)( line );
    }
    fclose( file );
  }

  if( appSettings.encoding[0] ){
    setenv( "G_FILENAME_ENCODING", appSettings.encoding, 1 );
  }

  load_bookmarks();
}

void save_bookmarks()
{
  FILE* file;
  gchar* path;
  GList* l;

  path = g_build_filename( g_get_home_dir(), ".pcmanfm/bookmarks", NULL );
  file = fopen( path, "w" );
  g_free( path );

  if( file )
  {
    for( l = appSettings.bookmarks; l; l = l->next ) {
      fprintf( file, "%s\n", (char*)l->data );
    }
    fclose( file );
  }
}

void save_settings()
{
  FILE* file;
  gchar* path;
  /* load settings */
  path = g_build_filename( g_get_home_dir(), ".pcmanfm", NULL );

  if( ! g_file_test( path, G_FILE_TEST_EXISTS ) ){
    g_mkdir( path, 0766 );
  }
  g_chdir( path );
  g_free( path );
  file = fopen( "main", "w" );
  if( file )
  {
    /* General */
    fputs("[General]\n", file);
    if( appSettings.encoding[0] )
      fprintf( file, "encoding=%s\n", appSettings.encoding );
    if( appSettings.showHiddenFiles != showHiddenFilesDefault )
      fprintf( file, "showHiddenFiles=%d\n", !!appSettings.showHiddenFiles );
    if( appSettings.showDirTree != showDirTreeDefault )
      fprintf( file, "showDirTree=%d\n", !!appSettings.showDirTree );
    if( appSettings.showThumbnail != showThumbnailDefault )
      fprintf( file, "showThumbnail=%d\n", !!appSettings.showThumbnail );
    if( appSettings.maxThumbSize != maxThumbSizeDefault )
      fprintf( file, "maxThumbSize=%d\n", appSettings.maxThumbSize>>10 );
    if( appSettings.viewMode != viewModeDefault )
      fprintf( file, "viewMode=%d\n", appSettings.viewMode );
    if( appSettings.sortOrder != sortOrderDefault )
      fprintf( file, "sortOrder=%d\n", appSettings.sortOrder );
    if( appSettings.sortType != sortTypeDefault )
      fprintf( file, "sortType=%d\n", appSettings.sortType );
    if( appSettings.openBookmarkMethod != openBookmarkMethodDefault )
      fprintf( file, "openBookmarkMethod=%d\n", appSettings.openBookmarkMethod );

    fputs("[Window]\n", file);
    if( appSettings.splitterPos != 160 )
      fprintf( file, "splitterPos=%d\n", appSettings.splitterPos );

    fclose( file );
  }
  save_bookmarks();
  save_mime_action();
}

void free_settings()
{
  g_list_foreach( appSettings.bookmarks, (GFunc)g_free, NULL );
  g_list_free( appSettings.bookmarks );
}
