#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "prefdlg.h"
#include "prefdlgui.h"
#include "glade_support.h"

#include "settings.h"

gboolean show_preference_dialog( GtkWindow* parent )
{
  gboolean ret;
  GtkWidget* encoding;
  GtkWidget* bm_open_method;
  GtkWidget* max_thumb_size;
  const char* filename_encoding;

  GtkWidget* dlg = create_prefdlg();
  gtk_window_set_transient_for( GTK_WINDOW(dlg), parent );

  encoding = lookup_widget( dlg, "filename_encoding" );
  bm_open_method = lookup_widget( dlg, "bm_open_method" );
  max_thumb_size = lookup_widget( dlg, "max_thumb_size" );

  if( '\0' == (char)appSettings.encoding[0] )
    gtk_entry_set_text( GTK_ENTRY(encoding), "UTF-8" );
  else
    gtk_entry_set_text( GTK_ENTRY(encoding), appSettings.encoding );

  if( appSettings.openBookmarkMethod >= 1 &&
      appSettings.openBookmarkMethod <= 3)
    gtk_combo_box_set_active( GTK_COMBO_BOX(bm_open_method),
                              appSettings.openBookmarkMethod - 1 );
  else
    gtk_combo_box_set_active(  GTK_COMBO_BOX(bm_open_method), 0 );

  gtk_spin_button_set_value ( GTK_SPIN_BUTTON(max_thumb_size),
                              appSettings.maxThumbSize>>10 );

  ret = (gtk_dialog_run(GTK_DIALOG(dlg)) == GTK_RESPONSE_OK);
  if( ret )
  {
    filename_encoding = gtk_entry_get_text( GTK_ENTRY(encoding) );
    if( filename_encoding
        && g_ascii_strcasecmp (filename_encoding, "UTF-8") )
    {
      strcpy( appSettings.encoding, filename_encoding );
      setenv( "G_FILENAME_ENCODING", appSettings.encoding, 1 );
    }
    else
    {
      appSettings.encoding[0] = '\0';
      unsetenv( "G_FILENAME_ENCODING" );
    }

    appSettings.openBookmarkMethod = gtk_combo_box_get_active(
                                          GTK_COMBO_BOX(bm_open_method) ) + 1;

    appSettings.maxThumbSize = ((int)gtk_spin_button_get_value (
                                      GTK_SPIN_BUTTON(max_thumb_size))) << 10;

  }
  gtk_widget_destroy( dlg );
  return ret;
}

