#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "fileproperties.h"
#include "filepropertiesui.h"
#include "glade_support.h"

#include "xdgmime.h"
#include "mimedescription.h"

#include <sys/types.h>
#include <pwd.h>
#include <grp.h>

static gpointer calc_size( gpointer data )
{
  
  return NULL;
}

void file_properties_dlg_init( GtkWidget* dlg, GList* sel_files )
{
  GThread* calc_size_thread;
  const char* multiple_files = _("Multiple files are selected");
  const char* mime;
  GtkWidget* name = lookup_widget( dlg, "file_name" );
  GtkWidget* owner = lookup_widget( dlg, "owner" );
  GtkWidget* group = lookup_widget( dlg, "group" );
  GtkWidget* location = lookup_widget( dlg, "location" );
  GtkWidget* mime_type = lookup_widget( dlg, "mime_type" );

  GtkWidget* mtime = lookup_widget( dlg, "mtime" );
  GtkWidget* atime = lookup_widget( dlg, "atime" );

  GtkWidget* owner_r = lookup_widget( dlg, "owner_r" );
  GtkWidget* owner_w = lookup_widget( dlg, "owner_w" );
  GtkWidget* owner_x = lookup_widget( dlg, "owner_x" );

  GtkWidget* group_r = lookup_widget( dlg, "group_r" );
  GtkWidget* group_w = lookup_widget( dlg, "group_w" );
  GtkWidget* group_x = lookup_widget( dlg, "group_x" );

  GtkWidget* others_r = lookup_widget( dlg, "others_r" );
  GtkWidget* others_w = lookup_widget( dlg, "others_w" );
  GtkWidget* others_x = lookup_widget( dlg, "others_x" );

  GtkWidget* set_uid = lookup_widget( dlg, "set_uid" );
  GtkWidget* set_gid = lookup_widget( dlg, "set_gid" );
  GtkWidget* sticky = lookup_widget( dlg, "sticky" );

  char buf[64];
  const time_format = "%Y-%m-%d %H:%M";

  gchar* file_name;
  gchar* file_dir;
  gchar* file_path;

  struct passwd* pw;
  struct group* grp;

  struct stat statbuf;

  file_dir = g_path_get_dirname( (char*)sel_files->data );
  gtk_label_set_text( GTK_LABEL(location), file_dir );
  g_free( file_dir );

  /* Multiple files are selected */
  if( sel_files && sel_files->next ) {
    gtk_widget_set_sensitive( name, FALSE );
    gtk_entry_set_text( GTK_ENTRY(name), multiple_files );
    gtk_label_set_text( GTK_LABEL(mime_type), multiple_files );

    gtk_label_set_text( GTK_LABEL(mtime), multiple_files );
    gtk_label_set_text( GTK_LABEL(atime), multiple_files );

    gtk_toggle_button_set_inconsistent ( GTK_TOGGLE_BUTTON(owner_r), TRUE );
    gtk_toggle_button_set_inconsistent( GTK_TOGGLE_BUTTON(owner_w), TRUE );
    gtk_toggle_button_set_inconsistent( GTK_TOGGLE_BUTTON(owner_x), TRUE );

    gtk_toggle_button_set_inconsistent( GTK_TOGGLE_BUTTON(group_r), TRUE );
    gtk_toggle_button_set_inconsistent( GTK_TOGGLE_BUTTON(group_w), TRUE );
    gtk_toggle_button_set_inconsistent( GTK_TOGGLE_BUTTON(group_x), TRUE );

    gtk_toggle_button_set_inconsistent( GTK_TOGGLE_BUTTON(others_r), TRUE );
    gtk_toggle_button_set_inconsistent( GTK_TOGGLE_BUTTON(others_w), TRUE );
    gtk_toggle_button_set_inconsistent( GTK_TOGGLE_BUTTON(others_x), TRUE );

    gtk_toggle_button_set_inconsistent( GTK_TOGGLE_BUTTON(set_uid), TRUE );
    gtk_toggle_button_set_inconsistent( GTK_TOGGLE_BUTTON(set_gid), TRUE );
    gtk_toggle_button_set_inconsistent( GTK_TOGGLE_BUTTON(sticky), TRUE );
  }
  else {
    gtk_editable_set_editable (GTK_EDITABLE(name), FALSE);
    file_name = g_path_get_basename( (char*)sel_files->data );
    gtk_entry_set_text( GTK_ENTRY(name), file_name );
    g_free( file_name );

    file_path = g_filename_from_utf8( (char*)sel_files->data, 
                                       -1, NULL, NULL, NULL );
    if( stat( file_path, &statbuf ) )  {
      memset( &statbuf, 0, sizeof(struct stat) );
    }

    if( S_ISDIR(statbuf.st_mode) ) {
      mime = XDG_MIME_TYPE_DIRECTORY;
    }
    else {
      mime = xdg_mime_get_mime_type_for_file( file_path, NULL);
    }
    g_free( file_path );

    mime = get_mime_description( mime );
    gtk_label_set_text( GTK_LABEL(mime_type), mime );

    strftime( buf, sizeof(buf), 
              time_format, localtime( &statbuf.st_mtime ) );
    gtk_label_set_text( GTK_LABEL(mtime), buf );

    strftime( buf, sizeof(buf), 
              time_format, localtime( &statbuf.st_atime ) );
    gtk_label_set_text( GTK_LABEL(atime), buf );


    pw = getpwuid( statbuf.st_uid );
    gtk_entry_set_text( GTK_ENTRY(owner), pw->pw_name );

    grp = getgrgid( statbuf.st_gid );
    gtk_entry_set_text( GTK_ENTRY(group), grp->gr_name );

    gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON(owner_r), 
                                   (statbuf.st_mode & S_IRUSR) );
    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(owner_w), 
                                  (statbuf.st_mode & S_IWUSR) );
    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(owner_x), 
                                  (statbuf.st_mode & S_IXUSR) );

    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(group_r), 
                                  (statbuf.st_mode & S_IRGRP) );
    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(group_w), 
                                  (statbuf.st_mode & S_IWGRP) );
    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(group_x), 
                                  (statbuf.st_mode & S_IXGRP) );

    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(others_r), 
                                  (statbuf.st_mode & S_IROTH) );
    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(others_w), 
                                  (statbuf.st_mode & S_IWOTH) );
    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(others_x), 
                                  (statbuf.st_mode & S_IXOTH) );

    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(set_uid), 
                                  (statbuf.st_mode & S_ISUID) );
    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(set_gid), 
                                  (statbuf.st_mode & S_ISGID) );
    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(sticky), 
                                  (statbuf.st_mode & S_ISVTX) );
  }
    /*
  calc_size_thread = g_thread_create ( (GThreadFunc)calc_size, 
  NULL, FALSE, NULL);
    */

}

