/*
*  C Interface: fileoperation
*
* Description: 
*
*
* Author: Hong Jen Yee (PCMan) <pcman.tw (AT) gmail.com>, (C) 2005
*
* Copyright: See COPYING file that comes with this distribution
*
*/
#ifndef  _FILE_OPERATION_H
#define  _FILE_OPERATION_H

#include <gtk/gtk.h>
#include <glib.h>
#include <sys/types.h>

typedef enum
{
  FO_MOVE = 0,
  FO_COPY,
  FO_DELETE,
  FO_LINK, /* will be supported in the future */
  FO_CHMOD, /* will be supported in the future */
  FO_CHOWN, /* will be supported in the future */
  FO_CALCTSIZE /* will be supported in the future */
}FileOperationType;

struct _FileOperation;

typedef void (*FileOperationCallback)( struct _FileOperation* );


typedef enum
{
  FOS_RUNNING,
  FOS_QUERYCANCEL,
  FOS_QUERYOVERWRITE,
  FOS_CANCELLED,
}FileOperationState;

typedef struct _FileOperation{
  FileOperationType action;
  GList* source_paths; /* All source files */
  char* src_path; /* First source file */
  char* dest_path; /* Destinaton directory */
  gboolean overwrite_all; /* Overwrite all existing files without prompt */
  gboolean skip_all; /* Don't try to overwrite any files */

  char* current_file; /* Current processed file */
  off_t total_size; /* Total size of the files to be processed, in bytes */
  off_t progress; /* Total size of current processed files, in btytes */
  int percent; /* progress (percentage) */

  char* error_message;

  GThread* thread;
  GCond* wait_gui;
  GMutex* mutex;

  GtkWindow* parent_window;
  GtkWidget* progress_dlg;
  GtkLabel* current_label;
  GtkLabel* from_label;
  GtkProgressBar* progress_bar;

/* provate data */
  gint timer;
  FileOperationState state;

  FileOperationCallback callback;
}FileOperation;


FileOperation* file_operation_new ( GList* source_files,
                                    const char* dest_path,
                                    FileOperationType action,
                                    FileOperationCallback callback,
                                    GtkWindow* parent_window );

#define file_operation_copy_files( source_files, dest_path, callback, parent_win )  \
          file_operation_new ( source_files, dest_path, FO_COPY, callback, parent_win  )

#define file_operation_copy_file( source_file, dest_path, callback, parent_win  )  \
          file_operation_new ( g_list_append( NULL, g_strdup(source_file) ), \
                              dest_path, FO_COPY, callback, parent_win  )


#define file_operation_move_files( source_files, dest_path, callback, parent_win  )  \
          file_operation_new ( source_files, dest_path, FO_MOVE, callback, parent_win  )

#define file_operation_move_file( source_file, dest_path, callback, parent_win  )  \
          file_operation_new ( g_list_append( NULL, g_strdup(source_file) ), \
                              dest_path, FO_MOVE, callback, parent_win  )

#define file_operation_delete_files( source_files, callback, parent_win  )  \
          file_operation_new ( source_files, NULL, FO_DELETE, callback, parent_win  )

#define file_operation_delete_file( source_file, callback, parent_win  )  \
          file_operation_new ( g_list_append( NULL, g_strdup(source_file) ), \
                              NULL, FO_DELETE, callback, parent_win  )


void file_operation_cancel ( FileOperation* file_operation );

void file_operation_free ( FileOperation* file_operation );

void
on_cancel_button_clicked               (GtkButton       *button,
                                        gpointer         user_data);

#endif
