#ifndef  _FILE_BROWSER_H_
#define  _FILE_BROWSER_H_

#include <gtk/gtk.h>
#include "foldercontent.h"
#include <sys/types.h>

#include "ptkiconview.h"

/*
* NOTE:
* All file paths used in these functions are encoded in UTF-8.
*/

typedef enum{
  FBVM_ICON_VIEW,
  FBVM_LIST_VIEW
}FileBrowserViewMode;

typedef enum{
  FB_SORT_BY_NAME = 0,
  FB_SORT_BY_SIZE,
  FB_SORT_BY_TIME
}FileBrowserSortOrder;

typedef struct{
  GList* history;
  GList* curHistory;
  int historyNum;
  int fileCount;
  const char* dir_name;

  FolderContent* folder_content;
  GtkTreeModel* list_filter;
  GtkTreeModel* tree_filter;
  GtkTreeModel* list_sorter;

  gboolean show_hidden_files;
  gboolean show_dir_tree;
  FileBrowserSortOrder sort_order;
  GtkSortType sort_type;

  GList* clipboard_file_list;

  int n_sel_files;
  off_t sel_size;

  GtkWidget* mainWindow;
  GtkNotebook* noteBook;

  GtkWidget* tab_label;
  GtkWidget* tab_text;
  GtkWidget* tab_icon;
  GtkWidget* close_btn;

  GtkWidget* folderPane;
  GtkTreeView* dirTree;
  GtkWidget* dirTreeScroll;
  GtkWidget* folderView;
  GtkWidget* folderViewScroll;
  FileBrowserViewMode view_mode;

}FileBrowserData;


FileBrowserData* file_browser_new( GtkWidget* mainWindow,
                                   FileBrowserViewMode view_mode,
                                   gboolean open_dir_tree,
                                   gboolean create_tab_label );

FileBrowserData* file_browser_get_data( GtkWidget* file_browser );

void file_browser_chdir( GtkWidget* file_browser,
                               const char* folder_path,
                               gboolean  addHistory );

const char* file_browser_get_cwd( GtkWidget* file_browser );

int file_browser_get_n_files( GtkWidget* file_browser );

gboolean file_browser_can_back( GtkWidget* file_browser );
void file_browser_go_back( GtkWidget* file_browser );

gboolean file_browser_can_forward( GtkWidget* file_browser );
void file_browser_go_forward( GtkWidget* file_browser );

void file_browser_refresh( GtkWidget* file_browser );
void file_browser_update_mime_icons( GtkWidget* file_browser );

PtkIconView* file_browser_get_folder_view( GtkWidget* file_browser );
GtkTreeView* file_browser_get_dir_tree( GtkWidget* file_browser );

void file_browser_show_hidden_files( GtkWidget* file_browser,
                                     gboolean show );
void file_browser_show_dir_tree( GtkWidget* file_browser,
                                 gboolean show );

/* Sorting files */
void file_browser_sort_by_name( GtkWidget* file_browser );
void file_browser_sort_by_size( GtkWidget* file_browser );
void file_browser_sort_by_time( GtkWidget* file_browser );
void file_browser_sort_ascending( GtkWidget* file_browser );
void file_browser_sort_descending( GtkWidget* file_browser );


void file_browser_open_selected_files( GtkWidget* file_browser );

gboolean file_browser_can_paste( GtkWidget* file_browser );
void file_browser_paste( GtkWidget* file_browser );

gboolean file_browser_can_cut_or_copy( GtkWidget* file_browser );
void file_browser_cut( GtkWidget* file_browser );
void file_browser_copy( GtkWidget* file_browser );

void file_browser_can_delete( GtkWidget* file_browser );
void file_browser_delete( GtkWidget* file_browser );

void file_browser_select_all( GtkWidget* file_browser );
void file_browser_invert_selection( GtkWidget* file_browser );

void file_browser_rename_selected_file( GtkWidget* file_browser );

void file_browser_view_as_icons( GtkWidget* file_browser );
void file_browser_view_as_list ( GtkWidget* file_browser );

/*
 gboolean file_browser_has_dir_tree(  GtkWidget* file_browser  );
*/

#endif
