/*
*  C Implementation: editbookmark
*
* Description:
*
*
* Author: Hong Jen Yee (PCMan) <pcman.tw (AT) gmail.com>, (C) 2006
*
* Copyright: See COPYING file that comes with this distribution
*
*/

#include "editbookmarks.h"
#include "settings.h"

#include <gtk/gtk.h>
#include <glib.h>

#include "inputdialog.h"
#include "glade_support.h"

enum{
  COL_DIRPATH = 0,
  NUM_COLS
};

static char* get_user_input( GtkWindow* parent, const char* old_text )
{
  char* path = NULL;
  const char* title = old_text ? _("Edit Bookmark") : _("Add to Bookmarks");
  GtkWidget* dlg = input_dialog_new( title,
                                     _("Enter new directory path:"),
                                     old_text,
                                     parent );

  while( gtk_dialog_run( GTK_DIALOG(dlg) ) == GTK_RESPONSE_OK ) {
    path = input_dialog_get_text( dlg );
    if( path )  {
      if( *path )
        break;
      else {
        g_free( path );
      }
    }
  }
  gtk_widget_destroy( dlg );
  return path;
}

static void on_add( GtkButton* btn, gpointer data )
{
  GtkWindow* parent = GTK_WINDOW(data);
  char* path;
  GtkTreeIter it, new_it;
  GtkTreeView* view = (GtkTreeView*)g_object_get_data( G_OBJECT(data),
                                                       "list_view" );
  GtkTreeModel* model;
  GtkTreeSelection* sel = gtk_tree_view_get_selection( view );
  if( gtk_tree_selection_get_selected ( sel, &model, &it ) )  {
    path = get_user_input( parent, NULL );
    if( path ){
      gtk_list_store_insert_after( GTK_LIST_STORE(model), &new_it, &it );
      gtk_list_store_set( GTK_LIST_STORE(model), &new_it,
                          COL_DIRPATH, path, -1);
      g_free( path );
    }
  }

}

static void on_edit( GtkButton* btn, gpointer data )
{
  GtkWindow* parent = GTK_WINDOW(btn);
  char* path, *old_path;
  GtkTreeIter it;
  GtkTreeView* view = (GtkTreeView*)g_object_get_data( G_OBJECT(parent),
                                                       "list_view" );
  GtkTreeModel* model;
  GtkTreeSelection* sel = gtk_tree_view_get_selection( view );
  if( gtk_tree_selection_get_selected ( sel, &model, &it ) )  {
    gtk_tree_model_get( model, &it, COL_DIRPATH, &old_path, -1 );
    if( old_path ) {
      path = get_user_input( parent, old_path );
      g_free( old_path );
      if( path ){
        gtk_list_store_set( GTK_LIST_STORE(model), &it,
                            COL_DIRPATH, path, -1);
        g_free( path );
      }
    }
  }
}

static void on_delete( GtkButton* btn, gpointer data )
{
  GtkTreeIter it;
  GtkTreeView* view = (GtkTreeView*)g_object_get_data( G_OBJECT(data),
                                                       "list_view" );
  GtkTreeModel* model;
  GtkTreeSelection* sel = gtk_tree_view_get_selection( view );
  if( gtk_tree_selection_get_selected ( sel, &model, &it ) )
  {
    gtk_list_store_remove( GTK_LIST_STORE(model), &it );
  }
  gtk_widget_grab_focus( GTK_WIDGET(view) );
}

gboolean edit_bookmarks( GtkWindow* parent )
{
  GList* l;
  GtkWidget* dlg;
  GtkWidget* btn_box;
  GtkWidget* add_btn;
  GtkWidget* edit_btn;
  GtkWidget* delete_btn;
  GtkWidget* scroll;
  GtkWidget* list_view;
  GtkListStore* list;
  GtkTreeViewColumn* col;
  GtkTreeIter it;
  GtkTreeSelection* sel;
  char* path;
  gboolean ret = FALSE;

  dlg = gtk_dialog_new_with_buttons ( _("Edit Bookmarks"),
                                      parent,
                                      GTK_DIALOG_MODAL,
                                      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                      GTK_STOCK_OK, GTK_RESPONSE_OK,
                                      NULL );

  list = gtk_list_store_new( NUM_COLS, G_TYPE_STRING );

  for( l = appSettings.bookmarks; l; l = l->next )
  {
    gtk_list_store_append( list, &it );
    gtk_list_store_set( list, &it, COL_DIRPATH, l->data, -1);
  }

  scroll = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW(scroll),
                                       GTK_SHADOW_IN);

  list_view = gtk_tree_view_new_with_model( GTK_TREE_MODEL(list) );
  g_object_set_data( G_OBJECT(dlg), "list_view", list_view );

  sel = gtk_tree_view_get_selection( GTK_TREE_VIEW(list_view) );
  gtk_tree_selection_set_mode( sel, GTK_SELECTION_BROWSE );

  gtk_tree_model_get_iter_first ( GTK_TREE_MODEL(list), &it );
  gtk_tree_selection_select_iter( sel, &it );

  col = gtk_tree_view_column_new_with_attributes(NULL,
      gtk_cell_renderer_text_new(),
      "text", COL_DIRPATH, NULL);
  gtk_tree_view_append_column( GTK_TREE_VIEW(list_view), col );
  gtk_tree_view_set_headers_visible ( GTK_TREE_VIEW(list_view), FALSE );
  gtk_tree_view_set_reorderable ( GTK_TREE_VIEW(list_view), TRUE );

  gtk_container_add( GTK_CONTAINER(scroll), list_view);

  btn_box = gtk_hbutton_box_new();
  gtk_button_box_set_layout ( GTK_BUTTON_BOX(btn_box), GTK_BUTTONBOX_START );
  add_btn = gtk_button_new_from_stock ( GTK_STOCK_ADD );
  g_signal_connect( add_btn, "clicked", G_CALLBACK(on_add), dlg );
  gtk_box_pack_start_defaults ( GTK_BOX(btn_box), add_btn );

  edit_btn = gtk_button_new_from_stock ( GTK_STOCK_EDIT );
  g_signal_connect_swapped( edit_btn, "clicked", G_CALLBACK(on_edit), dlg );
  gtk_box_pack_start_defaults ( GTK_BOX(btn_box), edit_btn );

  delete_btn = gtk_button_new_from_stock ( GTK_STOCK_DELETE );
  g_signal_connect( delete_btn, "clicked", G_CALLBACK(on_delete), dlg );
  gtk_box_pack_start_defaults ( GTK_BOX(btn_box), delete_btn );

  gtk_box_pack_start( GTK_BOX(GTK_DIALOG(dlg)->vbox), btn_box,
                       FALSE, FALSE, 4 );
  gtk_box_pack_start_defaults( GTK_BOX(GTK_DIALOG(dlg)->vbox), scroll );
  gtk_box_pack_start( GTK_BOX(GTK_DIALOG(dlg)->vbox),
                      gtk_label_new(_("Use drag & drop to sort the items")),
                      FALSE, FALSE, 4 );

  g_signal_connect_swapped( list_view, "row-activated",
                            G_CALLBACK(on_edit), dlg );

  gtk_window_set_default_size ( GTK_WINDOW(dlg), 400, 300 );

  gtk_widget_show_all( dlg );
  gtk_widget_grab_focus( list_view );

  if( gtk_dialog_run( GTK_DIALOG(dlg) ) == GTK_RESPONSE_OK )
  {
    g_list_foreach( appSettings.bookmarks, (GFunc)g_free, NULL);
    g_list_free( appSettings.bookmarks );
    appSettings.bookmarks = NULL;
    if( gtk_tree_model_get_iter_first( GTK_TREE_MODEL(list), &it ) )
    {
      do{
        gtk_tree_model_get( GTK_TREE_MODEL(list), &it, COL_DIRPATH, &path, -1 );
        appSettings.bookmarks = g_list_append( appSettings.bookmarks, path );
      }while( gtk_tree_model_iter_next( GTK_TREE_MODEL(list), &it) );
    }
    ret = TRUE;
  }
  gtk_widget_destroy( dlg );
  return ret;
}

