#ifndef _SETTINGS_H_
#define _SETTINGS_H_

#include <glib.h>

typedef struct {
  /* General Settings */
  char* encoding[32];
  gboolean showHiddenFiles;
  gboolean showDirTree;
  gboolean showThumbnail;
  int maxThumbSize;

  int openBookmarkMethod;
  /* 1: current tab, 2: new tab, 3: new window */
  int viewMode;
  int sortOrder; /* Sort by name, size, time */
  int sortType; /* ascending, descending */

  /* Window State */
  int splitterPos;

  /* Bookmarks */
  GList* bookmarks;
}AppSettings;

extern AppSettings appSettings;

void load_settings();
void save_settings();
void free_settings();

void load_bookmarks();
void save_bookmarks();

#endif
