#include <gtk/gtk.h>

extern GQuark mainWindowDataId;

/* Utility functions */
GtkWidget* get_current_file_browser( GtkWidget* mainWindow );

void
update_mainWindow_ui( GtkWidget* file_browser );


void add_new_tab( GtkWidget* mainWindow, 
										  const char* folder_path, 
										  gboolean open_dir_tree );

/* Signal handlers */

gboolean
on_mainWindow_delete_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data);

void
on_mainWindow_realize                  (GtkWidget       *widget,
                                        gpointer         user_data);

void
on_mainWindow_destroy                  (GtkObject       *object,
                                        gpointer         user_data);

void
on_backBtn_clicked                     (GtkWidget					*mainWindow,
                                        GtkToolButton   *toolbutton);

void
on_forwardBtn_clicked                  (GtkWidget					*mainWindow, 
																									GtkToolButton   *toolbutton);

void
on_upBtn_clicked                     (GtkWidget					*mainWindow, 
																								GtkToolButton   *toolbutton);

void
on_homeBtn_clicked                     (GtkWidget					*mainWindow, 
																									GtkToolButton   *toolbutton);

void
on_addressBar_activate                 (GtkWidget					*mainWindow,
                                        GtkEntry        *entry);

void
on_refreshBtn_clicked                  (GtkToolButton   *toolbutton,
                                        gpointer         user_data);



void
on_quit_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_new_folder_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_new_text_file_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_preference_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_about_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data);


gboolean
on_backBtn_popup_menu                  (GtkWidget       *widget,
                                        gpointer         user_data);

gboolean
on_forwardBtn_popup_menu               (GtkWidget       *widget,
                                        gpointer         user_data);

void
on_new_window_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_new_tab_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data);


void
on_folderNoteBook_switch_page          (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        guint            page_num,
                                        gpointer         user_data);

void
on_cut_activate                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_copy_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_paste_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_delete_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_select_all_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_add_to_bookmark_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_invert_selection_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_close_tab_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_rename_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data);


void
on_show_hidden_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_sort_by_name_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_sort_by_size_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_sort_by_time_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_sort_ascending_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_sort_descending_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_view_as_icons_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_view_as_list_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data);


void
on_open_directory_tree_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data);




void
on_dirTreeBtn_toggled                  (GtkToggleToolButton *toggletoolbutton,
                                        gpointer         user_data);

void
on_go_btn_clicked                      (GtkToolButton   *toolbutton,
                                        gpointer         user_data);
