/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <glib.h>

#include <stdlib.h>

#include "fileicon.h"
#include "mainwindowui.h"
#include "mainwindow.h"
#include "foldercontent.h"
#include "mimedescription.h"

#include "glade_support.h"

#include "settings.h"

static char* init_path = NULL;

gboolean delayed_open_new_tab( GtkWidget* mainWindow )
{
  add_new_tab( mainWindow, init_path, appSettings.showDirTree );
  return FALSE;
}

int
main (int argc, char *argv[])
{
  GtkWidget *mainWindow;
  GtkSettings *settings;

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gtk_init (&argc, &argv);

  load_settings();

  gtk_set_locale ();

  /* Use multithreading */
  g_thread_init(NULL);

/*
	add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");
*/
  mainWindow = create_mainWindow ();

  file_icon_init();
  folder_content_init();
  mime_description_init();

  gtk_widget_show (mainWindow);

  if( argc > 1 && *argv[1] )
    init_path = argv[1];
  else if( ! (init_path = getenv( "HOME" )) )
    init_path = "/";

  g_idle_add( (GSourceFunc)delayed_open_new_tab, mainWindow );
  //add_new_tab( mainWindow, init_path, appSettings.showDirTree );

  gtk_main ();

  save_settings();
  free_settings();

  file_icon_clean();
  folder_content_clean();
  mime_description_clean();

  return 0;
}

