/* $Id: icmp.c,v 1.6 2000/09/07 13:55:32 keiji Exp $ */
/*
** icmp.c - Packet Monster ICMP
** Author: Keiji Takeda (keiji@sfc.keio.ac.jp)
**
** pakemon is an abbreviation of "Packet Monster", a simple packet
** monitoring misuse detector.
** Copyright (C) 1999, 2000 Keiji Takeda <keiji@sfc.keio.ac.jp>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pakemon.h"
#include "signature.h"

/*****************************************************
  Function: icmp_callback
  Purpose: process icmp packet
  Arguments:
      struct ip_info ip_packet : ip packet to process
******************************************************/

void icmp_callback(struct ip_info *ip_packet )
{

  strcpy( ip_packet->src_IP, (char *)inet_ntoa( (ip_packet->ip_header)->ip_src));

  strcpy( ip_packet->dest_IP, (char *)inet_ntoa( (ip_packet->ip_header)->ip_dst ));

  ip_packet->trans_header = (u_char *)(ip_packet->ip_header) + 
    ((ip_packet->ip_header)->ip_hl ) * 4; 

  /*
  ip_packet->payload = (u_char *)( ip_packet->trans_header ) + 
    sizeof( struct icmphdr );
  */
  ip_packet->payload = (u_char *)&(((struct icmp *)( ip_packet->trans_header ))->icmp_hun );

  ip_packet->endof_payload = (u_char *)(ip_packet->payload) + ntohs((ip_packet->ip_header)->ip_len );

  ip_packet->payload_len = ip_packet->endof_payload - ip_packet->payload;

  ip_packet->src_number = ((struct icmp *)(ip_packet->trans_header))->icmp_type;

  ip_packet->dest_number = ((struct icmp *)(ip_packet->trans_header))->icmp_code;

  read_payload( ip_packet );

  if(pkmprm.verbose_mode)
    dump_packet_info( *ip_packet, local_netaddr, local_netmask );

  return ;

} /* icmp_callback  */

