// to compile gcc intro.c -laa

#include <aalib.h>
#include "intro.h"
#include <string.h>

void aa_Usage();
void aa_Flash(aa_context *context);
void aa_Fill(aa_context *context, int val);
void aa_Render(aa_context *context);
void aa_ImgMap(aa_context *context, unsigned char *img, int x, int y);
void aa_Invert(aa_context *context);
void aa_HLine(aa_context *context,int y,int val);
void aa_Grade(aa_context *context,int x,int y,int x2,int y2,int val);
void aa_ImgMapZoom(aa_context *context, unsigned char *img, int x, int y, float zoom);
void aa_FillZone(aa_context *context, int x, int y, int x2, int y2, int val);

void check_key(aa_context *ctx)
{
	int key
	= aa_getkey(ctx,0);
	if (key>0)
		exit(0);
}

main(int argc, char *argv[])
{
	int i;
	int y;
	int loop=0;
	aa_context *context;

	for(i=1;i<argc;i++)
	{
	    if (!strcmp(argv[i],"-loop")) loop=1; // 1=1 cop, 2=etern
	    else if (!strcmp(argv[i],"--loop")) loop=1; // 1=1 cop, 2=etern
	    else if (!strcmp(argv[i],"--help")) aa_Usage();
	    else if (!strcmp(argv[i],"-h")) aa_Usage();
	}

	if (!aa_parseoptions(NULL,NULL,&argc,argv)) aa_Usage();
	
	context = aa_autoinit(&aa_defparams);
	aa_autoinitkbd(context,0);
	if (!context) printf("<AALIB> Error, cannot initialize the context.");
	
	do{
	
	y=context->imgheight/2.3;

	for (i=0; i<3; i++){
		aa_Flash(context);
	
		if (i>-1) aa_ImgMap(context, img_p, 50, y );
		if (i> 0) aa_ImgMap(context, img_a, 70, y );
		if (i> 1) aa_ImgMap(context, img_g, 90, y );
		check_key(context);
		aa_Render(context);
		sleep(1);}

	for (i=y;i>3;i--)
	{
		usleep(10000);
		check_key(context);
		aa_Fill(context,0);
		aa_ImgMap(context, img_p, 50,i);
		aa_ImgMap(context, img_a, 70,i);
		aa_ImgMap(context, img_g, 90,i);
		aa_Render(context);
	}
	
	sleep(1);
	aa_Invert(context);
	aa_Render(context);
	check_key(context);
	sleep(1);
	
	for(i=context->imgheight;i>30;i--)
	{
		check_key(context);
		usleep(10000);
		aa_HLine(context,i,0);
		aa_Render(context);
	}
		
	aa_printf(context,26,13,AA_REVERSE,"( Portable Arcade Game )");
	aa_flush(context);
	check_key(context);
	sleep(1);
	check_key(context);
	aa_Invert(context);
	aa_flush(context);
	sleep(1);
	check_key(context);
	
	for (i=30;i<49;i++)
	{
		check_key(context);
		usleep(10000);
		aa_HLine(context,i,0);
		aa_Render(context);
	}

	sleep(1);

	for(i=0;i<255;i++)
	{
		check_key(context);
		sleep(10000);
		aa_Grade(context,50,4,50+IMG_WIDTH,4+IMG_HEIGHT,0); // P ..
		aa_Grade(context,90,4,90+IMG_WIDTH,4+IMG_HEIGHT,0); // .. G
		aa_Render(context);
		aa_flush(context);
	}
	    
	for(i=100;i>7;i--)
	{	
		check_key(context);
		aa_FillZone(context, 70, 0, 70+IMG_HEIGHT, 48, 0);
		aa_ImgMapZoom(context, img_a, 70,(100-i)/2, i);
		aa_Render(context);
		usleep(10000);
	}
	
	aa_printf(context,35,23,AA_NORMAL,"A");
	aa_flush(context);
	check_key(context);
	sleep(1);
	aa_printf(context,36,22,AA_BOLD,",");
	aa_flush(context);
	check_key(context);
	sleep(1);
	aa_printf(context,36,22,AA_NORMAL," ");
	aa_flush(context);
	check_key(context);
	sleep(1);
	
	for(i=35;i<aa_scrwidth(context)-1;i++)
	{
		check_key(context);
		aa_printf(context, i, 23, AA_NORMAL," A");
		aa_flush(context);
		usleep(10000);
	}

	aa_printf(context,80,23,AA_NORMAL," ");
	aa_flush(context);
	sleep(2);
	check_key(context);
	} while(loop);
	
	aa_getkey(context,3);

	aa_uninitkbd(context);	
//	aa_close(context);
	
	exit(0);
}

void aa_Grade(aa_context *context,int x,int y,int x2,int y2,int val)
{
	int i,i2;
	for(i=x;i<x2;i++)
	for(i2=y;i2<y2;i2++)
	{
		if (context->imagebuffer[context->imgwidth*i2+i]>val)
			aa_putpixel(context, i,i2,
			          context->imagebuffer[context->imgwidth*i2+i]-1);
		if (context->imagebuffer[context->imgwidth*i2+i]<val)
			aa_putpixel(context, i,i2,
			          context->imagebuffer[context->imgwidth*i2+i]+1);
	}
}


void aa_HLine(aa_context *context,int y,int val)
{
	int i;
	for (i=0;i<context->imgwidth;i++)
		aa_putpixel(context, i, y, val);
}


void aa_Invert(aa_context *context)
{
	int i,i2;
	for(i=0;i<context->imgwidth;i++)
		for(i2=0;i2<context->imgheight;i2++)
			aa_putpixel(context,
		            i , i2,
		            255-context->imagebuffer[context->imgwidth*i2+i]);
}

void aa_Flash(aa_context *context)
{
	aa_Fill(context,255);
	aa_Render(context);
	aa_Fill(context,0);
	aa_Render(context);
}

void aa_Fill(aa_context *context, int val)
{
       int i,i2;
       
       for(i=0; i<context->imgheight; i++) //files (y)
          for(i2=0;i2<context->imgwidth; i2++) //columnes (x)
             aa_putpixel(context, i2,i, val);
}

void aa_FillZone(aa_context *context, int x, int y, int x2, int y2, int val)
{
	int i,i2;

	for(i2=x; i2<x2; i2++) //files (y)
	for(i=y;i<y2; i++) //columnes (x)
		aa_putpixel(context, i2,i, val);
}

void aa_Render(aa_context *context)
{
	aa_fastrender(context,0,0,aa_scrwidth(context), aa_scrheight(context));
	aa_printf(context,1,1,AA_NORMAL,"press return to exit this intro");
	aa_flush(context);
}

void aa_ImgMap(aa_context *context, unsigned char *img, int x, int y)
{
	int i,i2;
	
	for(i=0;i<IMG_WIDTH;i++)
	for(i2=0;i2<IMG_HEIGHT;i2++)
	{
		aa_putpixel(context,
		            i + x,
		            i2  + y,
		            img[IMG_WIDTH*i2+i]);
	}
}

void aa_ImgMapZoom(aa_context *context, unsigned char *img, int x, int y, float zoom)
{
	float i,i2;
	float zoom_val=zoom/100;
//	x+=(int)(zoom_val*IMG_WIDTH);
//	y+=(int)(zoom_val*IMG_HEIGHT);
	
	for(i=0;i<IMG_WIDTH;i++)
		for(i2=0;i2<IMG_HEIGHT;i2++)
		{
		aa_putpixel(context,
		            (int)( i*zoom_val) + x,
		            (int)(i2*zoom_val) + y,
		            img[IMG_WIDTH*(int)i2+(int)i]);
		}
}

void aa_Usage()
{
	printf("%s",aa_help);
	printf("\n"
	       "Intro options:\n"
	       "  -loop          Repeat this intro ever.\n\n");
	exit(0);
}

