<?php

/**
 * BaseLeaveRequest
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $leave_request_id
 * @property integer $leave_period_id
 * @property string $leave_type_id
 * @property string $leave_type_name
 * @property date $date_applied
 * @property integer $empNumber
 * @property string $leave_comments
 * @property Employee $Employee
 * @property LeaveType $LeaveType
 * @property LeavePeriod $LeavePeriod
 * @property Doctrine_Collection $Leave
 * 
 * @method integer             getLeaveRequestId()   Returns the current record's "leave_request_id" value
 * @method integer             getLeavePeriodId()    Returns the current record's "leave_period_id" value
 * @method string              getLeaveTypeId()      Returns the current record's "leave_type_id" value
 * @method string              getLeaveTypeName()    Returns the current record's "leave_type_name" value
 * @method date                getDateApplied()      Returns the current record's "date_applied" value
 * @method integer             getEmpNumber()        Returns the current record's "empNumber" value
 * @method string              getLeaveComments()    Returns the current record's "leave_comments" value
 * @method Employee            getEmployee()         Returns the current record's "Employee" value
 * @method LeaveType           getLeaveType()        Returns the current record's "LeaveType" value
 * @method LeavePeriod         getLeavePeriod()      Returns the current record's "LeavePeriod" value
 * @method Doctrine_Collection getLeave()            Returns the current record's "Leave" collection
 * @method LeaveRequest        setLeaveRequestId()   Sets the current record's "leave_request_id" value
 * @method LeaveRequest        setLeavePeriodId()    Sets the current record's "leave_period_id" value
 * @method LeaveRequest        setLeaveTypeId()      Sets the current record's "leave_type_id" value
 * @method LeaveRequest        setLeaveTypeName()    Sets the current record's "leave_type_name" value
 * @method LeaveRequest        setDateApplied()      Sets the current record's "date_applied" value
 * @method LeaveRequest        setEmpNumber()        Sets the current record's "empNumber" value
 * @method LeaveRequest        setLeaveComments()    Sets the current record's "leave_comments" value
 * @method LeaveRequest        setEmployee()         Sets the current record's "Employee" value
 * @method LeaveRequest        setLeaveType()        Sets the current record's "LeaveType" value
 * @method LeaveRequest        setLeavePeriod()      Sets the current record's "LeavePeriod" value
 * @method LeaveRequest        setLeave()            Sets the current record's "Leave" collection
 * 
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseLeaveRequest extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('hs_hr_leave_requests');
        $this->hasColumn('leave_request_id', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 4,
             ));
        $this->hasColumn('leave_period_id', 'integer', 7, array(
             'type' => 'integer',
             'length' => 7,
             ));
        $this->hasColumn('leave_type_id', 'string', 13, array(
             'type' => 'string',
             'primary' => true,
             'length' => 13,
             ));
        $this->hasColumn('leave_type_name', 'string', 50, array(
             'type' => 'string',
             'fixed' => 1,
             'length' => 50,
             ));
        $this->hasColumn('date_applied', 'date', 25, array(
             'type' => 'date',
             'notnull' => true,
             'length' => 25,
             ));
        $this->hasColumn('employee_id as empNumber', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 4,
             ));
        $this->hasColumn('leave_comments', 'string', 250, array(
             'type' => 'string',
             'length' => 250,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Employee', array(
             'local' => 'empNumber',
             'foreign' => 'empNumber'));

        $this->hasOne('LeaveType', array(
             'local' => 'leave_type_id',
             'foreign' => 'leaveTypeId'));

        $this->hasOne('LeavePeriod', array(
             'local' => 'leave_period_id',
             'foreign' => 'leavePeriodId'));

        $this->hasMany('Leave', array(
             'local' => 'leave_request_id',
             'foreign' => 'leave_request_id'));
    }
}