<?php

/**
 * BaseEmployeeLeaveEntitlement
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property string $leave_type_id
 * @property integer $employee_id
 * @property integer $leave_period_id
 * @property decimal $no_of_days_allotted
 * @property decimal $leave_taken
 * @property decimal $leave_brought_forward
 * @property decimal $leave_carried_forward
 * @property LeaveType $LeaveType
 * @property Employee $Employee
 * @property LeavePeriod $LeavePeriod
 * 
 * @method string                   getLeaveTypeId()           Returns the current record's "leave_type_id" value
 * @method integer                  getEmployeeId()            Returns the current record's "employee_id" value
 * @method integer                  getLeavePeriodId()         Returns the current record's "leave_period_id" value
 * @method decimal                  getNoOfDaysAllotted()      Returns the current record's "no_of_days_allotted" value
 * @method decimal                  getLeaveTaken()            Returns the current record's "leave_taken" value
 * @method decimal                  getLeaveBroughtForward()   Returns the current record's "leave_brought_forward" value
 * @method decimal                  getLeaveCarriedForward()   Returns the current record's "leave_carried_forward" value
 * @method LeaveType                getLeaveType()             Returns the current record's "LeaveType" value
 * @method Employee                 getEmployee()              Returns the current record's "Employee" value
 * @method LeavePeriod              getLeavePeriod()           Returns the current record's "LeavePeriod" value
 * @method EmployeeLeaveEntitlement setLeaveTypeId()           Sets the current record's "leave_type_id" value
 * @method EmployeeLeaveEntitlement setEmployeeId()            Sets the current record's "employee_id" value
 * @method EmployeeLeaveEntitlement setLeavePeriodId()         Sets the current record's "leave_period_id" value
 * @method EmployeeLeaveEntitlement setNoOfDaysAllotted()      Sets the current record's "no_of_days_allotted" value
 * @method EmployeeLeaveEntitlement setLeaveTaken()            Sets the current record's "leave_taken" value
 * @method EmployeeLeaveEntitlement setLeaveBroughtForward()   Sets the current record's "leave_brought_forward" value
 * @method EmployeeLeaveEntitlement setLeaveCarriedForward()   Sets the current record's "leave_carried_forward" value
 * @method EmployeeLeaveEntitlement setLeaveType()             Sets the current record's "LeaveType" value
 * @method EmployeeLeaveEntitlement setEmployee()              Sets the current record's "Employee" value
 * @method EmployeeLeaveEntitlement setLeavePeriod()           Sets the current record's "LeavePeriod" value
 * 
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseEmployeeLeaveEntitlement extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('hs_hr_employee_leave_quota');
        $this->hasColumn('leave_type_id', 'string', 13, array(
             'type' => 'string',
             'primary' => true,
             'length' => 13,
             ));
        $this->hasColumn('employee_id', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 4,
             ));
        $this->hasColumn('leave_period_id', 'integer', 7, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 7,
             ));
        $this->hasColumn('no_of_days_allotted', 'decimal', 6, array(
             'type' => 'decimal',
             'scale' => false,
             'length' => 6,
             ));
        $this->hasColumn('leave_taken', 'decimal', 6, array(
             'type' => 'decimal',
             'default' => '0.00',
             'scale' => false,
             'length' => 6,
             ));
        $this->hasColumn('leave_brought_forward', 'decimal', 6, array(
             'type' => 'decimal',
             'default' => '0.00',
             'scale' => false,
             'length' => 6,
             ));
        $this->hasColumn('leave_carried_forward', 'decimal', 6, array(
             'type' => 'decimal',
             'default' => '0.00',
             'scale' => false,
             'length' => 6,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('LeaveType', array(
             'local' => 'leave_type_id',
             'foreign' => 'leaveTypeId'));

        $this->hasOne('Employee', array(
             'local' => 'employee_id',
             'foreign' => 'empNumber'));

        $this->hasOne('LeavePeriod', array(
             'local' => 'leave_period_id',
             'foreign' => 'leavePeriodId'));
    }
}