<?php
// Call CSVSplitterTest::main() if this source file is executed directly.
if (!defined('PHPUnit_MAIN_METHOD')) {
    define('PHPUnit_MAIN_METHOD', 'CSVSplitterTest::main');
}



require_once 'CSVSplitter.php';

/**
 * Test class for CSVSplitter.
 * Generated by PHPUnit on 2008-07-16 at 10:58:07.
 */
class CSVSplitterTest extends PHPUnit_Framework_TestCase {
	
	protected $testFilePath;
	
    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     */
    public static function main() {
        require_once 'PHPUnit/TextUI/TestRunner.php';

        $suite  = new PHPUnit_Framework_TestSuite('CSVSplitterTest');
        $result = PHPUnit_TextUI_TestRunner::run($suite);
    }

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     *
     * @access protected
     */
    protected function setUp() {
    	
    	$testFilePath = ROOT_PATH . '/lib/models/eimadmin/import/TestData.csv';    	
    	$this->assertTrue(file_exists($testFilePath));
    	$this->testFilePath = $testFilePath;
    	
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     *
     * @access protected
     */
    protected function tearDown() {
    	$csvSplitter = new CSVSplitter();
    	
    	$dirPath = $csvSplitter->getTempDir();
    	
    	$dir = opendir($dirPath);
		
		while ($file = readdir($dir)) {
			if (preg_match('/^_temp*/', $file)) {
				$this->assertTrue(unlink($dirPath . '/' . $file));
			}
		}
    	
    }

    public function testGetNoOfRecords() {
    	
    	$csvSplitter = new CSVSplitter();
    	
    	try {
    		$r = $csvSplitter->getNoOfRecords();
    		$this->fail('An exception should be thrown when no. of rows is not calculated');
    	} catch (Exception $e) {
    		$this->assertEquals(CSVSplitterException::ROWS_NOT_CALCULATED_YET, $e->getCode());
    	}
    	
    	$this->assertTrue($csvSplitter->split($this->testFilePath));
    	$noOfRows = $csvSplitter->getNoOfRecords();
    	$this->assertEquals(2024, $noOfRows);
    	
    }
    
    public function testGetHeader() {
    	
    	$csvSplitter = new CSVSplitter();
    	
    	try {
    		$r = $csvSplitter->getHeader();
    		$this->fail('An exception should be thrown when no. of rows is not calculated');
    	} catch (Exception $e) {
    		$this->assertEquals(CSVSplitterException::ROWS_NOT_CALCULATED_YET, $e->getCode());
    	}
    	
    	$this->assertTrue($csvSplitter->split($this->testFilePath));
    	$expectedHeader = '"Empl No",First,Last,MI,Street,City,State,Zip,Phone,Pager,DOH';
    	$actualHeader = $csvSplitter->getHeader();
    	$this->assertEquals($expectedHeader, $actualHeader);
    	
    }

    public function testSplit() {
    	
    	$csvSplitter = new CSVSplitter();
        
        // Test for an non-existing file
        try {
        	$csvSplitter->split('AnIncorrectFile.txt');
        	$this->fail('An exception should be thrown if an incorrect filename was given.');
        } catch (Exception $e) {
        	$this->assertEquals(CSVSplitterException::SOURCE_FILE_NOT_FOUND, $e->getCode());
        }
        
        // Checks for an empty file
        touch('EmptyFile.csv');
        try {
        	$csvSplitter->split('EmptyFile.csv');
        	$this->fail('An exception should be thrown if the give file is empty.');
        } catch (Exception $e) {
        	$this->assertEquals(CSVSplitterException::SOURCE_FILE_EMPTY, $e->getCode());
        }
        unlink('EmptyFile.csv');
        
        // Checks for splitting files
        $csvSplitter->split($this->testFilePath);
        
        $actualFileNames = array();
        $dirPath = $csvSplitter->getTempDir();
        
        $dir = opendir($dirPath);
        
		while ($file = readdir($dir)) {
			if (preg_match('/^_temp*/', $file)) {
				$actualFileNames[] = $dirPath . '/' . $file;
			}
		}

		$expectedFileNames = $csvSplitter->getTempFileList();
		sort($actualFileNames);
		sort($expectedFileNames);
		$this->assertEquals($expectedFileNames, $actualFileNames);
		
		$header = $csvSplitter->getHeader();
		
		foreach($actualFileNames as $file) {
			$this->assertTrue(filesize($file) > 0);
			
			if (!is_null($header)) {
				$contents = file($file);
				list($actualTempFileHeader) = $contents;
				
				$this->assertEquals($header, trim($actualTempFileHeader));
			} 
		}
        
    }

    public function testCleanup() {
        
        $csvSplitter = new CSVSplitter();
        
        $this->assertTrue($csvSplitter->cleanup());
        $this->assertFalse($this->_checkTempFilesExist($csvSplitter->getTempDir()));
        
        $this->assertTrue($csvSplitter->split($this->testFilePath));
        $this->assertTrue($this->_checkTempFilesExist($csvSplitter->getTempDir()));
        $this->assertTrue($csvSplitter->cleanup());
        $this->assertFalse($this->_checkTempFilesExist($csvSplitter->getTempDir()));
        
    }
        
    private function _checkTempFilesExist($dirPath) {
    	$dir = opendir($dirPath);
		
		while ($file = readdir($dir)) {
			if (preg_match('/^_temp*/', $file)) {
				return true;
			}
		}
		
		return false;
    }
}

// Call CSVSplitterTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == 'CSVSplitterTest::main') {
    CSVSplitterTest::main();
}
?>
