<?php
// Call MilleniumPayrollExportTest::main() if this source file is executed directly.
if (!defined("PHPUnit_MAIN_METHOD")) {
    define("PHPUnit_MAIN_METHOD", "MilleniumPayrollExportTest::main");
}

require_once "PHPUnit/Framework/TestCase.php";
require_once "PHPUnit/Framework/TestSuite.php";

require_once 'testConf.php';
require_once ROOT_PATH . '/lib/confs/Conf.php';
require_once 'MilleniumPayrollExport.php';
require_once ROOT_PATH . '/lib/models/eimadmin/encryption/KeyHandlerOld.php';

/**
 * Test class for MilleniumPayrollExport.
 * Generated by PHPUnit_Util_Skeleton on 2007-12-13 at 20:57:42.
 */
class MilleniumPayrollExportTest extends PHPUnit_Framework_TestCase {

	private $exportObj;

    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     */
    public static function main() {
        require_once "PHPUnit/TextUI/TestRunner.php";

        $suite  = new PHPUnit_Framework_TestSuite("MilleniumPayrollExportTest");
        $result = PHPUnit_TextUI_TestRunner::run($suite);
    }

    /**
     * Sets up the fixture, for example, open a network connection.
     * This method is called before a test is executed.
     *
     * @access protected
     */
    protected function setUp() {
    	$this->exportObj = new MilleniumPayrollExport();

    	$conf = new Conf();
    	$this->connection = mysql_connect($conf->dbhost.":".$conf->dbport, $conf->dbuser, $conf->dbpass);
        mysql_select_db($conf->dbname);

    	$this->_truncateTables();
    	$sql = "INSERT INTO hs_hr_employee" .
    				"(emp_number,   employee_id, emp_lastname, emp_firstname, emp_middle_name, " .
    				"emp_nick_name, emp_smoker, ethnic_race_code, emp_birthday, nation_code, " .
    				"emp_gender, emp_marital_status, emp_ssn_num, emp_sin_num, emp_other_id, " .
    				"emp_dri_lice_num, emp_dri_lice_exp_date, emp_military_service, emp_status, " .
    				"job_title_code, eeo_cat_code, work_station, " .
    				"emp_street1, emp_street2, city_code, coun_code, provin_code, emp_zipcode, " .
    				"emp_hm_telephone, emp_mobile, emp_work_telephone, emp_work_email, " .
    				"sal_grd_code, joined_date,	emp_oth_email)  VALUES (" .
  					"'10', 'E1921A', 'Karunadasa', 'Kamal', 'K', " .
  					"NULL, NULL, NULL, '1974-11-20', NULL, " .
  					"1, NULL, '987654320', '', '', " .
    				"null, NULL, NULL, 'EST001', " .
    				"NULL, NULL, NULL, " .
    				"'111 Main Street', 'SUITE A29', 'Houston', 'US', 'TX', '77845', " .
    				"'', '', '', NULL, " .
    				"NULL, '1997-12-11', NULL)";

    	if (KeyHandlerOld::keyExists()) {
    		$key = KeyHandlerOld::readKey();
    		$sql = str_replace("'987654320'", "AES_ENCRYPT('987654320', '$key')", $sql);
    	}

    	$this->assertTrue(mysql_query($sql), mysql_error());

    	$sql = "INSERT into hs_hr_emp_us_tax(emp_number, tax_federal_status, tax_federal_exceptions, " .
    			"tax_state, tax_state_status, tax_state_exceptions, tax_unemp_state,tax_work_state) VALUES (" .
    			"10, 'NRA', 2, 'MD', 'NA', 3, 'VA', 'AZ')";
		$this->assertTrue(mysql_query($sql), mysql_error());

    }

    /**
     * Tears down the fixture, for example, close a network connection.
     * This method is called after a test is executed.
     *
     * @access protected
     */
    protected function tearDown() {
    	$this->_truncateTables();
    }

    /**
     * Test getCSVData().
     */
    public function testGetCSVData() {
    	/*$expected = "E1921A,Karunadasa,Kamal,K,111 Main Street,SUITE A29,Houston,TX,77845,M,11/20/1974," .
    			"987654320,A,12-11-1997,CC1,CC2,CC3,CC4,CC5,,WorkState,,," .
    			"Home Phone,Ethnicity,Base Rate,Default Hours,Salary,Pay Frequency,Auto Pay,FITW Status," .
    			"FITW Exemptions,SITW State,SITW Status,SITW Exemptions,SITW Exemptions 2,SUI State," .
    			"Transit,DD1 Account,DD1 Amount,DD1 Amount Code,DD1 Checking,Transit,DD2 Account," .
    			"DD2 Amount,DD2 Amount Code,DD2 Checking";*/

    	$expected = "E1921A,Karunadasa,Kamal,K,111 Main Street,SUITE A29,Houston,TX,77845,M,11/20/1974," .
    			"987654320,A,12-11-1997,CC1,CC2,CC3,CC4,CC5,,'AZ',,," .
    			"Home Phone,Ethnicity,Base Rate,Default Hours,Salary,Pay Frequency,Auto Pay,'NRA'," .
    			"2,'MD','NA',3,,'VA'," .
    			"Transit,DD1 Account,DD1 Amount,DD1 Amount Code,DD1 Checking,Transit,DD2 Account," .
    			"DD2 Amount,DD2 Amount Code,DD2 Checking";

    	$expected = "E1921A,Karunadasa,Kamal,K,111 Main Street,SUITE A29,Houston,TX,77845,M,11/20/1974," .
    			"987654320,A,12/11/1997,,,,,,,AZ,,," .
    			",,,,,,,NRA," .
    			"2,MD,NA,3,,VA," .
    			",,,,,,," .
    			",,\n";

    	/*$expected = "E1921A,Karunadasa,Kamal,K,111 Main Street,SUITE A29,Houston,TX,77845,M,11/20/1974," .
    			"987654320,A,12/11/1997,,,,,,,,,," .
    			",,,,,,,," .
    			",,,,,," .
    			",,,,,,," .
    			",,\n";*/
		$actual = $this->exportObj->getCSVData();
		//echo "ACTUAL=|" . $actual . "|\n";
		//echo "EXPECTED=|" . $expected . "|\n";
    	$this->assertEquals($expected, $actual);

    }

    /**
     * Test getName().
     */
    public function testGetName() {
    	$this->assertEquals("Millenium Payroll Export", $this->exportObj->getName());
    }

    /**
     * Test getHeader().
     */
    public function testGetHeader() {
    	$expectedHeader = "ID,Last Name,First Name,Middle Name,Address 1,Address 2, City,State,Zip,Gender,Birth Date,SSN,Status,Hire Date,CC1,CC2,CC3,CC4,CC5,TaxForm,WorkState,Emp Type,Clock Number,Home Phone,Ethnicity,Base Rate,Default Hours,Salary,Pay Frequency,Auto Pay,FITW Status,FITW Exemptions,SITW State,SITW Status,SITW Exemptions,SITW Exemptions 2,SUI State,Transit,DD1 Account,DD1 Amount,DD1 Amount Code,DD1 Checking,Transit,DD2 Account,DD2 Amount,DD2 Amount Code,DD2 Checking";
    	$this->assertEquals($expectedHeader, $this->exportObj->getHeader());
    }

	/**
	 * Truncates tables used in test.
	 */
    private function _truncateTables() {
        $this->assertTrue(mysql_query("TRUNCATE TABLE `hs_hr_employee`"), mysql_error());
    }
}

// Call MilleniumPayrollExportTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == "MilleniumPayrollExportTest::main") {
    MilleniumPayrollExportTest::main();
}
?>
