<?php
// Call CSVFieldTest::main() if this source file is executed directly.
if (!defined("PHPUnit_MAIN_METHOD")) {
    define("PHPUnit_MAIN_METHOD", "CSVFieldTest::main");
}

require_once "PHPUnit/Framework/TestCase.php";
require_once "PHPUnit/Framework/TestSuite.php";

require_once "testConf.php";

require_once ROOT_PATH . '/lib/common/LocaleUtil.php';
require_once 'CSVField.php';

/**
 * Test class for CSVField.
 * Generated by PHPUnit_Util_Skeleton on 2008-01-09 at 11:51:48.
 */
class CSVFieldTest extends PHPUnit_Framework_TestCase {
    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     */
    public static function main() {
        require_once "PHPUnit/TextUI/TestRunner.php";

        $suite  = new PHPUnit_Framework_TestSuite("CSVFieldTest");
        $result = PHPUnit_TextUI_TestRunner::run($suite);
    }

    /**
     * Sets up the fixture, for example, open a network connection.
     * This method is called before a test is executed.
     *
     * @access protected
     */
    protected function setUp() {
    }

    /**
     * Tears down the fixture, for example, close a network connection.
     * This method is called after a test is executed.
     *
     * @access protected
     */
    protected function tearDown() {
    }

	/** Test constructor */
	public function testConstructor() {

		// frommap type without map - should throw exception
		try {
			$field = new CSVField("xyz", CSVField::FIELD_TYPE_FROMMAP);
			$this->fail("Should throw exception");
		} catch (Exception $e) {
		}

		// other types
		$field = new CSVField("xyz", CSVField::FIELD_TYPE_DIRECT);
		$field = new CSVField("xyz", CSVField::FIELD_TYPE_DATE);
		$field = new CSVField("xyz", CSVField::FIELD_TYPE_DIRECT_DEBIT);
	}

	/** Test escape() method */
	public function testEscape() {

		// no escape needed:
		$this->assertEquals('test value', CSVField::escape('test value'));
		$this->assertEquals('name', CSVField::escape('name'));


		// escape comma
		$this->assertEquals('"name, aaa"', CSVField::escape('name, aaa'));
		$this->assertEquals('",name aaa"', CSVField::escape(',name aaa'));
		$this->assertEquals('"name aaa,"', CSVField::escape('name aaa,'));

		// escape quotes
		$this->assertEquals('"""Hello"""', CSVField::escape('"Hello"'));
		$this->assertEquals('"Hello"" how"', CSVField::escape('Hello" how'));

		// both
		$this->assertEquals('"Hello"", how"', CSVField::escape('Hello", how'));

	}

	/** Test getValueFromMap() function */
	public function testGetValueFromMap() {

		$map = array (
			'xyz' => 'Value 1',
			'abc' => 'V2',
			'def' => 'Value 3',
			't' => 'Xyz'
		);

		// unknown value
		$this->assertEquals("", CSVField::getValueFromMap($map, 'hello'));

		// known values
		$this->assertEquals('Value 1', CSVField::getValueFromMap($map, 'xyz'));
		$this->assertEquals('V2', CSVField::getValueFromMap($map, 'abc'));
		$this->assertEquals('Value 3', CSVField::getValueFromMap($map, 'def'));
		$this->assertEquals('Xyz', CSVField::getValueFromMap($map, 't'));
	}

    /**
     * @todo Implement testGetValue().
     */
    public function testGetValue() {

		// Direct
		$field = new CSVField('name', CSVField::FIELD_TYPE_DIRECT);

		$row = array('id'=> '1', 'name'=>'Ranasinghe', 'age' =>39);
		$ddList = array();
		$this->assertEquals('Ranasinghe', $field->getValue($row, $ddList));

		// invalid (unavailable) name
		$field = new CSVField('middle_name', CSVField::FIELD_TYPE_DIRECT);
		$this->assertEquals('', $field->getValue($row, $ddList));

		// Date
		$field = new CSVField('joined_date', CSVField::FIELD_TYPE_DATE);
		$row = array('id'=> '1', 'name'=>'Ranasinghe', 'joined_date' => '2003-01-20');
		$ddList = array();
		$expected = LocaleUtil::getInstance()->formatDate($row['joined_date']);
		$this->assertEquals($expected, $field->getValue($row, $ddList));

		// invalid (unavailable) name
		$field = new CSVField('birth_date', CSVField::FIELD_TYPE_DATE);
		$this->assertEquals('', $field->getValue($row, $ddList));

		// From Map
		$genderMap = array (1 => "M", 2 => "F");
		$field = new CSVField('sex', CSVField::FIELD_TYPE_FROMMAP, $genderMap);
		$row = array('id'=> '1', 'name'=>'Ranasinghe', 'sex' => 1, 'joined_date' => '2003-01-20');
		$ddList = array();
		$this->assertEquals('M', $field->getValue($row, $ddList));

		// invalid (unavailable) name
		$field = new CSVField('gender', CSVField::FIELD_TYPE_FROMMAP, $genderMap);
		$this->assertEquals('', $field->getValue($row, $ddList));

		// direct debit
		$dd1 = new EmpDirectDebit();
		$dd1->setEmpNumber(1);
		$dd1->setDDSeqNo(1);
		$dd1->setRoutingNumber(121212);
		$dd1->setAccount('An account');
		$dd1->setAmount(100);
		$dd1->setAccountType('CHECKING');
		$dd1->setTransactionType('BLANK');

		$dd2 = new EmpDirectDebit();
		$dd2->setEmpNumber(222);
		$dd2->setDDSeqNo(2);
		$dd2->setRoutingNumber(444444);
		$dd2->setAccount('My Account');
		$dd2->setAmount(200);
		$dd2->setAccountType('SAVINGS');
		$dd2->setTransactionType('PERC');

		$ddList = array($dd1);

		$field = new CSVField('DD1_Amount', CSVField::FIELD_TYPE_DIRECT_DEBIT);
		$this->assertEquals(100, $field->getValue($row, $ddList));

		$field = new CSVField('DD1_Routing', CSVField::FIELD_TYPE_DIRECT_DEBIT);
		$this->assertEquals(121212, $field->getValue($row, $ddList));

		$field = new CSVField('DD1_Account', CSVField::FIELD_TYPE_DIRECT_DEBIT);
		$this->assertEquals('An account', $field->getValue($row, $ddList));

		$field = new CSVField('DD1_AmountCode', CSVField::FIELD_TYPE_DIRECT_DEBIT);
		$this->assertEquals('Blank', $field->getValue($row, $ddList));

		$field = new CSVField('DD1_Checking', CSVField::FIELD_TYPE_DIRECT_DEBIT);
		$this->assertEquals('Y', $field->getValue($row, $ddList));

		// Second direct debit settings
		$ddList = array($dd1, $dd2);
		$field = new CSVField('DD2_Checking', CSVField::FIELD_TYPE_DIRECT_DEBIT);
		$this->assertEquals('', $field->getValue($row, $ddList));

		$field = new CSVField('DD2_AmountCode', CSVField::FIELD_TYPE_DIRECT_DEBIT);
		$this->assertEquals('%', $field->getValue($row, $ddList));

		// invalid (unavailable) name
		$field = new CSVField('DD1_AAAmount', CSVField::FIELD_TYPE_DIRECT_DEBIT);
		try {
			$field->getValue($row, $ddList);
			$this->fail("Exception expected");
		} catch (Exception $e) {
		}
    }
}

// Call CSVFieldTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == "CSVFieldTest::main") {
    CSVFieldTest::main();
}
?>
