/*******************************************************************************
* Copyright (C) 2003-2004 Vintela, Inc All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of source code must retain the above copyright notice,
*    this list of conditions and the following disclaimer.
*
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this list of conditions and the following disclaimer in the documentation
*    and/or other materials provided with the distribution.
*
*  - Neither the name of Vintela, Inc nor the names of its
*    contributors may be used to endorse or promote products derived from this
*    software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL Vintela, Inc OR THE CONTRIBUTORS
* BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

// Do NOT modify this file.  It was generated by OW_GenCaseFoldingCompare.cpp
// If this file needs to be modified, change the generator and regenerate it.
#include "OW_config.h"
#include "OW_UTF8Utils.hpp"

namespace OW_NAMESPACE
{
namespace UTF8Utils
{

/////////////////////////////////////////////////////////////////////////////
int compareToIgnoreCase(const char* cstr1, const char* cstr2)
{
	const unsigned char* str1 = reinterpret_cast<const unsigned char*>(cstr1);
	const unsigned char* str2 = reinterpret_cast<const unsigned char*>(cstr2);
	const unsigned char* str1marker = 0;
	const unsigned char* str2marker = 0;
	goto state0;
no_match:
	if (str1marker) {
		str1 = str1marker; str1marker = 0;
		str2 = str2marker; str2marker = 0;
		goto state0;
	}
	return *(str1-1) - *(str2-1);
zero:
	return 0 - *str2;
state0:
	switch (*(str1++)){
		case 0x0: goto zero;
		case 0x1: goto state1;
		case 0x2: goto state3;
		case 0x3: goto state4;
		case 0x4: goto state5;
		case 0x5: goto state6;
		case 0x6: goto state7;
		case 0x7: goto state8;
		case 0x8: goto state9;
		case 0x9: goto statea;
		case 0xa: goto stateb;
		case 0xb: goto statec;
		case 0xc: goto stated;
		case 0xd: goto statee;
		case 0xe: goto statef;
		case 0xf: goto state10;
		case 0x10: goto state11;
		case 0x11: goto state12;
		case 0x12: goto state13;
		case 0x13: goto state14;
		case 0x14: goto state15;
		case 0x15: goto state16;
		case 0x16: goto state17;
		case 0x17: goto state18;
		case 0x18: goto state19;
		case 0x19: goto state1a;
		case 0x1a: goto state1b;
		case 0x1b: goto state1c;
		case 0x1c: goto state1d;
		case 0x1d: goto state1e;
		case 0x1e: goto state1f;
		case 0x1f: goto state20;
		case 0x20: goto state21;
		case 0x21: goto state22;
		case 0x22: goto state23;
		case 0x23: goto state24;
		case 0x24: goto state25;
		case 0x25: goto state26;
		case 0x26: goto state27;
		case 0x27: goto state28;
		case 0x28: goto state29;
		case 0x29: goto state2a;
		case 0x2a: goto state2b;
		case 0x2b: goto state2c;
		case 0x2c: goto state2d;
		case 0x2d: goto state2e;
		case 0x2e: goto state2f;
		case 0x2f: goto state30;
		case 0x30: goto state31;
		case 0x31: goto state32;
		case 0x32: goto state33;
		case 0x33: goto state34;
		case 0x34: goto state35;
		case 0x35: goto state36;
		case 0x36: goto state37;
		case 0x37: goto state38;
		case 0x38: goto state39;
		case 0x39: goto state3a;
		case 0x3a: goto state3b;
		case 0x3b: goto state3c;
		case 0x3c: goto state3d;
		case 0x3d: goto state3e;
		case 0x3e: goto state3f;
		case 0x3f: goto state40;
		case 0x40: goto state41;
		case 0x41: goto state42;
		case 0x42: goto state43;
		case 0x43: goto state44;
		case 0x44: goto state45;
		case 0x45: goto state46;
		case 0x46: goto state47;
		case 0x47: goto state48;
		case 0x48: goto state49;
		case 0x49: goto state4a;
		case 0x4a: goto state4b;
		case 0x4b: goto state4c;
		case 0x4c: goto state4d;
		case 0x4d: goto state4e;
		case 0x4e: goto state4f;
		case 0x4f: goto state50;
		case 0x50: goto state51;
		case 0x51: goto state52;
		case 0x52: goto state53;
		case 0x53: goto state54;
		case 0x54: goto state55;
		case 0x55: goto state56;
		case 0x56: goto state57;
		case 0x57: goto state58;
		case 0x58: goto state59;
		case 0x59: goto state5a;
		case 0x5a: goto state5b;
		case 0x5b: goto state5c;
		case 0x5c: goto state5d;
		case 0x5d: goto state5e;
		case 0x5e: goto state5f;
		case 0x5f: goto state60;
		case 0x60: goto state61;
		case 0x61: goto state62;
		case 0x62: goto state43;
		case 0x63: goto state44;
		case 0x64: goto state45;
		case 0x65: goto state46;
		case 0x66: goto state63;
		case 0x67: goto state48;
		case 0x68: goto state64;
		case 0x69: goto state65;
		case 0x6a: goto state66;
		case 0x6b: goto state67;
		case 0x6c: goto state4d;
		case 0x6d: goto state4e;
		case 0x6e: goto state4f;
		case 0x6f: goto state50;
		case 0x70: goto state51;
		case 0x71: goto state52;
		case 0x72: goto state53;
		case 0x73: goto state68;
		case 0x74: goto state69;
		case 0x75: goto state56;
		case 0x76: goto state57;
		case 0x77: goto state6a;
		case 0x78: goto state59;
		case 0x79: goto state6b;
		case 0x7a: goto state5b;
		case 0x7b: goto state6c;
		case 0x7c: goto state6d;
		case 0x7d: goto state6e;
		case 0x7e: goto state6f;
		case 0x7f: goto state70;
		case 0x80: goto state71;
		case 0x81: goto state72;
		case 0x82: goto state73;
		case 0x83: goto state74;
		case 0x84: goto state75;
		case 0x85: goto state76;
		case 0x86: goto state77;
		case 0x87: goto state78;
		case 0x88: goto state79;
		case 0x89: goto state7a;
		case 0x8a: goto state7b;
		case 0x8b: goto state7c;
		case 0x8c: goto state7d;
		case 0x8d: goto state7e;
		case 0x8e: goto state7f;
		case 0x8f: goto state80;
		case 0x90: goto state81;
		case 0x91: goto state82;
		case 0x92: goto state83;
		case 0x93: goto state84;
		case 0x94: goto state85;
		case 0x95: goto state86;
		case 0x96: goto state87;
		case 0x97: goto state88;
		case 0x98: goto state89;
		case 0x99: goto state8a;
		case 0x9a: goto state8b;
		case 0x9b: goto state8c;
		case 0x9c: goto state8d;
		case 0x9d: goto state8e;
		case 0x9e: goto state8f;
		case 0x9f: goto state90;
		case 0xa0: goto state91;
		case 0xa1: goto state92;
		case 0xa2: goto state93;
		case 0xa3: goto state94;
		case 0xa4: goto state95;
		case 0xa5: goto state96;
		case 0xa6: goto state97;
		case 0xa7: goto state98;
		case 0xa8: goto state99;
		case 0xa9: goto state9a;
		case 0xaa: goto state9b;
		case 0xab: goto state9c;
		case 0xac: goto state9d;
		case 0xad: goto state9e;
		case 0xae: goto state9f;
		case 0xaf: goto statea0;
		case 0xb0: goto statea1;
		case 0xb1: goto statea2;
		case 0xb2: goto statea3;
		case 0xb3: goto statea4;
		case 0xb4: goto statea5;
		case 0xb5: goto statea6;
		case 0xb6: goto statea7;
		case 0xb7: goto statea8;
		case 0xb8: goto statea9;
		case 0xb9: goto stateaa;
		case 0xba: goto stateab;
		case 0xbb: goto stateac;
		case 0xbc: goto statead;
		case 0xbd: goto stateae;
		case 0xbe: goto stateaf;
		case 0xbf: goto stateb0;
		case 0xc0: goto stateb1;
		case 0xc1: goto stateb2;
		case 0xc2: goto stateb3;
		case 0xc3: goto stateb4;
		case 0xc4: goto stateb6;
		case 0xc5: goto stateb8;
		case 0xc6: goto stateba;
		case 0xc7: goto statebc;
		case 0xc8: goto statebe;
		case 0xc9: goto statec0;
		case 0xca: goto statec1;
		case 0xcb: goto statec2;
		case 0xcc: goto statec3;
		case 0xcd: goto statec4;
		case 0xce: goto statec5;
		case 0xcf: goto statec7;
		case 0xd0: goto statec9;
		case 0xd1: goto statecb;
		case 0xd2: goto statecd;
		case 0xd3: goto statecf;
		case 0xd4: goto stated1;
		case 0xd5: goto stated3;
		case 0xd6: goto stated5;
		case 0xd7: goto stated6;
		case 0xd8: goto stated7;
		case 0xd9: goto stated8;
		case 0xda: goto stated9;
		case 0xdb: goto stateda;
		case 0xdc: goto statedb;
		case 0xdd: goto statedc;
		case 0xde: goto statedd;
		case 0xdf: goto statede;
		case 0xe0: goto statedf;
		case 0xe1: goto statee0;
		case 0xe2: goto statee2;
		case 0xe3: goto statee4;
		case 0xe4: goto statee5;
		case 0xe5: goto statee6;
		case 0xe6: goto statee7;
		case 0xe7: goto statee8;
		case 0xe8: goto statee9;
		case 0xe9: goto stateea;
		case 0xea: goto stateeb;
		case 0xeb: goto stateec;
		case 0xec: goto stateed;
		case 0xed: goto stateee;
		case 0xee: goto stateef;
		case 0xef: goto statef0;
		case 0xf0: goto statef2;
		case 0xf1: goto statef4;
		case 0xf2: goto statef5;
		case 0xf3: goto statef6;
		case 0xf4: goto statef7;
		case 0xf5: goto statef8;
		case 0xf6: goto statef9;
		case 0xf7: goto statefa;
		case 0xf8: goto statefb;
		case 0xf9: goto statefc;
		case 0xfa: goto statefd;
		case 0xfb: goto statefe;
		case 0xfc: goto stateff;
		case 0xfd: goto state100;
		case 0xfe: goto state101;
		case 0xff: goto state102;
		default: goto no_match;
	}
state1:
	switch (*(str2++)){
		case 0x1: goto state2;
		default: goto no_match;
	}
state2:
	goto state0;
state3:
	switch (*(str2++)){
		case 0x2: goto state2;
		default: goto no_match;
	}
state4:
	switch (*(str2++)){
		case 0x3: goto state2;
		default: goto no_match;
	}
state5:
	switch (*(str2++)){
		case 0x4: goto state2;
		default: goto no_match;
	}
state6:
	switch (*(str2++)){
		case 0x5: goto state2;
		default: goto no_match;
	}
state7:
	switch (*(str2++)){
		case 0x6: goto state2;
		default: goto no_match;
	}
state8:
	switch (*(str2++)){
		case 0x7: goto state2;
		default: goto no_match;
	}
state9:
	switch (*(str2++)){
		case 0x8: goto state2;
		default: goto no_match;
	}
statea:
	switch (*(str2++)){
		case 0x9: goto state2;
		default: goto no_match;
	}
stateb:
	switch (*(str2++)){
		case 0xa: goto state2;
		default: goto no_match;
	}
statec:
	switch (*(str2++)){
		case 0xb: goto state2;
		default: goto no_match;
	}
stated:
	switch (*(str2++)){
		case 0xc: goto state2;
		default: goto no_match;
	}
statee:
	switch (*(str2++)){
		case 0xd: goto state2;
		default: goto no_match;
	}
statef:
	switch (*(str2++)){
		case 0xe: goto state2;
		default: goto no_match;
	}
state10:
	switch (*(str2++)){
		case 0xf: goto state2;
		default: goto no_match;
	}
state11:
	switch (*(str2++)){
		case 0x10: goto state2;
		default: goto no_match;
	}
state12:
	switch (*(str2++)){
		case 0x11: goto state2;
		default: goto no_match;
	}
state13:
	switch (*(str2++)){
		case 0x12: goto state2;
		default: goto no_match;
	}
state14:
	switch (*(str2++)){
		case 0x13: goto state2;
		default: goto no_match;
	}
state15:
	switch (*(str2++)){
		case 0x14: goto state2;
		default: goto no_match;
	}
state16:
	switch (*(str2++)){
		case 0x15: goto state2;
		default: goto no_match;
	}
state17:
	switch (*(str2++)){
		case 0x16: goto state2;
		default: goto no_match;
	}
state18:
	switch (*(str2++)){
		case 0x17: goto state2;
		default: goto no_match;
	}
state19:
	switch (*(str2++)){
		case 0x18: goto state2;
		default: goto no_match;
	}
state1a:
	switch (*(str2++)){
		case 0x19: goto state2;
		default: goto no_match;
	}
state1b:
	switch (*(str2++)){
		case 0x1a: goto state2;
		default: goto no_match;
	}
state1c:
	switch (*(str2++)){
		case 0x1b: goto state2;
		default: goto no_match;
	}
state1d:
	switch (*(str2++)){
		case 0x1c: goto state2;
		default: goto no_match;
	}
state1e:
	switch (*(str2++)){
		case 0x1d: goto state2;
		default: goto no_match;
	}
state1f:
	switch (*(str2++)){
		case 0x1e: goto state2;
		default: goto no_match;
	}
state20:
	switch (*(str2++)){
		case 0x1f: goto state2;
		default: goto no_match;
	}
state21:
	switch (*(str2++)){
		case 0x20: goto state2;
		default: goto no_match;
	}
state22:
	switch (*(str2++)){
		case 0x21: goto state2;
		default: goto no_match;
	}
state23:
	switch (*(str2++)){
		case 0x22: goto state2;
		default: goto no_match;
	}
state24:
	switch (*(str2++)){
		case 0x23: goto state2;
		default: goto no_match;
	}
state25:
	switch (*(str2++)){
		case 0x24: goto state2;
		default: goto no_match;
	}
state26:
	switch (*(str2++)){
		case 0x25: goto state2;
		default: goto no_match;
	}
state27:
	switch (*(str2++)){
		case 0x26: goto state2;
		default: goto no_match;
	}
state28:
	switch (*(str2++)){
		case 0x27: goto state2;
		default: goto no_match;
	}
state29:
	switch (*(str2++)){
		case 0x28: goto state2;
		default: goto no_match;
	}
state2a:
	switch (*(str2++)){
		case 0x29: goto state2;
		default: goto no_match;
	}
state2b:
	switch (*(str2++)){
		case 0x2a: goto state2;
		default: goto no_match;
	}
state2c:
	switch (*(str2++)){
		case 0x2b: goto state2;
		default: goto no_match;
	}
state2d:
	switch (*(str2++)){
		case 0x2c: goto state2;
		default: goto no_match;
	}
state2e:
	switch (*(str2++)){
		case 0x2d: goto state2;
		default: goto no_match;
	}
state2f:
	switch (*(str2++)){
		case 0x2e: goto state2;
		default: goto no_match;
	}
state30:
	switch (*(str2++)){
		case 0x2f: goto state2;
		default: goto no_match;
	}
state31:
	switch (*(str2++)){
		case 0x30: goto state2;
		default: goto no_match;
	}
state32:
	switch (*(str2++)){
		case 0x31: goto state2;
		default: goto no_match;
	}
state33:
	switch (*(str2++)){
		case 0x32: goto state2;
		default: goto no_match;
	}
state34:
	switch (*(str2++)){
		case 0x33: goto state2;
		default: goto no_match;
	}
state35:
	switch (*(str2++)){
		case 0x34: goto state2;
		default: goto no_match;
	}
state36:
	switch (*(str2++)){
		case 0x35: goto state2;
		default: goto no_match;
	}
state37:
	switch (*(str2++)){
		case 0x36: goto state2;
		default: goto no_match;
	}
state38:
	switch (*(str2++)){
		case 0x37: goto state2;
		default: goto no_match;
	}
state39:
	switch (*(str2++)){
		case 0x38: goto state2;
		default: goto no_match;
	}
state3a:
	switch (*(str2++)){
		case 0x39: goto state2;
		default: goto no_match;
	}
state3b:
	switch (*(str2++)){
		case 0x3a: goto state2;
		default: goto no_match;
	}
state3c:
	switch (*(str2++)){
		case 0x3b: goto state2;
		default: goto no_match;
	}
state3d:
	switch (*(str2++)){
		case 0x3c: goto state2;
		default: goto no_match;
	}
state3e:
	switch (*(str2++)){
		case 0x3d: goto state2;
		default: goto no_match;
	}
state3f:
	switch (*(str2++)){
		case 0x3e: goto state2;
		default: goto no_match;
	}
state40:
	switch (*(str2++)){
		case 0x3f: goto state2;
		default: goto no_match;
	}
state41:
	switch (*(str2++)){
		case 0x40: goto state2;
		default: goto no_match;
	}
state42:
	switch (*(str2++)){
		case 0x41: goto state2;
		case 0x61: goto state2;
		default: goto no_match;
	}
state43:
	switch (*(str2++)){
		case 0x42: goto state2;
		case 0x62: goto state2;
		default: goto no_match;
	}
state44:
	switch (*(str2++)){
		case 0x43: goto state2;
		case 0x63: goto state2;
		default: goto no_match;
	}
state45:
	switch (*(str2++)){
		case 0x44: goto state2;
		case 0x64: goto state2;
		default: goto no_match;
	}
state46:
	switch (*(str2++)){
		case 0x45: goto state2;
		case 0x65: goto state2;
		default: goto no_match;
	}
state47:
	switch (*(str2++)){
		case 0x46: goto state2;
		case 0x66: goto state2;
		default: goto no_match;
	}
state48:
	switch (*(str2++)){
		case 0x47: goto state2;
		case 0x67: goto state2;
		default: goto no_match;
	}
state49:
	switch (*(str2++)){
		case 0x48: goto state2;
		case 0x68: goto state2;
		default: goto no_match;
	}
state4a:
	switch (*(str2++)){
		case 0x49: goto state2;
		case 0x69: goto state2;
		case 0xc4: goto statea2;
		default: goto no_match;
	}
state4b:
	switch (*(str2++)){
		case 0x4a: goto state2;
		case 0x6a: goto state2;
		default: goto no_match;
	}
state4c:
	switch (*(str2++)){
		case 0x4b: goto state2;
		case 0x6b: goto state2;
		default: goto no_match;
	}
state4d:
	switch (*(str2++)){
		case 0x4c: goto state2;
		case 0x6c: goto state2;
		default: goto no_match;
	}
state4e:
	switch (*(str2++)){
		case 0x4d: goto state2;
		case 0x6d: goto state2;
		default: goto no_match;
	}
state4f:
	switch (*(str2++)){
		case 0x4e: goto state2;
		case 0x6e: goto state2;
		default: goto no_match;
	}
state50:
	switch (*(str2++)){
		case 0x4f: goto state2;
		case 0x6f: goto state2;
		default: goto no_match;
	}
state51:
	switch (*(str2++)){
		case 0x50: goto state2;
		case 0x70: goto state2;
		default: goto no_match;
	}
state52:
	switch (*(str2++)){
		case 0x51: goto state2;
		case 0x71: goto state2;
		default: goto no_match;
	}
state53:
	switch (*(str2++)){
		case 0x52: goto state2;
		case 0x72: goto state2;
		default: goto no_match;
	}
state54:
	switch (*(str2++)){
		case 0x53: goto state2;
		case 0x73: goto state2;
		default: goto no_match;
	}
state55:
	switch (*(str2++)){
		case 0x54: goto state2;
		case 0x74: goto state2;
		default: goto no_match;
	}
state56:
	switch (*(str2++)){
		case 0x55: goto state2;
		case 0x75: goto state2;
		default: goto no_match;
	}
state57:
	switch (*(str2++)){
		case 0x56: goto state2;
		case 0x76: goto state2;
		default: goto no_match;
	}
state58:
	switch (*(str2++)){
		case 0x57: goto state2;
		case 0x77: goto state2;
		default: goto no_match;
	}
state59:
	switch (*(str2++)){
		case 0x58: goto state2;
		case 0x78: goto state2;
		default: goto no_match;
	}
state5a:
	switch (*(str2++)){
		case 0x59: goto state2;
		case 0x79: goto state2;
		default: goto no_match;
	}
state5b:
	switch (*(str2++)){
		case 0x5a: goto state2;
		case 0x7a: goto state2;
		default: goto no_match;
	}
state5c:
	switch (*(str2++)){
		case 0x5b: goto state2;
		default: goto no_match;
	}
state5d:
	switch (*(str2++)){
		case 0x5c: goto state2;
		default: goto no_match;
	}
state5e:
	switch (*(str2++)){
		case 0x5d: goto state2;
		default: goto no_match;
	}
state5f:
	switch (*(str2++)){
		case 0x5e: goto state2;
		default: goto no_match;
	}
state60:
	switch (*(str2++)){
		case 0x5f: goto state2;
		default: goto no_match;
	}
state61:
	switch (*(str2++)){
		case 0x60: goto state2;
		default: goto no_match;
	}
state62:
	switch (*(str2++)){
		case 0x41: goto state2;
		case 0x61: goto state2;
		case 0xe1: goto state165;
		default: goto no_match;
	}
state63:
	switch (*(str2++)){
		case 0x46: goto state2;
		case 0x66: goto state2;
		case 0xef: goto state207;
		default: goto no_match;
	}
state64:
	switch (*(str2++)){
		case 0x48: goto state2;
		case 0x68: goto state2;
		case 0xe1: goto state14d;
		default: goto no_match;
	}
state65:
	switch (*(str2++)){
		case 0x49: goto state2;
		case 0x69: goto state2;
		case 0xc4: goto state10b;
		default: goto no_match;
	}
state66:
	switch (*(str2++)){
		case 0x4a: goto state2;
		case 0x6a: goto state2;
		case 0xc7: goto state124;
		default: goto no_match;
	}
state67:
	switch (*(str2++)){
		case 0x4b: goto state2;
		case 0x6b: goto state2;
		case 0xe2: goto state1f7;
		default: goto no_match;
	}
state68:
	switch (*(str2++)){
		case 0x53: goto state2;
		case 0x73: goto state2;
		case 0xc3: goto state108;
		case 0xc5: goto stateb0;
		case 0xef: goto state211;
		default: goto no_match;
	}
state69:
	switch (*(str2++)){
		case 0x54: goto state2;
		case 0x74: goto state2;
		case 0xe1: goto state153;
		default: goto no_match;
	}
state6a:
	switch (*(str2++)){
		case 0x57: goto state2;
		case 0x77: goto state2;
		case 0xe1: goto state159;
		default: goto no_match;
	}
state6b:
	switch (*(str2++)){
		case 0x59: goto state2;
		case 0x79: goto state2;
		case 0xe1: goto state15f;
		default: goto no_match;
	}
state6c:
	switch (*(str2++)){
		case 0x7b: goto state2;
		default: goto no_match;
	}
state6d:
	switch (*(str2++)){
		case 0x7c: goto state2;
		default: goto no_match;
	}
state6e:
	switch (*(str2++)){
		case 0x7d: goto state2;
		default: goto no_match;
	}
state6f:
	switch (*(str2++)){
		case 0x7e: goto state2;
		default: goto no_match;
	}
state70:
	switch (*(str2++)){
		case 0x7f: goto state2;
		default: goto no_match;
	}
state71:
	switch (*(str2++)){
		case 0x80: goto state2;
		default: goto no_match;
	}
state72:
	switch (*(str2++)){
		case 0x81: goto state2;
		default: goto no_match;
	}
state73:
	switch (*(str2++)){
		case 0x82: goto state2;
		default: goto no_match;
	}
state74:
	switch (*(str2++)){
		case 0x83: goto state2;
		default: goto no_match;
	}
state75:
	switch (*(str2++)){
		case 0x84: goto state2;
		default: goto no_match;
	}
state76:
	switch (*(str2++)){
		case 0x85: goto state2;
		default: goto no_match;
	}
state77:
	switch (*(str2++)){
		case 0x86: goto state2;
		default: goto no_match;
	}
state78:
	switch (*(str2++)){
		case 0x87: goto state2;
		default: goto no_match;
	}
state79:
	switch (*(str2++)){
		case 0x88: goto state2;
		default: goto no_match;
	}
state7a:
	switch (*(str2++)){
		case 0x89: goto state2;
		default: goto no_match;
	}
state7b:
	switch (*(str2++)){
		case 0x8a: goto state2;
		default: goto no_match;
	}
state7c:
	switch (*(str2++)){
		case 0x8b: goto state2;
		default: goto no_match;
	}
state7d:
	switch (*(str2++)){
		case 0x8c: goto state2;
		default: goto no_match;
	}
state7e:
	switch (*(str2++)){
		case 0x8d: goto state2;
		default: goto no_match;
	}
state7f:
	switch (*(str2++)){
		case 0x8e: goto state2;
		default: goto no_match;
	}
state80:
	switch (*(str2++)){
		case 0x8f: goto state2;
		default: goto no_match;
	}
state81:
	switch (*(str2++)){
		case 0x90: goto state2;
		default: goto no_match;
	}
state82:
	switch (*(str2++)){
		case 0x91: goto state2;
		default: goto no_match;
	}
state83:
	switch (*(str2++)){
		case 0x92: goto state2;
		default: goto no_match;
	}
state84:
	switch (*(str2++)){
		case 0x93: goto state2;
		default: goto no_match;
	}
state85:
	switch (*(str2++)){
		case 0x94: goto state2;
		default: goto no_match;
	}
state86:
	switch (*(str2++)){
		case 0x95: goto state2;
		default: goto no_match;
	}
state87:
	switch (*(str2++)){
		case 0x96: goto state2;
		default: goto no_match;
	}
state88:
	switch (*(str2++)){
		case 0x97: goto state2;
		default: goto no_match;
	}
state89:
	switch (*(str2++)){
		case 0x98: goto state2;
		default: goto no_match;
	}
state8a:
	switch (*(str2++)){
		case 0x99: goto state2;
		default: goto no_match;
	}
state8b:
	switch (*(str2++)){
		case 0x9a: goto state2;
		default: goto no_match;
	}
state8c:
	switch (*(str2++)){
		case 0x9b: goto state2;
		default: goto no_match;
	}
state8d:
	switch (*(str2++)){
		case 0x9c: goto state2;
		default: goto no_match;
	}
state8e:
	switch (*(str2++)){
		case 0x9d: goto state2;
		default: goto no_match;
	}
state8f:
	switch (*(str2++)){
		case 0x9e: goto state2;
		default: goto no_match;
	}
state90:
	switch (*(str2++)){
		case 0x9f: goto state2;
		default: goto no_match;
	}
state91:
	switch (*(str2++)){
		case 0xa0: goto state2;
		default: goto no_match;
	}
state92:
	switch (*(str2++)){
		case 0xa1: goto state2;
		default: goto no_match;
	}
state93:
	switch (*(str2++)){
		case 0xa2: goto state2;
		default: goto no_match;
	}
state94:
	switch (*(str2++)){
		case 0xa3: goto state2;
		default: goto no_match;
	}
state95:
	switch (*(str2++)){
		case 0xa4: goto state2;
		default: goto no_match;
	}
state96:
	switch (*(str2++)){
		case 0xa5: goto state2;
		default: goto no_match;
	}
state97:
	switch (*(str2++)){
		case 0xa6: goto state2;
		default: goto no_match;
	}
state98:
	switch (*(str2++)){
		case 0xa7: goto state2;
		default: goto no_match;
	}
state99:
	switch (*(str2++)){
		case 0xa8: goto state2;
		default: goto no_match;
	}
state9a:
	switch (*(str2++)){
		case 0xa9: goto state2;
		default: goto no_match;
	}
state9b:
	switch (*(str2++)){
		case 0xaa: goto state2;
		default: goto no_match;
	}
state9c:
	switch (*(str2++)){
		case 0xab: goto state2;
		default: goto no_match;
	}
state9d:
	switch (*(str2++)){
		case 0xac: goto state2;
		default: goto no_match;
	}
state9e:
	switch (*(str2++)){
		case 0xad: goto state2;
		default: goto no_match;
	}
state9f:
	switch (*(str2++)){
		case 0xae: goto state2;
		default: goto no_match;
	}
statea0:
	switch (*(str2++)){
		case 0xaf: goto state2;
		default: goto no_match;
	}
statea1:
	switch (*(str2++)){
		case 0xb0: goto state2;
		default: goto no_match;
	}
statea2:
	switch (*(str2++)){
		case 0xb1: goto state2;
		default: goto no_match;
	}
statea3:
	switch (*(str2++)){
		case 0xb2: goto state2;
		default: goto no_match;
	}
statea4:
	switch (*(str2++)){
		case 0xb3: goto state2;
		default: goto no_match;
	}
statea5:
	switch (*(str2++)){
		case 0xb4: goto state2;
		default: goto no_match;
	}
statea6:
	switch (*(str2++)){
		case 0xb5: goto state2;
		default: goto no_match;
	}
statea7:
	switch (*(str2++)){
		case 0xb6: goto state2;
		default: goto no_match;
	}
statea8:
	switch (*(str2++)){
		case 0xb7: goto state2;
		default: goto no_match;
	}
statea9:
	switch (*(str2++)){
		case 0xb8: goto state2;
		default: goto no_match;
	}
stateaa:
	switch (*(str2++)){
		case 0xb9: goto state2;
		default: goto no_match;
	}
stateab:
	switch (*(str2++)){
		case 0xba: goto state2;
		default: goto no_match;
	}
stateac:
	switch (*(str2++)){
		case 0xbb: goto state2;
		default: goto no_match;
	}
statead:
	switch (*(str2++)){
		case 0xbc: goto state2;
		default: goto no_match;
	}
stateae:
	switch (*(str2++)){
		case 0xbd: goto state2;
		default: goto no_match;
	}
stateaf:
	switch (*(str2++)){
		case 0xbe: goto state2;
		default: goto no_match;
	}
stateb0:
	switch (*(str2++)){
		case 0xbf: goto state2;
		default: goto no_match;
	}
stateb1:
	switch (*(str2++)){
		case 0xc0: goto state2;
		default: goto no_match;
	}
stateb2:
	switch (*(str2++)){
		case 0xc1: goto state2;
		default: goto no_match;
	}
stateb3:
	switch (*(str2++)){
		case 0xc2: goto state2;
		case 0xce: goto state104;
		default: goto no_match;
	}
stateb4:
	switch (*(str2++)){
		case 0x73: goto state106;
		case 0xc3: goto stateb5;
		case 0xc5: goto state117;
		case 0xe2: goto state1fb;
		default: goto no_match;
	}
stateb5:
	str1marker = str1;
	str2marker = str2;
	switch (*(str1++)){
		case 0x80: goto state91;
		case 0x81: goto state92;
		case 0x82: goto state93;
		case 0x83: goto state94;
		case 0x84: goto state95;
		case 0x85: goto state96;
		case 0x86: goto state97;
		case 0x87: goto state98;
		case 0x88: goto state99;
		case 0x89: goto state9a;
		case 0x8a: goto state9b;
		case 0x8b: goto state9c;
		case 0x8c: goto state9d;
		case 0x8d: goto state9e;
		case 0x8e: goto state9f;
		case 0x8f: goto statea0;
		case 0x90: goto statea1;
		case 0x91: goto statea2;
		case 0x92: goto statea3;
		case 0x93: goto statea4;
		case 0x94: goto statea5;
		case 0x95: goto statea6;
		case 0x96: goto statea7;
		case 0x98: goto statea9;
		case 0x99: goto stateaa;
		case 0x9a: goto stateab;
		case 0x9b: goto stateac;
		case 0x9c: goto statead;
		case 0x9d: goto stateae;
		case 0x9e: goto stateaf;
		case 0xa0: goto state71;
		case 0xa1: goto state72;
		case 0xa2: goto state73;
		case 0xa3: goto state74;
		case 0xa4: goto state75;
		case 0xa5: goto state76;
		case 0xa6: goto state77;
		case 0xa7: goto state78;
		case 0xa8: goto state79;
		case 0xa9: goto state7a;
		case 0xaa: goto state7b;
		case 0xab: goto state7c;
		case 0xac: goto state7d;
		case 0xad: goto state7e;
		case 0xae: goto state7f;
		case 0xaf: goto state80;
		case 0xb0: goto state81;
		case 0xb1: goto state82;
		case 0xb2: goto state83;
		case 0xb3: goto state84;
		case 0xb4: goto state85;
		case 0xb5: goto state86;
		case 0xb6: goto state87;
		case 0xb8: goto state89;
		case 0xb9: goto state8a;
		case 0xba: goto state8b;
		case 0xbb: goto state8c;
		case 0xbc: goto state8d;
		case 0xbd: goto state8e;
		case 0xbe: goto state8f;
		default: goto no_match;
	}
stateb6:
	switch (*(str2++)){
		case 0x49: goto state103;
		case 0x69: goto state109;
		case 0xc4: goto stateb7;
		case 0xc5: goto state10e;
		default: goto no_match;
	}
stateb7:
	str1marker = str1;
	str2marker = str2;
	switch (*(str1++)){
		case 0x80: goto state72;
		case 0x81: goto state71;
		case 0x82: goto state74;
		case 0x83: goto state73;
		case 0x84: goto state76;
		case 0x85: goto state75;
		case 0x86: goto state78;
		case 0x87: goto state77;
		case 0x88: goto state7a;
		case 0x89: goto state79;
		case 0x8a: goto state7c;
		case 0x8b: goto state7b;
		case 0x8c: goto state7e;
		case 0x8d: goto state7d;
		case 0x8e: goto state80;
		case 0x8f: goto state7f;
		case 0x90: goto state82;
		case 0x91: goto state81;
		case 0x92: goto state84;
		case 0x93: goto state83;
		case 0x94: goto state86;
		case 0x95: goto state85;
		case 0x96: goto state88;
		case 0x97: goto state87;
		case 0x98: goto state8a;
		case 0x99: goto state89;
		case 0x9a: goto state8c;
		case 0x9b: goto state8b;
		case 0x9c: goto state8e;
		case 0x9d: goto state8d;
		case 0x9e: goto state90;
		case 0x9f: goto state8f;
		case 0xa0: goto state92;
		case 0xa1: goto state91;
		case 0xa2: goto state94;
		case 0xa3: goto state93;
		case 0xa4: goto state96;
		case 0xa5: goto state95;
		case 0xa6: goto state98;
		case 0xa7: goto state97;
		case 0xa8: goto state9a;
		case 0xa9: goto state99;
		case 0xaa: goto state9c;
		case 0xab: goto state9b;
		case 0xac: goto state9e;
		case 0xad: goto state9d;
		case 0xae: goto statea0;
		case 0xaf: goto state9f;
		case 0xb2: goto statea4;
		case 0xb3: goto statea3;
		case 0xb4: goto statea6;
		case 0xb5: goto statea5;
		case 0xb6: goto statea8;
		case 0xb7: goto statea7;
		case 0xb9: goto stateab;
		case 0xba: goto stateaa;
		case 0xbb: goto statead;
		case 0xbc: goto stateac;
		case 0xbd: goto stateaf;
		case 0xbe: goto stateae;
		default: goto no_match;
	}
stateb8:
	switch (*(str2++)){
		case 0x73: goto state118;
		case 0xc3: goto state116;
		case 0xc4: goto state10f;
		case 0xc5: goto stateb9;
		case 0xca: goto state110;
		default: goto no_match;
	}
stateb9:
	str1marker = str1;
	str2marker = str2;
	switch (*(str1++)){
		case 0x81: goto state73;
		case 0x82: goto state72;
		case 0x83: goto state75;
		case 0x84: goto state74;
		case 0x85: goto state77;
		case 0x86: goto state76;
		case 0x87: goto state79;
		case 0x88: goto state78;
		case 0x8a: goto state7c;
		case 0x8b: goto state7b;
		case 0x8c: goto state7e;
		case 0x8d: goto state7d;
		case 0x8e: goto state80;
		case 0x8f: goto state7f;
		case 0x90: goto state82;
		case 0x91: goto state81;
		case 0x92: goto state84;
		case 0x93: goto state83;
		case 0x94: goto state86;
		case 0x95: goto state85;
		case 0x96: goto state88;
		case 0x97: goto state87;
		case 0x98: goto state8a;
		case 0x99: goto state89;
		case 0x9a: goto state8c;
		case 0x9b: goto state8b;
		case 0x9c: goto state8e;
		case 0x9d: goto state8d;
		case 0x9e: goto state90;
		case 0x9f: goto state8f;
		case 0xa0: goto state92;
		case 0xa1: goto state91;
		case 0xa2: goto state94;
		case 0xa3: goto state93;
		case 0xa4: goto state96;
		case 0xa5: goto state95;
		case 0xa6: goto state98;
		case 0xa7: goto state97;
		case 0xa8: goto state9a;
		case 0xa9: goto state99;
		case 0xaa: goto state9c;
		case 0xab: goto state9b;
		case 0xac: goto state9e;
		case 0xad: goto state9d;
		case 0xae: goto statea0;
		case 0xaf: goto state9f;
		case 0xb0: goto statea2;
		case 0xb1: goto statea1;
		case 0xb2: goto statea4;
		case 0xb3: goto statea3;
		case 0xb4: goto statea6;
		case 0xb5: goto statea5;
		case 0xb6: goto statea8;
		case 0xb7: goto statea7;
		case 0xb9: goto stateab;
		case 0xba: goto stateaa;
		case 0xbb: goto statead;
		case 0xbc: goto stateac;
		case 0xbd: goto stateaf;
		case 0xbe: goto stateae;
		default: goto no_match;
	}
stateba:
	switch (*(str2++)){
		case 0xc6: goto statebb;
		case 0xc7: goto state11b;
		case 0xc8: goto state129;
		case 0xc9: goto state119;
		case 0xca: goto state11d;
		default: goto no_match;
	}
statebb:
	str1marker = str1;
	str2marker = str2;
	switch (*(str1++)){
		case 0x82: goto state74;
		case 0x83: goto state73;
		case 0x84: goto state76;
		case 0x85: goto state75;
		case 0x87: goto state79;
		case 0x88: goto state78;
		case 0x8b: goto state7d;
		case 0x8c: goto state7c;
		case 0x91: goto state83;
		case 0x92: goto state82;
		case 0x98: goto state8a;
		case 0x99: goto state89;
		case 0xa0: goto state92;
		case 0xa1: goto state91;
		case 0xa2: goto state94;
		case 0xa3: goto state93;
		case 0xa4: goto state96;
		case 0xa5: goto state95;
		case 0xa7: goto state99;
		case 0xa8: goto state98;
		case 0xac: goto state9e;
		case 0xad: goto state9d;
		case 0xaf: goto statea1;
		case 0xb0: goto statea0;
		case 0xb3: goto statea5;
		case 0xb4: goto statea4;
		case 0xb5: goto statea7;
		case 0xb6: goto statea6;
		case 0xb8: goto stateaa;
		case 0xb9: goto statea9;
		case 0xbc: goto stateae;
		case 0xbd: goto statead;
		default: goto no_match;
	}
statebc:
	switch (*(str2++)){
		case 0x6a: goto state122;
		case 0xc6: goto state11c;
		case 0xc7: goto statebd;
		default: goto no_match;
	}
statebd:
	str1marker = str1;
	str2marker = str2;
	switch (*(str1++)){
		case 0x84: goto state77;
		case 0x85: goto state77;
		case 0x86: goto state11f;
		case 0x87: goto state7a;
		case 0x88: goto state7a;
		case 0x89: goto state120;
		case 0x8a: goto state7d;
		case 0x8b: goto state7d;
		case 0x8c: goto state121;
		case 0x8d: goto state7f;
		case 0x8e: goto state7e;
		case 0x8f: goto state81;
		case 0x90: goto state80;
		case 0x91: goto state83;
		case 0x92: goto state82;
		case 0x93: goto state85;
		case 0x94: goto state84;
		case 0x95: goto state87;
		case 0x96: goto state86;
		case 0x97: goto state89;
		case 0x98: goto state88;
		case 0x99: goto state8b;
		case 0x9a: goto state8a;
		case 0x9b: goto state8d;
		case 0x9c: goto state8c;
		case 0x9e: goto state90;
		case 0x9f: goto state8f;
		case 0xa0: goto state92;
		case 0xa1: goto state91;
		case 0xa2: goto state94;
		case 0xa3: goto state93;
		case 0xa4: goto state96;
		case 0xa5: goto state95;
		case 0xa6: goto state98;
		case 0xa7: goto state97;
		case 0xa8: goto state9a;
		case 0xa9: goto state99;
		case 0xaa: goto state9c;
		case 0xab: goto state9b;
		case 0xac: goto state9e;
		case 0xad: goto state9d;
		case 0xae: goto statea0;
		case 0xaf: goto state9f;
		case 0xb1: goto statea4;
		case 0xb2: goto statea4;
		case 0xb3: goto state127;
		case 0xb4: goto statea6;
		case 0xb5: goto statea5;
		case 0xb8: goto stateaa;
		case 0xb9: goto statea9;
		case 0xba: goto stateac;
		case 0xbb: goto stateab;
		case 0xbc: goto stateae;
		case 0xbd: goto statead;
		case 0xbe: goto stateb0;
		case 0xbf: goto stateaf;
		default: goto no_match;
	}
statebe:
	switch (*(str2++)){
		case 0xc6: goto state128;
		case 0xc8: goto statebf;
		default: goto no_match;
	}
statebf:
	str1marker = str1;
	str2marker = str2;
	switch (*(str1++)){
		case 0x80: goto state72;
		case 0x81: goto state71;
		case 0x82: goto state74;
		case 0x83: goto state73;
		case 0x84: goto state76;
		case 0x85: goto state75;
		case 0x86: goto state78;
		case 0x87: goto state77;
		case 0x88: goto state7a;
		case 0x89: goto state79;
		case 0x8a: goto state7c;
		case 0x8b: goto state7b;
		case 0x8c: goto state7e;
		case 0x8d: goto state7d;
		case 0x8e: goto state80;
		case 0x8f: goto state7f;
		case 0x90: goto state82;
		case 0x91: goto state81;
		case 0x92: goto state84;
		case 0x93: goto state83;
		case 0x94: goto state86;
		case 0x95: goto state85;
		case 0x96: goto state88;
		case 0x97: goto state87;
		case 0x98: goto state8a;
		case 0x99: goto state89;
		case 0x9a: goto state8c;
		case 0x9b: goto state8b;
		case 0x9c: goto state8e;
		case 0x9d: goto state8d;
		case 0x9e: goto state90;
		case 0x9f: goto state8f;
		case 0xa2: goto state94;
		case 0xa3: goto state93;
		case 0xa4: goto state96;
		case 0xa5: goto state95;
		case 0xa6: goto state98;
		case 0xa7: goto state97;
		case 0xa8: goto state9a;
		case 0xa9: goto state99;
		case 0xaa: goto state9c;
		case 0xab: goto state9b;
		case 0xac: goto state9e;
		case 0xad: goto state9d;
		case 0xae: goto statea0;
		case 0xaf: goto state9f;
		case 0xb0: goto statea2;
		case 0xb1: goto statea1;
		case 0xb2: goto statea4;
		case 0xb3: goto statea3;
		default: goto no_match;
	}
statec0:
	switch (*(str2++)){
		case 0xc6: goto state11a;
		case 0xc9: goto state2;
		default: goto no_match;
	}
statec1:
	switch (*(str2++)){
		case 0xc5: goto state113;
		case 0xc6: goto state11e;
		case 0xca: goto state2;
		default: goto no_match;
	}
statec2:
	switch (*(str2++)){
		case 0xcb: goto state2;
		default: goto no_match;
	}
statec3:
	switch (*(str2++)){
		case 0xcc: goto state2;
		default: goto no_match;
	}
statec4:
	switch (*(str2++)){
		case 0xcd: goto state2;
		case 0xce: goto state12a;
		default: goto no_match;
	}
statec5:
	switch (*(str2++)){
		case 0xc2: goto state105;
		case 0xcd: goto state12b;
		case 0xce: goto statec6;
		case 0xcf: goto state12c;
		case 0xe1: goto state1bd;
		default: goto no_match;
	}
statec6:
	str1marker = str1;
	str2marker = str2;
	switch (*(str1++)){
		case 0x86: goto state9d;
		case 0x88: goto state9e;
		case 0x89: goto state9f;
		case 0x8a: goto statea0;
		case 0x90: goto state12e;
		case 0x91: goto statea2;
		case 0x92: goto statea3;
		case 0x93: goto statea4;
		case 0x94: goto statea5;
		case 0x95: goto statea6;
		case 0x96: goto statea7;
		case 0x97: goto statea8;
		case 0x98: goto statea9;
		case 0x99: goto stateaa;
		case 0x9a: goto stateab;
		case 0x9b: goto stateac;
		case 0x9c: goto statead;
		case 0x9d: goto stateae;
		case 0x9e: goto stateaf;
		case 0x9f: goto stateb0;
		case 0xac: goto state77;
		case 0xad: goto state79;
		case 0xae: goto state7a;
		case 0xaf: goto state7b;
		case 0xb1: goto state82;
		case 0xb2: goto state83;
		case 0xb3: goto state84;
		case 0xb4: goto state85;
		case 0xb5: goto state86;
		case 0xb6: goto state87;
		case 0xb7: goto state88;
		case 0xb8: goto state89;
		case 0xb9: goto state132;
		case 0xba: goto state8b;
		case 0xbb: goto state8c;
		case 0xbc: goto state8d;
		case 0xbd: goto state8e;
		case 0xbe: goto state8f;
		case 0xbf: goto state90;
		default: goto no_match;
	}
statec7:
	switch (*(str2++)){
		case 0xce: goto state12d;
		case 0xcf: goto statec8;
		case 0xe1: goto state174;
		case 0xe2: goto state1f3;
		default: goto no_match;
	}
statec8:
	str1marker = str1;
	str2marker = str2;
	switch (*(str1++)){
		case 0x80: goto state87;
		case 0x81: goto statea2;
		case 0x82: goto state74;
		case 0x83: goto state73;
		case 0x86: goto state86;
		case 0x95: goto state77;
		case 0x96: goto state71;
		case 0x98: goto state8a;
		case 0x99: goto state89;
		case 0x9a: goto state8c;
		case 0x9b: goto state8b;
		case 0x9c: goto state8e;
		case 0x9d: goto state8d;
		case 0x9e: goto state90;
		case 0x9f: goto state8f;
		case 0xa0: goto state92;
		case 0xa1: goto state91;
		case 0xa2: goto state94;
		case 0xa3: goto state93;
		case 0xa4: goto state96;
		case 0xa5: goto state95;
		case 0xa6: goto state98;
		case 0xa7: goto state97;
		case 0xa8: goto state9a;
		case 0xa9: goto state99;
		case 0xaa: goto state9c;
		case 0xab: goto state9b;
		case 0xac: goto state9e;
		case 0xad: goto state9d;
		case 0xae: goto statea0;
		case 0xaf: goto state9f;
		case 0xb1: goto state72;
		case 0xb2: goto stateaa;
		case 0xb7: goto statea9;
		case 0xb8: goto statea8;
		case 0xb9: goto statea3;
		case 0xba: goto stateac;
		case 0xbb: goto stateab;
		default: goto no_match;
	}
statec9:
	switch (*(str2++)){
		case 0xd0: goto stateca;
		case 0xd1: goto state13a;
		default: goto no_match;
	}
stateca:
	str1marker = str1;
	str2marker = str2;
	switch (*(str1++)){
		case 0x90: goto statea1;
		case 0x91: goto statea2;
		case 0x92: goto statea3;
		case 0x93: goto statea4;
		case 0x94: goto statea5;
		case 0x95: goto statea6;
		case 0x96: goto statea7;
		case 0x97: goto statea8;
		case 0x98: goto statea9;
		case 0x99: goto stateaa;
		case 0x9a: goto stateab;
		case 0x9b: goto stateac;
		case 0x9c: goto statead;
		case 0x9d: goto stateae;
		case 0x9e: goto stateaf;
		case 0x9f: goto stateb0;
		case 0xb0: goto state81;
		case 0xb1: goto state82;
		case 0xb2: goto state83;
		case 0xb3: goto state84;
		case 0xb4: goto state85;
		case 0xb5: goto state86;
		case 0xb6: goto state87;
		case 0xb7: goto state88;
		case 0xb8: goto state89;
		case 0xb9: goto state8a;
		case 0xba: goto state8b;
		case 0xbb: goto state8c;
		case 0xbc: goto state8d;
		case 0xbd: goto state8e;
		case 0xbe: goto state8f;
		case 0xbf: goto state90;
		default: goto no_match;
	}
statecb:
	switch (*(str2++)){
		case 0xd0: goto state13b;
		case 0xd1: goto statecc;
		default: goto no_match;
	}
statecc:
	str1marker = str1;
	str2marker = str2;
	switch (*(str1++)){
		case 0xa0: goto state92;
		case 0xa1: goto state91;
		case 0xa2: goto state94;
		case 0xa3: goto state93;
		case 0xa4: goto state96;
		case 0xa5: goto state95;
		case 0xa6: goto state98;
		case 0xa7: goto state97;
		case 0xa8: goto state9a;
		case 0xa9: goto state99;
		case 0xaa: goto state9c;
		case 0xab: goto state9b;
		case 0xac: goto state9e;
		case 0xad: goto state9d;
		case 0xae: goto statea0;
		case 0xaf: goto state9f;
		case 0xb0: goto statea2;
		case 0xb1: goto statea1;
		case 0xb2: goto statea4;
		case 0xb3: goto statea3;
		case 0xb4: goto statea6;
		case 0xb5: goto statea5;
		case 0xb6: goto statea8;
		case 0xb7: goto statea7;
		case 0xb8: goto stateaa;
		case 0xb9: goto statea9;
		case 0xba: goto stateac;
		case 0xbb: goto stateab;
		case 0xbc: goto stateae;
		case 0xbd: goto statead;
		case 0xbe: goto stateb0;
		case 0xbf: goto stateaf;
		default: goto no_match;
	}
statecd:
	switch (*(str2++)){
		case 0xd2: goto statece;
		default: goto no_match;
	}
statece:
	str1marker = str1;
	str2marker = str2;
	switch (*(str1++)){
		case 0x80: goto state72;
		case 0x81: goto state71;
		case 0x8a: goto state7c;
		case 0x8b: goto state7b;
		case 0x8c: goto state7e;
		case 0x8d: goto state7d;
		case 0x8e: goto state80;
		case 0x8f: goto state7f;
		case 0x90: goto state82;
		case 0x91: goto state81;
		case 0x92: goto state84;
		case 0x93: goto state83;
		case 0x94: goto state86;
		case 0x95: goto state85;
		case 0x96: goto state88;
		case 0x97: goto state87;
		case 0x98: goto state8a;
		case 0x99: goto state89;
		case 0x9a: goto state8c;
		case 0x9b: goto state8b;
		case 0x9c: goto state8e;
		case 0x9d: goto state8d;
		case 0x9e: goto state90;
		case 0x9f: goto state8f;
		case 0xa0: goto state92;
		case 0xa1: goto state91;
		case 0xa2: goto state94;
		case 0xa3: goto state93;
		case 0xa4: goto state96;
		case 0xa5: goto state95;
		case 0xa6: goto state98;
		case 0xa7: goto state97;
		case 0xa8: goto state9a;
		case 0xa9: goto state99;
		case 0xaa: goto state9c;
		case 0xab: goto state9b;
		case 0xac: goto state9e;
		case 0xad: goto state9d;
		case 0xae: goto statea0;
		case 0xaf: goto state9f;
		case 0xb0: goto statea2;
		case 0xb1: goto statea1;
		case 0xb2: goto statea4;
		case 0xb3: goto statea3;
		case 0xb4: goto statea6;
		case 0xb5: goto statea5;
		case 0xb6: goto statea8;
		case 0xb7: goto statea7;
		case 0xb8: goto stateaa;
		case 0xb9: goto statea9;
		case 0xba: goto stateac;
		case 0xbb: goto stateab;
		case 0xbc: goto stateae;
		case 0xbd: goto statead;
		case 0xbe: goto stateb0;
		case 0xbf: goto stateaf;
		default: goto no_match;
	}
statecf:
	switch (*(str2++)){
		case 0xd3: goto stated0;
		default: goto no_match;
	}
stated0:
	str1marker = str1;
	str2marker = str2;
	switch (*(str1++)){
		case 0x81: goto state73;
		case 0x82: goto state72;
		case 0x83: goto state75;
		case 0x84: goto state74;
		case 0x85: goto state77;
		case 0x86: goto state76;
		case 0x87: goto state79;
		case 0x88: goto state78;
		case 0x89: goto state7b;
		case 0x8a: goto state7a;
		case 0x8b: goto state7d;
		case 0x8c: goto state7c;
		case 0x8d: goto state7f;
		case 0x8e: goto state7e;
		case 0x90: goto state82;
		case 0x91: goto state81;
		case 0x92: goto state84;
		case 0x93: goto state83;
		case 0x94: goto state86;
		case 0x95: goto state85;
		case 0x96: goto state88;
		case 0x97: goto state87;
		case 0x98: goto state8a;
		case 0x99: goto state89;
		case 0x9a: goto state8c;
		case 0x9b: goto state8b;
		case 0x9c: goto state8e;
		case 0x9d: goto state8d;
		case 0x9e: goto state90;
		case 0x9f: goto state8f;
		case 0xa0: goto state92;
		case 0xa1: goto state91;
		case 0xa2: goto state94;
		case 0xa3: goto state93;
		case 0xa4: goto state96;
		case 0xa5: goto state95;
		case 0xa6: goto state98;
		case 0xa7: goto state97;
		case 0xa8: goto state9a;
		case 0xa9: goto state99;
		case 0xaa: goto state9c;
		case 0xab: goto state9b;
		case 0xac: goto state9e;
		case 0xad: goto state9d;
		case 0xae: goto statea0;
		case 0xaf: goto state9f;
		case 0xb0: goto statea2;
		case 0xb1: goto statea1;
		case 0xb2: goto statea4;
		case 0xb3: goto statea3;
		case 0xb4: goto statea6;
		case 0xb5: goto statea5;
		case 0xb8: goto stateaa;
		case 0xb9: goto statea9;
		default: goto no_match;
	}
stated1:
	switch (*(str2++)){
		case 0xd4: goto stated2;
		case 0xd5: goto state13c;
		default: goto no_match;
	}
stated2:
	str1marker = str1;
	str2marker = str2;
	switch (*(str1++)){
		case 0x80: goto state72;
		case 0x81: goto state71;
		case 0x82: goto state74;
		case 0x83: goto state73;
		case 0x84: goto state76;
		case 0x85: goto state75;
		case 0x86: goto state78;
		case 0x87: goto state77;
		case 0x88: goto state7a;
		case 0x89: goto state79;
		case 0x8a: goto state7c;
		case 0x8b: goto state7b;
		case 0x8c: goto state7e;
		case 0x8d: goto state7d;
		case 0x8e: goto state80;
		case 0x8f: goto state7f;
		default: goto no_match;
	}
stated3:
	switch (*(str2++)){
		case 0xd4: goto state13d;
		case 0xd5: goto stated4;
		case 0xd6: goto state13e;
		case 0xef: goto state218;
		default: goto no_match;
	}
stated4:
	str1marker = str1;
	str2marker = str2;
	switch (*(str1++)){
		case 0x80: goto statea1;
		case 0x81: goto statea2;
		case 0x82: goto statea3;
		case 0x83: goto statea4;
		case 0x84: goto statea5;
		case 0x85: goto statea6;
		case 0x86: goto statea7;
		case 0x87: goto statea8;
		case 0x88: goto statea9;
		case 0x89: goto stateaa;
		case 0x8a: goto stateab;
		case 0x8b: goto stateac;
		case 0x8c: goto statead;
		case 0x8d: goto stateae;
		case 0x8e: goto stateaf;
		case 0x8f: goto stateb0;
		case 0xb0: goto state71;
		case 0xb1: goto state72;
		case 0xb2: goto state73;
		case 0xb3: goto state74;
		case 0xb4: goto state75;
		case 0xb5: goto state76;
		case 0xb6: goto state77;
		case 0xb7: goto state78;
		case 0xb8: goto state79;
		case 0xb9: goto state7a;
		case 0xba: goto state7b;
		case 0xbb: goto state7c;
		case 0xbc: goto state7d;
		case 0xbd: goto state7e;
		case 0xbe: goto state7f;
		case 0xbf: goto state80;
		default: goto no_match;
	}
stated5:
	switch (*(str2++)){
		case 0xd5: goto state13f;
		case 0xd6: goto state2;
		default: goto no_match;
	}
stated6:
	switch (*(str2++)){
		case 0xd7: goto state2;
		default: goto no_match;
	}
stated7:
	switch (*(str2++)){
		case 0xd8: goto state2;
		default: goto no_match;
	}
stated8:
	switch (*(str2++)){
		case 0xd9: goto state2;
		default: goto no_match;
	}
stated9:
	switch (*(str2++)){
		case 0xda: goto state2;
		default: goto no_match;
	}
stateda:
	switch (*(str2++)){
		case 0xdb: goto state2;
		default: goto no_match;
	}
statedb:
	switch (*(str2++)){
		case 0xdc: goto state2;
		default: goto no_match;
	}
statedc:
	switch (*(str2++)){
		case 0xdd: goto state2;
		default: goto no_match;
	}
statedd:
	switch (*(str2++)){
		case 0xde: goto state2;
		default: goto no_match;
	}
statede:
	switch (*(str2++)){
		case 0xdf: goto state2;
		default: goto no_match;
	}
statedf:
	switch (*(str2++)){
		case 0xe0: goto state2;
		default: goto no_match;
	}
statee0:
	switch (*(str2++)){
		case 0x61: goto state162;
		case 0x68: goto state14a;
		case 0x74: goto state150;
		case 0x77: goto state156;
		case 0x79: goto state15c;
		case 0xce: goto state1ba;
		case 0xcf: goto state170;
		case 0xe1: goto statee1;
		default: goto no_match;
	}
statee1:
	str1marker = str1;
	str2marker = str2;
	switch (*(str1++)){
		case 0xb8: goto state145;
		case 0xb9: goto state147;
		case 0xba: goto state148;
		case 0xbb: goto state16a;
		case 0xbc: goto state16c;
		case 0xbd: goto state16e;
		case 0xbe: goto state187;
		case 0xbf: goto state1ca;
		default: goto no_match;
	}
statee2:
	switch (*(str2++)){
		case 0x6b: goto state1f5;
		case 0xc3: goto state1f8;
		case 0xcf: goto state1f0;
		case 0xe2: goto statee3;
		default: goto no_match;
	}
statee3:
	str1marker = str1;
	str2marker = str2;
	switch (*(str1++)){
		case 0x85: goto state1fd;
		case 0x92: goto state1ff;
		case 0x93: goto state201;
		default: goto no_match;
	}
statee4:
	switch (*(str2++)){
		case 0xe3: goto state2;
		default: goto no_match;
	}
statee5:
	switch (*(str2++)){
		case 0xe4: goto state2;
		default: goto no_match;
	}
statee6:
	switch (*(str2++)){
		case 0xe5: goto state2;
		default: goto no_match;
	}
statee7:
	switch (*(str2++)){
		case 0xe6: goto state2;
		default: goto no_match;
	}
statee8:
	switch (*(str2++)){
		case 0xe7: goto state2;
		default: goto no_match;
	}
statee9:
	switch (*(str2++)){
		case 0xe8: goto state2;
		default: goto no_match;
	}
stateea:
	switch (*(str2++)){
		case 0xe9: goto state2;
		default: goto no_match;
	}
stateeb:
	switch (*(str2++)){
		case 0xea: goto state2;
		default: goto no_match;
	}
stateec:
	switch (*(str2++)){
		case 0xeb: goto state2;
		default: goto no_match;
	}
stateed:
	switch (*(str2++)){
		case 0xec: goto state2;
		default: goto no_match;
	}
stateee:
	switch (*(str2++)){
		case 0xed: goto state2;
		default: goto no_match;
	}
stateef:
	switch (*(str2++)){
		case 0xee: goto state2;
		default: goto no_match;
	}
statef0:
	switch (*(str2++)){
		case 0x66: goto state204;
		case 0x73: goto state20e;
		case 0xd5: goto state214;
		case 0xef: goto statef1;
		default: goto no_match;
	}
statef1:
	str1marker = str1;
	str2marker = str2;
	switch (*(str1++)){
		case 0xbc: goto state226;
		case 0xbd: goto state228;
		default: goto no_match;
	}
statef2:
	switch (*(str2++)){
		case 0xf0: goto statef3;
		default: goto no_match;
	}
statef3:
	str1marker = str1;
	str2marker = str2;
	switch (*(str1++)){
		case 0x90: goto state22a;
		default: goto no_match;
	}
statef4:
	switch (*(str2++)){
		case 0xf1: goto state2;
		default: goto no_match;
	}
statef5:
	switch (*(str2++)){
		case 0xf2: goto state2;
		default: goto no_match;
	}
statef6:
	switch (*(str2++)){
		case 0xf3: goto state2;
		default: goto no_match;
	}
statef7:
	switch (*(str2++)){
		case 0xf4: goto state2;
		default: goto no_match;
	}
statef8:
	switch (*(str2++)){
		case 0xf5: goto state2;
		default: goto no_match;
	}
statef9:
	switch (*(str2++)){
		case 0xf6: goto state2;
		default: goto no_match;
	}
statefa:
	switch (*(str2++)){
		case 0xf7: goto state2;
		default: goto no_match;
	}
statefb:
	switch (*(str2++)){
		case 0xf8: goto state2;
		default: goto no_match;
	}
statefc:
	switch (*(str2++)){
		case 0xf9: goto state2;
		default: goto no_match;
	}
statefd:
	switch (*(str2++)){
		case 0xfa: goto state2;
		default: goto no_match;
	}
statefe:
	switch (*(str2++)){
		case 0xfb: goto state2;
		default: goto no_match;
	}
stateff:
	switch (*(str2++)){
		case 0xfc: goto state2;
		default: goto no_match;
	}
state100:
	switch (*(str2++)){
		case 0xfd: goto state2;
		default: goto no_match;
	}
state101:
	switch (*(str2++)){
		case 0xfe: goto state2;
		default: goto no_match;
	}
state102:
	switch (*(str2++)){
		case 0xff: goto state2;
		default: goto no_match;
	}
state103:
	switch (*(str1++)){
		case 0xb1: goto state2;
		default: goto no_match;
	}
state104:
	switch (*(str1++)){
		case 0xb5: goto statead;
		default: goto no_match;
	}
state105:
	switch (*(str1++)){
		case 0xbc: goto statea6;
		default: goto no_match;
	}
state106:
	switch (*(str1++)){
		case 0x9f: goto state107;
		default: goto no_match;
	}
state107:
	switch (*(str2++)){
		case 0x73: goto state2;
		default: goto no_match;
	}
state108:
	switch (*(str1++)){
		case 0x73: goto state90;
		default: goto no_match;
	}
state109:
	switch (*(str1++)){
		case 0xb0: goto state10a;
		default: goto no_match;
	}
state10a:
	str1marker = str1;
	str2marker = str2;
	switch (*(str2++)){
		case 0xcc: goto state78;
		default: goto no_match;
	}
state10b:
	switch (*(str1++)){
		case 0xcc: goto state10c;
	}
	--str1;
	switch (*(str2++)){
		case 0xb0: goto state2;
		default: goto no_match;
	}
state10c:
	switch (*(str2++)){
		case 0xb0: goto state10d;
		default: goto no_match;
	}
state10d:
	switch (*(str1++)){
		case 0x87: goto state2;
		default: goto no_match;
	}
state10e:
	switch (*(str1++)){
		case 0xbf: goto state71;
		default: goto no_match;
	}
state10f:
	switch (*(str1++)){
		case 0x80: goto stateb0;
		default: goto no_match;
	}
state110:
	switch (*(str1++)){
		case 0x89: goto state111;
		default: goto no_match;
	}
state111:
	switch (*(str2++)){
		case 0xbc: goto state112;
		default: goto no_match;
	}
state112:
	switch (*(str2++)){
		case 0x6e: goto state2;
		default: goto no_match;
	}
state113:
	switch (*(str1++)){
		case 0xbc: goto state114;
		default: goto no_match;
	}
state114:
	switch (*(str2++)){
		case 0x89: goto state115;
		default: goto no_match;
	}
state115:
	switch (*(str1++)){
		case 0x6e: goto state2;
		default: goto no_match;
	}
state116:
	switch (*(str1++)){
		case 0xb8: goto stateb0;
		default: goto no_match;
	}
state117:
	switch (*(str1++)){
		case 0xbf: goto statea9;
		default: goto no_match;
	}
state118:
	switch (*(str1++)){
		case 0xbf: goto state2;
		default: goto no_match;
	}
state119:
	switch (*(str1++)){
		case 0x81: goto state84;
		case 0x86: goto state85;
		case 0x89: goto state87;
		case 0x8a: goto state88;
		case 0x8f: goto state8a;
		case 0x90: goto state8c;
		case 0x93: goto state91;
		case 0x94: goto state94;
		case 0x96: goto state9a;
		case 0x97: goto state99;
		case 0x9c: goto statea0;
		case 0x9d: goto statea3;
		case 0x9f: goto statea6;
		default: goto no_match;
	}
state11a:
	switch (*(str1++)){
		case 0x93: goto state72;
		case 0x94: goto state77;
		case 0x96: goto state7a;
		case 0x97: goto state7b;
		case 0x99: goto state80;
		case 0x9b: goto state81;
		case 0xa0: goto state84;
		case 0xa3: goto state85;
		case 0xa8: goto state88;
		case 0xa9: goto state87;
		case 0xaf: goto state8d;
		case 0xb2: goto state8e;
		case 0xb5: goto state90;
		default: goto no_match;
	}
state11b:
	switch (*(str1++)){
		case 0x8e: goto state8e;
		case 0x95: goto statea7;
		case 0xbf: goto statea8;
		default: goto no_match;
	}
state11c:
	switch (*(str1++)){
		case 0x9d: goto state7f;
		case 0xb6: goto state86;
		case 0xb7: goto stateb0;
		default: goto no_match;
	}
state11d:
	switch (*(str1++)){
		case 0xa6: goto state71;
		case 0xa9: goto state74;
		case 0xae: goto state79;
		case 0xb1: goto state7b;
		case 0xb2: goto state7c;
		case 0xb7: goto state83;
		default: goto no_match;
	}
state11e:
	switch (*(str1++)){
		case 0x80: goto state97;
		case 0x83: goto state9a;
		case 0x88: goto state9f;
		case 0x8a: goto statea2;
		case 0x8b: goto statea3;
		case 0x92: goto statea8;
		default: goto no_match;
	}
state11f:
	switch (*(str2++)){
		case 0x84: goto state2;
		case 0x85: goto state2;
		default: goto no_match;
	}
state120:
	switch (*(str2++)){
		case 0x87: goto state2;
		case 0x88: goto state2;
		default: goto no_match;
	}
state121:
	switch (*(str2++)){
		case 0x8a: goto state2;
		case 0x8b: goto state2;
		default: goto no_match;
	}
state122:
	switch (*(str1++)){
		case 0xb0: goto state123;
		default: goto no_match;
	}
state123:
	switch (*(str2++)){
		case 0xcc: goto state7d;
		default: goto no_match;
	}
state124:
	switch (*(str1++)){
		case 0xcc: goto state125;
		default: goto no_match;
	}
state125:
	switch (*(str2++)){
		case 0xb0: goto state126;
		default: goto no_match;
	}
state126:
	switch (*(str1++)){
		case 0x8c: goto state2;
		default: goto no_match;
	}
state127:
	switch (*(str2++)){
		case 0xb1: goto state2;
		case 0xb2: goto state2;
		default: goto no_match;
	}
state128:
	switch (*(str1++)){
		case 0xa0: goto state8f;
		default: goto no_match;
	}
state129:
	switch (*(str1++)){
		case 0x9e: goto state91;
		default: goto no_match;
	}
state12a:
	switch (*(str1++)){
		case 0x85: goto stateaa;
		default: goto no_match;
	}
state12b:
	switch (*(str1++)){
		case 0xb9: goto state76;
		default: goto no_match;
	}
state12c:
	switch (*(str1++)){
		case 0x8c: goto state7d;
		case 0x8e: goto state7e;
		case 0x8f: goto state7f;
		case 0xa0: goto state71;
		case 0xa1: goto state72;
		case 0xa3: goto state74;
		case 0xa4: goto state75;
		case 0xa5: goto state76;
		case 0xa6: goto state77;
		case 0xa7: goto state78;
		case 0xa8: goto state79;
		case 0xa9: goto state7a;
		case 0xaa: goto state7b;
		case 0xab: goto state7c;
		case 0xb0: goto state138;
		case 0xb2: goto state81;
		case 0xb5: goto statea6;
		case 0xb8: goto state139;
		case 0xba: goto statea1;
		default: goto no_match;
	}
state12d:
	switch (*(str1++)){
		case 0x80: goto state91;
		case 0x81: goto state92;
		case 0x83: goto state94;
		case 0x84: goto state95;
		case 0x85: goto state137;
		case 0x86: goto state97;
		case 0x87: goto state98;
		case 0x88: goto state99;
		case 0x89: goto state9a;
		case 0x8a: goto state9b;
		case 0x8b: goto state9c;
		case 0x8c: goto state7d;
		case 0x8d: goto state7f;
		case 0x8e: goto state80;
		case 0x90: goto statea3;
		case 0x91: goto statea9;
		case 0xb0: goto stateab;
		case 0xb4: goto statea9;
		case 0xb5: goto statea6;
		default: goto no_match;
	}
state12e:
	switch (*(str2++)){
		case 0xb9: goto state12f;
		default: goto no_match;
	}
state12f:
	switch (*(str2++)){
		case 0xcc: goto state130;
		default: goto no_match;
	}
state130:
	switch (*(str2++)){
		case 0x88: goto state131;
		default: goto no_match;
	}
state131:
	switch (*(str2++)){
		case 0xcc: goto state72;
		default: goto no_match;
	}
state132:
	switch (*(str2++)){
		case 0x90: goto state133;
		case 0x99: goto state2;
		default: goto no_match;
	}
state133:
	switch (*(str1++)){
		case 0xcc: goto state134;
		default: goto no_match;
	}
state134:
	switch (*(str1++)){
		case 0x88: goto state135;
		default: goto no_match;
	}
state135:
	switch (*(str1++)){
		case 0xcc: goto state136;
		default: goto no_match;
	}
state136:
	switch (*(str1++)){
		case 0x81: goto state2;
		default: goto no_match;
	}
state137:
	switch (*(str2++)){
		case 0xa5: goto state2;
		case 0xb0: goto state133;
		default: goto no_match;
	}
state138:
	switch (*(str2++)){
		case 0x85: goto state12f;
		default: goto no_match;
	}
state139:
	switch (*(str2++)){
		case 0x91: goto state2;
		case 0xb4: goto state2;
		default: goto no_match;
	}
state13a:
	switch (*(str1++)){
		case 0x80: goto state81;
		case 0x81: goto state82;
		case 0x82: goto state83;
		case 0x83: goto state84;
		case 0x84: goto state85;
		case 0x85: goto state86;
		case 0x86: goto state87;
		case 0x87: goto state88;
		case 0x88: goto state89;
		case 0x89: goto state8a;
		case 0x8a: goto state8b;
		case 0x8b: goto state8c;
		case 0x8c: goto state8d;
		case 0x8d: goto state8e;
		case 0x8e: goto state8f;
		case 0x8f: goto state90;
		case 0xa0: goto state71;
		case 0xa1: goto state72;
		case 0xa2: goto state73;
		case 0xa3: goto state74;
		case 0xa4: goto state75;
		case 0xa5: goto state76;
		case 0xa6: goto state77;
		case 0xa7: goto state78;
		case 0xa8: goto state79;
		case 0xa9: goto state7a;
		case 0xaa: goto state7b;
		case 0xab: goto state7c;
		case 0xac: goto state7d;
		case 0xad: goto state7e;
		case 0xae: goto state7f;
		case 0xaf: goto state80;
		default: goto no_match;
	}
state13b:
	switch (*(str1++)){
		case 0x80: goto state91;
		case 0x81: goto state92;
		case 0x82: goto state93;
		case 0x83: goto state94;
		case 0x84: goto state95;
		case 0x85: goto state96;
		case 0x86: goto state97;
		case 0x87: goto state98;
		case 0x88: goto state99;
		case 0x89: goto state9a;
		case 0x8a: goto state9b;
		case 0x8b: goto state9c;
		case 0x8c: goto state9d;
		case 0x8d: goto state9e;
		case 0x8e: goto state9f;
		case 0x8f: goto statea0;
		case 0x90: goto state71;
		case 0x91: goto state72;
		case 0x92: goto state73;
		case 0x93: goto state74;
		case 0x94: goto state75;
		case 0x95: goto state76;
		case 0x96: goto state77;
		case 0x97: goto state78;
		case 0x98: goto state79;
		case 0x99: goto state7a;
		case 0x9a: goto state7b;
		case 0x9b: goto state7c;
		case 0x9c: goto state7d;
		case 0x9d: goto state7e;
		case 0x9e: goto state7f;
		case 0x9f: goto state80;
		default: goto no_match;
	}
state13c:
	switch (*(str1++)){
		case 0xb1: goto state92;
		case 0xb2: goto state93;
		case 0xb3: goto state94;
		case 0xb4: goto state95;
		case 0xb5: goto state96;
		case 0xb6: goto state97;
		case 0xb7: goto state98;
		case 0xb8: goto state99;
		case 0xb9: goto state9a;
		case 0xba: goto state9b;
		case 0xbb: goto state9c;
		case 0xbc: goto state9d;
		case 0xbd: goto state9e;
		case 0xbe: goto state9f;
		case 0xbf: goto statea0;
		default: goto no_match;
	}
state13d:
	switch (*(str1++)){
		case 0xa1: goto statea2;
		case 0xa2: goto statea3;
		case 0xa3: goto statea4;
		case 0xa4: goto statea5;
		case 0xa5: goto statea6;
		case 0xa6: goto statea7;
		case 0xa7: goto statea8;
		case 0xa8: goto statea9;
		case 0xa9: goto stateaa;
		case 0xaa: goto stateab;
		case 0xab: goto stateac;
		case 0xac: goto statead;
		case 0xad: goto stateae;
		case 0xae: goto stateaf;
		case 0xaf: goto stateb0;
		default: goto no_match;
	}
state13e:
	switch (*(str1++)){
		case 0x90: goto state71;
		case 0x91: goto state72;
		case 0x92: goto state73;
		case 0x93: goto state74;
		case 0x94: goto state75;
		case 0x95: goto state76;
		case 0x96: goto state77;
		case 0xa5: goto state142;
		default: goto no_match;
	}
state13f:
	switch (*(str1++)){
		case 0x80: goto state81;
		case 0x81: goto state82;
		case 0x82: goto state83;
		case 0x83: goto state84;
		case 0x84: goto state85;
		case 0x85: goto state86;
		case 0x86: goto state87;
		case 0x87: goto state140;
		default: goto no_match;
	}
state140:
	switch (*(str2++)){
		case 0xa5: goto state141;
		default: goto no_match;
	}
state141:
	switch (*(str2++)){
		case 0xd6: goto state73;
		default: goto no_match;
	}
state142:
	switch (*(str2++)){
		case 0x87: goto state143;
		default: goto no_match;
	}
state143:
	switch (*(str1++)){
		case 0xd6: goto state144;
		default: goto no_match;
	}
state144:
	switch (*(str1++)){
		case 0x82: goto state2;
		default: goto no_match;
	}
state145:
	switch (*(str2++)){
		case 0xb8: goto state146;
		default: goto no_match;
	}
state146:
	switch (*(str1++)){
		case 0x80: goto state72;
		case 0x81: goto state71;
		case 0x82: goto state74;
		case 0x83: goto state73;
		case 0x84: goto state76;
		case 0x85: goto state75;
		case 0x86: goto state78;
		case 0x87: goto state77;
		case 0x88: goto state7a;
		case 0x89: goto state79;
		case 0x8a: goto state7c;
		case 0x8b: goto state7b;
		case 0x8c: goto state7e;
		case 0x8d: goto state7d;
		case 0x8e: goto state80;
		case 0x8f: goto state7f;
		case 0x90: goto state82;
		case 0x91: goto state81;
		case 0x92: goto state84;
		case 0x93: goto state83;
		case 0x94: goto state86;
		case 0x95: goto state85;
		case 0x96: goto state88;
		case 0x97: goto state87;
		case 0x98: goto state8a;
		case 0x99: goto state89;
		case 0x9a: goto state8c;
		case 0x9b: goto state8b;
		case 0x9c: goto state8e;
		case 0x9d: goto state8d;
		case 0x9e: goto state90;
		case 0x9f: goto state8f;
		case 0xa0: goto state92;
		case 0xa1: goto state91;
		case 0xa2: goto state94;
		case 0xa3: goto state93;
		case 0xa4: goto state96;
		case 0xa5: goto state95;
		case 0xa6: goto state98;
		case 0xa7: goto state97;
		case 0xa8: goto state9a;
		case 0xa9: goto state99;
		case 0xaa: goto state9c;
		case 0xab: goto state9b;
		case 0xac: goto state9e;
		case 0xad: goto state9d;
		case 0xae: goto statea0;
		case 0xaf: goto state9f;
		case 0xb0: goto statea2;
		case 0xb1: goto statea1;
		case 0xb2: goto statea4;
		case 0xb3: goto statea3;
		case 0xb4: goto statea6;
		case 0xb5: goto statea5;
		case 0xb6: goto statea8;
		case 0xb7: goto statea7;
		case 0xb8: goto stateaa;
		case 0xb9: goto statea9;
		case 0xba: goto stateac;
		case 0xbb: goto stateab;
		case 0xbc: goto stateae;
		case 0xbd: goto statead;
		case 0xbe: goto stateb0;
		case 0xbf: goto stateaf;
		default: goto no_match;
	}
state147:
	switch (*(str2++)){
		case 0xb9: goto state146;
		case 0xba: goto state169;
		default: goto no_match;
	}
state148:
	switch (*(str2++)){
		case 0xb9: goto state168;
		case 0xba: goto state149;
		default: goto no_match;
	}
state149:
	switch (*(str1++)){
		case 0x80: goto state72;
		case 0x81: goto state71;
		case 0x82: goto state74;
		case 0x83: goto state73;
		case 0x84: goto state76;
		case 0x85: goto state75;
		case 0x86: goto state78;
		case 0x87: goto state77;
		case 0x88: goto state7a;
		case 0x89: goto state79;
		case 0x8a: goto state7c;
		case 0x8b: goto state7b;
		case 0x8c: goto state7e;
		case 0x8d: goto state7d;
		case 0x8e: goto state80;
		case 0x8f: goto state7f;
		case 0x90: goto state82;
		case 0x91: goto state81;
		case 0x92: goto state84;
		case 0x93: goto state83;
		case 0x94: goto state86;
		case 0x95: goto state85;
		case 0xa0: goto state92;
		case 0xa1: goto state91;
		case 0xa2: goto state94;
		case 0xa3: goto state93;
		case 0xa4: goto state96;
		case 0xa5: goto state95;
		case 0xa6: goto state98;
		case 0xa7: goto state97;
		case 0xa8: goto state9a;
		case 0xa9: goto state99;
		case 0xaa: goto state9c;
		case 0xab: goto state9b;
		case 0xac: goto state9e;
		case 0xad: goto state9d;
		case 0xae: goto statea0;
		case 0xaf: goto state9f;
		case 0xb0: goto statea2;
		case 0xb1: goto statea1;
		case 0xb2: goto statea4;
		case 0xb3: goto statea3;
		case 0xb4: goto statea6;
		case 0xb5: goto statea5;
		case 0xb6: goto statea8;
		case 0xb7: goto statea7;
		case 0xb8: goto stateaa;
		case 0xb9: goto statea9;
		case 0xba: goto stateac;
		case 0xbb: goto stateab;
		case 0xbc: goto stateae;
		case 0xbd: goto statead;
		case 0xbe: goto stateb0;
		case 0xbf: goto stateaf;
		default: goto no_match;
	}
state14a:
	switch (*(str1++)){
		case 0xba: goto state14b;
		default: goto no_match;
	}
state14b:
	switch (*(str2++)){
		case 0xcc: goto state14c;
		default: goto no_match;
	}
state14c:
	switch (*(str1++)){
		case 0x96: goto statea2;
		default: goto no_match;
	}
state14d:
	switch (*(str1++)){
		case 0xcc: goto state14e;
		default: goto no_match;
	}
state14e:
	switch (*(str2++)){
		case 0xba: goto state14f;
		default: goto no_match;
	}
state14f:
	switch (*(str1++)){
		case 0xb1: goto state87;
		default: goto no_match;
	}
state150:
	switch (*(str1++)){
		case 0xba: goto state151;
		default: goto no_match;
	}
state151:
	switch (*(str2++)){
		case 0xcc: goto state152;
		default: goto no_match;
	}
state152:
	switch (*(str1++)){
		case 0x97: goto state79;
		default: goto no_match;
	}
state153:
	switch (*(str1++)){
		case 0xcc: goto state154;
		default: goto no_match;
	}
state154:
	switch (*(str2++)){
		case 0xba: goto state155;
		default: goto no_match;
	}
state155:
	switch (*(str1++)){
		case 0x88: goto state88;
		default: goto no_match;
	}
state156:
	switch (*(str1++)){
		case 0xba: goto state157;
		default: goto no_match;
	}
state157:
	switch (*(str2++)){
		case 0xcc: goto state158;
		default: goto no_match;
	}
state158:
	switch (*(str1++)){
		case 0x98: goto state7b;
		default: goto no_match;
	}
state159:
	switch (*(str1++)){
		case 0xcc: goto state15a;
		default: goto no_match;
	}
state15a:
	switch (*(str2++)){
		case 0xba: goto state15b;
		default: goto no_match;
	}
state15b:
	switch (*(str1++)){
		case 0x8a: goto state89;
		default: goto no_match;
	}
state15c:
	switch (*(str1++)){
		case 0xba: goto state15d;
		default: goto no_match;
	}
state15d:
	switch (*(str2++)){
		case 0xcc: goto state15e;
		default: goto no_match;
	}
state15e:
	switch (*(str1++)){
		case 0x99: goto state7b;
		default: goto no_match;
	}
state15f:
	switch (*(str1++)){
		case 0xcc: goto state160;
		default: goto no_match;
	}
state160:
	switch (*(str2++)){
		case 0xba: goto state161;
		default: goto no_match;
	}
state161:
	switch (*(str1++)){
		case 0x8a: goto state8a;
		default: goto no_match;
	}
state162:
	switch (*(str1++)){
		case 0xba: goto state163;
		default: goto no_match;
	}
state163:
	switch (*(str2++)){
		case 0xca: goto state164;
		default: goto no_match;
	}
state164:
	switch (*(str1++)){
		case 0x9a: goto stateaf;
		default: goto no_match;
	}
state165:
	switch (*(str1++)){
		case 0xca: goto state166;
		default: goto no_match;
	}
state166:
	switch (*(str2++)){
		case 0xba: goto state167;
		default: goto no_match;
	}
state167:
	switch (*(str1++)){
		case 0xbe: goto state8b;
		default: goto no_match;
	}
state168:
	switch (*(str1++)){
		case 0x9b: goto state92;
		default: goto no_match;
	}
state169:
	switch (*(str1++)){
		case 0xa1: goto state8c;
		default: goto no_match;
	}
state16a:
	switch (*(str2++)){
		case 0xbb: goto state16b;
		default: goto no_match;
	}
state16b:
	switch (*(str1++)){
		case 0x80: goto state72;
		case 0x81: goto state71;
		case 0x82: goto state74;
		case 0x83: goto state73;
		case 0x84: goto state76;
		case 0x85: goto state75;
		case 0x86: goto state78;
		case 0x87: goto state77;
		case 0x88: goto state7a;
		case 0x89: goto state79;
		case 0x8a: goto state7c;
		case 0x8b: goto state7b;
		case 0x8c: goto state7e;
		case 0x8d: goto state7d;
		case 0x8e: goto state80;
		case 0x8f: goto state7f;
		case 0x90: goto state82;
		case 0x91: goto state81;
		case 0x92: goto state84;
		case 0x93: goto state83;
		case 0x94: goto state86;
		case 0x95: goto state85;
		case 0x96: goto state88;
		case 0x97: goto state87;
		case 0x98: goto state8a;
		case 0x99: goto state89;
		case 0x9a: goto state8c;
		case 0x9b: goto state8b;
		case 0x9c: goto state8e;
		case 0x9d: goto state8d;
		case 0x9e: goto state90;
		case 0x9f: goto state8f;
		case 0xa0: goto state92;
		case 0xa1: goto state91;
		case 0xa2: goto state94;
		case 0xa3: goto state93;
		case 0xa4: goto state96;
		case 0xa5: goto state95;
		case 0xa6: goto state98;
		case 0xa7: goto state97;
		case 0xa8: goto state9a;
		case 0xa9: goto state99;
		case 0xaa: goto state9c;
		case 0xab: goto state9b;
		case 0xac: goto state9e;
		case 0xad: goto state9d;
		case 0xae: goto statea0;
		case 0xaf: goto state9f;
		case 0xb0: goto statea2;
		case 0xb1: goto statea1;
		case 0xb2: goto statea4;
		case 0xb3: goto statea3;
		case 0xb4: goto statea6;
		case 0xb5: goto statea5;
		case 0xb6: goto statea8;
		case 0xb7: goto statea7;
		case 0xb8: goto stateaa;
		case 0xb9: goto statea9;
		default: goto no_match;
	}
state16c:
	switch (*(str2++)){
		case 0xbc: goto state16d;
		case 0xbe: goto state18b;
		default: goto no_match;
	}
state16d:
	switch (*(str1++)){
		case 0x80: goto state79;
		case 0x81: goto state7a;
		case 0x82: goto state7b;
		case 0x83: goto state7c;
		case 0x84: goto state7d;
		case 0x85: goto state7e;
		case 0x86: goto state7f;
		case 0x87: goto state80;
		case 0x88: goto state71;
		case 0x89: goto state72;
		case 0x8a: goto state73;
		case 0x8b: goto state74;
		case 0x8c: goto state75;
		case 0x8d: goto state76;
		case 0x8e: goto state77;
		case 0x8f: goto state78;
		case 0x90: goto state89;
		case 0x91: goto state8a;
		case 0x92: goto state8b;
		case 0x93: goto state8c;
		case 0x94: goto state8d;
		case 0x95: goto state8e;
		case 0x98: goto state81;
		case 0x99: goto state82;
		case 0x9a: goto state83;
		case 0x9b: goto state84;
		case 0x9c: goto state85;
		case 0x9d: goto state86;
		case 0xa0: goto state99;
		case 0xa1: goto state9a;
		case 0xa2: goto state9b;
		case 0xa3: goto state9c;
		case 0xa4: goto state9d;
		case 0xa5: goto state9e;
		case 0xa6: goto state9f;
		case 0xa7: goto statea0;
		case 0xa8: goto state91;
		case 0xa9: goto state92;
		case 0xaa: goto state93;
		case 0xab: goto state94;
		case 0xac: goto state95;
		case 0xad: goto state96;
		case 0xae: goto state97;
		case 0xaf: goto state98;
		case 0xb0: goto statea9;
		case 0xb1: goto stateaa;
		case 0xb2: goto stateab;
		case 0xb3: goto stateac;
		case 0xb4: goto statead;
		case 0xb5: goto stateae;
		case 0xb6: goto stateaf;
		case 0xb7: goto stateb0;
		case 0xb8: goto statea1;
		case 0xb9: goto statea2;
		case 0xba: goto statea3;
		case 0xbb: goto statea4;
		case 0xbc: goto statea5;
		case 0xbd: goto statea6;
		case 0xbe: goto statea7;
		case 0xbf: goto statea8;
		default: goto no_match;
	}
state16e:
	switch (*(str2++)){
		case 0xbd: goto state16f;
		case 0xbe: goto state1af;
		case 0xbf: goto state1cd;
		default: goto no_match;
	}
state16f:
	switch (*(str1++)){
		case 0x80: goto state79;
		case 0x81: goto state7a;
		case 0x82: goto state7b;
		case 0x83: goto state7c;
		case 0x84: goto state7d;
		case 0x85: goto state7e;
		case 0x88: goto state71;
		case 0x89: goto state72;
		case 0x8a: goto state73;
		case 0x8b: goto state74;
		case 0x8c: goto state75;
		case 0x8d: goto state76;
		case 0x91: goto state8a;
		case 0x93: goto state8c;
		case 0x95: goto state8e;
		case 0x97: goto state90;
		case 0x99: goto state82;
		case 0x9b: goto state84;
		case 0x9d: goto state86;
		case 0x9f: goto state88;
		case 0xa0: goto state99;
		case 0xa1: goto state9a;
		case 0xa2: goto state9b;
		case 0xa3: goto state9c;
		case 0xa4: goto state9d;
		case 0xa5: goto state9e;
		case 0xa6: goto state9f;
		case 0xa7: goto statea0;
		case 0xa8: goto state91;
		case 0xa9: goto state92;
		case 0xaa: goto state93;
		case 0xab: goto state94;
		case 0xac: goto state95;
		case 0xad: goto state96;
		case 0xae: goto state97;
		case 0xaf: goto state98;
		default: goto no_match;
	}
state170:
	switch (*(str1++)){
		case 0xbd: goto state171;
		case 0xbf: goto state1e4;
		default: goto no_match;
	}
state171:
	switch (*(str2++)){
		case 0x85: goto state172;
		default: goto no_match;
	}
state172:
	switch (*(str1++)){
		case 0x90: goto state173;
		case 0x92: goto state179;
		case 0x94: goto state17f;
		case 0x96: goto state182;
		default: goto no_match;
	}
state173:
	switch (*(str2++)){
		case 0xcc: goto state84;
		default: goto no_match;
	}
state174:
	switch (*(str1++)){
		case 0x81: goto state1e9;
		case 0x85: goto state175;
		case 0x89: goto state1ee;
		case 0x8e: goto state1ef;
		default: goto no_match;
	}
state175:
	switch (*(str2++)){
		case 0xbd: goto state176;
		case 0xbf: goto state1e6;
		default: goto no_match;
	}
state176:
	switch (*(str1++)){
		case 0xcc: goto state177;
		default: goto no_match;
	}
state177:
	switch (*(str2++)){
		case 0x90: goto state178;
		case 0x92: goto state17c;
		case 0x94: goto state181;
		case 0x96: goto state185;
		default: goto no_match;
	}
state178:
	switch (*(str1++)){
		case 0x93: goto state2;
		default: goto no_match;
	}
state179:
	switch (*(str2++)){
		case 0xcc: goto state17a;
		default: goto no_match;
	}
state17a:
	switch (*(str2++)){
		case 0x93: goto state17b;
		default: goto no_match;
	}
state17b:
	switch (*(str2++)){
		case 0xcc: goto state71;
		default: goto no_match;
	}
state17c:
	switch (*(str1++)){
		case 0x93: goto state17d;
		default: goto no_match;
	}
state17d:
	switch (*(str1++)){
		case 0xcc: goto state17e;
		default: goto no_match;
	}
state17e:
	switch (*(str1++)){
		case 0x80: goto state2;
		default: goto no_match;
	}
state17f:
	switch (*(str2++)){
		case 0xcc: goto state180;
		default: goto no_match;
	}
state180:
	switch (*(str2++)){
		case 0x93: goto state131;
		default: goto no_match;
	}
state181:
	switch (*(str1++)){
		case 0x93: goto state135;
		default: goto no_match;
	}
state182:
	switch (*(str2++)){
		case 0xcc: goto state183;
		default: goto no_match;
	}
state183:
	switch (*(str2++)){
		case 0x93: goto state184;
		default: goto no_match;
	}
state184:
	switch (*(str2++)){
		case 0xcd: goto state73;
		default: goto no_match;
	}
state185:
	switch (*(str1++)){
		case 0x93: goto state186;
		default: goto no_match;
	}
state186:
	switch (*(str1++)){
		case 0xcd: goto state144;
		default: goto no_match;
	}
state187:
	switch (*(str2++)){
		case 0xbc: goto state188;
		case 0xbd: goto state1ae;
		case 0xbe: goto state19d;
		default: goto no_match;
	}
state188:
	switch (*(str1++)){
		case 0x80: goto state189;
		case 0x81: goto state18f;
		case 0x82: goto state191;
		case 0x83: goto state193;
		case 0x84: goto state195;
		case 0x85: goto state197;
		case 0x86: goto state199;
		case 0x87: goto state19b;
		case 0x88: goto state189;
		case 0x89: goto state18f;
		case 0x8a: goto state191;
		case 0x8b: goto state193;
		case 0x8c: goto state195;
		case 0x8d: goto state197;
		case 0x8e: goto state199;
		case 0x8f: goto state19b;
		case 0x90: goto state19e;
		case 0x91: goto state1a0;
		case 0x92: goto state1a2;
		case 0x93: goto state1a4;
		case 0x94: goto state1a6;
		case 0x95: goto state1a8;
		case 0x96: goto state1aa;
		case 0x97: goto state1ac;
		case 0x98: goto state19e;
		case 0x99: goto state1a0;
		case 0x9a: goto state1a2;
		case 0x9b: goto state1a4;
		case 0x9c: goto state1a6;
		case 0x9d: goto state1a8;
		case 0x9e: goto state1aa;
		case 0x9f: goto state1ac;
		default: goto no_match;
	}
state189:
	switch (*(str2++)){
		case 0x80: goto state18a;
		default: goto no_match;
	}
state18a:
	switch (*(str2++)){
		case 0xce: goto stateaa;
		default: goto no_match;
	}
state18b:
	switch (*(str1++)){
		case 0x80: goto state18c;
		case 0x81: goto state190;
		case 0x82: goto state192;
		case 0x83: goto state194;
		case 0x84: goto state196;
		case 0x85: goto state198;
		case 0x86: goto state19a;
		case 0x87: goto state19c;
		case 0xa0: goto state19f;
		case 0xa1: goto state1a1;
		case 0xa2: goto state1a3;
		case 0xa3: goto state1a5;
		case 0xa4: goto state1a7;
		case 0xa5: goto state1a9;
		case 0xa6: goto state1ab;
		case 0xa7: goto state1ad;
		default: goto no_match;
	}
state18c:
	switch (*(str2++)){
		case 0x80: goto state18d;
		case 0x88: goto state18d;
		default: goto no_match;
	}
state18d:
	switch (*(str1++)){
		case 0xce: goto state18e;
		default: goto no_match;
	}
state18e:
	switch (*(str1++)){
		case 0xb9: goto state2;
		default: goto no_match;
	}
state18f:
	switch (*(str2++)){
		case 0x81: goto state18a;
		default: goto no_match;
	}
state190:
	switch (*(str2++)){
		case 0x81: goto state18d;
		case 0x89: goto state18d;
		default: goto no_match;
	}
state191:
	switch (*(str2++)){
		case 0x82: goto state18a;
		default: goto no_match;
	}
state192:
	switch (*(str2++)){
		case 0x82: goto state18d;
		case 0x8a: goto state18d;
		default: goto no_match;
	}
state193:
	switch (*(str2++)){
		case 0x83: goto state18a;
		default: goto no_match;
	}
state194:
	switch (*(str2++)){
		case 0x83: goto state18d;
		case 0x8b: goto state18d;
		default: goto no_match;
	}
state195:
	switch (*(str2++)){
		case 0x84: goto state18a;
		default: goto no_match;
	}
state196:
	switch (*(str2++)){
		case 0x84: goto state18d;
		case 0x8c: goto state18d;
		default: goto no_match;
	}
state197:
	switch (*(str2++)){
		case 0x85: goto state18a;
		default: goto no_match;
	}
state198:
	switch (*(str2++)){
		case 0x85: goto state18d;
		case 0x8d: goto state18d;
		default: goto no_match;
	}
state199:
	switch (*(str2++)){
		case 0x86: goto state18a;
		default: goto no_match;
	}
state19a:
	switch (*(str2++)){
		case 0x86: goto state18d;
		case 0x8e: goto state18d;
		default: goto no_match;
	}
state19b:
	switch (*(str2++)){
		case 0x87: goto state18a;
		default: goto no_match;
	}
state19c:
	switch (*(str2++)){
		case 0x87: goto state18d;
		case 0x8f: goto state18d;
		default: goto no_match;
	}
state19d:
	switch (*(str1++)){
		case 0x80: goto state79;
		case 0x81: goto state7a;
		case 0x82: goto state7b;
		case 0x83: goto state7c;
		case 0x84: goto state7d;
		case 0x85: goto state7e;
		case 0x86: goto state7f;
		case 0x87: goto state80;
		case 0x88: goto state71;
		case 0x89: goto state72;
		case 0x8a: goto state73;
		case 0x8b: goto state74;
		case 0x8c: goto state75;
		case 0x8d: goto state76;
		case 0x8e: goto state77;
		case 0x8f: goto state78;
		case 0x90: goto state89;
		case 0x91: goto state8a;
		case 0x92: goto state8b;
		case 0x93: goto state8c;
		case 0x94: goto state8d;
		case 0x95: goto state8e;
		case 0x96: goto state8f;
		case 0x97: goto state90;
		case 0x98: goto state81;
		case 0x99: goto state82;
		case 0x9a: goto state83;
		case 0x9b: goto state84;
		case 0x9c: goto state85;
		case 0x9d: goto state86;
		case 0x9e: goto state87;
		case 0x9f: goto state88;
		case 0xa0: goto state99;
		case 0xa1: goto state9a;
		case 0xa2: goto state9b;
		case 0xa3: goto state9c;
		case 0xa4: goto state9d;
		case 0xa5: goto state9e;
		case 0xa6: goto state9f;
		case 0xa7: goto statea0;
		case 0xa8: goto state91;
		case 0xa9: goto state92;
		case 0xaa: goto state93;
		case 0xab: goto state94;
		case 0xac: goto state95;
		case 0xad: goto state96;
		case 0xae: goto state97;
		case 0xaf: goto state98;
		case 0xb0: goto statea9;
		case 0xb1: goto stateaa;
		case 0xb3: goto statead;
		case 0xb8: goto statea1;
		case 0xb9: goto statea2;
		case 0xbc: goto statea4;
		default: goto no_match;
	}
state19e:
	switch (*(str2++)){
		case 0xa0: goto state18a;
		default: goto no_match;
	}
state19f:
	switch (*(str2++)){
		case 0x90: goto state18d;
		case 0x98: goto state18d;
		default: goto no_match;
	}
state1a0:
	switch (*(str2++)){
		case 0xa1: goto state18a;
		default: goto no_match;
	}
state1a1:
	switch (*(str2++)){
		case 0x91: goto state18d;
		case 0x99: goto state18d;
		default: goto no_match;
	}
state1a2:
	switch (*(str2++)){
		case 0xa2: goto state18a;
		default: goto no_match;
	}
state1a3:
	switch (*(str2++)){
		case 0x92: goto state18d;
		case 0x9a: goto state18d;
		default: goto no_match;
	}
state1a4:
	switch (*(str2++)){
		case 0xa3: goto state18a;
		default: goto no_match;
	}
state1a5:
	switch (*(str2++)){
		case 0x93: goto state18d;
		case 0x9b: goto state18d;
		default: goto no_match;
	}
state1a6:
	switch (*(str2++)){
		case 0xa4: goto state18a;
		default: goto no_match;
	}
state1a7:
	switch (*(str2++)){
		case 0x94: goto state18d;
		case 0x9c: goto state18d;
		default: goto no_match;
	}
state1a8:
	switch (*(str2++)){
		case 0xa5: goto state18a;
		default: goto no_match;
	}
state1a9:
	switch (*(str2++)){
		case 0x95: goto state18d;
		case 0x9d: goto state18d;
		default: goto no_match;
	}
state1aa:
	switch (*(str2++)){
		case 0xa6: goto state18a;
		default: goto no_match;
	}
state1ab:
	switch (*(str2++)){
		case 0x96: goto state18d;
		case 0x9e: goto state18d;
		default: goto no_match;
	}
state1ac:
	switch (*(str2++)){
		case 0xa7: goto state18a;
		default: goto no_match;
	}
state1ad:
	switch (*(str2++)){
		case 0x97: goto state18d;
		case 0x9f: goto state18d;
		default: goto no_match;
	}
state1ae:
	switch (*(str1++)){
		case 0xa0: goto state19e;
		case 0xa1: goto state1a0;
		case 0xa2: goto state1a2;
		case 0xa3: goto state1a4;
		case 0xa4: goto state1a6;
		case 0xa5: goto state1a8;
		case 0xa6: goto state1aa;
		case 0xa7: goto state1ac;
		case 0xa8: goto state19e;
		case 0xa9: goto state1a0;
		case 0xaa: goto state1a2;
		case 0xab: goto state1a4;
		case 0xac: goto state1a6;
		case 0xad: goto state1a8;
		case 0xae: goto state1aa;
		case 0xaf: goto state1ac;
		case 0xb2: goto state1b8;
		case 0xba: goto statea1;
		case 0xbb: goto statea2;
		default: goto no_match;
	}
state1af:
	switch (*(str1++)){
		case 0xa0: goto state1b0;
		case 0xa1: goto state1b1;
		case 0xa2: goto state1b2;
		case 0xa3: goto state1b3;
		case 0xa4: goto state1b4;
		case 0xa5: goto state1b5;
		case 0xa6: goto state1b6;
		case 0xa7: goto state1b7;
		case 0xb0: goto state1b9;
		case 0xb1: goto stateac;
		default: goto no_match;
	}
state1b0:
	switch (*(str2++)){
		case 0xa0: goto state18d;
		case 0xa8: goto state18d;
		default: goto no_match;
	}
state1b1:
	switch (*(str2++)){
		case 0xa1: goto state18d;
		case 0xa9: goto state18d;
		default: goto no_match;
	}
state1b2:
	switch (*(str2++)){
		case 0xa2: goto state18d;
		case 0xaa: goto state18d;
		default: goto no_match;
	}
state1b3:
	switch (*(str2++)){
		case 0xa3: goto state18d;
		case 0xab: goto state18d;
		default: goto no_match;
	}
state1b4:
	switch (*(str2++)){
		case 0xa4: goto state18d;
		case 0xac: goto state18d;
		default: goto no_match;
	}
state1b5:
	switch (*(str2++)){
		case 0xa5: goto state18d;
		case 0xad: goto state18d;
		default: goto no_match;
	}
state1b6:
	switch (*(str2++)){
		case 0xa6: goto state18d;
		case 0xae: goto state18d;
		default: goto no_match;
	}
state1b7:
	switch (*(str2++)){
		case 0xa7: goto state18d;
		case 0xaf: goto state18d;
		default: goto no_match;
	}
state1b8:
	switch (*(str2++)){
		case 0xb0: goto state18a;
		default: goto no_match;
	}
state1b9:
	switch (*(str2++)){
		case 0xb2: goto state18d;
		case 0xba: goto state2;
		default: goto no_match;
	}
state1ba:
	switch (*(str1++)){
		case 0xbe: goto state1bb;
		case 0xbf: goto state1cf;
		default: goto no_match;
	}
state1bb:
	switch (*(str2++)){
		case 0xac: goto state1c1;
		case 0xb1: goto state1bc;
		case 0xb9: goto state1c8;
		default: goto no_match;
	}
state1bc:
	switch (*(str1++)){
		case 0xb3: goto state18a;
		case 0xb6: goto state184;
		case 0xb7: goto state1c6;
		case 0xbc: goto state18a;
		default: goto no_match;
	}
state1bd:
	switch (*(str1++)){
		case 0xac: goto state1c2;
		case 0xae: goto state1d5;
		case 0xb1: goto state1be;
		case 0xb7: goto state1d1;
		case 0xb9: goto state1c9;
		default: goto no_match;
	}
state1be:
	switch (*(str2++)){
		case 0xbe: goto state1bf;
		default: goto no_match;
	}
state1bf:
	switch (*(str1++)){
		case 0xcd: goto state1c5;
		case 0xce: goto state1c0;
		default: goto no_match;
	}
state1c0:
	switch (*(str2++)){
		case 0xb3: goto state18e;
		case 0xbc: goto state18e;
		default: goto no_match;
	}
state1c1:
	switch (*(str1++)){
		case 0xb4: goto state18a;
		default: goto no_match;
	}
state1c2:
	switch (*(str2++)){
		case 0xbe: goto state1c3;
		default: goto no_match;
	}
state1c3:
	switch (*(str1++)){
		case 0xce: goto state1c4;
		default: goto no_match;
	}
state1c4:
	switch (*(str2++)){
		case 0xb4: goto state18e;
		default: goto no_match;
	}
state1c5:
	switch (*(str2++)){
		case 0xb6: goto state144;
		case 0xb7: goto state1c7;
		default: goto no_match;
	}
state1c6:
	switch (*(str2++)){
		case 0xcd: goto state191;
		default: goto no_match;
	}
state1c7:
	switch (*(str1++)){
		case 0x82: goto state18d;
		default: goto no_match;
	}
state1c8:
	switch (*(str1++)){
		case 0xbe: goto state2;
		default: goto no_match;
	}
state1c9:
	switch (*(str2++)){
		case 0xbe: goto stateaf;
		case 0xbf: goto state1dd;
		default: goto no_match;
	}
state1ca:
	switch (*(str2++)){
		case 0xbd: goto state1cb;
		case 0xbf: goto state1d9;
		default: goto no_match;
	}
state1cb:
	switch (*(str1++)){
		case 0x82: goto state1cc;
		case 0x88: goto statea3;
		case 0x89: goto statea4;
		case 0x8a: goto statea5;
		case 0x8b: goto statea6;
		case 0x9a: goto statea7;
		case 0x9b: goto statea8;
		case 0xaa: goto stateab;
		case 0xab: goto stateac;
		case 0xb2: goto state1ed;
		case 0xb8: goto statea9;
		case 0xb9: goto stateaa;
		case 0xba: goto statead;
		case 0xbb: goto stateae;
		default: goto no_match;
	}
state1cc:
	switch (*(str2++)){
		case 0xb4: goto state18a;
		default: goto no_match;
	}
state1cd:
	switch (*(str1++)){
		case 0xb2: goto state79;
		case 0xb3: goto state7a;
		case 0xb4: goto state1ce;
		case 0xb5: goto state7c;
		case 0xb6: goto state8b;
		case 0xb7: goto state8c;
		case 0xb8: goto statea9;
		case 0xb9: goto stateaa;
		case 0xba: goto state9b;
		case 0xbb: goto state9c;
		case 0xbc: goto state1b9;
		case 0xbd: goto stateac;
		default: goto no_match;
	}
state1ce:
	switch (*(str2++)){
		case 0x82: goto state18d;
		case 0x8a: goto state2;
		default: goto no_match;
	}
state1cf:
	switch (*(str2++)){
		case 0xae: goto state1d4;
		case 0xb7: goto state1d0;
		case 0xb9: goto state1da;
		default: goto no_match;
	}
state1d0:
	switch (*(str1++)){
		case 0x83: goto state18a;
		case 0x86: goto state184;
		case 0x87: goto state1c6;
		case 0x8c: goto state18a;
		default: goto no_match;
	}
state1d1:
	switch (*(str2++)){
		case 0xbf: goto state1d2;
		default: goto no_match;
	}
state1d2:
	switch (*(str1++)){
		case 0xcd: goto state1d8;
		case 0xce: goto state1d3;
		default: goto no_match;
	}
state1d3:
	switch (*(str2++)){
		case 0x83: goto state18e;
		case 0x8c: goto state18e;
		default: goto no_match;
	}
state1d4:
	switch (*(str1++)){
		case 0x84: goto state18a;
		default: goto no_match;
	}
state1d5:
	switch (*(str2++)){
		case 0xbf: goto state1d6;
		default: goto no_match;
	}
state1d6:
	switch (*(str1++)){
		case 0xce: goto state1d7;
		default: goto no_match;
	}
state1d7:
	switch (*(str2++)){
		case 0x84: goto state18e;
		default: goto no_match;
	}
state1d8:
	switch (*(str2++)){
		case 0x86: goto state144;
		case 0x87: goto state1c7;
		default: goto no_match;
	}
state1d9:
	switch (*(str1++)){
		case 0x83: goto state7d;
		case 0x8c: goto state74;
		case 0x90: goto state89;
		case 0x91: goto state8a;
		case 0x98: goto state81;
		case 0x99: goto state82;
		case 0xa0: goto state99;
		case 0xa1: goto state9a;
		case 0xa5: goto state9d;
		case 0xa8: goto state91;
		case 0xa9: goto state92;
		case 0xac: goto state96;
		case 0xb3: goto statead;
		case 0xbc: goto statea4;
		default: goto no_match;
	}
state1da:
	switch (*(str1++)){
		case 0x92: goto state1db;
		case 0x93: goto state12f;
		case 0x96: goto state184;
		case 0x97: goto state1e1;
		default: goto no_match;
	}
state1db:
	switch (*(str2++)){
		case 0xcc: goto state1dc;
		default: goto no_match;
	}
state1dc:
	switch (*(str2++)){
		case 0x88: goto state17b;
		default: goto no_match;
	}
state1dd:
	switch (*(str1++)){
		case 0xcc: goto state1de;
		case 0xcd: goto state1e0;
		default: goto no_match;
	}
state1de:
	switch (*(str2++)){
		case 0x92: goto state1df;
		case 0x93: goto state134;
		case 0x97: goto state1e3;
		default: goto no_match;
	}
state1df:
	switch (*(str1++)){
		case 0x88: goto state17d;
		default: goto no_match;
	}
state1e0:
	switch (*(str2++)){
		case 0x96: goto state144;
		default: goto no_match;
	}
state1e1:
	switch (*(str2++)){
		case 0xcc: goto state1e2;
		default: goto no_match;
	}
state1e2:
	switch (*(str2++)){
		case 0x88: goto state184;
		default: goto no_match;
	}
state1e3:
	switch (*(str1++)){
		case 0x88: goto state186;
		default: goto no_match;
	}
state1e4:
	switch (*(str2++)){
		case 0x81: goto state1e8;
		case 0x85: goto state1e5;
		case 0x89: goto state1bc;
		case 0x8e: goto state1c1;
		default: goto no_match;
	}
state1e5:
	switch (*(str1++)){
		case 0xa2: goto state1db;
		case 0xa3: goto state12f;
		case 0xa6: goto state184;
		case 0xa7: goto state1e1;
		default: goto no_match;
	}
state1e6:
	switch (*(str1++)){
		case 0xcc: goto state1e7;
		case 0xcd: goto state1ec;
		default: goto no_match;
	}
state1e7:
	switch (*(str2++)){
		case 0xa2: goto state1df;
		case 0xa3: goto state134;
		case 0xa7: goto state1e3;
		default: goto no_match;
	}
state1e8:
	switch (*(str1++)){
		case 0xa4: goto state173;
		default: goto no_match;
	}
state1e9:
	switch (*(str2++)){
		case 0xbf: goto state1ea;
		default: goto no_match;
	}
state1ea:
	switch (*(str1++)){
		case 0xcc: goto state1eb;
		default: goto no_match;
	}
state1eb:
	switch (*(str2++)){
		case 0xa4: goto state178;
		default: goto no_match;
	}
state1ec:
	switch (*(str2++)){
		case 0xa6: goto state144;
		default: goto no_match;
	}
state1ed:
	switch (*(str2++)){
		case 0xbc: goto state18a;
		default: goto no_match;
	}
state1ee:
	switch (*(str2++)){
		case 0xbf: goto state1bf;
		default: goto no_match;
	}
state1ef:
	switch (*(str2++)){
		case 0xbf: goto state1c3;
		default: goto no_match;
	}
state1f0:
	switch (*(str1++)){
		case 0x84: goto state1f1;
		default: goto no_match;
	}
state1f1:
	switch (*(str2++)){
		case 0x89: goto state1f2;
		default: goto no_match;
	}
state1f2:
	switch (*(str1++)){
		case 0xa6: goto state2;
		default: goto no_match;
	}
state1f3:
	switch (*(str1++)){
		case 0x89: goto state1f4;
		default: goto no_match;
	}
state1f4:
	switch (*(str2++)){
		case 0x84: goto state97;
		default: goto no_match;
	}
state1f5:
	switch (*(str1++)){
		case 0x84: goto state1f6;
		default: goto no_match;
	}
state1f6:
	switch (*(str1++)){
		case 0xaa: goto state2;
		default: goto no_match;
	}
state1f7:
	switch (*(str2++)){
		case 0x84: goto state9b;
		default: goto no_match;
	}
state1f8:
	switch (*(str1++)){
		case 0x84: goto state1f9;
		default: goto no_match;
	}
state1f9:
	switch (*(str2++)){
		case 0xa5: goto state1fa;
		default: goto no_match;
	}
state1fa:
	switch (*(str1++)){
		case 0xab: goto state2;
		default: goto no_match;
	}
state1fb:
	switch (*(str1++)){
		case 0xa5: goto state1fc;
		default: goto no_match;
	}
state1fc:
	switch (*(str2++)){
		case 0x84: goto state9c;
		default: goto no_match;
	}
state1fd:
	switch (*(str2++)){
		case 0x85: goto state1fe;
		default: goto no_match;
	}
state1fe:
	switch (*(str1++)){
		case 0xa0: goto statea1;
		case 0xa1: goto statea2;
		case 0xa2: goto statea3;
		case 0xa3: goto statea4;
		case 0xa4: goto statea5;
		case 0xa5: goto statea6;
		case 0xa6: goto statea7;
		case 0xa7: goto statea8;
		case 0xa8: goto statea9;
		case 0xa9: goto stateaa;
		case 0xaa: goto stateab;
		case 0xab: goto stateac;
		case 0xac: goto statead;
		case 0xad: goto stateae;
		case 0xae: goto stateaf;
		case 0xaf: goto stateb0;
		case 0xb0: goto state91;
		case 0xb1: goto state92;
		case 0xb2: goto state93;
		case 0xb3: goto state94;
		case 0xb4: goto state95;
		case 0xb5: goto state96;
		case 0xb6: goto state97;
		case 0xb7: goto state98;
		case 0xb8: goto state99;
		case 0xb9: goto state9a;
		case 0xba: goto state9b;
		case 0xbb: goto state9c;
		case 0xbc: goto state9d;
		case 0xbd: goto state9e;
		case 0xbe: goto state9f;
		case 0xbf: goto statea0;
		default: goto no_match;
	}
state1ff:
	switch (*(str2++)){
		case 0x93: goto state200;
		default: goto no_match;
	}
state200:
	switch (*(str1++)){
		case 0xb6: goto state81;
		case 0xb7: goto state82;
		case 0xb8: goto state83;
		case 0xb9: goto state84;
		case 0xba: goto state85;
		case 0xbb: goto state86;
		case 0xbc: goto state87;
		case 0xbd: goto state88;
		case 0xbe: goto state89;
		case 0xbf: goto state8a;
		default: goto no_match;
	}
state201:
	switch (*(str2++)){
		case 0x92: goto state202;
		case 0x93: goto state203;
		default: goto no_match;
	}
state202:
	switch (*(str1++)){
		case 0x90: goto statea7;
		case 0x91: goto statea8;
		case 0x92: goto statea9;
		case 0x93: goto stateaa;
		case 0x94: goto stateab;
		case 0x95: goto stateac;
		case 0x96: goto statead;
		case 0x97: goto stateae;
		case 0x98: goto stateaf;
		case 0x99: goto stateb0;
		default: goto no_match;
	}
state203:
	switch (*(str1++)){
		case 0x80: goto state8b;
		case 0x81: goto state8c;
		case 0x82: goto state8d;
		case 0x83: goto state8e;
		case 0x84: goto state8f;
		case 0x85: goto state90;
		case 0x86: goto state91;
		case 0x87: goto state92;
		case 0x88: goto state93;
		case 0x89: goto state94;
		case 0x8a: goto state95;
		case 0x8b: goto state96;
		case 0x8c: goto state97;
		case 0x8d: goto state98;
		case 0x8e: goto state99;
		case 0x8f: goto state9a;
		case 0x9a: goto state71;
		case 0x9b: goto state72;
		case 0x9c: goto state73;
		case 0x9d: goto state74;
		case 0x9e: goto state75;
		case 0x9f: goto state76;
		case 0xa0: goto state77;
		case 0xa1: goto state78;
		case 0xa2: goto state79;
		case 0xa3: goto state7a;
		case 0xa4: goto state7b;
		case 0xa5: goto state7c;
		case 0xa6: goto state7d;
		case 0xa7: goto state7e;
		case 0xa8: goto state7f;
		case 0xa9: goto state80;
		default: goto no_match;
	}
state204:
	switch (*(str1++)){
		case 0xac: goto state205;
		default: goto no_match;
	}
state205:
	switch (*(str2++)){
		case 0x66: goto state206;
		case 0x69: goto state136;
		case 0x6c: goto state144;
		default: goto no_match;
	}
state206:
	switch (*(str1++)){
		case 0x80: goto state2;
		case 0x83: goto state20c;
		case 0x84: goto state20d;
		default: goto no_match;
	}
state207:
	switch (*(str1++)){
		case 0x66: goto state208;
		case 0x69: goto state20a;
		case 0x6c: goto state20b;
		default: goto no_match;
	}
state208:
	switch (*(str2++)){
		case 0xac: goto state209;
		default: goto no_match;
	}
state209:
	switch (*(str1++)){
		case 0x69: goto state74;
		case 0x6c: goto state75;
	}
	--str1;
	switch (*(str2++)){
		case 0x80: goto state2;
		default: goto no_match;
	}
state20a:
	switch (*(str2++)){
		case 0xac: goto state72;
		default: goto no_match;
	}
state20b:
	switch (*(str2++)){
		case 0xac: goto state73;
		default: goto no_match;
	}
state20c:
	switch (*(str2++)){
		case 0x69: goto state2;
		default: goto no_match;
	}
state20d:
	switch (*(str2++)){
		case 0x6c: goto state2;
		default: goto no_match;
	}
state20e:
	switch (*(str1++)){
		case 0xac: goto state20f;
		default: goto no_match;
	}
state20f:
	switch (*(str2++)){
		case 0x74: goto state210;
		default: goto no_match;
	}
state210:
	switch (*(str1++)){
		case 0x85: goto state2;
		case 0x86: goto state2;
		default: goto no_match;
	}
state211:
	switch (*(str1++)){
		case 0x74: goto state212;
		default: goto no_match;
	}
state212:
	switch (*(str2++)){
		case 0xac: goto state213;
		default: goto no_match;
	}
state213:
	switch (*(str2++)){
		case 0x85: goto state2;
		case 0x86: goto state2;
		default: goto no_match;
	}
state214:
	switch (*(str1++)){
		case 0xac: goto state215;
		default: goto no_match;
	}
state215:
	switch (*(str2++)){
		case 0xb4: goto state216;
		case 0xbe: goto state220;
		default: goto no_match;
	}
state216:
	switch (*(str1++)){
		case 0x93: goto state217;
		case 0x94: goto state21d;
		case 0x95: goto state21f;
		case 0x97: goto state224;
		default: goto no_match;
	}
state217:
	switch (*(str2++)){
		case 0xd5: goto statea7;
		default: goto no_match;
	}
state218:
	switch (*(str1++)){
		case 0xb4: goto state219;
		case 0xbe: goto state221;
		default: goto no_match;
	}
state219:
	switch (*(str2++)){
		case 0xac: goto state21a;
		default: goto no_match;
	}
state21a:
	switch (*(str1++)){
		case 0xd5: goto state21b;
		default: goto no_match;
	}
state21b:
	switch (*(str2++)){
		case 0x93: goto state21c;
		case 0x94: goto state21e;
		case 0x95: goto state1fa;
		case 0x97: goto state225;
		default: goto no_match;
	}
state21c:
	switch (*(str1++)){
		case 0xb6: goto state2;
		default: goto no_match;
	}
state21d:
	switch (*(str2++)){
		case 0xd5: goto state96;
		default: goto no_match;
	}
state21e:
	switch (*(str1++)){
		case 0xa5: goto state2;
		default: goto no_match;
	}
state21f:
	switch (*(str2++)){
		case 0xd5: goto state9c;
		default: goto no_match;
	}
state220:
	switch (*(str1++)){
		case 0x96: goto state217;
		default: goto no_match;
	}
state221:
	switch (*(str2++)){
		case 0xac: goto state222;
		default: goto no_match;
	}
state222:
	switch (*(str1++)){
		case 0xd5: goto state223;
		default: goto no_match;
	}
state223:
	switch (*(str2++)){
		case 0x96: goto state21c;
		default: goto no_match;
	}
state224:
	switch (*(str2++)){
		case 0xd5: goto state9e;
		default: goto no_match;
	}
state225:
	switch (*(str1++)){
		case 0xad: goto state2;
		default: goto no_match;
	}
state226:
	switch (*(str2++)){
		case 0xbd: goto state227;
		default: goto no_match;
	}
state227:
	switch (*(str1++)){
		case 0xa1: goto state72;
		case 0xa2: goto state73;
		case 0xa3: goto state74;
		case 0xa4: goto state75;
		case 0xa5: goto state76;
		case 0xa6: goto state77;
		case 0xa7: goto state78;
		case 0xa8: goto state79;
		case 0xa9: goto state7a;
		case 0xaa: goto state7b;
		case 0xab: goto state7c;
		case 0xac: goto state7d;
		case 0xad: goto state7e;
		case 0xae: goto state7f;
		case 0xaf: goto state80;
		case 0xb0: goto state81;
		case 0xb1: goto state82;
		case 0xb2: goto state83;
		case 0xb3: goto state84;
		case 0xb4: goto state85;
		case 0xb5: goto state86;
		case 0xb6: goto state87;
		case 0xb7: goto state88;
		case 0xb8: goto state89;
		case 0xb9: goto state8a;
		case 0xba: goto state8b;
		default: goto no_match;
	}
state228:
	switch (*(str2++)){
		case 0xbc: goto state229;
		default: goto no_match;
	}
state229:
	switch (*(str1++)){
		case 0x81: goto state92;
		case 0x82: goto state93;
		case 0x83: goto state94;
		case 0x84: goto state95;
		case 0x85: goto state96;
		case 0x86: goto state97;
		case 0x87: goto state98;
		case 0x88: goto state99;
		case 0x89: goto state9a;
		case 0x8a: goto state9b;
		case 0x8b: goto state9c;
		case 0x8c: goto state9d;
		case 0x8d: goto state9e;
		case 0x8e: goto state9f;
		case 0x8f: goto statea0;
		case 0x90: goto statea1;
		case 0x91: goto statea2;
		case 0x92: goto statea3;
		case 0x93: goto statea4;
		case 0x94: goto statea5;
		case 0x95: goto statea6;
		case 0x96: goto statea7;
		case 0x97: goto statea8;
		case 0x98: goto statea9;
		case 0x99: goto stateaa;
		case 0x9a: goto stateab;
		default: goto no_match;
	}
state22a:
	switch (*(str2++)){
		case 0x90: goto state22b;
		default: goto no_match;
	}
state22b:
	switch (*(str1++)){
		case 0x90: goto state22c;
		case 0x91: goto state22f;
		default: goto no_match;
	}
state22c:
	switch (*(str2++)){
		case 0x90: goto state22d;
		case 0x91: goto state22e;
		default: goto no_match;
	}
state22d:
	switch (*(str1++)){
		case 0x80: goto state99;
		case 0x81: goto state9a;
		case 0x82: goto state9b;
		case 0x83: goto state9c;
		case 0x84: goto state9d;
		case 0x85: goto state9e;
		case 0x86: goto state9f;
		case 0x87: goto statea0;
		case 0x88: goto statea1;
		case 0x89: goto statea2;
		case 0x8a: goto statea3;
		case 0x8b: goto statea4;
		case 0x8c: goto statea5;
		case 0x8d: goto statea6;
		case 0x8e: goto statea7;
		case 0x8f: goto statea8;
		case 0x90: goto statea9;
		case 0x91: goto stateaa;
		case 0x92: goto stateab;
		case 0x93: goto stateac;
		case 0x94: goto statead;
		case 0x95: goto stateae;
		case 0x96: goto stateaf;
		case 0x97: goto stateb0;
		case 0xa8: goto state71;
		case 0xa9: goto state72;
		case 0xaa: goto state73;
		case 0xab: goto state74;
		case 0xac: goto state75;
		case 0xad: goto state76;
		case 0xae: goto state77;
		case 0xaf: goto state78;
		case 0xb0: goto state79;
		case 0xb1: goto state7a;
		case 0xb2: goto state7b;
		case 0xb3: goto state7c;
		case 0xb4: goto state7d;
		case 0xb5: goto state7e;
		case 0xb6: goto state7f;
		case 0xb7: goto state80;
		case 0xb8: goto state81;
		case 0xb9: goto state82;
		case 0xba: goto state83;
		case 0xbb: goto state84;
		case 0xbc: goto state85;
		case 0xbd: goto state86;
		case 0xbe: goto state87;
		case 0xbf: goto state88;
		default: goto no_match;
	}
state22e:
	switch (*(str1++)){
		case 0x98: goto state71;
		case 0x99: goto state72;
		case 0x9a: goto state73;
		case 0x9b: goto state74;
		case 0x9c: goto state75;
		case 0x9d: goto state76;
		case 0x9e: goto state77;
		case 0x9f: goto state78;
		case 0xa0: goto state79;
		case 0xa1: goto state7a;
		case 0xa2: goto state7b;
		case 0xa3: goto state7c;
		case 0xa4: goto state7d;
		case 0xa5: goto state7e;
		case 0xa6: goto state7f;
		case 0xa7: goto state80;
		default: goto no_match;
	}
state22f:
	switch (*(str2++)){
		case 0x90: goto state230;
		default: goto no_match;
	}
state230:
	switch (*(str1++)){
		case 0x80: goto state89;
		case 0x81: goto state8a;
		case 0x82: goto state8b;
		case 0x83: goto state8c;
		case 0x84: goto state8d;
		case 0x85: goto state8e;
		case 0x86: goto state8f;
		case 0x87: goto state90;
		case 0x88: goto state91;
		case 0x89: goto state92;
		case 0x8a: goto state93;
		case 0x8b: goto state94;
		case 0x8c: goto state95;
		case 0x8d: goto state96;
		case 0x8e: goto state97;
		case 0x8f: goto state98;
		default: goto no_match;
	}
}

} // end namespace UTF8Utils
} // end namespace OW_NAMESPACE

