<?
/*	weatherstation.php  - part of the open2300 package
 *
 *	Version 1.4 - multilingual version of 1.3
 *
 *	Control WS2300 weather station
 *
 *	Copyright 2003,2004, Kenneth Lavrsen
 *	v. 1.4 additional copyright 2004, Ralf Winkler
 *	This program is published under the GNU Public license
 */

// Get the language of the browser 
if ($_GET["language"] == "")
{
	if(isset($HTTP_SERVER_VARS["HTTP_ACCEPT_LANGUAGE"]))
	{
		if(strpos($HTTP_SERVER_VARS["HTTP_ACCEPT_LANGUAGE"],"-") === false)
			$language = $HTTP_SERVER_VARS["HTTP_ACCEPT_LANGUAGE"];
		else
			list($language) = explode ("-", $HTTP_SERVER_VARS["HTTP_ACCEPT_LANGUAGE"]);
	}
}

// if language is not available, set language to english
if (file_exists("text_".strtolower($language).".inc.php") == false)
{
	$language = "en";
}

// Read Texts from the Languagefile
require_once("text_".strtolower($language).".inc.php");

exec("/usr/local/bin/fetch2300",$fetcharray);

foreach ($fetcharray as $value)
{
	list($parameter,$parvalue)=explode(" ", $value);
	$ws["$parameter"]=$parvalue;
}
$forecastpic= strtolower($ws["Forecast"]) . ".jpg";
$tendencypic= strtolower($ws["Tendency"]) . ".png";

?>

<html>

<head>
<title><?=$title?></title>
<META HTTP-EQUIV="Expires" CONTENT="Tue, 01 Jan 1980 1:00:00 GMT">  
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">  
<META HTTP-EQUIV="Refresh" CONTENT="60">  
</head>

<body bgcolor="honeydew" text="black" link="blue" vlink="purple" alink="red">

<h1 align="center"><?=$title?></h1>
<p align="center">
<?
  $langlist = "";
  // List available Languagefiles
  $d = dir(".");
  while($entry=$d->read()) {
    if ((substr($entry,0,5) == "text_") && substr($entry,strlen($entry)-8,8)) {
		  $langlist .= "<a href=\"".$PHP_SELF."?language=".substr($entry,5,strlen($entry)-13)."\">[".substr($entry,5,strlen($entry)-13)."]</a> | ";
		}	
  }
  $d->close();
	echo substr($langlist,0,strlen($langlist)-3)."<br>\n";
?>
</p>
<table border="3" width="700" align="center" bgcolor="ivory">
  <tr>
    <td width="100%">
      <table border="0" cellpadding="0" cellspacing="0" width=100%">
        <tr>

            <td width="55%" valign="top">
                <table border="1" width="100%">
                    <tr>
                        <td width="50%" height="170" valign="top">
                            <center><b><?=$ws["Time"]?>&nbsp;&nbsp;<?=$ws["Date"]?></b></center><br>
                            <img src="<?=$forecastpic?>" align="left">
                            <br><?=$Forecast?>: <?=$ForecastArr[$ws["Forecast"]]?><br><br>
                            <?=$Tendency?>: <?=$TendencyArr[$ws["Tendency"]]?> <img src="<?=$tendencypic?>" align="middle">
                        </td>
                         </td>
                        <td width="50%" height="170" valign="top">
                            <?=$RP?>
                            <p align="center"><font size="5"><?=number_format($ws["RP"],1,'.','')?> <?=$PressureUnit?></font></p>
                            <p><font size="2"><?=$Minimum?>: <?=number_format($ws["RPmin"],1,'.','')?> <?=$PressureUnit?></font><br>
                               <font size="2"><center><?=$ws["TRPmin"]?> <?=$ws["DRPmin"]?></center></font>
                            <p><font size="2"><?=$Maximum?>: <?=number_format($ws["RPmax"],1,'.','')?> <?=$PressureUnit?></font><br>
                               <font size="2"><center><?=$ws["TRPmax"]?> <?=$ws["DRPmax"]?></center></font>
                        </td>
                    <tr>
                </table>
                <table border="1" width="100%">
                    <tr>
                        <td width="50%" height="170" valign="top">
                            <p><?=$WS?></p>
                            <p align="center"><font size="5"><?=$ws["WS"]?> <?=$SpeedUnit?></font></p>
                            <p><font size="2"><?=$Minimum?>: <?=$ws["WSmin"]?> <?=$SpeedUnit?></font><br>
                               <font size="2"><center><?=$ws["TWSmin"]?> <?=$ws["DWSmin"]?></center></font>
                            <p><font size="2"><?=$Maximum?>: <?=$ws["WSmax"]?> <?=$SpeedUnit?></font><br>
                               <font size="2"><center><?=$ws["TWSmax"]?> <?=$ws["DWSmax"]?></center></font>
                         </td>
                        <td width="50%" height="170" valign="top">
                            <p><?=$DIRtext?></p>
                            <p align="center"><font size="5"><?=$DirectionArr[$ws["DIRtext"]]?></font><br><font size="5"><?=$ws["DIR0"]?> <?=$DirUnit?></font></p>
                            <p><font size="2"><?=$DIRtext5last?><br>
                               <center><?=$ws["DIR1"]?> <?=$DirUnit?>, <?=$ws["DIR2"]?> <?=$DirUnit?>, <?=$ws["DIR3"]?> <?=$DirUnit?>,<br>
                               <?=$ws["DIR4"]?> <?=$DirUnit?>, <?=$ws["DIR5"]?> <?=$DirUnit?></center></font>
                        </td>
                    <tr>
                </table>
                <table border="1" width="100%">
                    <tr>
                        <td width="33%" height="190" valign="top">
                            <p><?=$Rtot?></p>
                            <p align="center"><font size="5"><?=number_format($ws["Rtot"],1,'.','')?> <?=$RainUnit?></font></p>
                            <p><br><font size="2"><?=$Rtotsince?>:</font><br>
                                   <font size="2"><center><?=$ws["TRtot"]?> <?=$ws["DRtot"]?></center></font>
                         </td>
                        <td width="33%" height="190" valign="top">
                            <p><?=$R24h?></p>
                            <p align="center"><font size="5"><?=number_format($ws["R24h"],1,'.','')?> <?=$RainUnit?></font></p>
                            <p><br><font size="2"><?=$Maximum?>: <?=number_format($ws["R24hmax"],1,'.','')?> <?=$RainUnit?></font><br>
                                   <font size="2"><center><?=$ws["TR24hmax"]?> <?=$ws["DR24hmax"]?></center></font>
                         </td>
                         <td width="33%" height="190" valign="top">
                            <p><?=$R1h?></p>
                            <p align="center"><font size="5"><?=number_format($ws["R1h"],1,'.','')?> <?=$RainUnit?></font></p>
                            <p><br><font size="2"><?=$Maximum?>: <?=number_format($ws["R1hmax"],1,'.','')?> <?=$RainUnit?></font><br>
                                   <font size="2"><center><?=$ws["TR1hmax"]?> <?=$ws["DR1hmax"]?></center></font>
                        </td>
                    <tr>
                </table>

            </td>
            <td width="45%" valign="top">
                <table border="1" width="100%">
                    <tr>
                        <td width="50%" height="170" valign="top">
                            <p><?=$Ti?></p>
                            <p align="center"><font size="5"><?=$ws["Ti"]?> <?=$TempUnit?></font></p>
                            <p><font size="2"><?=$Minimum?>: <?=$ws["Timin"]?> <?=$TempUnit?></font><br>
                               <font size="2"><center><?=$ws["TTimin"]?> <?=$ws["DTimin"]?></center></font>
                            <p><font size="2"><?=$Maximum?>: <?=$ws["Timax"]?> <?=$TempUnit?></font><br>
                               <font size="2"><center><?=$ws["TTimax"]?> <?=$ws["DTimax"]?></center></font>
                         </td>
                        <td width="50%" height="170" valign="top">
                            <p><?=$To?></p>
                            <p align="center"><font size="5"><?=$ws["To"]?> <?=$TempUnit?></font></p>
                            <p><font size="2"><?=$Minimum?>: <?=$ws["Tomin"]?> <?=$TempUnit?></font><br>
                               <font size="2"><center><?=$ws["TTomin"]?> <?=$ws["DTomin"]?></center></font>
                            <p><font size="2"><?=$Maximum?>: <?=$ws["Tomax"]?> <?=$TempUnit?></font><br>
                               <font size="2"><center><?=$ws["TTomax"]?> <?=$ws["DTomax"]?></center></font>
                        </td>
                    <tr>
                </table>
                <table border="1" width="100%">
                    <tr>
                        <td width="50%" height="170" valign="top">
                            <p><?=$DP?></p>
                            <p align="center"><font size="5"><?=$ws["DP"]?> <?=$TempUnit?></font></p>
                            <p><font size="2"><?=$Minimum?>: <?=$ws["DPmin"]?> <?=$TempUnit?></font><br>
                               <font size="2"><center><?=$ws["TDPmin"]?> <?=$ws["DDPmin"]?></center></font>
                            <p><font size="2"><?=$Maximum?>: <?=$ws["DPmax"]?> <?=$TempUnit?></font><br>
                               <font size="2"><center><?=$ws["TDPmax"]?> <?=$ws["DDPmax"]?></center></font>
                        </td>
                        <td width="50%" height="170" valign="top">
                            <p><?=$WC?></p>
                            <p align="center"><font size="5"><?=$ws["WC"]?> <?=$TempUnit?></font></p>
                            <p><font size="2"><?=$Minimum?>: <?=$ws["WCmin"]?> <?=$TempUnit?></font><br>
                               <font size="2"><center><?=$ws["TWCmin"]?> <?=$ws["DWCmin"]?></center></font>
                            <p><font size="2"><?=$Maximum?>: <?=$ws["WCmax"]?> <?=$TempUnit?></font><br>
                               <font size="2"><center><?=$ws["TWCmax"]?> <?=$ws["DWCmax"]?></center></font>
                          </td>
                    <tr>
                </table>
                <table border="1" width="100%">
                    <tr>
                        <td width="50%" height="190" valign="top">
                            <p><?=$RHi?></p>
                            <p align="center"><font size="5"><?=$ws["RHi"]?> <?=$Percent?></font></p>
                            <p><font size="2"><?=$Minimum?>: <?=$ws["RHimin"]?> <?=$Percent?></font><br>
                               <font size="2"><center><?=$ws["TRHimin"]?> <?=$ws["DRHimin"]?></center></font>
                            <p><font size="2"><?=$Maximum?>: <?=$ws["RHimax"]?> <?=$Percent?></font><br>
                               <font size="2"><center><?=$ws["TRHimax"]?> <?=$ws["DRHimax"]?></center></font>
                         </td>
                        <td width="50%" height="190" valign="top">
                            <p><?=$RHo?></p>
                            <p align="center"><font size="5"><?=$ws["RHo"]?> <?=$Percent?></font></p>
                            <p><font size="2"><?=$Minimum?>: <?=$ws["RHomin"]?> <?=$Percent?></font><br>
                               <font size="2"><center><?=$ws["TRHomin"]?> <?=$ws["DRHomin"]?></center></font>
                            <p><font size="2"><?=$Maximum?>: <?=$ws["RHomax"]?> <?=$Percent?></font><br>
                               <font size="2"><center><?=$ws["TRHomax"]?> <?=$ws["DRHomax"]?></center></font>
                        </td>
                    <tr>
                </table>
            </td>

        </tr>
      </table>
    </td>
  </tr>
</table>
<p align="center"><?=$Footer?></p>
<p>
<p align="center"><a href="index.htm">[<?=$Link1?>]</a> <a href="weathergraphs.php?language=<?=$language?>">[<?=$Link2?>]</a> 
<a href="phpweather/index.php?icao=EKCH&language=<?=$language?>">[<?=$Link3?>]</a> <a href="/">[<?=$Link4?>]</a></p>
</body>

</html>
