#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <regex.h>
#include <ctype.h>
#include "oak.h"

int oak_text_trim_string_by_lines(char *instr, char *outstr, int lines)
{
  /* space must be allocated for outstr */
  int i, good;
  char *ptr, *ptr2;

  good=0;
  ptr2=instr;
  for (i=0; i<lines; i++) {
    ptr=strchr(ptr2, '\n');
    if (!ptr) {
      good=1;
      break;
    }
    ptr2=ptr+1;
  }

  strcpy(outstr, instr);

  if (!good) {
    outstr[ptr2-instr]='\0';
    return(1);
  }
  return(0);
}

/* Replace all the substituion sections of the regex with "newstr".
 */
void oak_text_replace_string_sections(char *in, regmatch_t pmatch[], char *out, char *newstr)
{
  int len, i, j, outptr, lock, newstrlen;
  char *mask;

   /* The way we'll do this is: set up a mask of the characters in
   * instr.  A 1 in the mask means to carry the character through, a 0
   * means it shouldn't be carried through.  Then we'll create the
   * output string by replacing contiguous sections of 0's with
   * "newstr"
   */

  newstrlen=strlen(newstr);
  
  /* mask */
  len=strlen(in);
  mask=malloc((sizeof(int)*len)+20);
  /* initialize everything to OK (1) */
  for (i=0; i<len; i++) {
    mask[i]='1';
  }
  /* set substitutions to not OK (0) */
  for (i=1; i<15; i++) { /* skip 0 */
    if ((pmatch[i].rm_so != -1) && (pmatch[i].rm_eo != -1)) {
      for (j=pmatch[i].rm_so; j<pmatch[i].rm_eo; j++) {
	mask[j]='0';
      }
    }
  }

  /* create the output string, i.e. do the newchar */
  outptr=0;
  lock=0;
  for (i=0; i<len; i++) {
    if (mask[i] == '1') {
      out[outptr]=in[i];
      outptr++;
      lock=0;
    } else {
      if (!lock) {
	for (j=0; j<newstrlen; j++) {
	  out[outptr+j]=newstr[j];
	}
	outptr+=newstrlen;
      }
      lock=1;
    }
  }
  out[outptr]='\0';

  free(mask);
  return;
}


/* Replace all the substituion sections of the regex with "newstr".
 *  Caller must free the return
 */
char *oak_text_replace_string_sections_new(char *in, regmatch_t pmatch[], char *newstr)
{
  int i, j, outptr, lock, newstrlen, max_sections, instrlen;
  char *mask, *out;

   /* The way we'll do this is: set up a mask of the characters in
   * instr.  A 1 in the mask means to carry the character through, a 0
   * means it shouldn't be carried through.  Then we'll create the
   * output string by replacing contiguous sections of 0's with
   * "newstr"
   */

  newstrlen=strlen(newstr);
  instrlen=strlen(in);
  max_sections=15;
  
  /* mask */
  mask=malloc((sizeof(int)*instrlen)+20);
  /* initialize everything to OK (1) */
  for (i=0; i<instrlen; i++) {
    mask[i]='1';
  }
  /* set substitutions to not OK (0) */
  for (i=1; i<max_sections; i++) { /* skip 0 */
    if ((pmatch[i].rm_so != -1) && (pmatch[i].rm_eo != -1)) {
      for (j=pmatch[i].rm_so; j<pmatch[i].rm_eo; j++) {
	mask[j]='0';
      }
    }
  }

  out=malloc((newstrlen*max_sections)+instrlen+10);

  /* create the output string, i.e. do the newchar */
  outptr=0;
  lock=0;
  for (i=0; i<instrlen; i++) {
    if (mask[i] == '1') {
      out[outptr]=in[i];
      outptr++;
      lock=0;
    } else {
      if (!lock) {
	for (j=0; j<newstrlen; j++) {
	  out[outptr+j]=newstr[j];
	}
	outptr+=newstrlen;
      }
      lock=1;
    }
  }
  out[outptr]='\0';

  free(mask);
  return(out);
}

/* caller must free the return */
char *oak_text_get_line_from_log(char *log)
{
  char *ptr, *ptr2, *out;
  int len;

  ptr=strchr(log, ':');
  if (ptr) {
    ptr2=strchr(ptr+1, ':');
    if (ptr2) len=strlen(ptr2); /* length from second colon on */
  }
  
  if (!ptr || !ptr2 || len<5) {
    if (oak_global_is_debug(&g)) printf("DEBUG: Non syslog style line in logfile, skipping\n");
    return(NULL);
  }
  ptr2+=4;
  len-=4;

  /* if there's a 4 digit number and a space, it's a year and we should skip it */
  if (len>=5 &&
      isdigit((int) ptr2[0]) &&
      isdigit((int) ptr2[1]) &&
      isdigit((int) ptr2[2]) &&
      isdigit((int) ptr2[3]) &&
      ptr2[4] == ' ') {
    ptr2+=5;
    /* len-=5; */
  }

  /* skip the hostname */
  ptr=strchr(ptr2, ' ');
  if (!ptr) {
    if (oak_global_is_debug(&g)) printf("DEBUG: Non syslog style line in logfile, skipping\n");
    return(NULL);
  }
  ptr++;
  out=strdup(ptr);

  /* strip the trailing new line */
  len=strlen(out);
  if (out[len-1]=='\n') out[len-1]='\0';

  return(out);
}

char *oak_text_get_host_from_log(char *log)
{
  char *ptr, *ptr2, *out;
  int len;

  ptr=strchr(log, ':');
  if (ptr) {
    ptr2=strchr(ptr+1, ':');
    if (ptr2) len=strlen(ptr2); /* length from second colon on */
  }
  
  if (!ptr || !ptr2 || len<5) {
    if (oak_global_is_debug(&g)) printf("DEBUG: Non syslog style line in logfile, skipping\n");
    return(NULL);
  }
  ptr2+=4;
  len-=4;

  /* if there's a 4 digit number and a space, it's a year and we should skip it */
  if (len>=5 &&
      isdigit((int) ptr2[0]) &&
      isdigit((int) ptr2[1]) &&
      isdigit((int) ptr2[2]) &&
      isdigit((int) ptr2[3]) &&
      ptr2[4] == ' ') {
    ptr2+=5;
    /* len-=5; */
  }

  /* find the end of the hostname */
  ptr=strchr(ptr2, ' ');
  if (!ptr) {
    if (oak_global_is_debug(&g)) printf("DEBUG: Non syslog style line in logfile, skipping\n");
    return(NULL);
  }
  ptr++;
  out=malloc((ptr-ptr2)+5);
  strncpy(out, ptr2, ptr-ptr2);
  out[(ptr-ptr2)-1]='\0';

  return(out);
}
