#include <stdio.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <ctype.h>
#include "oak.h"

void oak_readconfig(char *file)
{
  FILE *configfile;
  int line, ret;
  oak_queue *q=NULL;
  oak_queue *tmpq;
  oak_matchline *ml=NULL;
  oak_action *tmpaction=NULL;
  oak_list *actionlist;
  char *ptr;
  char buff[LINE];
  if (oak_global_is_debug(&g)) printf("DEBUG: reading config file\n");

  /* create the default trash queue */
  tmpq=oak_queue_create("trash", NULL, NULL);
  oak_list_append_element(oak_global_get_queuelist(&g), tmpq);

  /* read the config file here */
  if (!(configfile=fopen(file, "r"))) {
    perror("Could not open configfile");
    exit(1);
  }

  line=0;
  while(fgets(buff, LINE, configfile)) {
    line++;

    /* remove initial spaces and tabs */
    ptr=buff;
    while ((ptr[0]==' ') || (ptr[0]=='\t')) ptr++;

    /* ignore comments */
    if (ptr[0]=='#') continue;
    
    /* ignore blank lines */
    if (ptr[0]=='\n') continue;

    /* nuke a trailing newline */
    if (ptr[strlen(ptr)-1]=='\n') ptr[strlen(ptr)-1]='\0';

    if (!strncmp(ptr, "set ", 4)) {
      ptr+=4;
      if (!strncmp(ptr, "infile ", 7)) {
	ptr+=7;
	oak_global_set_logfile(&g, ptr);
	if (oak_global_is_debug(&g)) printf("DEBUG: set logfile to %s.\n", oak_global_get_logfile(&g));
      } else if (!strncmp(ptr, "replacestr ", 11)) {
	ptr+=11;
	oak_global_set_replacestr(&g, ptr);
	if (oak_global_is_debug(&g)) printf("DEBUG: set replacestr to %s.\n", oak_global_get_replacestr(&g));
      } else if (!strcmp(ptr, "nukepid")) {
	oak_global_set_nukepid(&g);
	if (oak_global_is_debug(&g)) printf("DEBUG: set nukepid\n");
      } else if (!strcmp(ptr, "no nukepid")) {
	oak_global_set_no_nukepid(&g);
	if (oak_global_is_debug(&g)) printf("DEBUG: set no nukepid\n");
      } else if (!strcmp(ptr, "nukeciscoid") || !strcmp(ptr, "nukeciscopid")) {
	oak_global_set_nukeciscoid(&g);
	if (oak_global_is_debug(&g)) printf("DEBUG: set nukeciscoid\n");
      } else if (!strcmp(ptr, "no nukeciscoid") || !strcmp(ptr, "no nukeciscopid")) {
	oak_global_set_no_nukeciscoid(&g);
	if (oak_global_is_debug(&g)) printf("DEBUG: set no nukeciscoid\n");
      } else if (!strcmp(ptr, "nukesmqid")) {
	oak_global_set_nukesmqid(&g);
	if (oak_global_is_debug(&g)) printf("DEBUG: set nukesmqid\n");
      } else if (!strcmp(ptr, "no nukesmqid")) {
	oak_global_set_no_nukesmqid(&g);
	if (oak_global_is_debug(&g)) printf("DEBUG: set no nukesmqid\n");
      } else if (!strncmp(ptr, "ignorehosts ", 12)) {
	ret=oak_global_set_ignorehosts(&g, ptr+12);
	if (ret<0) {
	  fprintf(stderr, "ignorehosts set while onlyhosts is already in use.\n");
	  exit(1);
	}
	if (oak_global_is_debug(&g)) printf("DEBUG: set ignorehosts\n");
      } else if (!strncmp(ptr, "onlyhosts ", 10)) {
	ret=oak_global_set_onlyhosts(&g, ptr+10);
	if (ret<0) {
	  fprintf(stderr, "onlyhosts set while ignorehosts is already in use.\n");
	  exit(1);
	}
	if (oak_global_is_debug(&g)) printf("DEBUG: set onlyhosts\n");
      } else {
	fprintf(stderr, "unknown set variable on line %i in configfile\n", line);
	exit(1);
      }
    } else if (!strncmp(ptr, "define ", 7)) {
      ptr+=7;
      if (!strncmp(ptr, "queue ", 6)) {
	ptr+=6;
	actionlist=NULL;
	/* while (ptr[strlen(ptr)-1]==' ' || ptr[strlen(ptr)-1]=='\t') ptr[strlen(ptr)-1]='\0'; */
	q=oak_queue_create(ptr, NULL, NULL);
	oak_list_append_element(oak_global_get_queuelist(&g), q);
      } else {
	fprintf(stderr, "unknown define type on line %i in configfile\n", line);
	exit(1);
      }
      if (oak_global_is_debug(&g)) printf("DEBUG:\nDEBUG: added queue %s\n", oak_queue_get_name(q));
    } else if (!strncmp(ptr, "prescan", 7)) {
      oak_queue_set_prescan(q);
    } else if (!strncmp(ptr, "action ", 7)) {
      ptr+=7;
      /* memset(strchr(ptr, ' '), 0, 1); */
      if (!q) {
	fprintf(stderr, "action statement with no queue defined on line %i in config\n", line);
	exit(1);
      }

      tmpaction=oak_action_create_from_argstring("silly", ptr);
      if (oak_global_is_debug(&g)) printf("DEBUG: created action with name %s and args %s\n", "silly", ptr);

      if (!actionlist) {
	actionlist=malloc(sizeof(oak_list));
	oak_list_create(actionlist);
	oak_queue_set_actionlist(q, actionlist);
      }
      oak_list_append_element(actionlist, tmpaction);
      if (oak_global_is_debug(&g)) printf("DEBUG: added action '%s' to queue %s\n", oak_action_get_name(tmpaction), oak_queue_get_name(q));
    } else if (!strncmp(ptr, "action-limits ", 14)) {
      int a, b, c, d;
      char *tmpptr;
      ptr+=14;
      if (!tmpaction) {
	fprintf(stderr, "action-limits statement with no action specified on line %i in config\n", line);
	exit(1);
      }
      a=atoi(ptr);
      tmpptr=strchr(ptr, ' ')+1;
      b=atoi(tmpptr);
      tmpptr=strchr(tmpptr, ' ')+1;
      c=atoi(tmpptr);
      tmpptr=strchr(tmpptr, ' ')+1;
      d=atoi(tmpptr);
      oak_action_set_limits(tmpaction, a, b, c, d);
    } else if (!strncmp(ptr, "fire ", 5)) {
      oak_fire *tmpfire;
      ptr+=5;
      if (!q) {
	fprintf(stderr, "fire statement with no queue defined on line %i in config\n", line);
	exit(1);
      }
      tmpfire=oak_fire_create(ptr);
      oak_queue_set_fire(q, tmpfire);
      if (oak_global_is_debug(&g)) printf("DEBUG: added fire %s to queue %s\n", ptr, oak_queue_get_name(q));
    } else if (!strncmp(ptr, "locking ", 8)) {
      ptr+=8;
      if (!q) {
	fprintf(stderr, "locking statement with no queue defined on line %i in config\n", line);
	exit(1);
      }
      oak_queue_set_locktime_fromstring(q, ptr);
      if (oak_global_is_debug(&g)) printf("DEBUG: added locktime of %i queue %s\n", oak_queue_get_locktime(q), oak_queue_get_name(q));
    } else if (!strncmp(ptr, "header ", 7)) {
      ptr+=7;
      if (!q) {
	fprintf(stderr, "header statement with no queue defined on line %i in config\n", line);
	exit(1);
      }
      oak_queue_set_header(q, ptr);
      if (oak_global_is_debug(&g)) printf("DEBUG: added header %s to queue %s\n", oak_queue_get_header(q), oak_queue_get_name(q));
    } else if (!strncmp(ptr, "on ", 3)) {
      ptr+=3;
      ml=oak_matchline_create(ptr, NULL);
      oak_list_append_element(oak_global_get_matchlist(&g), ml); /* add  matchline ml to the list */
      if (oak_global_is_debug(&g)) printf("DEBUG:\nDEBUG: Created matchlline and appended it to global list\n");
    } else if (!strncmp(ptr, "queues ", 7)) {
      ptr+=7;
      if (!ml) {
	fprintf(stderr, "queues statement with no matchline defined on line %i in config\n", line);
	exit(1);
      }
      ret=oak_matchline_set_queuelist_from_string(ml, ptr);
      if (ret) {
	fprintf(stderr, "undefined queue used on line %i in config\n", line);
	exit(1);
      }
	
      if (oak_global_is_debug(&g)) printf("DEBUG: added queues to matchlist\n");
    } else {
      char tmpbuff[LINE], *ptr2;
      ptr2=ptr;
      ptr2=strchr(ptr, ' ');
      strncpy(tmpbuff, ptr, ptr2-ptr);
      fprintf(stderr, "Uknown directive '%s' on line %i in config\n", tmpbuff, line);
      exit(1);
    }
					   

  }
}
