#
# Information about who is compiling the binary....
# This file is in the public domain, such as it is.
#

comp_host=`hostname | cut -d. -f1`
comp_user=$USER
comp_time=`date +"%B %d, %Y"`
comp_num=`cat .times`
echo "*** This is compile #$comp_num by $comp_user@$comp_host on $comp_time"
new_comp_num=`expr $comp_num + 1`
echo $new_comp_num > .times

# Dump the C file...
cat > info.c << __E__O__F__
/*
 * info.c -- info about who compiled this version.
 * This file is auto-magically created.   Changes will be nuked.
 */

#include "config.h"
#ifdef ANONYMOUS_COMPILE
#define USER "<anonymous>"
#define HOST "<anonymous>"
#else
#define USER "$comp_user"
#define HOST "$comp_host"
#endif

char *compile_user = "$comp_user";
char *compile_host = "$comp_host";
char *compile_time = "$comp_time";
char *compile_num  = "$comp_num";
char *compile_info = "Compile #$comp_num by " USER "@" HOST " on $comp_time";

__E__O__F__
