/*
 * hosts.c
 *
 * This source code implements methods and algorithms for internet connections.
 *
 * written by Joshua J. Drake
 * copyright (c) 1998
 * 
 * -= SuckSoft =-
 */

#include "hosts.h"
#include "output.h"
#include "vars.h"
#include "ircaux.h"
#include "newio.h"

int
getTCPSock(void)
{
   return socket(AF_INET, SOCK_STREAM, 0);
}

/*
 * resolve hostname and store it in addr.
 * return 1 or 0 for success or failure
 */
int
resolve_host(addr, host)
   struct in_addr *addr;
   u_char *host;
{
   struct hostent *he;
   unsigned long ipaddr;

   ipaddr = inet_addr(host);
   if ((int)ipaddr != -1)
     {
	memcpy(&(addr->s_addr), &ipaddr, sizeof(addr->s_addr));
	return 1;
     }
   he = gethostbyname(host);
   if (he == (struct hostent *)NULL)
      return 0;
   memcpy(&(addr->s_addr), he->h_addr, sizeof(addr->s_addr));
   return 1;
}

/*
 * connect to a host via the tcp
 *
 * returns:
 * 1	success
 * 0	failure, tell please print the error
 * -1	failure, error was already printed
 */
int
tcpConnect(int s, struct in_addr baddr, struct sockaddr_in addr, int alen)
{
   struct sockaddr_in la;

   if (s < 0)
     return 0;
   
   /* try to bind if we have something to bind to. */
   if (baddr.s_addr != INADDR_ANY)
     {
	memset(&la, 0, sizeof(la));
	la.sin_family = AF_INET;
	la.sin_addr = baddr;
	if (bind(s, (struct sockaddr *)&la, sizeof(la)) == -1)
	  {
	     put_error("Unable to bind to address \"%s\": %s", inet_ntoa(baddr), strerror(errno));
	     new_close(s);
	     return -1;
	  }
     }
   /* if we have a socks proxy set, bounce through it. (blocking)
    * 
    * this has moved to server.c... much better place for it...
    */
#ifdef NON_BLOCKING_CONNECTS
   if (set_non_blocking(s) < 0)
     {
	new_close(s);
	put_error("Unable to set socket non-blocking: %s", strerror(errno));
	return -1;
     }
#endif
   /* attempt to connect to remote host on the socket we've allocated.. */
   if (connect(s, (struct sockaddr *)&addr, alen) < 0)
     {
	if (errno != EINPROGRESS)
	  {
	     new_close(s);
	     return 0;
	  }
     }
   return s;
}
