/*
 * names.h: Header for names.c
 *
 * Written By Michael Sandrof
 *
 * Copyright (c) 1990 Michael Sandrof.
 * Copyright (c) 1991, 1992 Troy Rollo.
 * Copyright (c) 1992-2000 Matthew R. Green.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @(#)$Id: names.h,v 1.31 2000/04/01 07:39:58 mrg Exp $
 */

#ifndef __channels_h_
#define __channels_h_

#include "irc.h"

/*
 * MODE_STRING and other MODE_FOO defines need to be kept in sync.
 * MODE_STRING refers to the bits in the mode bitmask.  the letters
 * and numbers need to match up.
 */

/* for now, ninja will support hybrid modes */
#define NMODE_STRING	"ov"
#define NMODE_CHOP	((u_long) 0x0001)
#define NMODE_VOICE	((u_long) 0x0002)

#define LMODE_STRING	"bed"
#define LMODE_BAN	((u_long) 0x0001)
#define LMODE_EXCEPTION	((u_long) 0x0002)
#define LMODE_DENY	((u_long) 0x0004)

#define MODE_STRING	"iklmnpst"
#define MODE_INVITE	((u_long) 0x0001)
#define MODE_KEY	((u_long) 0x0002)
#define MODE_LIMIT	((u_long) 0x0004)
#define MODE_MODERATED	((u_long) 0x0008)
#define MODE_MSGS	((u_long) 0x0010)
#define MODE_PRIVATE	((u_long) 0x0020)
#define MODE_SECRET	((u_long) 0x0040)
#define MODE_TOPIC	((u_long) 0x0080)

/*
 * i have no idea where phone got these, but I will look into it
 *
#define MODE_STIRNG	"acqrR"
#define MODE_ANONYMOUS	((u_long) 0x0001)
#define MODE_COLOURLESS	((u_long) 0x0002)
#define MODE_QUIET	((u_long) 0x0100)
#define MODE_REOP	((u_long) 0x0200)
#define MODE_REGONLY	((u_long) 0x1000)
 *
 */

/* for lookup_channel() */
#define	CHAN_NOUNLINK	1
#define CHAN_UNLINK	2

/* the list head
 *   ..is now stored in the server structure!
extern	Channel	*channel_list;
 */

/* prototypes */
	int	is_channel_mode _((u_char *, int, int));
	int	is_chanop _((u_char *, u_char *));
	int	has_voice _((u_char *, u_char *));
	Channel	*lookup_channel _((u_char *, int, int));
	u_char	*get_channel_mode _((u_char *, int));
#ifdef	INCLUDE_UNUSED_FUNCTIONS
	void	set_channel_mode _((u_char *, int, u_char *));
#endif /* INCLUDE_UNUSED_FUNCTIONS */
	void	add_channel _((u_char *, int, int, Channel *));
	Channel	*add_to_channel _((u_char *, u_char *, int, 
				  int, int, int, 
				  u_char *, u_char *, u_char *, 
				  int, int, u_char *));
	void	remove_channel _((u_char *, int));
	void	remove_from_channel _((u_char *, u_char *, int));
	int	is_on_channel _((u_char *, int, u_char *));
	void	list_channels _((void));
	void	reconnect_all_channels _((int));
	void	switch_channels _((u_int, u_char *));
	u_char	*what_channel _((u_char *, int));
	u_char	*walk_channels _((u_char *, int, int));
	void	rename_nick _((u_char *, u_char *, int));
	void	update_channel_mode _((u_char *, int, u_char *, u_char *, Channel *));
	void	set_channel_window _((Window *, u_char *, int));
	u_char	*create_channel_list _((Window *));
	int	get_channel_oper _((u_char *, int));
	void	channel_server_delete _((int));
	void	change_server_channels _((int, int));
	void	clear_channel_list _((int));
	void	set_waiting_channel _((int));
	int	chan_is_connected _((u_char *, int));
	void	mark_not_connected _((int));
	int	same_channel _((Channel *, u_char *));

/* ninja additions */
	u_char	*make_chan _((u_char *));
	int	is_channel _((u_char *));

#endif /* __channels_h_ */
