/*
 * The original was spagetti. I have replaced Michael's code with some of
 * my own which is a thousand times more readable and can also handle '%',
 * which substitutes anything except a space. This should enable people
 * to position things better based on argument. I have also added '?', which
 * substitutes to any single character. And of course it still handles '*'.
 * this should be more efficient than the previous version too.
 *
 * Thus this whole file becomes:
 *
 * Written By Troy Rollo
 *
 * Copyright(c) 1992
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 */

#include "irc.h"
#include "ircaux.h"
#include "output.h"

static int total_explicit;

/*
 * The following #define is here because we *know* its behaviour.
 * The behaviour of toupper tends to be undefined when it's given
 * a non lower case letter.
 * All the systems supported by IRCII should be ASCII
 */
#define	mkupper(c)	(((c) >= 'a' && (c) <= 'z') ? ((c) - 'a' + 'A') : c)

#ifdef __STDC__
int
match(u_char *pattern, u_char *string)
#else
int
match(pattern, string)
   u_char *pattern, *string;
#endif
{
   u_char type;

#if 0
   if ((!pattern || !string) && !x_debug)
     {
	yell("match: pattern or string is NULL!");
	return 0;
     }
#endif

   while (*string && *pattern && *pattern != '*' && *pattern != '%')
     {
	if (*pattern == '\\' && *(pattern + 1))
	  {
	     if (!*++pattern || !(mkupper(*pattern) ==
				  mkupper(*string)))
		return 0;
	     else
		pattern++, string++, total_explicit++;
	  }

	if (*pattern == '?')
	   pattern++, string++;
	else if (mkupper(*pattern) == mkupper(*string))
	   pattern++, string++, total_explicit++;
	else
	   break;
     }
   if (*pattern == '*' || *pattern == '%')
     {
	type = (*pattern++);
	while (*string)
	  {
	     if (match(pattern, string))
		return 1;
	     else if (type == '*' || *string != ' ')
		string++;
	     else
		break;
	  }
     }
   if (!*string && !*pattern)
      return 1;
   return 0;
}

/*
 * This version of wild_match returns 1 + the  count  of characters
 * explicitly matched if a match occurs. That way we can look for
 * the best match in a list
 */
/* \\[ and \\] handling done by Jeremy Nelson
 * EPIC will not use the new pattern matcher currently used by 
 * ircii because i am not convinced that it is 1) better * and 
 * 2) i think the \\[ \\] stuff is important.
 */
#ifdef __STDC__
int
wild_match(u_char *pattern, u_char *str)
#else
int
wild_match(pattern, str)
   u_char *pattern, *str;
#endif
{
   u_char *ptr;
   u_char *ptr2 = pattern;
   int nest = 0;
   u_char my_buff[2048];
   u_char *arg;
   int best_total = 0;

   total_explicit = 0;

   if (!str)
     {
	put_error("string is null calling wild_match().. caller contains a bug");
	return 0;
     }
   /* Is there a \[ in the pattern to be expanded? */
   /* This stuff here just reduces the \[ \] set into a series of
    * one-simpler patterns and then recurses */
   if ((ptr2 = strstr(pattern, "\\[")))
     {
	/* we will have to null this out, but not until weve used it */
	u_char *placeholder = ptr2;
	ptr = ptr2;

	/* yes. whats the character after it? (first time
	   through is a trivial case) */
	do
	  {
	     switch (ptr[1])
	       {
		     /* step over it and add to nest */
		  case '[':
		     ptr2 = ptr + 2;
		     nest++;
		     break;
		     /* step over it and remove nest */
		  case ']':
		     ptr2 = ptr + 2;
		     nest--;
		     break;
	       }
	  }
	/* Repeat while there are more backslashes to look at and
	 * we have are still in nested \[ \] sets
	 */
	while ((nest) && (ptr = index(ptr2, '\\')));

	/* right now, we know ptr points to a \] or to null */
	/* remember that && short circuits and that ptr will 
	   not be set to null if (nest) is zero... */
	if (ptr)
	  {
	     /* null out and step over the original \[ */
	     *placeholder = '\0';
	     placeholder += 2;

	     /* null out and step over the matching \] */
	     *ptr = '\0';
	     ptr += 2;

	     /* grab words ("" sets or space words) one at a time
	      * and attempt to match all of them.  The best value
	      * matched is the one used.
	      */
	     while ((arg = new_next_arg(placeholder, &placeholder)))
	       {
		  int tmpval;

		  strncpy(my_buff, pattern, sizeof(my_buff)-1);
		  strmcat(my_buff, arg, sizeof(my_buff)-1);
		  strmcat(my_buff, ptr, sizeof(my_buff)-1);
		  /* the total_explicit we return is whichever
		   * pattern has the highest total_explicit */
		  if ((tmpval = wild_match(my_buff, str)))
		    {
		       if (tmpval > best_total)
			  best_total = tmpval;
		    }
	       }
	     return best_total;	/* end of expansion section */
	  }
	/* Possibly an unmatched \[ \] set */
	else
	  {
	     total_explicit = 0;
	     if (match(pattern, str))
		return total_explicit + 1;
	     else
	       {
#if 0
		  yell("Unmatched \\[ !");
#endif
		  return 0;
	       }
	  }
     }
   /* trivial case (no expansion) when weve expanded all the way out */
   else if (match(pattern, str))
      return total_explicit + 1;
   else
      return 0;
}

















/*
 * IP match().. only matches for digits and dots.
 * 
 * - doesn't support \<char>
 * - returns 0 if anything other than a digit or dot is found..
 * 
 */
#ifdef __STDC__
int
ip_match(u_char *pattern, u_char *string)
#else
int
ip_match(pattern, string)
   u_char *pattern, *string;
#endif
{
   u_char type;

#if 0
   if ((!pattern || !string) && !x_debug)
     {
	yell("ip_match: pattern or string is NULL!");
	return 0;
     }
#endif

   while (*string && *pattern && *pattern != '*' && *pattern != '%')
     {
	if (*pattern == '?')
	   pattern++, string++;
	/* not digit or dot? */
	else if ((!isdigit(*pattern) && *pattern != '.') || (!isdigit(*string) && *string != '.'))
	  break;
	else if (*pattern == *string)
	   pattern++, string++;
	else
	   break;
     }
   if (*pattern == '*' || *pattern == '%')
     {
	type = (*pattern++);
	while (*string)
	  {
	     /* not digit or dot ? */
	     if (!isdigit(*string) && *string != '.')
	       break;
	     else if (ip_match(pattern, string))
		return 1;
	     else if (type == '*' || *string != ' ')
		string++;
	     else
		break;
	  }
     }
   if (!*string && !*pattern)
      return 1;
   return 0;
}

/*
 * case sensitive match()..
 * 
 */
#ifdef __STDC__
int
cs_match(u_char *pattern, u_char *string)
#else
int
cs_match(pattern, string)
   u_char *pattern, *string;
#endif
{
   u_char type;

#if 0
   if ((!pattern || !string) && !x_debug)
     {
	yell("ip_match: pattern or string is NULL!");
	return 0;
     }
#endif

   while (*string && *pattern && *pattern != '*' && *pattern != '%')
     {
	if (*pattern == '\\' && *(pattern + 1))
	  {
	     if (!*++pattern || !(*pattern == *string))
		return 0;
	     else
		pattern++, string++;
	  }

	if (*pattern == '?')
	   pattern++, string++;
	else if (*pattern == *string)
	  pattern++, string++;
	else
	  break;
     }
   if (*pattern == '*' || *pattern == '%')
     {
	type = (*pattern++);
	while (*string)
	  {
	     if (cs_match(pattern, string))
		return 1;
	     else if (type == '*' || *string != ' ')
		string++;
	     else
		break;
	  }
     }
   if (!*string && !*pattern)
      return 1;
   return 0;
}
