/*
 * nincache.c: this parses and caches date from the server...
 * 
 * this was created because:
 *  1. didn't want to make a big mess in parse.c
 *  2. wanted to cache data before do_hook(RAW_IRC_LIST...
 * 
 * written by Joshua J. Drake <jduck@EFNet>
 */

#include "irc.h"
#include "parse.h"
#include "channels.h"
#include "dma.h"
#include "server.h"
#include "ircaux.h"
#include "funny.h"
#include "notify.h"
#include "window.h"
#include "ctcp.h"
#include "vars.h"
#include "server.h"
#include "output.h"

#include "bans.h"
#include "orignick.h"
#include "friends.h"
#include "ndcc.h"
#include "nicks.h"

/*
 * this idea would cause joining race conditions resulting in
 * people not getting cached when they joined..
 * 
 * well this is only used for whether or not to display the who line now..
 * 
static	u_char	*who_hack_nick = UNULL;
static	int	who_hack_warned = 0;
 * 
 * and its not used anymore.. server[index].who_nicks instead keeps track
 * of multiple people...
 */

extern	int	chk_channel_cached _((u_char *));
static	int	check_who_nicks _((u_char *, int));

int
parse_into_cache(line, flag, str_flag)
   u_char *line;
   int *flag;
   u_char **str_flag;
{
   u_char *copy = UNULL, *comm, *from = UNULL;
   u_char *chk_chan = UNULL;
   u_char **ArgList, *TrueArgs[MAXPARA+1];
   int numeric, ret = 1;
   
   /* make a copy and break it up */
   dma_strcpy(&copy, line);
   ArgList = TrueArgs;
   BreakArgs(copy, &from, ArgList);
   
   /* if no command, return */
   if (!(comm = (*ArgList++)))
     return ret;
   
   /* is it numeric? */
   numeric = my_atoi(comm);
   if (numeric > 0)
     {
	ArgList++; /* skip past "user" field, it should be me! */
	switch (numeric)
	  {
	   case 004:	/* allowed channel and user modes for server */
	       {
		  if (ArgList[0] && ArgList[1] && ArgList[2] && ArgList[3])
		    {
		       if (my_strncmp(ArgList[1], "2.8/hybrid-", 11) == 0)
			 set_server_version(parsing_server_index, Server2_8_hyb);
		       dma_strcpy(&(server_list[parsing_server_index].umodes), ArgList[2]);
		       dma_strcpy(&(server_list[parsing_server_index].cmodes), ArgList[3]);
		       goto out;
		    }
	       }
	     break;
	   case 324:   	/* update channel mode */
	       {
		  u_char *mode, *channel;
		  Channel *chan;
		  
		  if (!ArgList[0])
		    goto out;
		  
		  /* backwards compatability sucks! */
		  if (get_server_version(parsing_server_index) < Server2_6)
		    {
		       channel = NULL;
		       mode = ArgList[0];
		       PasteArgs(ArgList, 0);
		    }
		  else
		    {
		       channel = ArgList[0];
		       mode = ArgList[1];
		       PasteArgs(ArgList, 1);
		    }
		  
		  /* lookup the channel */
		  chan = lookup_channel(channel, parsing_server_index, CHAN_NOUNLINK);
		  if (!chan)
		    goto out;
		  /* the channel to check for complete sync at the end */
		  dma_strcpy(&chk_chan, chan->channel);
		  /* upate the mode! */
		  update_channel_mode(UNULL, parsing_server_index, mode, from, chan);
		  
		  /* the mode is sync'd now! */
		  if (!(chan->status & CHAN_MODE))
		    {
		       ret = 0;
		       chan->status |= CHAN_MODE;
		       update_all_status();
		    }
	       }
	     break;
	   case 367:	/* ban entry */
	       {
		  Channel *chan;

		  /* lookup the channel */
		  if (!ArgList[0])
		    goto out;
		  chan = lookup_channel(ArgList[0], parsing_server_index, CHAN_NOUNLINK);
		  
		  if (!chan || (chan->status & CHAN_BANS))
		    goto out;
		  
		  /* the channel to check for complete sync at the end */
		  dma_strcpy(&chk_chan, chan->channel);
		  
		  if (ArgList[1] && ArgList[2] && ArgList[3])
		    add_ban(chan, ArgList[1], ArgList[2], ArgList[3]);
		  else if (ArgList[1] && ArgList[2])
		    add_ban(chan, ArgList[1], ArgList[2], UNULL);
		  else if (ArgList[1])
		    add_ban(chan, ArgList[1], UNULL, UNULL);
		  ret = 0;
	       }
	     break;
	   case 348:	/* ban exception entry */
	       {
		  Channel *chan;
		  
		  /* lookup the channel */
		  chan = lookup_channel(ArgList[0], parsing_server_index, CHAN_NOUNLINK);
		  if (!chan || (chan->status & CHAN_EXCEPT))
		    goto out;
		  
		  /* the channel to check for complete sync at the end */
		  dma_strcpy(&chk_chan, chan->channel);
		  
		  /* add_exception(chan, ArgList[2], ArgList[3], ArgList[4]); */
		  ret = 0;
	       }
	     break;
	   case 315:	/* end of who */
	   case 349:	/* end of ban exceptions */
	   case 366:	/* end of names */
	   case 368:	/* end of bans */
	   case 329:	/* channel timestamp... not cached yet */
	       {
		  Channel *chan;
		  int tmp = 0;
		  
		  if (numeric == 315)
		    tmp |= CHAN_WHO;
		  else if (numeric == 349)
		    tmp |= CHAN_EXCEPT;
		  else if (numeric == 368)
		    tmp |= CHAN_BANS;
		  else if (numeric == 329)
		    tmp |= CHAN_START;
		  else if (numeric == 366)
		    tmp |= CHAN_NAMES;
		  
		  /* it must be a nick instead of a channel, eh? */
		  if (numeric == 315
		      && !is_channel(ArgList[0]))
		    {
		       ret = check_who_nicks(ArgList[0], 1);
		       goto out;
		    }
		  
		  /* lookup the channel */
		  chan = lookup_channel(ArgList[0], parsing_server_index, CHAN_NOUNLINK);
		  if (!chan || (chan->status & tmp))
		    goto out;
		  
		  /* the channel to check for complete sync at the end */
		  dma_strcpy(&chk_chan, chan->channel);
		  
		  chan->status |= tmp;
		  if (numeric != 366 ||		/* show then end maybe */
		      ((numeric == 366) 
		       && !get_int_var(SHOW_CHANNEL_NAMES_VAR)))
		    ret = 0;
	       }
	     break;
	   case 352:	/* who entry */
	       {
		  u_char  *channel, *user, *host, *server, *nick, *stat, *name, *hopcount;
		  int i = 0, chop, oper, voice, hops, here;
		  Channel *tmp, *c2 = NULL;
		  Nick *n;

		  /* get args */
		  channel = user = host = server = nick = stat = hopcount = name = UNULL;
		  chop = oper = voice = hops = here = 0;
		  if (ArgList[i])
		    channel = ArgList[i++];
		  
		  /* lookup the channel (if we aren't on it, go to the whois_who stuff! */
		  tmp = lookup_channel(channel, parsing_server_index, CHAN_NOUNLINK);
		  c2 = tmp;

		  /* i'm there, go on... */
		  if (ArgList[i])
		    user = ArgList[i++];
		  if (ArgList[i])
		    host = ArgList[i++];
		  if (ArgList[i])
		    server = ArgList[i++];
		  if (ArgList[i])
		    nick = ArgList[i++];
		  if (ArgList[i])
		    stat = ArgList[i++];
		  PasteArgs(ArgList, i);
		  if (ArgList[i])
		    name = ArgList[i];
		  
		  /* who header?! wtf */
		  if (stat && *stat == 'S')
		    goto out;

		  /* parse up the name field for a possible hop count */
		  hops = -1;
		  if (name)
		    {
		       if (*name == ':')
			 name++;
		       if (isdigit(*name) && my_index(name, ' '))
			 hopcount = next_arg(name, &name);
		       if (hopcount)
			 hops = my_atoi(hopcount);
		    }

		  /* parse out stat stuff */
		  if (stat)
		    {
		       here = (*stat == 'H');
		       voice = (my_index(stat, '+') != NULL);
		       chop = (my_index(stat, '@') != NULL);
		       oper = (my_index(stat, '*') != NULL);
		    }

		  /* update global stuff for all other channels they're on with me
		   * and if its a channel that shows in the who line, then update the chan
		   * specific stuff too..
		   */
		  if (c2)
		    {
		       add_to_channel(tmp->channel, nick, parsing_server_index,
				      oper, chop, voice, 
				      user, host, name, 
				      hops, here, server);
		       if (!(c2->status & CHAN_WHO))
			 {
			    ret = 0;
			    goto out;
			 }

		       /* the channel to check for complete sync at the end */
		       dma_strcpy(&chk_chan, c2->channel);
		    }
		  else /* i'm not on that channel! */
		    {
		       /* we'll always update them on all channnels they are on... */
		       for (tmp = server_list[parsing_server_index].chan_list; tmp; tmp = tmp->next)
			 if ((n = find_nick(nick, UNULL, parsing_server_index, tmp)))
			   add_to_channel(tmp->channel, nick, parsing_server_index, 
					  oper, -1, -1, 
					  user, host, name,
					  hops, here, server);
		    }
		  /* BUT,
		   * if we are /who'n them on a join, we must ignore the line..
		   * 
		   * we don't adjust the list here, we do that in ENDOFWHO stuff
		   */
		  ret = check_who_nicks(nick, 0);
		  goto out;
	       }
	     break;
	   case 353: /* names line.. this is here for compatability.. 
		      * and since most servers send these on join already!
		      */
	       {
		  u_char *nick, *p;
		  Channel *ch;

		  ch = lookup_channel(ArgList[1], parsing_server_index, CHAN_NOUNLINK);
		  if (!ch || (ch->status & CHAN_NAMES))
		    goto out;
		  PasteArgs(ArgList, 2);
		  p = ArgList[2];
		  while ((nick = next_arg(p, &p)) != NULL)
		    add_to_channel(ArgList[1], nick, parsing_server_index, 
				   -1, -1, -1,
				   UNULL, UNULL, UNULL,
				   -1, -1, UNULL);
	       }
	     break;
	   default:
	     break;
	  }
     }
   else
     {
	/* non-numeric thing needing to be parsed into cache
	 * 
	 * this stuff is mostly maintaining the cache, the above numeric stuff
	 * mostly does join cacheing..
	 */
	
	/* part's must be handled silently here (for channel cache) */
	if (my_strcmp(comm, "PART") == 0)
	  {
	     if (my_stricmp(from, get_server_nickname(parsing_server_index)) == 0)
	       remove_channel(ArgList[0], parsing_server_index);
	     else
	       remove_from_channel(ArgList[0], from, from_server);
	     goto out;
	  }
   
	/*
	 * I had to move this back to parse.c due to signoffs not showing up and not as
	 * easy to hack it as it was with NICK
	 * 
	 * someone quit, remove them from all channels!
	if (my_strcmp(comm, "QUIT") == 0)
	  {
	     remove_from_channel(NULL, from, from_server);
	     notify_mark(from, 0, 0, UNULL, UNULL, 0);
	     nchk_orignick(from);
	     goto out;
	  }
	 */
	
	/* someone entered a channel (or exited for old style) */
	if (my_strcmp(comm, "CHANNEL") == 0
	    || my_strcmp(comm, "JOIN") == 0)
	  {
	     int join, chop = 0, voice = 0;
	     u_char *channel, *s;
	     
	     if (!from)
	       goto out;
	     /* are we joining 0? */
	     if (my_strcmp(ArgList[0], zero) != 0)
	       {
		  join = 1;
		  channel = ArgList[0];
		  if ((s = my_index(channel, '\007')))
		    {
		       *s = '\0';
		       while (*++s)
			 {
			    if (*s == 'o')
			      chop = 1;
			    if (*s == 'v')
			      voice = 1;
			 }
		    }
		  dma_strcpy(&joined_nick, from);
	       }
	     else
	       {
		  join = 0;
		  channel = zero;
	       }
	     
	     /* is it me? */
	     if (!my_stricmp(from, get_server_nickname(parsing_server_index)))
	       {
		  if (join)
		    {
		       add_channel(channel, parsing_server_index, CHAN_JOINED, (Channel *)0);
		       if (get_server_version(parsing_server_index) == Server2_5)
			 send_to_server("NAMES %s", channel);
		       send_to_server("WHO %s", channel);
		       send_to_server("MODE %s", channel);
		       send_to_server("MODE %s b", channel);
		       /*
			* MISC server modes, not really implemented yet..
			* 
		       if (my_index(server_list[parsing_server_index].cmodes, 'e'))
		       send_to_server("MODE %s e", channel);
		       if (my_index(server_list[parsing_server_index].cmodes, 'd'))
		       send_to_server("MODE %s d", channel);
			*/
		    }
		  else
		    remove_channel(channel, parsing_server_index);
	       }
	     else
	       {
		  if (join)
		    {
		       Channel *chan;
		       
		       /* XXX: check for netjoins */
		       
		       chan = lookup_channel(channel, parsing_server_index, CHAN_NOUNLINK);
		       if (!chan)
			 {
			    /* little error message to see if this is ever reached */
			    put_error("odd, someone joined %s on server #%d which i know nothing about...",
				      channel, parsing_server_index+1);
			 }
		       
		       /* blah but we have to add them with minor stuff for the next thing to work.. */
		       add_to_channel(channel, from, parsing_server_index,
				      -1, 0, 0,
				      FromUser, FromHost, UNULL,
				      -1, -1, UNULL);

		       /*
			* we'll just /who the user... this will update the cache..
			*/
		       if (get_int_var(EXTENDED_CACHE_VAR))
			 {
			    if (server_list[parsing_server_index].who_nicks)
			      dma_strcat(&server_list[parsing_server_index].who_nicks, ",");
			    dma_strcat(&server_list[parsing_server_index].who_nicks, from);
			    send_to_server("WHO %s", from);
			 }

		       /* if i'm a channel operator, then do friends list stuff */
		       if ((chan->status & CHAN_CHOP))
			 check_friend_join(chan, from, FromUser, FromHost, 3+(int) (4.0*rand()/(RAND_MAX+1.0)));
		    }
		  else
		    remove_from_channel(channel, from, parsing_server_index);
	       }
	     goto out;
	  }
	
	/* nick changes */
	if (my_strcmp(comm, "NICK") == 0)
	  {
	     dma_strcpy(str_flag, ArgList[0]);
	     /* am i changing my nickname? */
	     if (my_stricmp(from, get_server_nickname(parsing_server_index)) == 0)
	       {
		  if (parsing_server_index == primary_server)
		    malloc_strcpy(&nickname, ArgList[0]);
		  set_server_nickname(parsing_server_index, ArgList[0]);
		  *flag = 1;
	       }
	     else
	       nchk_orignick(from);
	     rename_nick(from, ArgList[0], parsing_server_index);
	     if (my_stricmp(from, ArgList[0]) != 0)
	       {
		  notify_mark(from, 0, 0, FromUser, FromHost, 0);
		  notify_mark(ArgList[0], 1, 0, FromUser, FromHost, 0);
	       }
	     goto out;
	  }
	
	/* kick's */
	if (my_strcmp(comm, "KICK") == 0)
	  {
	     /* me? */
	     if (my_stricmp(ArgList[1], get_server_nickname(parsing_server_index)) == 0)
	       remove_channel(ArgList[0], parsing_server_index);
	     else
	       {
		  /* this friends list check must be done before removing 
		   * them from the channel 
		   */
		  check_friend_kick(ArgList[0], from, FromUser, FromHost, ArgList[1]);
		  remove_from_channel(ArgList[0], ArgList[1], parsing_server_index);
	       }
	     goto out;
	  }

	/* mode changes */
	if (my_strcmp(comm, "MODE") == 0)
	  {
	     PasteArgs(ArgList, 1);
	     if (ArgList[0] && ArgList[1])
	       {
		  if (is_channel(ArgList[0]))
		    update_channel_mode(ArgList[0], parsing_server_index, ArgList[1], from, (Channel *)0);
		  else
		    update_user_mode(ArgList[1]);
	       }
	     goto out;
	  }

	/* pings, server seeing if we're alive */
	if (my_strcmp(comm, "PING") == 0)
	  {
	     PasteArgs(ArgList, 0);
	     send_to_server("PONG :%s", ArgList[0]);
	     ret = 0;
	     goto out;
	  }
	
	/* pongs, lag check */
	if (my_strcmp(comm, "PONG") == 0)
	  {
	     Server *srv = (Server *)&(server_list[parsing_server_index]);

	     if (my_stricmp(from, srv->itsname) == 0
		 && srv->in_ping
		 /* && my_strncmp("LAG:", ArgList[1], 4) == 0 */ )
	       {
		  set_server_lag(parsing_server_index);
		  ret = 0;
		  goto out;
	       }
	  }

	/* privmsg, anti-idle?! */
	if (my_strcmp(comm, "PRIVMSG") == 0)
	  {
	     Server *srv = (Server *)&(server_list[parsing_server_index]);
	     u_char *ptr = ArgList[1];
	     
	     if (my_strncmp("LAG CHECK ", ArgList[1], 10) == 0
		 && !my_stricmp(from, srv->nickname)
		 && srv->in_ping)
	       {
		  set_server_lag(parsing_server_index);
		  ret = 0;
		  goto out;
	       }
	     /* allow NDCC calls via /msg as well as ctcp */
	     if (get_int_var(NDCC_OFFERING_VAR))
	       {
		  if (*ptr == CTCP_DELIM_CHAR)
		    {
		       u_char *p;
		       
		       ptr++;
		       p = my_index(ptr, CTCP_DELIM_CHAR);
		       if (p)
			 *p = '\0';
		    }
		  if (my_strnicmp(ptr, "NDCC ", 5) == 0
		      || my_strnicmp(ptr, "XDCC ", 5) == 0
		      || my_strnicmp(ptr, "CDCC ", 5) == 0)
		    {
		       process_remote_ndcc(from, FromUser, FromHost, ArgList[0], ptr+5);
		       ret = 0;
		       goto out;
		    }
	       }
	  }

	/* invite, auto join due to friend?! */
	if (my_strcmp(comm, "INVITE") == 0)
	  check_friend_invite(ArgList[1], from, FromUser, FromHost);
	
	/* MORE! */
     }
   /* okay, all parsed up, RIGHT?!  you didn't forget anything, did you?!?!! */
out:
   if (chk_chan)
     {
	chk_channel_cached(chk_chan);
	dma_Free(&chk_chan);
     }
   dma_Free(&copy);
   return ret;
}


/*
 * check to see if we just /who'd a person on join...
 * 
 * update specifies whether or not to remove them from the list..
 * 
 * process:
 * srv: JOIN person
 * you: WHO person
 * srv: 352 person stuff...
 * you: (nothing sent, information saved and line ignored if this code returns true)
 * srv: 315 person end of /who
 * you: (nothing sent, remove person from the list)
 * 
 * returns: 1 (person not found, show the line)
 *      or: 0 (person found, don't show it, we may have removed it)
 */
int
check_who_nicks(nick, update)
   u_char *nick;
   int update;
{
   u_char *who_nicks, *otp, *tp;
   
   who_nicks = server_list[parsing_server_index].who_nicks;
   if (!who_nicks)
     return 1;
   
   otp = who_nicks;
   while (otp)
     {
	tp = my_index(otp, ',');
	if (tp) /* not the last spot */
	  *tp = '\0';
	if (my_stricmp(otp, nick) == 0) /* found it ? */
	  {
	     if (update)	/* shift the list back from tp.. */
	       {
		  u_char *nwn = UNULL;
		  
		  /* copy from beginning to otp */
		  if (otp != who_nicks)
		    *(otp-1) = '\0';
		  dma_strcat(&nwn, who_nicks);
		  if (otp != who_nicks)
		    *(otp-1) = ',';
		  
		  /* copy from after otp nick to end (if we're not at the end) */
		  if (tp)
		    {
		       dma_strcat(&nwn, UP(","));
		       dma_strcat(&nwn, tp+1);
		    }
		  
		  /* free the list and point it to our new list*/
		  dma_Free(&server_list[parsing_server_index].who_nicks);
		  server_list[parsing_server_index].who_nicks = nwn;
		  
		  /* ignore it!*/
		  return 0;
	       }
	     else	/* found it, but no update! */
	       {
		  if (tp)
		    *tp = ',';
		  return 0;
	       }
	  }
	if (tp)
	  {
	     *tp = ',';
	     otp = tp+1;
	  }
	else
	  otp = tp;
     }
   return 1;
}
