.TH Nikto 1 "February 12, 2007" "Nikto 1.36" ""
.
.SH NAME
.
\fBNikto\fP - Web Server and CGI Scanner, Version 1.36
.
.SH SYNOPSIS
.
\fBnikto.pl\fP [\-h \fItarget\fP] [\fIoptions\fP]
.
.SH WARNING
.
Nikto is a tool for finding default web files and examing web server and
CGI security.  It makes a lot of reqeusts to the remote server, which in
some cases may cause the server to crash.  It may also be illegal to use
this software against servers you do not have permission to do test.
.
.SH DESCRIPTION
.
Nikto is designed to examine web servers and look for items in multiple
categories:
.RS
.IP \(bu 3
misconfigurations
.IP \(bu 3
default files and scripts
.IP \(bu 3
insecure files and scripts
.IP \(bu 3
outdated software
.RE
.PP
It uses Rain Forest Puppy's LibWhisker (wiretrip.net) for HTTP
functionality, and can perform checks in HTTP or HTTPS.  It also supports
basic port scanning and will determine if a web server is running on any
open ports.
.PP
Nikto checks and code can be automatically udpated from the main
distribution server by using the \fB\-update\fP option (see below) to ensure
Nikto is checking the most recent vulnerabilities.
.PP
Nikto will also load user defined checks at startup if they are placed
in a file named \fIuser_scan_database.db\fP in the plugins directory.
Unlike \fIscan_database.db\fP, this file will not be over-written if the
\fB\-update\fP option is used. This should always be used if you add
your own checks (and you should send those checks to sullo@cirt.net).
.PP
Nikto leaves a footprint on a server it scans--both in an invalid 404
check and in the User-Agent header. This can be changed by forcing the
\fB$NIKTO{fingerprint}\fP and \fB$NIKTO{useragent}\fP to new values in
the source code, \fBor\fP, if any IDS evasion (\fB\-e\fP) option is
used.  Note that it's pretty obvious when Nikto is scanning a server
anyway--the large number of invalid requests sticks out a lot in the
server logs, although with an IDS evasion technique it might not be
extremely obvious that it was Nikto.
.PP
Why the name Nikto? See the movies \fI"The Day the Earth Stood
Still"\fP and, of course \fI"Army of Darkness"\fP for the answer. For
a full list of pop-culture references to this, see
http://www.blather.net/archives2/issue2no21.html which has a lot of
good information.
.
.SH OPTIONS
.
The options listed below are all optional except the \fB\-h\fP target
specification.  They can all be abbreviated to the first letter (i.e.,
\fB\-m\fP for \fB\-mutate\fP), with the exception of \fB\-verbose\fP
and \fB\-debug\fB.
.TP
.BI \-config " <config file>"
Read the specified configuration file instead of the default one.
.TP
.BI \-Cgidirs " <dirs>"
Optionally force the CGI directories to scan. Valid values are 'none' to
not check any, 'all' to force scan all CGi directories (like the deprecated
\fB\-allcgi\fP), or a value to use as the CGI directory, i.e. '/cgi/'.
.TP
.B \-cookies
Print out the cookie names and values that were received during the scan.
.TP
.BI \-evasion " <evasion method>"
IDS evasion techniques.  This enables the intrusion detection evasion in
LibWhisker.  Multiple options can be used by stringing the numbers
together, i.e. to enable methods 1 and 5, use "\-e 15".  The valid options
are (use the number preceeding each description):
.RS
.TP
.B 1
Random URI encoding (non-UTF8)
.TP
.B 2
Add directory self-reference\~/./
.TP
.B 3
Premature URL ending
.TP
.B 4
Prepend long random string to request
.TP
.B 5
Fake parameters to files
.TP
.B 6
TAB as request spacer instead of spaces
.TP
.B 7
Random case sensitivity
.TP
.B 8
Use Windows directory separator\~\\ instead of\~/
.TP
.B 9
Session splicing
.PP
See the LibWhisker source for more information, or http://www.wiretrip.net/
.RE
.TP
.B \-findonly
Use port scan to find valid HTTP and HTTPS ports only, but do not perform
checks against them.
.TP
.B \-Format
Output format for the file specified with the -output option. Valid formats
are:
.RS
.TP
.B HTM
HTML output format.
.TP
.B TXT
Text output format. This is the default if \fB\-F\fP is not specified.
.TP
.B CSV
Comma Seperated Value format.
.RE
.TP
.B \-generic
Force full scan rather than trusting the "Server:" identification string,
as many servers allow this to be changed.
.TP
.BI \-host " <ip, hostname or file>"
Target host(s) to check against. This can be an IP address or
hostname, or a file of IPs or hostnames.  If this argument is a file,
it should formatted as described below. This is the only required
option.
.TP
.BI \-id " <user:password:realm>"
HTTP Authentication use, format is userid:password for authorizing
Nikto a web server realm. For NTLM realms, format is
id:password:realm.
.TP
.BI \-mutate
Mutate checks. This causes Nikto put all files with all directories
from the .db files and can the host. You might find some oddities this
way. Note that it generates a lot of checks.
.TP
.BI \-nolookup
Don't perform a host name lookup.
.TP
.BI \-output " <filename>"
Write output to this file when complete.  Format is text unless specified
via \fB\-Format\fP.
.TP
.BI \-port " <port number>"
Port number to scan, defaults to port 80 if missing.  This can also be
a range or list of ports, which Nikto will check for web servers.  If
a web server is found, it will perform a full scan unless the
\fB\-f\fP option is used.
.TP
.BI \-root " <root>"
Always prepend this to requests, i.e., changes a request of "/password.txt"
to "/directory/password.txt" (assuming the value passed on the CLI was
"/directory")
.TP
.B \-ssl
Force SSL mode on port(s) listed.  Note that Nikto attempts to determine if
a port is HTTP or HTTPS automatically, but this can be slow if the server
fails to respond or is slow to respond to the incorrect one. This sets SSL
usage for \fBall\fP hosts and ports.
.TP
.B \-timeout " <timeout>"
Set timeout for each request, default is 10 seconds
.TP
.B \-useproxy
Use the proxy defined in \fIconfig.txt\fP for all requests
.TP
.BI \-vhost " <ip or hostname>"
Virtual host to use for the "Host:" header, in case it is different from
the target.
.TP
.B \-Version
Print version numbers of Nikto, all plugins and all databases.
.B \-404
Pass a string to be matched against content. If a page matches to this string, 
it cannot be treated as a positive (it will be skipped, like a 404 response).
.TP
Print version numbers of Nikto, all plugins and all databases.
.PP
These options cannot be abbreviated to the first letter:
.TP
.B \-dbcheck
This option will check the syntax of the checks in the
\fIscan_database.db\fP and \fIuser_scan_database.db\fP files. This is
really only useful if you are adding checks or are having problems.
.TP
.B \-debug
Print a huge amount of detail out. In most cases this is going to be more
information than you need, so try \fB\-verbose\fP first.
.TP
.B \-update
This will connect to cirt.net and download updated scan_database.db and
plugin files. Use this with caution as you are downloading files--perhaps
including code--from an "untrusted" source. This option cannot be combined
with any other, but required variables (like the \fBPROXY\fP settings)
will be loaded from the \fIconfig.txt\fP file.
.TP
.B \-verbose
Print out a lot of extra data during a run. This can be useful if a scan or
server is failing, or to see exactly how a server responds to each request.
.
.SH HOSTNAME FILE
.
If a file is specified with \fB\-h\fP instead of a hostname or IP, Nikto
will open the file to use it as a list of targets. The file should be
formatted with one host per line. If no port is specified, port 80 is
assumed. Multiple ports may be specified per host. If a host file is used,
any ports specified via \fB\-p\fP are added to every host. Valid lines would
be:
.PP
.RS
10.100.100.100
.br
10.100.100.100:443
.br
10.100.100.100,443
.br
10.100.100.100:443:8443
.br
10.100.100.100,443,8443
.br
evilash.example.com,80
.br
(etc)
.RE
.
.SH CONFIG FILE
.
The \fIconfig.txt\fP file provides a means to set variables at
run-time without modifying the Nikto source itself. The options below
can be set in the file. Options that accept multiple values
(\fBCGIDIRS\fP, \fBSKIPPORTS\fP, etc.) should just use a space to
distinguish multiple values.  None of these are required unless you
need them.
.TP
.B CLIOPTS
Add any option here to be added to every Nikto execution, whether specified
at the command line or not.
.TP
.B NMAP
Path to nmap. If defined, Nikto will use nmap to port scan a host rather
than PERL code, and so should be faster.
.TP
.B SKIPPORTS
Port number never to scan (so you don't crash services, perhaps?).
.TP
.B PROXYHOST
Server to use as a proxy, either IP or hostname, no 'http://' needed.
.TP
.B PROXYPORT
Port number that \fBPROXYHOST\fP uses as a proxy.
.TP
.B PROXYUSER
If the \fBPROXYHOST\fP requires authentication, use this ID. Nikto will
prompt for it if this is not set & it is needed.
.TP
.B PROXYPASS
If the \fBPROXYHOST\fP requires a password for \fBPROXYUSER\fP, use this
password.  Nikto will prompt for it if this is not set & it is needed.
.TP
.B PLUGINDIR
If Nikto can't find it's plugin directory for some reason, enter the full
path and the problem is solved.
.TP
.B UPDATES
Turns data push to cirt.net on. Please see the \fBCIRT.NET UPDATES\fP
section for details.
.TP
.B MAX_WARN
If the number of OK or MOVED messages reaches this number, a warning will
printed.
.TP
.B PROMPTS
If set to "no", Nikto will \fBnever\fP prompt for anything--proxy auth,
updates, nothing...
.TP
.B DEFAULTHTTPVER
First try this HTTP method. If this fails, Nikto will attempt to find a
valid one. Useful if you want try something non-standard.
.TP
.B STATIC-COOKIE
The name/value of this cookie, if set, will be sent for every request
(useful for auth cookies).
.PP
Variables that start with the 'at' sign (@) will be used when scan rules
are loaded. For each value (seperated by space), the rule will be
duplicated. See the \fBTEST DATABASES\fP section for more information.
.PP
Predefined variables are:
.TP
.B @CGIDIRS
CGI directories to look for, valid ones (or all) will be used for CGI
checks against the remote host.
.TP
.B @MUTATEDIRS
Additional directories to use when operating under the Mutate mode besides
ones already defined the .db files.
.TP
.B @MUTATEFILES
Additional files to use when operating under the Mutate mode besides ones
already defined the .db files.
.TP
.B @ADMINDIRS
Typical administration directories.
.TP
.B @USERS
Typical user names for the user guessing plugins.
.
.SH CIRT.NET UPDATES
.
In order to help keep the Nikto databases up-to-date, you have the ability
to easily submit some updates back to cirt.net for inclusion in new copies
of the databases.  Currently, this only includes software versions (such as
"Apache/7.0.3"). If Nikto scans a host and sees a newer version on the host
than it has in the database, or it is missing entirely, (and your databases
are fairly recent), this information can be automatically (or manually)
sent back to cirt.net.
.PP
Behaviour of this option is controlled in config.txt through the
\fBUPDATES\fP variable. If \fBUPDATES\fP is set to "no", Nikto will not
send or ask about sending values to cirt.net. If set to "auto", it will
automatically send the data through an HTTP request. If set to "yes" (which
is the default), when there are updates it will ask if you would like to
submit and show you the data (unless PROMPTS=no).
.PP
There is only one thing submitted to cirt.net when you do this: the
"updated" version string.  No information specific to the host tested is
sent.  No information from the scanning source is sent (it does log your IP
address as seen by cirt.net's web server, but... nothing else).
.PP
If you're not comfortable with this, you may also email it to me at
sullo@cirt.net or just set UPDATES=no. Please don't complain and say I'm
stealing your data... just trying to save me some work ;)
.PP
Again: the default configuration of Nikto does \fBnot\fP send \fBany\fP
data to cirt.net.
.
.SH TEST DATABASES
.
Rules in the scan databases can use dynamic variables from config.txt. Any
variable that starts with the 'at' sign (@) will be substited in rules. For
example: A rule of
.IP
"generic","@CGIDIRStest.html","200","GET","Test"
.PP
with "@CGIDIRS=/cgi-bin/ /cgi-sys/"
will test for:
.RS
.IP \(bu 4
/cgi-bin/test.html
.IP \(bu 4
/cgi-sys/test.html
.RE
.PP
Any number of these variables can be set, and any number can be used in a
rule (i.e., "@CGIDIRS@ADMINDIRStest.html").  Additionally, the generic
@HOSTNAME and @IP are available, which use the current target's
hostname or IP.
.PP
Rules can be specified which also have conditionals for test success. This
can allow a test to look for a 200 HTTP response but not contain the word
"home". This would look like "200!home" in the \fIscan_database.db\fP file.
.
.SH EXAMPLES
.
A basic scan of a web server on port 80. The \fB\-h\fP option is the
only option that is required for a basic scan of a web server on the
standard HTTP port.
.IP ""
nikto.pl \-h 10.100.100.10
.PP
A basic scan of a web server on port 443, forcing SSL encryption and
ignoring the Server header.  Note that Nikto does not assume port 443
to be SSL, but if HTTP fails it will try HTTPS.
.IP ""
nikto.pl \-h 10.100.100.10 \-p 443 \-s \-g
.PP
Scanning multiple ports on the server, letting Nikto determine if they are
HTTP and SSL encrypted.
.IP ""
nikto.pl \-h 10.100.100.10 \-p 80\-90
.PP
Scanning specific ports on the system.
.IP ""
nikto.pl \-h 10.100.100.10 \-p 80,443,8000,8080
.PP
You may combine IDS evasion techniques as desired.
.IP ""
nikto.pl \-h 10.100.100.10 \-p 80 \-e 167
.
.SH IMPORTANT FILES
.
.TP
.I config.txt
run-time configuration options, see the CONFIG FILE section
.TP
.I nikto_core.plugin
main Nikto code, absolutely required
.TP
.I nikto_plugin_order.txt
determines the order in which plugins are executed
.TP
.I LW.pm
The stand-alone LibWhisker file.
.TP
.I user_scan_database.db
If it exists in the plugins directory, it will load these checks as well.
Same syntax as \fIscan_database.db\fP
.
.SH ADDITIONAL SOFTWARE
.
LibWhisker is required for proper execution of Nikto. The LW.pm library is
included with Nikto, but it is recommended that you download and install
the full LibWhisker module from http://www.wiretrip.net/. If you are not
using an installed Libwhisker, you will need to change Nikto.pl so that it
includes the proper LW.pm file.  Edit Nikto.pl and comment the line:
.IP ""
require "$NIKTO{plugindir}/LW.pm";
.PP
and uncomment the line below it:
.IP ""
use LW;
.PP
nmap can be used to speed up port scans. This should be much faster than
relying on PERL code to perform port scans. Nmap can be obtained from
http://www.nmap.org/, it is not included with Nikto.
.PP
SSL software is required to test using HTTPS.  For Windows systems, the SSL
software and libraries can be obtained from http://www.activestate.com/.
For unix systems, OpenSSL from http://www.openssl.org/ and the Net::SSLeay
module from http://www.cpan.org/ are required.
.
.SH CHECKS
.
Checks, both information and actual security problems, are derived from a
number of sources. These include the mailing lists BugTraq, NTBugTraq,
WebAppSec (WWW-Mobile-Code), and others. The web sites
www.securitytracker.com, www.securiteam.com, www.packetstormsecurity.com
and www.securityfocus.com.  Additionally, updates to Nessus are watched and
many thanks to all the plugin writers (and to Renaud for Nessus itself)
(http://www.nessus.org/).
.
.SH WARNINGS
.
Nikto can cause harm to your local system, the remote system and/or the
network.  Some options can generate over 70,000 HTTP requests to a target.
Do not run Nikto againsts hosts you are not authorized to perform testing
against. Cirt.net takes no responsibility for anything done with this
software, any problems it may cause or problems it may find.
.PP
Plugins are standard PERL.  They are included and executed when Nikto is
run. If you run the \fB\-update\fP option, new and updated plugins will be
downloaded from cirt.net. This means you are downloading code, and
potentially running it, without viewing it yourself.  Please consider the
implications.  Do not assume code distributed from Cirt.net is not harmful,
as accidents happen and a malicious third party may have inserted a
dangerous plugin. Cirt.net assumes no responsibility if any malicious code
is delivered via the \fB\-update\fP option.
.
.SH DISTRIBUTION
.
Nikto and updated databases and plugins is distributed from
http://www.cirt.net/
.
.SH "SEE ALSO"
.
.TP
.B LibWhisker
http://www.wiretrip.net/
.TP
.B Nmap
http://www.nmap.org/
.TP
.B OpenSSL
http://www.openssl.org/
.TP
.B CPAN
http://www.cpan.org/
.TP
.B ActiveState
http://www.activestate.com/
.TP
.B Nessus
http://www.nessus.org/
.
.SH LICENSE
.
This copyright applies to all code included in this distribution, but
does not include the LibWhisker software, which is distributed under
its own license.
.PP
Copyright (C) 2001-2005 Sullo/CIRT.net
.PP
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2  of the License, or (at
your option) any later version.
.PP
This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.
.PP
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
USA.
.PP
Contact Information: See the \fBAUTHOR\fP section.
.
.SH AUTHOR
.
Sullo, sullo@cirt.net
.br
http://www.cirt.net/
.PP
Suggestions/fixes/support from: Jericho/attrition.org,
rfp/wiretrip.net, Zel/firewallmonkeys.com, Zeno/cgisecurity.com,
Darby/cirt.net, Valdez/cirt.net, S Saady, P Eronen/nixu.com, M Arboi,
T Seyrat, J DePriest, P Woroshow, fr0stman, E Udassin, H Heimann and
more
.PP
Many tests and contributed/suggested by: M Richardson,
Jericho/attrition.org, Prickley Paw, M Arboi, H Heimann and more
.PP
And Xiola.net for kicking ass.
.
